/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.common.util;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.command.CommandResponse;
import com.cloudpath.common.os.mac.common.plist.PlistConstants;
import com.cloudpath.common.os.mac.common.plist.pojo.Dict;
import com.cloudpath.common.os.mac.common.plist.pojo.Plist;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueArray;
import com.cloudpath.common.util.OsConstants;
import com.cloudpath.common.util.Util;

public class SystemProfilerAirport {
    private static Plist PLIST = null;

    public static final Plist getPlist(CommandHandler commandHandler) throws Exception {
        if (PLIST == null) {
            CommandResponse commandResponse = commandHandler.executeCommand(new String[]{"/usr/sbin/system_profiler", "SPAirPortDataType", "-xml"});
            commandResponse.waitFor();
            PLIST = PlistConstants.readPlist(Util.join(commandResponse.getOutput()));
        }
        return PLIST;
    }

    private static Dict getBaseDict(CommandHandler commandHandler) throws Exception {
        Dict dict = (Dict)SystemProfilerAirport.getPlist(commandHandler).getArray().getValue(0);
        ValueArray valueArray = dict.getArray("_items", new ValueArray());
        Dict dict2 = (Dict)valueArray.getValue(0);
        if (OsConstants.isMacLeopardOrBefore()) {
            return dict2;
        }
        ValueArray valueArray2 = (ValueArray)dict2.getPair(0).getValue();
        Dict dict3 = (Dict)valueArray2.getValue(0);
        return dict3;
    }

    public static String getWirelessCardType(CommandHandler commandHandler) {
        return SystemProfilerAirport.getWirelessValue(commandHandler, "spairport_wireless_card_type");
    }

    public static String getWirelessCardFirmwareVersion(CommandHandler commandHandler) {
        return SystemProfilerAirport.getWirelessValue(commandHandler, "spairport_wireless_firmware_version");
    }

    public static String getWirelessCardPhys(CommandHandler commandHandler) {
        return SystemProfilerAirport.getWirelessValue(commandHandler, "spairport_supported_phymodes");
    }

    public static String getWirelessValue(CommandHandler commandHandler, String string) {
        try {
            Dict dict = SystemProfilerAirport.getBaseDict(commandHandler);
            if (dict != null) {
                return dict.getString(string, "");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }
}

