/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.common.util;

import com.cloudpath.common.os.mac.common.plist.pojo.Dict;
import com.cloudpath.common.os.mac.common.plist.pojo.Plist;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueArray;
import com.cloudpath.common.util.FileUtil;
import java.util.Vector;

public class MaceapState {
    public static final String ADDITIONAL_PROPERTIES = "AdditionalProperties";
    public static final String TLS_NEGOTIATED_CIPHER = "TLSNegotiatedCipher";
    public static final String TLS_SERVER_CERTIFICATE_CHAIN = "TLSServerCertificateChain";
    public static final String TLS_SESSION_WAS_RESUMED = "TLSSessionWasResumed";
    public static final String TLS_TRUST_CLIENT_STATUS = "TLSTrustClientStatus";
    public static final String CLIENT_STATUS = "ClientStatus";
    public static final String CONFIGURATION_GENERATION = "ConfigurationGeneration";
    public static final String DOMAIN_SPECIFIC_ERROR = "DomainSpecificError";
    public static final String EAP_TYPE = "EAPType";
    public static final String EAP_TYPE_NAME = "EAPTypeName";
    public static final String IDENTITY_ATTRIBUTES = "IdentityAttributes";
    public static final String MODE = "Mode";
    public static final String REQUIRED_PROPERTIES = "RequiredProperties";
    public static final String SUPPLICANT_STATE = "SupplicantState";
    public static final String TIMESTAMP = "Timestamp";
    public static final String UNIQUE_IDENTIFIER = "UniqueIdentifier";
    public static final int SUPP_STATE_DISCONNECTED = 0;
    public static final int SUPP_STATE_CONNECTING = 1;
    public static final int SUPP_STATE_ACQUIRED = 2;
    public static final int SUPP_STATE_AUTHENTICATING = 3;
    public static final int SUPP_STATE_AUTHENTICATED = 4;
    public static final int SUPP_STATE_HELD = 5;
    public static final int SUPP_STATE_LOGOFF = 6;
    public static final int SUPP_STATE_INACTIVE = 7;
    public static final int CLIENT_STATUS_OK = 0;
    public static final int CLIENT_STATUS_FAILED = 1;
    public static final int CLIENT_STATUS_ALLOCATION_FAILED = 2;
    public static final int CLIENT_STATUS_USER_INPUT_REQUIRED = 3;
    public static final int CLIENT_STATUS_CONFIGURATION_INVALID = 4;
    public static final int CLIENT_STATUS_PROTOCOL_NOT_SUPPORTED = 5;
    public static final int CLIENT_STATUS_SERVER_CERTIFICATUS_NOT_TRUSTED = 6;
    public static final int CLIENT_STATUS_INNER_PROTOCOL_NOT_SUPPORTED = 7;
    public static final int CLIENT_STATUS_INTERNAL_ERROR = 8;
    public static final int CLIENT_STATUS_USER_CANCELLED_AUTHENTICATION = 9;
    public static final int CLIENT_STATUS_UNKNOWN_ROOT_CERTIFICATE = 10;
    public static final int CLIENT_STATUS_NO_ROOT_CERTIFICATE = 11;
    public static final int CLIENT_STATUS_CERTIFICATE_EXPIRED = 12;
    public static final int CLIENT_STATUS_CERTIFICATE_NOT_YET_VALID = 13;
    public static final int CLIENT_STATUS_CERTIFICATE_REQUIRES_CONFIRMATION = 14;
    public static final int CLIENT_STATUS_USER_INPUT_NOT_POSSIBLE = 15;
    public static final int CLIENT_STATUS_CONFIGURATION_INCOMPLETE = 3;
    public static final int CLIENT_STATUS_ERROR_STARTING = 1000;
    private static final String WAITING_USERNAME = "UserName";
    private static final String WAITING_PASSWORD = "UserPassword";
    private static final String WAITING_CERT_ACCEPTANCE = "TLSUserTrustProceedCertificateChain";
    private static int counter = 1;
    private int cls_Id = counter++;
    private long cls_TlsNegotiatedCipher;
    private Vector<String> cls_TlsServerCertificateChain = new Vector();
    private boolean cls_TlsSessionWasResumed = false;
    private long cls_TlsTrustClientStatus = 0L;
    private long cls_ClientStatus = 0L;
    private long cls_ConfigurationGeneration = 0L;
    private long cls_DomainSpecificError = 0L;
    private long cls_EapType = 0L;
    private String cls_EapTypeName = "";
    private Vector<String> cls_IdentityAttributes = new Vector();
    private long cls_Mode = 0L;
    private Vector<String> cls_RequiredProperties = new Vector();
    private long cls_SupplicantState = 0L;
    private long cls_Timestamp = 0L;
    private String cls_UniqueIdentifier = "";

    public MaceapState() {
    }

    public MaceapState(Plist plist) {
        if (plist != null && plist.getDict() != null) {
            this.parse(plist.getDict());
            try {
                FileUtil.write("/Users/kevin/Desktop/FILE_" + this.cls_Id + ".txt", plist.getXml());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public long getTlsNegotiatedCipher() {
        return this.cls_TlsNegotiatedCipher;
    }

    public void setTlsNegotiatedCipher(long l) {
        this.cls_TlsNegotiatedCipher = l;
    }

    public boolean getTlsSessionWasResumed() {
        return this.cls_TlsSessionWasResumed;
    }

    public void setTlsSessionWasResumed(boolean bl) {
        this.cls_TlsSessionWasResumed = bl;
    }

    public long getTlsTrustClientStatus() {
        return this.cls_TlsTrustClientStatus;
    }

    public void setTlsTrustClientStatus(long l) {
        this.cls_TlsTrustClientStatus = l;
    }

    public long getClientStatus() {
        return this.cls_ClientStatus;
    }

    public void setClientStatus(long l) {
        this.cls_ClientStatus = l;
    }

    public long getConfigurationGeneration() {
        return this.cls_ConfigurationGeneration;
    }

    public void setConfigurationGeneration(long l) {
        this.cls_ConfigurationGeneration = l;
    }

    public long getDomainSpecificError() {
        return this.cls_DomainSpecificError;
    }

    public void setDomainSpecificError(long l) {
        this.cls_DomainSpecificError = l;
    }

    public long getEapType() {
        return this.cls_EapType;
    }

    public void setEapType(long l) {
        this.cls_EapType = l;
    }

    public String getEapTypeName() {
        return this.cls_EapTypeName;
    }

    public void setEapTypeName(String string) {
        this.cls_EapTypeName = string;
    }

    public long getMode() {
        return this.cls_Mode;
    }

    public void setMode(long l) {
        this.cls_Mode = l;
    }

    public long getSupplicantState() {
        return this.cls_SupplicantState;
    }

    public void setSupplicantState(long l) {
        this.cls_SupplicantState = l;
    }

    public long getTimestamp() {
        return this.cls_Timestamp;
    }

    public void setTimestamp(long l) {
        this.cls_Timestamp = l;
    }

    public void addTlsServerCertificate(String string) {
        this.cls_TlsServerCertificateChain.add(string);
    }

    public int getTlsServerCertificateCount() {
        return this.cls_TlsServerCertificateChain.size();
    }

    public String getTlsServerCertificate(int n) {
        if (n >= 0 && n < this.cls_TlsServerCertificateChain.size()) {
            return this.cls_TlsServerCertificateChain.get(n);
        }
        return null;
    }

    public void addIdentityAttributes(String string) {
        this.cls_IdentityAttributes.add(string);
    }

    public int getIdentityAttributesCount() {
        return this.cls_IdentityAttributes.size();
    }

    public String getIdentityAttributes(int n) {
        if (n >= 0 && n < this.cls_IdentityAttributes.size()) {
            return this.cls_IdentityAttributes.get(n);
        }
        return null;
    }

    public String getIdentityAttributes() {
        return this.cls_IdentityAttributes.toString();
    }

    public void addRequiredProperties(String string) {
        this.cls_RequiredProperties.add(string);
    }

    public int getRequiredPropertiesCount() {
        return this.cls_RequiredProperties.size();
    }

    public String getRequiredProperties(int n) {
        if (n >= 0 && n < this.cls_RequiredProperties.size()) {
            return this.cls_RequiredProperties.get(n);
        }
        return null;
    }

    public String getRequiredProperties() {
        return this.cls_RequiredProperties.toString();
    }

    public void setUniqueIdentifier(String string) {
        this.cls_UniqueIdentifier = string;
    }

    public String getUniqueIdentifier() {
        return this.cls_UniqueIdentifier;
    }

    public void parse(Dict dict) {
        int n;
        ValueArray valueArray;
        Dict dict2 = dict.getDict(ADDITIONAL_PROPERTIES, null);
        if (dict2 != null) {
            this.setTlsNegotiatedCipher(dict2.getInteger(TLS_NEGOTIATED_CIPHER, this.getTlsNegotiatedCipher()));
            valueArray = dict2.getArray(TLS_SERVER_CERTIFICATE_CHAIN, null);
            if (valueArray != null) {
                for (n = 0; n < valueArray.getValueCount(); ++n) {
                    this.addTlsServerCertificate(valueArray.getValue(n).getString());
                }
            }
            this.setTlsSessionWasResumed(dict2.getBoolean(TLS_SESSION_WAS_RESUMED, this.getTlsSessionWasResumed()));
            this.setTlsTrustClientStatus(dict2.getInteger(TLS_TRUST_CLIENT_STATUS, this.getTlsTrustClientStatus()));
        }
        this.setClientStatus(dict.getInteger(CLIENT_STATUS, this.getClientStatus()));
        this.setConfigurationGeneration(dict.getInteger(CONFIGURATION_GENERATION, this.getConfigurationGeneration()));
        this.setDomainSpecificError(dict.getInteger(DOMAIN_SPECIFIC_ERROR, this.getDomainSpecificError()));
        this.setEapType(dict.getInteger(EAP_TYPE, this.getEapType()));
        this.setEapTypeName(dict.getString(EAP_TYPE_NAME, this.getEapTypeName()));
        valueArray = dict.getArray(IDENTITY_ATTRIBUTES, null);
        if (valueArray != null) {
            for (n = 0; n < valueArray.getValueCount(); ++n) {
                this.addIdentityAttributes(valueArray.getValue(n).getString());
            }
        }
        this.setMode(dict.getInteger(MODE, this.getMode()));
        ValueArray valueArray2 = dict.getArray(REQUIRED_PROPERTIES, null);
        if (valueArray2 != null) {
            for (int i = 0; i < valueArray2.getValueCount(); ++i) {
                this.addRequiredProperties(valueArray2.getValue(i).getString());
            }
        }
        this.setSupplicantState(dict.getInteger(SUPPLICANT_STATE, this.getSupplicantState()));
        this.setTimestamp(dict.getDate(TIMESTAMP, this.getTimestamp()));
        this.setUniqueIdentifier(dict.getString(UNIQUE_IDENTIFIER, this.getUniqueIdentifier()));
    }

    public SummaryState getSummaryState() {
        if (this.getSupplicantState() == 6L || this.getSupplicantState() == 7L) {
            return SummaryState.DISCONNECTED;
        }
        if (this.getSupplicantState() == 4L) {
            return SummaryState.AUTHENTICATED;
        }
        if (this.getClientStatus() == 3L) {
            if (this.isWaitingOnUserName() || this.isWaitingOnUserPassword()) {
                return SummaryState.WAITING_INPUT;
            }
            if (this.isWaitingForCertAcceptance()) {
                return SummaryState.WAITING_CERT;
            }
            return SummaryState.WAITING_UNCERTAIN;
        }
        if (this.getSupplicantState() == 5L || this.getSupplicantState() == 6L || this.getSupplicantState() == 7L) {
            return SummaryState.DISCONNECTED;
        }
        return SummaryState.PROCESSING;
    }

    public boolean isWaitingForCertAcceptance() {
        return this.cls_RequiredProperties.contains(WAITING_CERT_ACCEPTANCE);
    }

    public boolean isWaitingOnUserName() {
        return this.cls_RequiredProperties.contains(WAITING_USERNAME);
    }

    public boolean isWaitingOnUserPassword() {
        return this.cls_RequiredProperties.contains(WAITING_PASSWORD);
    }

    public String getSupplicantStateName() {
        int n = (int)this.getSupplicantState();
        switch (n) {
            case 0: {
                return "Disconnected";
            }
            case 1: {
                return "Connecting";
            }
            case 2: {
                return "Acquired";
            }
            case 3: {
                return "Authenticating";
            }
            case 4: {
                return "Authenticated";
            }
            case 5: {
                return "Held";
            }
            case 6: {
                return "LoggedOff";
            }
            case 7: {
                return "Inactive";
            }
        }
        return "Unknown(" + n + ")";
    }

    public String getClientStatusName() {
        int n = (int)this.getClientStatus();
        switch (n) {
            case 0: {
                return "Ok";
            }
            case 1: {
                return "Failed";
            }
            case 2: {
                return "AllocationFailed";
            }
            case 3: {
                return "UserInputRequired";
            }
            case 4: {
                return "ConfigurationInvalid";
            }
            case 5: {
                return "ProtocolNotSupported";
            }
            case 6: {
                return "ServerCertificateNotTrusted";
            }
            case 7: {
                return "InnerProtocolNotSupported";
            }
            case 8: {
                return "InternalError";
            }
            case 9: {
                return "UserCancelledAuthentication";
            }
            case 10: {
                return "UnknownRootCertificate";
            }
            case 11: {
                return "NoRootCertificate";
            }
            case 12: {
                return "CertificateExpired";
            }
            case 13: {
                return "CertificateNotYetValid";
            }
            case 14: {
                return "CertificateRequiredConfirmation";
            }
            case 15: {
                return "UserInputNotPossible";
            }
            case 1000: {
                return "ErrorStarting";
            }
        }
        return "Unknown(" + n + ")";
    }

    public String toString() {
        return "[" + this.cls_Id + "- State: " + this.getTlsNegotiatedCipher() + ", Tls:" + this.getTlsTrustClientStatus() + ", Client:" + this.getClientStatus() + ", ConfigGen:" + this.getConfigurationGeneration() + ", Domain:" + this.getDomainSpecificError() + ", Mode:" + this.getMode() + ", SupState:" + this.getSupplicantStateName() + " - " + this.getRequiredProperties() + " - " + this.getIdentityAttributes() + " - " + this.getTlsServerCertificateCount() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SummaryState {
        DISCONNECTED,
        PROCESSING,
        WAITING_INPUT,
        WAITING_CERT,
        WAITING_UNCERTAIN,
        AUTHENTICATED,
        UNINITIALIZED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EapolState {
        Idle,
        Starting,
        Running,
        Stopping;

    }
}

