/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.common.util;

import com.cloudpath.common.command.CommandResponseEndless;
import com.cloudpath.common.os.mac.common.plist.PlistConstants;
import com.cloudpath.common.os.mac.common.plist.pojo.Plist;
import com.cloudpath.common.os.mac.common.util.MaceapState;
import com.cloudpath.common.os.mac.leopard.eapol.MacEapCmd;
import java.util.Vector;
import org.apache.log4j.Logger;

public class EapStateWatcher
implements CommandResponseEndless.CommandResponseListener {
    private static final Logger log = Logger.getLogger(EapStateWatcher.class);
    private StringBuffer cls_Buffer = new StringBuffer();
    private MaceapState.SummaryState cls_CurrentSummaryState = MaceapState.SummaryState.UNINITIALIZED;
    private MaceapState cls_CurrentState = null;
    private final MacEapCmd cls_Maceap;
    private CommandResponseEndless cls_Response;
    private final Vector<EapStateListener> cls_EapStateListeners = new Vector();

    public EapStateWatcher(MacEapCmd macEapCmd) {
        this.cls_Maceap = macEapCmd;
    }

    public void addListener(EapStateListener eapStateListener) {
        if (!this.cls_EapStateListeners.contains(eapStateListener)) {
            this.cls_EapStateListeners.add(eapStateListener);
        }
    }

    public void start(String string) {
    }

    public void stop() {
        if (this.cls_Response != null) {
            this.cls_Response.close();
        }
    }

    public synchronized void stateChanged(MaceapState maceapState) {
        MaceapState.SummaryState summaryState;
        System.out.println(maceapState);
        if (maceapState != null && (summaryState = maceapState.getSummaryState()) != null) {
            if (maceapState.getClientStatus() == 1L) {
                System.out.println("    -- FAILED.");
            }
            if (summaryState.equals((Object)this.cls_CurrentSummaryState)) {
                this.cls_CurrentState = maceapState;
                this.cls_CurrentSummaryState = summaryState;
            } else {
                if (summaryState.equals((Object)MaceapState.SummaryState.DISCONNECTED) && this.cls_CurrentState != null && this.cls_CurrentState.getRequiredPropertiesCount() > 0) {
                    System.out.println("   -- FAILED: " + this.cls_CurrentState.getRequiredProperties());
                }
                MaceapState maceapState2 = this.cls_CurrentState;
                this.cls_CurrentState = maceapState;
                this.cls_CurrentSummaryState = summaryState;
                for (int i = 0; i < this.cls_EapStateListeners.size(); ++i) {
                    try {
                        this.cls_EapStateListeners.get(i).eapStateChanged(maceapState, maceapState2);
                        continue;
                    }
                    catch (Exception exception) {
                        log.warn((Object)"Listener threw exception.", (Throwable)exception);
                    }
                }
            }
        }
    }

    public synchronized void commandOutputReceived(String string) {
        if (string != null) {
            int n = string.indexOf("</plist>");
            while (n >= 0) {
                String string2 = string.substring(0, n += 8);
                String string3 = this.cls_Buffer.toString() + string2;
                int n2 = string3.indexOf("<plist");
                if (n2 >= 0) {
                    string3 = string3.substring(n2);
                    try {
                        Plist plist = PlistConstants.readPlist(string3);
                        MaceapState maceapState = null;
                        if (plist != null && plist.getDict() != null && plist.getDict().getPairCount() > 0 && plist.getDict().getPair(0).getKey().equals("interface_name")) {
                            String string4 = plist.getDict().getString("interface_state", "");
                            if (string4 != null && "idle".equals(string4.toLowerCase())) {
                                maceapState = new MaceapState();
                                maceapState.setSupplicantState(7L);
                                this.stateChanged(maceapState);
                            }
                        } else {
                            maceapState = new MaceapState(plist);
                            this.stateChanged(maceapState);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                this.cls_Buffer = new StringBuffer();
                string = string.substring(n);
                n = string.indexOf("</plist>");
            }
            this.cls_Buffer.append(string);
        }
    }

    public void commandErrorReceived(String string) {
        System.err.println("MACEAP: " + string);
    }

    public static interface EapStateListener {
        public void eapStateChanged(MaceapState var1, MaceapState var2);
    }
}

