/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.common.util;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.command.CommandResponse;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEapProfileManager;
import com.cloudpath.common.util.Util;
import java.io.File;
import org.apache.log4j.Logger;

public class Defaults {
    private static final Logger log = Logger.getLogger(LeopardEapProfileManager.class);

    public static final boolean getBoolean(CommandHandler commandHandler, File file, String string, boolean bl) {
        int n = Defaults.getInt(commandHandler, file, string);
        if (n < 0) {
            return bl;
        }
        return n > 0;
    }

    public static final int getInt(CommandHandler commandHandler, File file, String string) {
        String string2 = file.getAbsolutePath();
        if (!file.exists()) {
            log.warn((Object)("A read was requested from non-existent plist file: " + file.getAbsolutePath()));
        }
        if (string2.toLowerCase().endsWith(".plist")) {
            string2 = string2.substring(0, string2.length() - 6);
        }
        String[] stringArray = new String[]{"defaults", "read", string2, string, "-int"};
        try {
            CommandResponse commandResponse = commandHandler.executeCommand(stringArray);
            commandResponse.waitFor();
            String string3 = Util.join(commandResponse.getOutput());
            try {
                return Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                log.error((Object)("An error occurred while trying to format '" + string3 + "'.  StdErr was '" + Util.join(commandResponse.getError()) + "'."), (Throwable)numberFormatException);
                return -1;
            }
        }
        catch (Exception exception) {
            log.error((Object)("An error occurred while reading defaults for '" + string2 + "' and '" + string + "'."), (Throwable)exception);
            return -1;
        }
    }
}

