/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.common.provider;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.command.CommandResponse;
import com.cloudpath.common.compare.VersionCompare;
import com.cloudpath.common.os.mac.common.ioreg.IoRegController;
import com.cloudpath.common.util.OsConstants;
import com.cloudpath.common.util.Util;
import java.io.IOException;
import org.apache.log4j.Logger;

public class MacSystemProvider {
    private static final Logger log = Logger.getLogger(MacSystemProvider.class);
    private static final String UNKNOWN = "[Unknown]";
    private String HOST_NAME = null;
    private String COMPUTER_MODEL = null;
    private final CommandHandler cls_CommandHandler;

    public MacSystemProvider(CommandHandler commandHandler) {
        this.cls_CommandHandler = commandHandler;
    }

    public static final String getOsFriendlyName() {
        return MacSystemProvider.getOsTypeInternal() + " " + OsConstants.getMacFriendlyName(MacSystemProvider.getOsVersion());
    }

    public static final String getOsName() {
        return MacSystemProvider.getOsTypeInternal() + " " + MacSystemProvider.getOsVersion();
    }

    private static final String getOsTypeInternal() {
        return System.getProperty("os.name");
    }

    public static final String getOsType() {
        return "mac";
    }

    public static final String getOsFullVersion() {
        String string = System.getProperty("os.version");
        long[] lArray = VersionCompare.getSplitVersion(string);
        while (lArray.length < 3) {
            string = string + ".0";
            lArray = VersionCompare.getSplitVersion(string);
        }
        return string;
    }

    public static final String getOsVersion() {
        long[] lArray = VersionCompare.getSplitVersion(MacSystemProvider.getOsFullVersion());
        if (lArray == null || lArray.length == 0) {
            return "0";
        }
        String string = lArray[0] + ".";
        string = lArray.length > 1 ? string + lArray[1] : string + "0";
        return string;
    }

    public static final long getOsServicePack() {
        long[] lArray = VersionCompare.getSplitVersion(MacSystemProvider.getOsFullVersion());
        if (lArray == null || lArray.length == 0) {
            return 0L;
        }
        if (lArray.length > 2) {
            return lArray[2];
        }
        return 0L;
    }

    public static final String getCurrentUser() {
        return System.getProperty("user.name");
    }

    public String getComputerManufacturer() {
        return "Apple";
    }

    public String getComputerModel() {
        if (this.COMPUTER_MODEL == null) {
            try {
                this.COMPUTER_MODEL = IoRegController.getComputerModel(this.cls_CommandHandler);
            }
            catch (Exception exception) {
                this.COMPUTER_MODEL = "Apple";
            }
        }
        return this.COMPUTER_MODEL;
    }

    public String getComputerName() {
        if (this.HOST_NAME == null) {
            try {
                CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(new String[]{"hostname", "-s"});
                commandResponse.waitFor();
                this.HOST_NAME = Util.join(commandResponse.getOutput());
            }
            catch (IOException iOException) {
                log.error((Object)"Error occurred while querying computer name.", (Throwable)iOException);
                return UNKNOWN;
            }
        }
        return this.HOST_NAME;
    }
}

