/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.common.provider;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.command.CommandResponse;
import com.cloudpath.common.os.common.DefaultsProvider;
import com.cloudpath.common.util.Util;
import org.apache.log4j.Logger;

public class MacDefaultsProvider
implements DefaultsProvider {
    private static final Logger log = Logger.getLogger(MacDefaultsProvider.class);
    private final CommandHandler cls_CommandHandler;

    public MacDefaultsProvider(CommandHandler commandHandler) {
        this.cls_CommandHandler = commandHandler;
    }

    public final boolean getBoolean(String string, String string2, boolean bl) {
        int n = this.getInt(string, string2);
        return n < 0 ? bl : n > 0;
    }

    public final int getInt(String string, String string2) {
        return this.getInt(string, string2, -1);
    }

    public final int getInt(String string, String string2, int n) {
        String string3 = this.read(string, string2, "-int");
        if (string3 != null && string3.length() > 0) {
            try {
                return Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                log.error((Object)("An error occurred while trying to format '" + string3 + "'."), (Throwable)numberFormatException);
                return n;
            }
        }
        return n;
    }

    public final String getString(String string, String string2) {
        return this.read(string, string2, "-string");
    }

    public final boolean write(String string, String string2, int n) {
        return this.write(string, string2, "" + n, "-int");
    }

    public final boolean write(String string, String string2, boolean bl) {
        return this.write(string, string2, bl ? "TRUE" : "FALSE", "-bool");
    }

    public final boolean write(String string, String string2, String string3) {
        return this.write(string, string2, string3, "");
    }

    public final boolean delete(String string, String string2) {
        String string3 = MacDefaultsProvider.convertFileNameToDomain(string);
        String[] stringArray = new String[]{"defaults", "delete", string3, string2};
        try {
            CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
            commandResponse.waitFor();
            return true;
        }
        catch (Exception exception) {
            log.error((Object)("An error occurred while deleting defaults for '" + string3 + "' and '" + string2 + "'."), (Throwable)exception);
            return false;
        }
    }

    private final String read(String string, String string2, String string3) {
        String string4 = MacDefaultsProvider.convertFileNameToDomain(string);
        String[] stringArray = string3 != null && string3.length() > 0 ? new String[]{"defaults", "read", string4, string2, string3} : new String[]{"defaults", "read", string4, string2};
        try {
            CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
            commandResponse.waitFor();
            String string5 = Util.join(commandResponse.getOutput());
            log.debug((Object)("Response: " + string5));
            if (Util.join(commandResponse.getError()).length() > 0) {
                System.err.println("ERROR: " + Util.join(commandResponse.getError()));
            }
            return string5;
        }
        catch (Exception exception) {
            log.error((Object)("An error occurred while reading defaults for '" + string4 + "' and '" + string2 + "' as datatype " + string3 + "."), (Throwable)exception);
            return "";
        }
    }

    private final boolean write(String string, String string2, String string3, String string4) {
        String string5 = MacDefaultsProvider.convertFileNameToDomain(string);
        String[] stringArray = string4 != null && string4.length() > 0 ? new String[]{"defaults", "write", string5, string2, string4, string3} : new String[]{"defaults", "write", string5, string2, string3};
        try {
            CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
            commandResponse.waitFor();
            return true;
        }
        catch (Exception exception) {
            log.error((Object)("An error occurred while writing defaults for '" + string5 + "' and '" + string2 + "' with value " + string3 + "."), (Throwable)exception);
            return false;
        }
    }

    private static String convertFileNameToDomain(String string) {
        String string2 = string;
        if (string2.toLowerCase().endsWith(".plist")) {
            string2 = string2.substring(0, string2.length() - 6);
        }
        return string2;
    }
}

