/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.common.provider;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.command.CommandResponse;
import com.cloudpath.common.os.common.ApplicationProvider;
import com.cloudpath.common.os.mac.common.plist.PlistUtil;
import com.cloudpath.common.os.mac.common.plist.pojo.Plist;
import com.cloudpath.common.os.mac.common.util.DockController;
import com.cloudpath.common.os.mac.leopard.cmd.Maccmd;
import com.cloudpath.common.util.FileHandler;
import com.cloudpath.common.util.FileUtil;
import com.cloudpath.common.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class MacApplicationProvider
implements ApplicationProvider {
    private static final Logger log = Logger.getLogger(MacApplicationProvider.class);
    private static final HashMap<String, File> cls_LastKnown = new HashMap();
    private static final HashMap<File, String> cls_VerifiedApplications = new HashMap();
    private final Maccmd cls_Maccmd;
    private final FileHandler cls_FileHandler;
    private final CommandHandler cls_CommandHandler;

    public MacApplicationProvider(FileHandler fileHandler, CommandHandler commandHandler, Maccmd maccmd) {
        this.cls_FileHandler = fileHandler;
        this.cls_CommandHandler = commandHandler;
        this.cls_Maccmd = maccmd;
    }

    public void refresh() {
    }

    public boolean isApplicationInstalled(String string) {
        log.debug((Object)("Will check if application '" + string + "' is installed."));
        return this.getApplicationLocation(string) != null;
    }

    public String getApplicationVersion(String string) {
        log.debug((Object)("Will check version for application '" + string + "'."));
        File file = this.getApplicationLocation(string);
        if (file == null || !file.exists()) {
            log.debug((Object)("  - Application doesn't exist (" + file + ")"));
            return "";
        }
        File file2 = new File(file, "/Contents/Info.plist");
        if (!file2.exists()) {
            log.debug((Object)"  - Info not available.");
            return "";
        }
        Plist plist = PlistUtil.getCurrentPlist(this.cls_FileHandler, this.cls_CommandHandler, file2, null);
        if (plist == null) {
            log.debug((Object)"  - Couldn't load version info.");
            return "";
        }
        String string2 = plist.getDict().getString("CFBundleShortVersionString", "");
        if (string2 != null && string2.length() > 0) {
            log.debug((Object)("  - Version (Short) found to be " + string2));
            return string2;
        }
        string2 = plist.getDict().getString("CFBundleVersion", "");
        log.debug((Object)("  - Version found to be " + string2));
        return string2;
    }

    public final void killApplication(String string) {
        MacApplicationProvider.killApplication(this.cls_CommandHandler, string);
    }

    public final void launchApplication(String string) {
        File file = this.getApplicationLocation(string);
        if (file != null) {
            log.debug((Object)("Will launch: " + file.getAbsolutePath()));
            String[] stringArray = new String[]{"/usr/bin/open", file.getAbsolutePath()};
            try {
                CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
                commandResponse.waitFor();
            }
            catch (IOException iOException) {
                log.warn((Object)("An error occurred while kill application '" + string + "'."), (Throwable)iOException);
            }
        } else {
            log.info((Object)("Could not location application '" + string + "'."));
        }
    }

    public final int getProcessCount(String string) throws IOException {
        boolean bl;
        String string2;
        int n = 0;
        File file = this.getApplicationLocation(string);
        String[] stringArray = this.getProcesses();
        if (file == null) {
            string2 = "/" + string;
            bl = false;
        } else {
            string2 = file.getAbsolutePath();
            bl = true;
        }
        log.info((Object)("Will check process state for '" + string2 + "' (FullSearch=" + bl + ")."));
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            if (bl && stringArray[i].startsWith(string2)) {
                ++n;
                continue;
            }
            if (bl || !stringArray[i].contains(string2)) continue;
            ++n;
        }
        return n;
    }

    public void setServiceState(String string, int n) {
    }

    public int getServiceState(String string) {
        return 0;
    }

    public File getApplicationLocation(String string) {
        File file;
        log.debug((Object)(string + " - Will find location of application '" + string + "'."));
        if (string.startsWith("/") && (file = new File(string)).exists()) {
            log.debug((Object)(string + " - Application was located at the full path provided: " + file.getAbsolutePath()));
            return file;
        }
        file = this.getLastKnown(string);
        if (file != null && file.exists()) {
            log.debug((Object)(string + " - Application was located via the last-known cache at: " + file.getAbsolutePath()));
            return file;
        }
        File file2 = new File("/Applications");
        file = this.getApplicationLocation(file2, string, false, 0, 4);
        if (file != null) {
            log.debug((Object)(string + " - Application '" + string + "' located in Applications at " + file.getAbsolutePath()));
            this.setLastKnown(string, file);
            return file;
        }
        file2 = new File("/System/Library/CoreServices");
        file = this.getApplicationLocation(file2, string, false, 0, 1);
        if (file != null) {
            log.debug((Object)(string + " - Application '" + string + "' located in CoreServices at " + file.getAbsolutePath()));
            this.setLastKnown(string, file);
            return file;
        }
        file2 = new File("/Library/Application Support");
        file = this.getApplicationLocation(file2, string, false, 0, 4);
        if (file != null) {
            log.debug((Object)(string + " - Application '" + string + "' located in Application Support at " + file.getAbsolutePath()));
            this.setLastKnown(string, file);
            return file;
        }
        file2 = new File(System.getProperty("user.home"), "Desktop");
        file = this.getApplicationLocation(file2, string, false, 0, 1);
        if (file != null) {
            log.debug((Object)(string + " - Application '" + string + "' located in Desktop at " + file.getAbsolutePath()));
            this.setLastKnown(string, file);
            return file;
        }
        file2 = new File(System.getProperty("user.home"), "Documents");
        file = this.getApplicationLocation(file2, string, false, 0, 1);
        if (file != null) {
            log.debug((Object)(string + " - Application '" + string + "' located in Documents at " + file.getAbsolutePath()));
            this.setLastKnown(string, file);
            return file;
        }
        try {
            File[] fileArray = DockController.getPersistentApps(this.cls_FileHandler, this.cls_CommandHandler);
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    if (fileArray[i] != null && fileArray[i].exists()) {
                        file = this.getApplicationLocation(fileArray[i], string, false, 0, 1);
                        if (file == null) continue;
                        log.debug((Object)(string + " - Application '" + string + "' located via Dock in " + fileArray[i].getAbsolutePath()));
                        this.setLastKnown(string, file);
                        return file;
                    }
                    log.debug((Object)(string + "     - Dock path doesn't exist: " + fileArray[i].getAbsolutePath()));
                }
            }
        }
        catch (Exception exception) {
            log.debug((Object)(string + " - An exception occurred while checking the applications in the Dock."), (Throwable)exception);
        }
        try {
            log.debug((Object)(string + " - Will remove last known location of '" + string + "'..."));
            cls_LastKnown.remove(string);
            log.debug((Object)(string + " - Last known location of '" + string + "' removed."));
        }
        catch (Exception exception) {
            log.debug((Object)(string + " - Error occurred while trying to remove last known location of '" + string + "'."), (Throwable)exception);
        }
        log.debug((Object)(string + " - GetApplicationLocation is returning null."));
        return null;
    }

    private File getApplicationLocation(File file, String string, boolean bl, int n, int n2) {
        String string2 = string + " - ";
        for (int i = 0; i < n; ++i) {
            string2 = string2 + "  ";
        }
        log.debug((Object)(string2 + "Will find location of '" + string + "' from " + file.getAbsolutePath()));
        if (string != null && !string.endsWith(".app")) {
            string = string + ".app";
        }
        if (file != null && file.exists() && file.isDirectory()) {
            if (file.getName().equals(string)) {
                return file;
            }
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    Object object;
                    if (!fileArray[i].isDirectory()) continue;
                    if (fileArray[i].getName().equals(string)) {
                        log.debug((Object)"  - Found by name.");
                        return fileArray[i];
                    }
                    if (fileArray[i].getName().endsWith(".app")) {
                        String string3;
                        log.debug((Object)(string2 + "Found another application: " + fileArray[i].getAbsolutePath()));
                        this.setLastKnown(fileArray[i].getName(), fileArray[i]);
                        object = cls_VerifiedApplications.get(fileArray[i]);
                        if (object != null) {
                            if (!((String)object).equals(string)) continue;
                            return fileArray[i];
                        }
                        if (!bl || (string3 = this.getInternalName(fileArray[i])).length() <= 0) continue;
                        string3 = string3 + ".app";
                        cls_VerifiedApplications.put(fileArray[i], string3);
                        if (string3.equals(fileArray[i].getName())) continue;
                        log.debug((Object)(string2 + "  - Internal manifest name is " + string3 + " (vs " + fileArray[i].getName() + ")."));
                        this.setLastKnown(string3, fileArray[i]);
                        if (!string3.equals(string)) continue;
                        return fileArray[i];
                    }
                    if (n >= n2 - 1) continue;
                    log.debug((Object)(string2 + "- Current depth is " + n + " of " + n2));
                    object = this.getApplicationLocation(fileArray[i], string, bl, n + 1, n2);
                    if (object == null) continue;
                    return object;
                }
            }
        }
        log.debug((Object)(string2 + "- Done looking.  Returning null."));
        return null;
    }

    public static final void killApplication(CommandHandler commandHandler, String string) {
        String[] stringArray = new String[]{"killall", string};
        try {
            CommandResponse commandResponse = commandHandler.executeCommand(stringArray);
            commandResponse.waitFor();
        }
        catch (IOException iOException) {
            log.warn((Object)("An error occurred while kill application '" + string + "'."), (Throwable)iOException);
        }
    }

    public static void killSystemPreferences(CommandHandler commandHandler) {
        MacApplicationProvider.killApplication(commandHandler, "System Preferences");
    }

    public ApplicationProvider.InstallResult installApplication(File file, String string, String string2) throws IOException {
        boolean bl;
        boolean bl2 = string2 != null && string2.contains("/Utilities");
        boolean bl3 = bl = string2 != null && string2.contains("/Open");
        if (file.getAbsolutePath().endsWith(".dmg")) {
            log.info((Object)("Will open DMG file: " + file.getAbsolutePath() + "."));
            this.launchApplication(file.getAbsolutePath());
            bl = false;
        } else if (file.getAbsolutePath().endsWith(".app.zip")) {
            if (!this.cls_Maccmd.installApplication(file, bl2)) {
                log.info((Object)"Maccmd reported that installation failed.");
            }
        } else {
            if (file.getAbsolutePath().endsWith(".mpkg.zip")) {
                log.info((Object)("Will open MPKG file from zip: " + file.getAbsolutePath() + "."));
                FileUtil.unzipFileToFolder(file, FileUtil.getUserTmpDir(), this.cls_CommandHandler);
                String string3 = file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - 4);
                if (new File(string3).exists()) {
                    log.debug((Object)("File '" + string3 + "' exists.  Will set execute bit on '" + new File(string3).getAbsolutePath() + "'."));
                    CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(new String[]{"/bin/chmod", "-R", "+x", new File(string3).getAbsolutePath()});
                    commandResponse.waitFor();
                    log.info((Object)Util.join(commandResponse.getError()));
                    log.info((Object)Util.join(commandResponse.getOutput()));
                    log.debug((Object)("File '" + string3 + "' exists.  Will launch."));
                    this.launchApplication(string3);
                    if (this.getProcessCount("Installer") > 0) {
                        log.info((Object)"Installer is running.");
                        return ApplicationProvider.InstallResult.SUCCESS_INSTALLER_RUNNING;
                    }
                    for (int i = 0; i < 3; ++i) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (this.getProcessCount("Installer") <= 0) continue;
                        log.info((Object)("Installer is running on check " + (i + 1 + 1) + "."));
                        return ApplicationProvider.InstallResult.SUCCESS_INSTALLER_RUNNING;
                    }
                    log.info((Object)"Installer is not running.");
                    return ApplicationProvider.InstallResult.FAILED_TO_LOAD_FILE;
                }
                return ApplicationProvider.InstallResult.FAILED_TO_UNZIP_FILE;
            }
            if (file.getAbsolutePath().endsWith(".pkg.zip") || file.getAbsolutePath().endsWith(".zip")) {
                log.info((Object)("Will open PKG file from zip: " + file.getAbsolutePath() + "."));
                FileUtil.unzipFileToFolder(file, FileUtil.getUserTmpDir(), this.cls_CommandHandler);
                log.info((Object)"Zip file unzipped.");
                String string4 = file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - 4);
                if (!string4.endsWith(".pkg")) {
                    string4 = string4 + ".pkg";
                }
                log.info((Object)("Package name is '" + string4 + "."));
                if (new File(string4).exists()) {
                    log.debug((Object)("File '" + string4 + "' exists.  Will launch."));
                    this.launchApplication(string4);
                    log.debug((Object)("File '" + string4 + " launched."));
                    if (this.getProcessCount("Installer") > 0) {
                        log.info((Object)"Installer is running.");
                        return ApplicationProvider.InstallResult.SUCCESS_INSTALLER_RUNNING;
                    }
                    for (int i = 0; i < 3; ++i) {
                        try {
                            log.debug((Object)"Waiting for installer to launch.");
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (this.getProcessCount("Installer") <= 0) continue;
                        log.info((Object)("Installer is running on check " + (i + 1 + 1) + "."));
                        return ApplicationProvider.InstallResult.SUCCESS_INSTALLER_RUNNING;
                    }
                    log.info((Object)"Installer is not running.");
                    return ApplicationProvider.InstallResult.FAILED_TO_LOAD_FILE;
                }
                log.info((Object)"Couldn't determine unzipped file type.");
                return ApplicationProvider.InstallResult.FAILED_TO_UNZIP_FILE;
            }
            if (!this.cls_Maccmd.installApplication(file, bl2)) {
                log.info((Object)"Maccmd reported that installation failed.");
            }
        }
        if (bl) {
            log.info((Object)("Will launch application '" + string + "'."));
            this.launchApplication(string);
        }
        return this.isApplicationInstalled(string) ? ApplicationProvider.InstallResult.SUCCESS : ApplicationProvider.InstallResult.GENERAL_FAILURE;
    }

    protected final String[] getProcesses() throws IOException {
        CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(new String[]{"ps", "-A", "-o", "command="});
        commandResponse.waitFor();
        String[] stringArray = commandResponse.getOutput();
        return stringArray;
    }

    private String getInternalName(File file) {
        File file2 = new File(file, "/Contents/Info.plist");
        if (!file2.exists()) {
            log.debug((Object)"  - Info not available.");
            return "";
        }
        Plist plist = PlistUtil.getCurrentPlist(this.cls_FileHandler, this.cls_CommandHandler, file2, null);
        if (plist == null) {
            log.debug((Object)"  - Couldn't load version info.");
            return "";
        }
        return plist.getDict().getString("CFBundleName", "");
    }

    public void flushCaches() {
        log.debug((Object)"Flushing caches...");
        cls_LastKnown.clear();
        cls_VerifiedApplications.clear();
    }

    public void printCaches() {
        int n;
        Object[] objectArray = cls_LastKnown.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            System.out.println(objectArray[n] + " -> " + cls_LastKnown.get(objectArray[n]));
        }
        System.out.println("\n\nVerified Names\n");
        objectArray = cls_VerifiedApplications.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            System.out.println(objectArray[n] + " -> " + cls_VerifiedApplications.get(objectArray[n]));
        }
    }

    private File getLastKnown(String string) {
        if (string.endsWith(".app")) {
            string = string.substring(0, string.length() - 4);
        }
        return cls_LastKnown.get(string);
    }

    private void setLastKnown(String string, File file) {
        if (string.endsWith(".app")) {
            string = string.substring(0, string.length() - 4);
        }
        cls_LastKnown.put(string, file);
    }
}

