/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.common.plist.pojo;

import com.cloudpath.common.os.mac.common.plist.pojo.Pair;
import com.cloudpath.common.os.mac.common.plist.pojo.PairValue;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueArray;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueBoolean;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueComment;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueDate;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueInteger;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueReal;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueString;
import com.cloudpath.common.util.XmlUtil;
import java.util.ArrayList;

public class Dict
implements PairValue {
    public static final String ELEMENT = "dict";
    private ValueComment cls_Comment = null;
    private ArrayList<Pair> cls_Pairs = new ArrayList();

    public void setString(String string) {
    }

    public String getString() {
        return null;
    }

    public void setComment(String string) {
        this.cls_Comment = new ValueComment(string);
    }

    public void addPair(String string, boolean bl) {
        this.addPair(string, new ValueBoolean(bl));
    }

    public void addPair(String string, String string2) {
        this.addPair(string, new ValueString(string2));
    }

    public void addPair(String string, int n) {
        this.addPair(string, new ValueInteger(n));
    }

    public void addPair(String string, long l) {
        this.addPair(string, new ValueInteger(l));
    }

    public void addReal(String string, String string2) {
        this.addPair(string, new ValueReal(string2));
    }

    public void addDate(String string, String string2) {
        this.addPair(string, new ValueDate(string2));
    }

    public void addPair(String string, PairValue pairValue) {
        this.addPair(new Pair(string, pairValue));
    }

    public void addPair(String string, PairValue pairValue, boolean bl) {
        this.addPair(new Pair(string, pairValue, bl));
    }

    public void addPair(Pair pair) {
        this.cls_Pairs.add(pair);
    }

    public int getPairCount() {
        return this.cls_Pairs.size();
    }

    public Pair getPair(int n) {
        return this.cls_Pairs.get(n);
    }

    public void clear() {
        this.cls_Pairs.clear();
    }

    public void removeKey(String string) {
        for (int i = 0; i < this.getPairCount(); ++i) {
            if (!string.equals(this.getPair(i).getKey())) continue;
            this.cls_Pairs.remove(i);
            --i;
        }
    }

    public PairValue getKeyValue(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < this.getPairCount(); ++i) {
            if (!string.equals(this.getPair(i).getKey())) continue;
            return this.getPair(i).getValue();
        }
        return null;
    }

    public Pair[] getPairs() {
        Pair[] pairArray = new Pair[this.cls_Pairs.size()];
        this.cls_Pairs.toArray(pairArray);
        return pairArray;
    }

    public String getXml(String string) {
        if (this.getPairCount() == 0) {
            return string + XmlUtil.createElementIsolated(ELEMENT);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + XmlUtil.createElementOpen(ELEMENT));
        if (this.cls_Comment != null) {
            stringBuffer.append(this.cls_Comment.getXml(string));
        }
        for (int i = 0; i < this.getPairCount(); ++i) {
            stringBuffer.append(this.getPair(i).getXml(string + "\t"));
        }
        stringBuffer.append(string + XmlUtil.createElementClose(ELEMENT));
        return stringBuffer.toString();
    }

    public Dict getDict(String string, Dict dict) {
        PairValue pairValue = this.getKeyValue(string);
        if (pairValue == null || !(pairValue instanceof Dict)) {
            return dict;
        }
        return (Dict)pairValue;
    }

    public String getString(String string, String string2) {
        PairValue pairValue = this.getKeyValue(string);
        if (pairValue == null) {
            return string2;
        }
        return pairValue.getString();
    }

    public String getData(String string, String string2) {
        PairValue pairValue = this.getKeyValue(string);
        if (pairValue == null) {
            return string2;
        }
        return pairValue.getString();
    }

    public long getDate(String string, long l) {
        PairValue pairValue = this.getKeyValue(string);
        if (pairValue == null || !(pairValue instanceof ValueDate)) {
            return l;
        }
        return ((ValueDate)pairValue).getTimestamp();
    }

    public long getInteger(String string, long l) {
        PairValue pairValue = this.getKeyValue(string);
        if (pairValue == null || !(pairValue instanceof ValueInteger)) {
            return l;
        }
        return ((ValueInteger)pairValue).getValue();
    }

    public boolean getBoolean(String string, boolean bl) {
        PairValue pairValue = this.getKeyValue(string);
        if (pairValue == null || !(pairValue instanceof ValueBoolean)) {
            return bl;
        }
        return ((ValueBoolean)pairValue).getValue();
    }

    public ValueArray getArray(String string, ValueArray valueArray) {
        PairValue pairValue = this.getKeyValue(string);
        if (pairValue == null || !(pairValue instanceof ValueArray)) {
            return valueArray;
        }
        return (ValueArray)pairValue;
    }

    public PairValue clone() {
        Dict dict = new Dict();
        for (int i = 0; i < this.cls_Pairs.size(); ++i) {
            dict.addPair(this.cls_Pairs.get(i).clone());
        }
        return dict;
    }

    public String toString() {
        return "[Dict xml=" + this.getXml("") + "]";
    }
}

