/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.common.plist;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.os.mac.common.plist.PlistConstants;
import com.cloudpath.common.os.mac.common.plist.pojo.Dict;
import com.cloudpath.common.os.mac.common.plist.pojo.PairValue;
import com.cloudpath.common.os.mac.common.plist.pojo.Plist;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueArray;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueBoolean;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueDate;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueInteger;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueString;
import com.cloudpath.common.util.FileHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import java.util.UUID;
import org.apache.log4j.Logger;

public class PlistUtil {
    private static final Logger log = Logger.getLogger(PlistUtil.class);

    public static Plist getCurrentPlist(FileHandler fileHandler, CommandHandler commandHandler, File file, Plist plist) {
        log.debug((Object)("[CPN~] Will read from file " + file));
        if (fileHandler == null || !fileHandler.exists(file)) {
            log.debug((Object)(file.getAbsolutePath() + " config file doesn't exist.  Will use blank."));
            return plist;
        }
        try {
            return PlistConstants.readPlist(commandHandler, fileHandler, file);
        }
        catch (Exception exception) {
            log.debug((Object)("Error occurred while parsing " + file.getName() + " config file.  Will use default."), (Throwable)exception);
            return plist;
        }
    }

    public static boolean getBooleanValue(Dict dict, String string, boolean bl) {
        PairValue pairValue = dict.getKeyValue(string);
        if (pairValue != null && pairValue instanceof ValueBoolean) {
            return ((ValueBoolean)pairValue).getValue();
        }
        return bl;
    }

    public static long getIntegerValue(Dict dict, String string, long l) {
        PairValue pairValue = dict.getKeyValue(string);
        if (pairValue != null && pairValue instanceof ValueInteger) {
            return ((ValueInteger)pairValue).getValue();
        }
        return l;
    }

    public static String getStringValue(Dict dict, String string, String string2) {
        PairValue pairValue = dict.getKeyValue(string);
        if (pairValue != null && pairValue instanceof ValueString) {
            return ((ValueString)pairValue).getValue();
        }
        return string2;
    }

    public static long getDateValue(Dict dict, String string, long l) {
        PairValue pairValue = dict.getKeyValue(string);
        if (pairValue != null && pairValue instanceof ValueDate) {
            return ((ValueDate)pairValue).getTimestamp();
        }
        return l;
    }

    public static long[] getIntArrayValue(Dict dict, String string) {
        int n;
        Object object;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        PairValue pairValue = dict.getKeyValue(string);
        if (pairValue != null && pairValue instanceof ValueArray) {
            object = (ValueArray)pairValue;
            for (n = 0; n < ((ValueArray)object).getValueCount(); ++n) {
                PairValue pairValue2 = ((ValueArray)object).getValue(n);
                if (pairValue2 == null || !(pairValue2 instanceof ValueInteger)) continue;
                arrayList.add(((ValueInteger)pairValue2).getValue());
            }
        }
        object = new long[arrayList.size()];
        for (n = 0; n < ((long[])object).length; ++n) {
            object[n] = (Long)arrayList.get(n);
        }
        return object;
    }

    public static String[] getStringArrayValue(Dict dict, String string) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        PairValue pairValue = dict.getKeyValue(string);
        if (pairValue != null && pairValue instanceof ValueArray) {
            stringArray = (ValueArray)pairValue;
            for (int i = 0; i < stringArray.getValueCount(); ++i) {
                PairValue pairValue2 = stringArray.getValue(i);
                if (pairValue2 == null || !(pairValue2 instanceof ValueString)) continue;
                arrayList.add(((ValueString)pairValue2).getValue());
            }
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static String generateGuid() {
        return UUID.randomUUID().toString().toUpperCase(Locale.US);
    }
}

