/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.common.network.scutil;

import com.cloudpath.common.command.CommandHandlerImpl;
import com.cloudpath.common.command.CommandResponse;
import com.cloudpath.common.os.mac.common.MacUtil;
import com.cloudpath.common.os.mac.common.network.networksetup.HttpProxyBehavior;
import com.cloudpath.common.pojo.NetworkInterface;
import com.cloudpath.common.util.FileUtil;
import com.cloudpath.common.util.Util;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ScUtilInterface {
    private static final Logger log = Logger.getLogger(ScUtilInterface.class);
    private ArrayList<String> guidList = new ArrayList();

    private void genScListCmd() throws IOException {
        File file = new File(FileUtil.getUserTmpDir(), "sclist");
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.append("echo \"list /NetworkServices\" | /usr/sbin/scutil --prefs");
        bufferedWriter.close();
    }

    private void cleanUpScListCmd() {
        File file = new File(FileUtil.getUserTmpDir(), "sclist");
        if (file.exists() && !file.delete()) {
            file.deleteOnExit();
        }
    }

    private void parseLine(String string) {
        String[] stringArray = (string = string.trim()).split("=");
        if (stringArray != null && stringArray.length >= 2) {
            String string2 = stringArray[1].trim();
            log.info((Object)("Adding : " + string2 + "/Proxies"));
            this.guidList.add(string2 + "/Proxies");
        }
    }

    public void enumGuidList() {
        File file = new File(FileUtil.getUserTmpDir(), "sclist");
        CommandHandlerImpl commandHandlerImpl = new CommandHandlerImpl();
        String[] stringArray = new String[]{"/bin/sh", file.getAbsolutePath()};
        log.info((Object)"Loading GUID list...");
        try {
            this.genScListCmd();
            CommandResponse commandResponse = commandHandlerImpl.executeCommand(stringArray);
            commandResponse.waitFor();
            for (int i = 0; i < commandResponse.getOutput().length; ++i) {
                log.info((Object)("ScUtil Output : " + commandResponse.getOutput()[i]));
                this.parseLine(commandResponse.getOutput()[i]);
            }
            this.cleanUpScListCmd();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeDisableProxyScript() throws IOException {
        File file = new File(FileUtil.getUserTmpDir(), "scproxyscript");
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.append("open\n");
        bufferedWriter.append("lock\n");
        for (int i = 0; i < this.guidList.size(); ++i) {
            bufferedWriter.append("get " + this.guidList.get(i) + "\n");
            bufferedWriter.append("d.remove ProxyAutoConfigEnable\n");
            bufferedWriter.append("d.remove ProxyAutoDiscoveryEnable\n");
            bufferedWriter.append("d.remove HTTPEnable\n");
            bufferedWriter.append("d.remove HTTPPort\n");
            bufferedWriter.append("d.remove HTTPProxy\n");
            bufferedWriter.append("d.remove ProxyAutoConfigURLString\n");
            bufferedWriter.append("set " + this.guidList.get(i) + "\n");
        }
        bufferedWriter.append("commit\n");
        bufferedWriter.append("apply\n");
        bufferedWriter.append("unlock\n");
        bufferedWriter.append("quit\n");
        bufferedWriter.close();
    }

    private void writeStaticProxyScript(HttpProxyBehavior httpProxyBehavior) throws IOException {
        File file = new File(FileUtil.getUserTmpDir(), "scproxyscript");
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.append("open\n");
        bufferedWriter.append("lock\n");
        for (int i = 0; i < this.guidList.size(); ++i) {
            bufferedWriter.append("get " + this.guidList.get(i) + "\n");
            bufferedWriter.append("d.remove ProxyAutoConfigEnable\n");
            bufferedWriter.append("d.remove ProxyAutoDiscoveryEnable\n");
            bufferedWriter.append("d.add HTTPEnable # 1\n");
            bufferedWriter.append("d.add HTTPPort # " + httpProxyBehavior.getHttpProxyPort() + "\n");
            bufferedWriter.append("d.add HTTPProxy " + httpProxyBehavior.getServerOnly() + "\n");
            bufferedWriter.append("d.remove ProxyAutoConfigURLString\n");
            bufferedWriter.append("set " + this.guidList.get(i) + "\n");
        }
        bufferedWriter.append("commit\n");
        bufferedWriter.append("apply\n");
        bufferedWriter.append("unlock\n");
        bufferedWriter.append("quit\n");
        bufferedWriter.close();
    }

    private void writeAutoDetectProxyScript() throws IOException {
        File file = new File(FileUtil.getUserTmpDir(), "scproxyscript");
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.append("open\n");
        bufferedWriter.append("lock\n");
        for (int i = 0; i < this.guidList.size(); ++i) {
            bufferedWriter.append("get " + this.guidList.get(i) + "\n");
            bufferedWriter.append("d.remove ProxyAutoConfigEnable\n");
            bufferedWriter.append("d.add ProxyAutoDiscoveryEnable # 1\n");
            bufferedWriter.append("d.remove HTTPEnable\n");
            bufferedWriter.append("d.remove HTTPPort\n");
            bufferedWriter.append("d.remove HTTPProxy\n");
            bufferedWriter.append("d.remove ProxyAutoConfigURLString\n");
            bufferedWriter.append("set " + this.guidList.get(i) + "\n");
        }
        bufferedWriter.append("commit\n");
        bufferedWriter.append("apply\n");
        bufferedWriter.append("unlock\n");
        bufferedWriter.append("quit\n");
        bufferedWriter.close();
    }

    private void writeAutoConfigProxyScript(HttpProxyBehavior httpProxyBehavior) throws IOException {
        File file = new File(FileUtil.getUserTmpDir(), "scproxyscript");
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.append("open\n");
        bufferedWriter.append("lock\n");
        for (int i = 0; i < this.guidList.size(); ++i) {
            bufferedWriter.append("get " + this.guidList.get(i) + "\n");
            bufferedWriter.append("d.add ProxyAutoConfigEnable # 1\n");
            bufferedWriter.append("d.remove ProxyAutoDiscoveryEnable\n");
            bufferedWriter.append("d.remove HTTPEnable\n");
            bufferedWriter.append("d.remove HTTPPort\n");
            bufferedWriter.append("d.remove HTTPProxy\n");
            bufferedWriter.append("d.add ProxyAutoConfigURLString " + httpProxyBehavior.getHttpProxyAutoconfUrl() + "\n");
            bufferedWriter.append("set " + this.guidList.get(i) + "\n");
        }
        bufferedWriter.append("commit\n");
        bufferedWriter.append("apply\n");
        bufferedWriter.append("unlock\n");
        bufferedWriter.append("quit\n");
        bufferedWriter.close();
    }

    private void createScUtilProxyUpdateScript(HttpProxyBehavior httpProxyBehavior) throws IOException {
        File file = new File(FileUtil.getUserTmpDir(), "scproxyupdate");
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.append("/usr/sbin/scutil --prefs < \"" + FileUtil.getUserTmpDir() + "/scproxyscript\"");
        bufferedWriter.close();
        if (httpProxyBehavior.getHttpProxyType().equals((Object)HttpProxyBehavior.HttpProxyType.DISABLED)) {
            this.writeDisableProxyScript();
        } else if (httpProxyBehavior.getHttpProxyType().equals((Object)HttpProxyBehavior.HttpProxyType.MANUAL)) {
            this.writeStaticProxyScript(httpProxyBehavior);
        } else if (httpProxyBehavior.getHttpProxyType().equals((Object)HttpProxyBehavior.HttpProxyType.AUTODETECT)) {
            this.writeAutoDetectProxyScript();
        } else if (httpProxyBehavior.getHttpProxyType().equals((Object)HttpProxyBehavior.HttpProxyType.AUTO_BY_URL)) {
            this.writeAutoConfigProxyScript(httpProxyBehavior);
        } else if (httpProxyBehavior.getHttpProxyType().equals((Object)HttpProxyBehavior.HttpProxyType.AUTO_OR_BY_URL)) {
            this.writeAutoOrByUrl(httpProxyBehavior);
        }
    }

    private void writeAutoOrByUrl(HttpProxyBehavior httpProxyBehavior) throws IOException {
        if (MacUtil.getSystemSoftwareVersion().startsWith("10.5")) {
            this.writeAutoConfigProxyScript(httpProxyBehavior);
        } else {
            this.writeAutoDetectProxyScript();
        }
    }

    private void cleanUpScUtilProxyUpdateScript() {
        File file;
        File file2 = new File(FileUtil.getUserTmpDir(), "scproxyupdate");
        if (file2.exists() && !file2.delete()) {
            file2.deleteOnExit();
        }
        if ((file = new File(FileUtil.getUserTmpDir(), "scproxyscript")).exists() && !file.delete()) {
            file.deleteOnExit();
        }
    }

    public void setProxyOnAllGuids(HttpProxyBehavior httpProxyBehavior) {
        File file = new File(FileUtil.getUserTmpDir(), "scproxyupdate");
        CommandHandlerImpl commandHandlerImpl = new CommandHandlerImpl();
        String[] stringArray = new String[]{"/bin/sh", file.getAbsolutePath()};
        try {
            this.createScUtilProxyUpdateScript(httpProxyBehavior);
            CommandResponse commandResponse = commandHandlerImpl.executeCommand(stringArray);
            commandResponse.waitFor();
            log.info((Object)("ScUtil result : " + commandResponse.getExitValue()));
            this.cleanUpScUtilProxyUpdateScript();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void createScUtilQueryProxyScript(String string) throws IOException {
        File file = new File(FileUtil.getUserTmpDir(), "scproxyget");
        File file2 = new File(FileUtil.getUserTmpDir(), "scgetscript");
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.append("/usr/sbin/scutil --prefs < \"" + file2.getAbsolutePath() + "\"");
        bufferedWriter.close();
        BufferedWriter bufferedWriter2 = new BufferedWriter(new FileWriter(file2));
        bufferedWriter2.append("get " + string + "\n");
        bufferedWriter2.append("d.show\n");
        bufferedWriter2.append("quit\n");
        bufferedWriter2.close();
    }

    private void cleanUpScUtilQueryProxyScript() {
        File file = new File(FileUtil.getUserTmpDir(), "scproxyget");
        File file2 = new File(FileUtil.getUserTmpDir(), "scgetscript");
        if (file.exists() && !file.delete()) {
            file.deleteOnExit();
        }
        if (file2.exists() && !file2.delete()) {
            file2.deleteOnExit();
        }
    }

    public boolean allProxySettingsMatch(HttpProxyBehavior httpProxyBehavior, NetworkInterface networkInterface) {
        boolean bl = true;
        log.info((Object)("Will check proxy settings for nic " + (networkInterface != null ? networkInterface.getLogicalGuid() : "all")));
        for (int i = 0; bl && i < this.guidList.size(); ++i) {
            log.info((Object)("Looking at NIC " + this.guidList.get(i)));
            if (networkInterface != null && !this.guidList.get(i).startsWith(networkInterface.getLogicalGuid())) continue;
            try {
                this.createScUtilQueryProxyScript(this.guidList.get(i));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                bl = false;
                break;
            }
            File file = new File(FileUtil.getUserTmpDir(), "scproxyget");
            CommandHandlerImpl commandHandlerImpl = new CommandHandlerImpl();
            String[] stringArray = new String[]{"/bin/sh", file.getAbsolutePath()};
            try {
                CommandResponse commandResponse = commandHandlerImpl.executeCommand(stringArray);
                commandResponse.waitFor();
                HttpProxyBehavior httpProxyBehavior2 = new HttpProxyBehavior();
                log.info((Object)("Proxy response: " + Util.join(commandResponse.getOutput(), '\n')));
                httpProxyBehavior2.parse(commandResponse.getOutput());
                log.info((Object)"Will compare current and desired behaviors.");
                log.info((Object)("Current: " + httpProxyBehavior2));
                log.info((Object)("Desired: " + httpProxyBehavior));
                if (!httpProxyBehavior.equals(httpProxyBehavior2)) {
                    log.info((Object)"Behaviours do not match.");
                    bl = false;
                    this.cleanUpScUtilQueryProxyScript();
                    break;
                }
                log.info((Object)"Behaviours match.");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.cleanUpScUtilQueryProxyScript();
        }
        return bl;
    }
}

