/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.common.network.networksetup;

import com.cloudpath.common.os.mac.common.MacUtil;
import com.cloudpath.common.os.mac.common.network.networksetup.Ipv6Behavior;

public class ServiceInfo {
    private static final String DHCP_CONFIGURATION = "DHCP Configuration";
    private static final String IP_ADDRESS = "IP address: ";
    private static final String SUBNET_MASK = "Subnet mask: ";
    private static final String ROUTER = "Router: ";
    private static final String IPV6 = "IPv6: ";
    private static final String IPV6_ADDRESS = "IPv6 IP address: ";
    private static final String IPV6_ROUTER = "IPv6 Router: ";
    private static final String IPV6_PREFIX_LENGTH = "IPv6 Prefix Length: ";
    private String cls_ServiceName = "";
    private boolean cls_IsDhcp = false;
    private String cls_IpAddress = "";
    private String cls_SubnetMask = "";
    private String cls_Router = "";
    private Ipv6Behavior cls_Ipv6Behavior = new Ipv6Behavior(Ipv6Behavior.Ipv6Type.OFF);

    public ServiceInfo(String string, String string2) {
        this.cls_ServiceName = string;
        String[] stringArray = string2.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            this.parseLine(stringArray[i]);
        }
    }

    public String getServiceName() {
        return this.cls_ServiceName;
    }

    public boolean isDhcp() {
        return this.cls_IsDhcp;
    }

    public String getIpAddress() {
        return this.cls_IpAddress;
    }

    public String getSubnetMask() {
        return this.cls_SubnetMask;
    }

    public String getRouter() {
        return this.cls_Router;
    }

    public Ipv6Behavior getIpv6Behavior() {
        return this.cls_Ipv6Behavior;
    }

    private void parseLine(String string) {
        if ((string = string.trim()).startsWith(IP_ADDRESS)) {
            this.cls_IpAddress = this.checkNull(MacUtil.parseSetting(string, IP_ADDRESS, null));
        } else if (string.startsWith(SUBNET_MASK)) {
            this.cls_SubnetMask = this.checkNull(MacUtil.parseSetting(string, SUBNET_MASK, null));
        } else if (string.startsWith(ROUTER)) {
            this.cls_Router = this.checkNull(MacUtil.parseSetting(string, ROUTER, null));
        } else if (string.startsWith(DHCP_CONFIGURATION)) {
            this.cls_IsDhcp = true;
        } else if (string.startsWith(IPV6)) {
            String string2 = MacUtil.parseSetting(string, IPV6, null);
            Ipv6Behavior.Ipv6Type ipv6Type = Ipv6Behavior.Ipv6Type.parse(string2);
            this.cls_Ipv6Behavior = new Ipv6Behavior(ipv6Type);
        } else if (string.startsWith(IPV6_ADDRESS)) {
            String string3 = this.checkNull(MacUtil.parseSetting(string, IPV6_ADDRESS, null));
            this.cls_Ipv6Behavior.setIpv6Address(string3);
        } else if (string.startsWith(IPV6_ROUTER)) {
            String string4 = this.checkNull(MacUtil.parseSetting(string, IPV6_ROUTER, null));
            this.cls_Ipv6Behavior.setIpv6Router(string4);
        } else if (string.startsWith(IPV6_PREFIX_LENGTH)) {
            String string5 = this.checkNull(MacUtil.parseSetting(string, IPV6_PREFIX_LENGTH, null));
            this.cls_Ipv6Behavior.setIpv6PrefixLength(string5);
        }
    }

    private String checkNull(String string) {
        if (string == null || string.equals("(null)") || string.equals("none")) {
            return "";
        }
        return string;
    }
}

