/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.common.network.networksetup;

import com.cloudpath.common.os.mac.common.MacUtil;

public class HardwarePort {
    private static final String HARDWARE_PORT = "Hardware Port: ";
    private static final String DEVICE = "Device: ";
    private static final String ETHERNET_ADDRESS = "Ethernet Address: ";
    private String cls_HardwarePort;
    private String cls_DeviceName;
    private String cls_MacAddress;

    public HardwarePort(String string) {
        String[] stringArray = string.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            this.parseLine(stringArray[i]);
        }
    }

    public String getHardwarePort() {
        return this.cls_HardwarePort;
    }

    public String getDeviceName() {
        return this.cls_DeviceName;
    }

    public String getMacAddress() {
        return this.cls_MacAddress;
    }

    public boolean isEthernet() {
        return this.getHardwarePort() != null && this.getHardwarePort().toLowerCase().contains("ethernet");
    }

    public boolean isAirport() {
        return this.getHardwarePort() != null && (this.getHardwarePort().toLowerCase().contains("airport") || this.getHardwarePort().toLowerCase().contains("wi-fi") || this.getHardwarePort().toLowerCase().contains("wifi"));
    }

    private void parseLine(String string) {
        if ((string = string.trim()).startsWith(HARDWARE_PORT)) {
            this.cls_HardwarePort = MacUtil.parseSetting(string, HARDWARE_PORT, null);
        } else if (string.startsWith(DEVICE)) {
            this.cls_DeviceName = MacUtil.parseSetting(string, DEVICE, null);
        } else if (string.startsWith(ETHERNET_ADDRESS)) {
            this.cls_MacAddress = MacUtil.parseSetting(string, ETHERNET_ADDRESS, null);
        }
    }
}

