/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.common.network.ifconfig;

import com.cloudpath.common.os.common.NicProvider;
import com.cloudpath.common.os.mac.common.network.ifconfig.IpListener;
import com.cloudpath.common.pojo.NetworkInterface;
import com.cloudpath.common.util.Util;
import org.apache.log4j.Logger;

public class IpMonitor
implements Runnable {
    private static final Logger log = Logger.getLogger(IpMonitor.class);
    public static final boolean STOP_AFTER_IP_RECEIVED = false;
    public static final boolean CONTINUE_TO_RUN = true;
    private static long COUNTER = 1L;
    private boolean cls_Continue = true;
    private final NicProvider cls_NicProvider;
    private final NetworkInterface cls_Nic;
    private final String[] cls_DesiredSubnets;
    private final IpListener cls_IpListener;
    private final int cls_BackoffInterval;
    private final Thread cls_Thread;
    private int cls_PollingInterval;
    private final long cls_StopTime;
    private final String cls_Id;
    private final boolean cls_ListenUntilStopped;
    private String cls_LastIp = "";

    public IpMonitor(String string, NicProvider nicProvider, NetworkInterface networkInterface, String[] stringArray, IpListener ipListener, int n, int n2, long l, boolean bl) {
        this.cls_Id = "(" + COUNTER++ + ") - " + string;
        log.info((Object)("Starting " + this.getClass().getSimpleName() + this.cls_Id));
        this.cls_NicProvider = nicProvider;
        this.cls_Nic = networkInterface;
        this.cls_DesiredSubnets = stringArray;
        this.cls_IpListener = ipListener;
        this.cls_PollingInterval = n;
        this.cls_BackoffInterval = n2;
        this.cls_StopTime = l > 0L ? System.currentTimeMillis() + l : Long.MAX_VALUE;
        this.cls_ListenUntilStopped = bl;
        this.cls_Thread = Util.runThread(this.getClass().getSimpleName(), this);
    }

    public void stop() {
        log.info((Object)(this.toString() + " - Stop requested."));
        this.cls_Continue = false;
        this.cls_Thread.interrupt();
    }

    public boolean isClosed() {
        return !this.cls_Thread.isAlive();
    }

    public void run() {
        while (this.cls_Continue) {
            if (System.currentTimeMillis() < this.cls_StopTime) {
                try {
                    this.cls_NicProvider.refresh();
                    NetworkInterface networkInterface = this.cls_NicProvider.getInterface(this.cls_Nic.getLogicalGuid());
                    if (networkInterface != null && NetworkInterface.isValidIpAddress(networkInterface.getIpAddress())) {
                        log.debug((Object)(this.toString() + " - Current IP is " + networkInterface.getIpAddress() + "."));
                        if (NetworkInterface.isIpAddressInSubnets(networkInterface.getIpAddress(), this.cls_DesiredSubnets) && (!this.cls_ListenUntilStopped || !this.cls_LastIp.equals(networkInterface.getIpAddress())) && this.cls_Continue) {
                            this.cls_IpListener.ipReceived(networkInterface.getIpAddress());
                            this.cls_Continue = this.cls_ListenUntilStopped;
                            this.cls_LastIp = networkInterface.getIpAddress();
                        }
                    } else if (this.cls_LastIp.length() > 0 && this.cls_Continue) {
                        this.cls_IpListener.ipRemoved();
                    }
                }
                catch (Exception exception) {
                    log.error((Object)("Error in " + this.toString()), (Throwable)exception);
                }
            } else {
                if (this.cls_Continue) {
                    this.cls_IpListener.timeoutOccurred();
                }
                this.cls_Continue = false;
            }
            if (!this.cls_Continue) continue;
            try {
                this.cls_PollingInterval += this.cls_BackoffInterval;
                Thread.sleep(this.cls_PollingInterval);
            }
            catch (Exception exception) {
                if (!this.cls_Continue) continue;
                log.debug((Object)(this.toString() + " - Thread failed to sleep."), (Throwable)exception);
            }
        }
        log.debug((Object)(this.toString() + " is exiting."));
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + this.cls_Id + "]";
    }
}

