/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.common.network.ifconfig;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.command.CommandResponse;
import com.cloudpath.common.os.mac.common.network.ifconfig.IfconfigEntry;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class IfconfigReader {
    private static final Logger log = Logger.getLogger(IfconfigReader.class);
    private final CommandHandler cls_CommandHandler;

    public IfconfigReader(CommandHandler commandHandler) {
        this.cls_CommandHandler = commandHandler;
    }

    public IfconfigEntry[] readAllInterfaces(String string) throws Exception {
        log.debug((Object)("Will read all interfaces with match " + string));
        String[] stringArray = this.readInterfaceNames(string);
        log.debug((Object)("Read " + stringArray.length + " entries."));
        IfconfigEntry[] ifconfigEntryArray = new IfconfigEntry[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            log.debug((Object)(" - Will read " + stringArray[i]));
            ifconfigEntryArray[i] = this.readInterface(stringArray[i]);
        }
        return ifconfigEntryArray;
    }

    public IfconfigEntry readInterface(String string) throws Exception {
        CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(new String[]{"ifconfig", string});
        commandResponse.waitFor();
        String[] stringArray = commandResponse.getOutput();
        return new IfconfigEntry(stringArray);
    }

    public String[] readInterfaceNames(String string) throws Exception {
        Object object;
        String[] stringArray = new String[]{""};
        String[] stringArray2 = new String[]{};
        for (int i = 0; stringArray.length == 1 && stringArray[0].length() == 0 && i < 4; ++i) {
            if (i > 0) {
                log.warn((Object)"Received a blank response from ifconfig.");
                Thread.sleep(100L);
            }
            object = this.cls_CommandHandler.executeCommand(new String[]{"ifconfig", "-l"});
            ((CommandResponse)object).waitFor();
            stringArray = ((CommandResponse)object).getOutput();
            stringArray2 = stringArray[0].replace('\n', ' ').split(" ");
        }
        object = new ArrayList<String>();
        for (int i = 0; i < stringArray2.length; ++i) {
            if (string != null) {
                if (!stringArray2[i].startsWith(string)) continue;
                ((ArrayList)object).add(stringArray2[i]);
                continue;
            }
            ((ArrayList)object).add(stringArray2[i]);
        }
        String[] stringArray3 = new String[((ArrayList)object).size()];
        ((ArrayList)object).toArray(stringArray3);
        return stringArray3;
    }
}

