/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.common.network.ifconfig;

import com.cloudpath.common.os.mac.common.MacUtil;
import java.util.HashSet;

public class IfconfigEntry {
    private static final String LINE_MARKER_INET6 = "inet6 ";
    private static final String LINE_MARKER_INET = "inet ";
    private static final String LINE_MARKER_ETHER = "ether ";
    private static final String LINE_MARKER_MEDIA = "media: ";
    private static final String LINE_MARKER_SUPPORTED_MEDIA = "supported media: ";
    private static final String LINE_STATUS = "status: ";
    private static final String MARKER_FLAGS = ": flags=";
    private static final String MARKER_MTU = " mtu ";
    private static final String MARKER_STATUS = " status: ";
    private static final String MARKER_NETMASK = " netmask ";
    private static final String MARKER_BROADCAST = " broadcast ";
    private static final String KEY_AUTOSELECT = " autoselect ";
    private static final String[] VIRTUAL_MASK_ARRAY = new String[]{"005056", "000C29", "000569", "001C42"};
    private static final HashSet<String> VIRTUAL_MASKS = new HashSet();
    private String cls_Name = "";
    private String cls_Flags = "";
    private String cls_Mtu = "";
    private String cls_IpAddress = "";
    private String cls_Netmask = "";
    private String cls_Broadcast = "";
    private String cls_MacAddress = "";
    private boolean cls_IsUp = false;
    private String cls_SupportedMedia = "";

    public IfconfigEntry(String string) {
        this(string.split("\n"));
    }

    public IfconfigEntry(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("\n");
            for (int j = 0; j < stringArray2.length; ++j) {
                this.parseLine(stringArray2[j]);
            }
        }
    }

    public String getName() {
        return this.cls_Name;
    }

    public String getFlags() {
        return this.cls_Flags;
    }

    public String getMtu() {
        return this.cls_Mtu;
    }

    public String getIpAddress() {
        return this.cls_IpAddress;
    }

    public String getNetmask() {
        return this.cls_Netmask;
    }

    public String getBroadcast() {
        return this.cls_Broadcast;
    }

    public String getMacAddress() {
        return this.cls_MacAddress;
    }

    public String getSupportedMedia() {
        return this.cls_SupportedMedia;
    }

    public boolean isUp() {
        return this.cls_IsUp;
    }

    public boolean isNic() {
        return this.getMacAddress().length() > 0;
    }

    public boolean isVirtualNic() {
        return IfconfigEntry.isVirtualNic(this.getMacAddress());
    }

    public static boolean isVirtualNic(String string) {
        string = string != null ? string.toUpperCase() : "";
        string = string.replace("-", "");
        if ((string = string.replace(":", "")).length() >= 6) {
            String string2 = string.substring(0, 6);
            return VIRTUAL_MASKS.contains(string2);
        }
        return false;
    }

    private void parseLine(String string) {
        if (!(string = string.trim()).startsWith(LINE_MARKER_INET6)) {
            if (string.startsWith(LINE_MARKER_INET)) {
                this.cls_IpAddress = MacUtil.parseSetting(string, LINE_MARKER_INET, " ");
                this.cls_Netmask = MacUtil.parseSetting(string, MARKER_NETMASK, " ");
                this.cls_Broadcast = MacUtil.parseSetting(string, MARKER_BROADCAST, " ");
            } else if (string.startsWith(LINE_MARKER_ETHER)) {
                this.cls_MacAddress = MacUtil.parseSetting(string, LINE_MARKER_ETHER, " ");
            } else if (string.startsWith(LINE_MARKER_MEDIA)) {
                String string2 = MacUtil.parseSetting(string, MARKER_STATUS, " ");
                this.cls_IsUp = "active".equals(string2);
            } else if (string.startsWith(LINE_STATUS)) {
                this.cls_IsUp = "active".equals(MacUtil.parseSetting(string, LINE_STATUS, " "));
            } else if (string.startsWith(LINE_MARKER_SUPPORTED_MEDIA)) {
                this.cls_SupportedMedia = MacUtil.parseSetting(string, KEY_AUTOSELECT, null);
            } else if (string.indexOf(MARKER_FLAGS) >= 0) {
                this.cls_Name = MacUtil.parseSetting(string, "", ": ");
                this.cls_Flags = MacUtil.parseSetting(string, MARKER_FLAGS, "<");
                this.cls_Mtu = MacUtil.parseSetting(string, MARKER_MTU, " ");
            }
        }
    }

    static {
        for (int i = 0; i < VIRTUAL_MASK_ARRAY.length; ++i) {
            VIRTUAL_MASKS.add(VIRTUAL_MASK_ARRAY[i].toUpperCase());
        }
    }
}

