/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.common.network.airport;

import com.cloudpath.common.os.common.WirelessAssociation;
import com.cloudpath.common.os.common.WirelessProvider;
import com.cloudpath.common.os.mac.common.network.airport.AirportListener;
import com.cloudpath.common.util.Util;
import org.apache.log4j.Logger;

public class AirportMonitor
implements Runnable {
    private static final Logger log = Logger.getLogger(AirportMonitor.class);
    private boolean cls_Continue = true;
    private final WirelessProvider cls_WirelessProvider;
    private final String cls_LogicalGuid;
    private final AirportListener cls_AirportListener;
    private final boolean cls_DesiredState;
    private final Thread cls_Thread;
    private final int cls_BackoffRate;
    private int cls_PollingInterval;
    private final long cls_Timeout;

    public AirportMonitor(WirelessProvider wirelessProvider, String string, boolean bl, AirportListener airportListener, int n, int n2, long l) {
        this.cls_WirelessProvider = wirelessProvider;
        this.cls_LogicalGuid = string;
        this.cls_DesiredState = bl;
        this.cls_AirportListener = airportListener;
        this.cls_PollingInterval = n;
        this.cls_BackoffRate = n2;
        this.cls_Timeout = l > 0L ? System.currentTimeMillis() + l : Long.MAX_VALUE;
        this.cls_Thread = Util.runThread(this.getClass().getSimpleName(), this);
    }

    public void stop(boolean bl) {
        this.cls_Continue = false;
        this.cls_Thread.interrupt();
        if (bl) {
            try {
                this.cls_Thread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isClosed() {
        return !this.cls_Thread.isAlive();
    }

    public void run() {
        while (this.cls_Continue && System.currentTimeMillis() < this.cls_Timeout) {
            block7: {
                try {
                    WirelessAssociation wirelessAssociation = this.cls_WirelessProvider.getCurrentAssociation(this.cls_LogicalGuid);
                    if (wirelessAssociation != null && wirelessAssociation.isEnabled() && wirelessAssociation.isAssociated()) {
                        log.debug((Object)("Current state is " + wirelessAssociation.isEnabled() + ", waiting for " + this.cls_DesiredState));
                        if (this.cls_DesiredState == wirelessAssociation.isEnabled() && this.cls_Continue) {
                            this.cls_AirportListener.airportStateChanged(wirelessAssociation.isEnabled());
                            this.cls_Continue = false;
                        }
                    }
                }
                catch (Exception exception) {
                    log.error((Object)"ERROR", (Throwable)exception);
                }
                if (!this.cls_Continue) continue;
                try {
                    Thread.sleep(this.cls_PollingInterval);
                }
                catch (Exception exception) {
                    if (!this.cls_Continue) break block7;
                    log.debug((Object)"Thread failed to sleep.", (Throwable)exception);
                }
            }
            this.cls_PollingInterval += this.cls_BackoffRate;
        }
        log.debug((Object)(this.getClass().getSimpleName() + " thread is exiting."));
    }
}

