/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.compare;

import com.cloudpath.common.compare.Operator;
import com.cloudpath.common.compare.StringCompare;
import org.apache.log4j.Logger;

public class VersionCompare {
    private static final Logger log = Logger.getLogger(VersionCompare.class);
    private static StringCompare STRING_COMPARE = new StringCompare(true);

    public boolean qualifies(String string, Operator operator, String string2) {
        string = string != null ? string : "0";
        string2 = string2 != null ? string2 : "0";
        log.debug((Object)("     - Will compare '" + string + "' to '" + string2 + "' with operator '" + operator + "'."));
        long[] lArray = VersionCompare.getSplitVersion(string2);
        long[] lArray2 = VersionCompare.getSplitVersion(string);
        Operator operator2 = operator = operator != null ? operator : Operator.EQUAL;
        if (Operator.EQUAL.equals(operator)) {
            return VersionCompare.compareVersions(lArray2, lArray) == 0;
        }
        if (Operator.NOT_EQUAL.equals(operator)) {
            return VersionCompare.compareVersions(lArray2, lArray) != 0;
        }
        if (Operator.LESS_THAN.equals(operator)) {
            return VersionCompare.compareVersions(lArray2, lArray) < 0;
        }
        if (Operator.LESS_THAN_OR_EQUAL_TO.equals(operator)) {
            return VersionCompare.compareVersions(lArray2, lArray) <= 0;
        }
        if (Operator.GREATER_THAN.equals(operator)) {
            return VersionCompare.compareVersions(lArray2, lArray) > 0;
        }
        if (Operator.GREATER_THAN_OR_EQUAL_TO.equals(operator)) {
            return VersionCompare.compareVersions(lArray2, lArray) >= 0;
        }
        if (Operator.STARTS_WITH.equals(operator)) {
            return STRING_COMPARE.qualifies("" + string, operator, "" + string2);
        }
        if (Operator.ENDS_WITH.equals(operator)) {
            return STRING_COMPARE.qualifies("" + string, operator, "" + string2);
        }
        if (Operator.CONTAINS.equals(operator)) {
            return STRING_COMPARE.qualifies("" + string, operator, "" + string2);
        }
        if (Operator.REGEX.equals(operator)) {
            return STRING_COMPARE.qualifies("" + string, operator, "" + string2);
        }
        if (Operator.BETWEEN.equals(operator)) {
            return STRING_COMPARE.qualifies(string, operator, string2);
        }
        return string == string2;
    }

    public static long[] getSplitVersion(String string) {
        if (string == null || string.length() == 0) {
            return new long[0];
        }
        String[] stringArray = string.split("[\\.,]");
        long[] lArray = new long[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                lArray[i] = Long.parseLong(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                lArray[i] = 0L;
            }
        }
        return lArray;
    }

    public static int compareVersions(long[] lArray, long[] lArray2) {
        for (int i = 0; i < lArray.length || i < lArray2.length; ++i) {
            long l;
            long l2 = i < lArray.length ? lArray[i] : 0L;
            long l3 = l = i < lArray2.length ? lArray2[i] : 0L;
            if (l2 == l) continue;
            if (l2 > l) {
                return 1;
            }
            return -1;
        }
        return 0;
    }
}

