/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.compare;

import com.cloudpath.common.compare.Operator;
import org.apache.log4j.Logger;

public class StringCompare {
    private static final Logger log = Logger.getLogger(StringCompare.class);
    private final boolean cls_CaseSensitive;

    public StringCompare(boolean bl) {
        this.cls_CaseSensitive = bl;
    }

    public boolean qualifies(String string, Operator operator, String string2) {
        string = string != null ? string : "";
        string2 = string2 != null ? string2 : "";
        Operator operator2 = operator = operator != null ? operator : Operator.EQUAL;
        if (!this.cls_CaseSensitive) {
            log.debug((Object)"     - Will compare in case insensitive manner.");
            string = string.toUpperCase();
            string2 = string2.toUpperCase();
        }
        log.debug((Object)("     - Will compare '" + string + "' to '" + string2 + "' with operator '" + operator + "'."));
        if (Operator.EQUAL.equals(operator)) {
            return string.compareTo(string2) == 0;
        }
        if (Operator.NOT_EQUAL.equals(operator)) {
            return string.compareTo(string2) != 0;
        }
        if (Operator.LESS_THAN.equals(operator)) {
            return string.compareTo(string2) < 0;
        }
        if (Operator.LESS_THAN_OR_EQUAL_TO.equals(operator)) {
            return string.compareTo(string2) <= 0;
        }
        if (Operator.GREATER_THAN.equals(operator)) {
            return string.compareTo(string2) > 0;
        }
        if (Operator.GREATER_THAN_OR_EQUAL_TO.equals(operator)) {
            return string.compareTo(string2) >= 0;
        }
        if (Operator.STARTS_WITH.equals(operator)) {
            return string.startsWith(string2);
        }
        if (Operator.ENDS_WITH.equals(operator)) {
            return string.endsWith(string2);
        }
        if (Operator.CONTAINS.equals(operator)) {
            return string.indexOf(string2) >= 0;
        }
        if (Operator.REGEX.equals(operator)) {
            try {
                return string.matches(string2);
            }
            catch (Exception exception) {
                log.warn((Object)("Failed to apply regex '" + string2 + "' to value '" + string + "'. Will return false."), (Throwable)exception);
                return false;
            }
        }
        if (Operator.BETWEEN.equals(operator)) {
            String string3;
            String string4;
            if (string2.indexOf(59) < 0) {
                string4 = string2;
                string3 = "ZZZZZZZZZZZZZZZZZ";
            } else {
                string4 = string2.substring(0, string2.indexOf(59));
                string3 = string2.substring(string2.indexOf(59) + 1);
            }
            return this.qualifies(string, Operator.GREATER_THAN_OR_EQUAL_TO, string4) && this.qualifies(string, Operator.LESS_THAN_OR_EQUAL_TO, string3);
        }
        return string.compareTo(string2) == 0;
    }
}

