/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.compare;

import com.cloudpath.common.compare.NumberCompare;
import com.cloudpath.common.compare.Operator;
import com.cloudpath.common.compare.StringCompare;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class DateCompare {
    private static final Logger log = Logger.getLogger(NumberCompare.class);
    private static StringCompare STRING_COMPARE = new StringCompare(true);
    private static final SimpleDateFormat[] FORMATS = new SimpleDateFormat[]{new SimpleDateFormat("MM/dd/yyyy"), new SimpleDateFormat("MM dd yyyy"), new SimpleDateFormat("yyyy-MM-dd")};
    private static final SimpleDateFormat STANDARD_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public boolean qualifies(String string, Operator operator, String string2) {
        if (Operator.BETWEEN.equals(operator)) {
            String string3;
            String string4;
            String string5 = string2 = string2 != null ? string2 : "";
            if (string2.indexOf(59) < 0) {
                string4 = string2;
                string3 = "9999-12-31";
            } else {
                string4 = string2.substring(0, string2.indexOf(59));
                string3 = string2.substring(string2.indexOf(59) + 1);
            }
            return this.qualifies(string, Operator.GREATER_THAN_OR_EQUAL_TO, string4) && this.qualifies(string, Operator.LESS_THAN_OR_EQUAL_TO, string3);
        }
        string = string != null ? string : "1/1/1970";
        string2 = string2 != null ? string2 : "1/1/1970";
        log.debug((Object)("     - Will compare '" + string + "' to '" + string2 + "' with operator '" + operator + "'."));
        string = DateCompare.getFormattedDate(string);
        string2 = DateCompare.getFormattedDate(string2);
        log.debug((Object)("After formatting, will compare '" + string + "' to '" + string2 + "' with operator '" + operator + "'."));
        return STRING_COMPARE.qualifies(string, operator, string2);
    }

    public static String getFormattedDate(String string) {
        for (int i = 0; i < FORMATS.length; ++i) {
            try {
                Date date = FORMATS[i].parse(string);
                return STANDARD_FORMAT.format(date);
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        return string;
    }
}

