/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.cert;

import com.cloudpath.common.cert.CertificateChain;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.X509CertSelector;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.security.cert.X509Certificate;
import org.apache.log4j.Logger;

public class CertUtil {
    private static final Logger log = Logger.getLogger(CertUtil.class);
    private static CertificateFactory CERTIFICATE_FACTORY;
    private static MessageDigest SHA1;

    public static CertificateFactory getCertificateFactory() throws CertificateException {
        if (CERTIFICATE_FACTORY == null) {
            CERTIFICATE_FACTORY = CertificateFactory.getInstance("X.509");
        }
        return CERTIFICATE_FACTORY;
    }

    public static KeyStore getBlankKeystore() throws KeyStoreException {
        KeyStore keyStore = KeyStore.getInstance("jks");
        try {
            keyStore.load(null);
        }
        catch (CertificateException certificateException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return keyStore;
    }

    public static boolean isSelfSigned(java.security.cert.X509Certificate x509Certificate) {
        try {
            x509Certificate.verify(x509Certificate.getPublicKey());
            return true;
        }
        catch (SignatureException signatureException) {
            return false;
        }
        catch (InvalidKeyException invalidKeyException) {
            return false;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            return false;
        }
        catch (CertificateException certificateException) {
            return false;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return x509Certificate.getIssuerDN() == null || x509Certificate.getIssuerDN().equals(x509Certificate.getSubjectDN());
        }
    }

    public static java.security.cert.X509Certificate getCertificateFromFile(File file) throws CertificateException, FileNotFoundException {
        return CertUtil.getCertificateFromFile(file, CertUtil.getCertificateFactory());
    }

    public static java.security.cert.X509Certificate getCertificateFromFile(File file, CertificateFactory certificateFactory) throws CertificateException, FileNotFoundException {
        return (java.security.cert.X509Certificate)certificateFactory.generateCertificate(new FileInputStream(file));
    }

    public static java.security.cert.X509Certificate getCertificateFromString(String string) throws CertificateException {
        return CertUtil.getCertificateFromString(string, CertUtil.getCertificateFactory());
    }

    public static java.security.cert.X509Certificate getCertificateFromString(String string, CertificateFactory certificateFactory) throws CertificateException {
        return (java.security.cert.X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(string.getBytes()));
    }

    public static void addCertificateToKeystore(KeyStore keyStore, java.security.cert.X509Certificate x509Certificate) throws CertificateEncodingException, NoSuchAlgorithmException, KeyStoreException {
        keyStore.setCertificateEntry(CertUtil.getThumbprint(x509Certificate), x509Certificate);
    }

    public static java.security.cert.X509Certificate[] getCertificatesFromFolder(File file) throws Exception {
        return CertUtil.getCertificatesFromFolder(file, CertUtil.getCertificateFactory());
    }

    public static java.security.cert.X509Certificate[] getCertificatesFromFolder(File file, CertificateFactory certificateFactory) throws Exception {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (file != null) {
            if (file.isFile()) {
                object = (java.security.cert.X509Certificate)certificateFactory.generateCertificate(new FileInputStream(file));
                arrayList.add(object);
            } else {
                object = file.listFiles();
                for (int i = 0; object != null && i < ((Serializable[])object).length; ++i) {
                    Object object2;
                    if (((File)object[i]).isFile()) {
                        object2 = (java.security.cert.X509Certificate)certificateFactory.generateCertificate(new FileInputStream((File)object[i]));
                        arrayList.add(object2);
                        continue;
                    }
                    object2 = CertUtil.getCertificatesFromFolder((File)object[i], certificateFactory);
                    if (object2 == null) continue;
                    for (int j = 0; j < ((java.security.cert.X509Certificate[])object2).length; ++j) {
                        arrayList.add(object2[i]);
                    }
                }
            }
        }
        object = new java.security.cert.X509Certificate[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    public static CertificateChain getCertificateChain(java.security.cert.X509Certificate[] x509CertificateArray, java.security.cert.X509Certificate[] x509CertificateArray2, java.security.cert.X509Certificate x509Certificate, boolean bl) throws Exception {
        if (x509Certificate == null) {
            if (bl) {
                System.out.println("Certificate is null.");
            }
            return new CertificateChain(x509Certificate, null, false, new java.security.cert.X509Certificate[0], new java.security.cert.X509Certificate[0], false, new java.security.cert.X509Certificate[0]);
        }
        java.security.cert.X509Certificate x509Certificate2 = CertUtil.findSupercedingCertificate(x509CertificateArray, x509Certificate);
        java.security.cert.X509Certificate x509Certificate3 = CertUtil.findSupercedingCertificate(x509CertificateArray2, x509Certificate);
        java.security.cert.X509Certificate x509Certificate4 = CertUtil.getNewestCert(x509Certificate2, x509Certificate3);
        KeyStore keyStore = KeyStore.getInstance("jks");
        keyStore.load(null);
        if (x509CertificateArray != null) {
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                if (x509CertificateArray[i] == null) continue;
                if (bl) {
                    System.out.println("Root CA: " + CertUtil.getThumbprint(x509CertificateArray[i]));
                }
                keyStore.setCertificateEntry(CertUtil.getThumbprint(x509CertificateArray[i]), x509CertificateArray[i]);
            }
        }
        if (keyStore.size() == 0) {
            if (bl) {
                System.out.println("Keystore is blank.");
            }
            return new CertificateChain(x509Certificate, x509Certificate4, false, new java.security.cert.X509Certificate[0], new java.security.cert.X509Certificate[0], false, new java.security.cert.X509Certificate[0]);
        }
        ArrayList<java.security.cert.X509Certificate> arrayList = new ArrayList<java.security.cert.X509Certificate>();
        if (x509CertificateArray2 != null) {
            for (int i = 0; i < x509CertificateArray2.length; ++i) {
                arrayList.add(x509CertificateArray2[i]);
                if (!bl) continue;
                System.out.println("Intermediary CA: " + CertUtil.getThumbprint(x509CertificateArray2[i]));
            }
        }
        arrayList.add(x509Certificate);
        X509CertSelector x509CertSelector = new X509CertSelector();
        x509CertSelector.setCertificate(x509Certificate);
        CertPathBuilder certPathBuilder = CertPathBuilder.getInstance("PKIX");
        PKIXBuilderParameters pKIXBuilderParameters = new PKIXBuilderParameters(keyStore, (CertSelector)x509CertSelector);
        pKIXBuilderParameters.setRevocationEnabled(false);
        pKIXBuilderParameters.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(arrayList)));
        try {
            java.security.cert.X509Certificate[] x509CertificateArray3;
            boolean bl2;
            java.security.cert.X509Certificate[] x509CertificateArray4;
            java.security.cert.X509Certificate[] x509CertificateArray5;
            block20: {
                java.security.cert.X509Certificate[] x509CertificateArray6;
                Object object;
                Object object2;
                PKIXCertPathBuilderResult pKIXCertPathBuilderResult = (PKIXCertPathBuilderResult)certPathBuilder.build(pKIXBuilderParameters);
                java.security.cert.X509Certificate x509Certificate5 = pKIXCertPathBuilderResult.getTrustAnchor().getTrustedCert();
                List<? extends Certificate> list = pKIXCertPathBuilderResult.getCertPath().getCertificates();
                x509CertificateArray5 = new java.security.cert.X509Certificate[list.size() + 1];
                list.toArray(x509CertificateArray5);
                x509CertificateArray5[x509CertificateArray5.length - 1] = x509Certificate5;
                x509CertificateArray4 = x509CertificateArray5;
                bl2 = CertUtil.isSelfSigned(x509Certificate5);
                if (!bl2) {
                    int n;
                    x509CertificateArray3 = new java.security.cert.X509Certificate[x509CertificateArray.length];
                    System.arraycopy(x509CertificateArray, 0, x509CertificateArray3, 0, x509CertificateArray.length);
                    object2 = new java.security.cert.X509Certificate[x509CertificateArray2.length];
                    System.arraycopy(x509CertificateArray2, 0, object2, 0, x509CertificateArray2.length);
                    for (n = 0; n < x509CertificateArray3.length; ++n) {
                        if (x509CertificateArray3[n] == null || !x509CertificateArray3[n].getPublicKey().equals(x509Certificate5.getPublicKey())) continue;
                        x509CertificateArray3[n] = null;
                    }
                    for (n = 0; n < ((Object)object2).length; ++n) {
                        if (object2[n] == null || !((Certificate)object2[n]).getPublicKey().equals(x509Certificate5.getPublicKey())) continue;
                        object2[n] = null;
                    }
                    object = CertUtil.getCertificateChain(x509CertificateArray3, (java.security.cert.X509Certificate[])object2, pKIXCertPathBuilderResult.getTrustAnchor().getTrustedCert(), bl);
                    if (object != null) {
                        x509CertificateArray6 = ((CertificateChain)object).getChainToRoot();
                        if (x509CertificateArray6.length >= 2) {
                            x509CertificateArray4 = new java.security.cert.X509Certificate[x509CertificateArray5.length + x509CertificateArray6.length - 1];
                            System.arraycopy(x509CertificateArray5, 0, x509CertificateArray4, 0, x509CertificateArray5.length);
                            System.arraycopy(x509CertificateArray6, 1, x509CertificateArray4, x509CertificateArray5.length, x509CertificateArray6.length - 1);
                        }
                        bl2 = ((CertificateChain)object).isChainedToRoot();
                    }
                }
                keyStore.deleteEntry(CertUtil.getThumbprint(x509Certificate5));
                x509CertificateArray3 = new java.security.cert.X509Certificate[]{};
                if (keyStore.size() > 0) {
                    try {
                        object2 = new PKIXBuilderParameters(keyStore, (CertSelector)x509CertSelector);
                        ((PKIXParameters)object2).setRevocationEnabled(false);
                        ((PKIXParameters)object2).addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(arrayList)));
                        object = (PKIXCertPathBuilderResult)certPathBuilder.build((CertPathParameters)object2);
                        x509CertificateArray6 = ((PKIXCertPathValidatorResult)object).getTrustAnchor().getTrustedCert();
                        List<? extends Certificate> list2 = ((PKIXCertPathBuilderResult)object).getCertPath().getCertificates();
                        x509CertificateArray3 = new java.security.cert.X509Certificate[list2.size() + 1];
                        list2.toArray(x509CertificateArray3);
                        x509CertificateArray3[x509CertificateArray3.length - 1] = x509CertificateArray6;
                    }
                    catch (CertPathBuilderException certPathBuilderException) {
                        if (!bl) break block20;
                        certPathBuilderException.printStackTrace();
                    }
                }
            }
            return new CertificateChain(x509Certificate, x509Certificate4, true, x509CertificateArray5, x509CertificateArray3, bl2, x509CertificateArray4);
        }
        catch (CertPathBuilderException certPathBuilderException) {
            if (bl) {
                certPathBuilderException.printStackTrace();
            }
            return new CertificateChain(x509Certificate, x509Certificate4, false, new java.security.cert.X509Certificate[0], new java.security.cert.X509Certificate[0], false, new java.security.cert.X509Certificate[0]);
        }
    }

    public static boolean isCaCertificate(java.security.cert.X509Certificate x509Certificate) {
        if (x509Certificate.getVersion() < 3) {
            return CertUtil.isSelfSigned(x509Certificate);
        }
        return x509Certificate.getBasicConstraints() >= 0;
    }

    public static boolean isRootCa(java.security.cert.X509Certificate x509Certificate) {
        return CertUtil.isCaCertificate(x509Certificate) && CertUtil.isSelfSigned(x509Certificate);
    }

    public static boolean isIntermediaryCa(java.security.cert.X509Certificate x509Certificate) {
        return CertUtil.isCaCertificate(x509Certificate) && !CertUtil.isSelfSigned(x509Certificate);
    }

    public static boolean isServerCertificate(java.security.cert.X509Certificate x509Certificate) {
        return !CertUtil.isCaCertificate(x509Certificate);
    }

    public static String getCertificateIssuerThumbprint(File file, File file2, File file3, boolean bl) throws Exception {
        java.security.cert.X509Certificate[] x509CertificateArray = CertUtil.getCertificatesFromFolder(file);
        java.security.cert.X509Certificate[] x509CertificateArray2 = CertUtil.getCertificatesFromFolder(file2);
        java.security.cert.X509Certificate x509Certificate = CertUtil.getCertificateFromFile(file3);
        if (CertUtil.isRootCa(x509Certificate)) {
            return "";
        }
        CertificateChain certificateChain = CertUtil.getCertificateChain(x509CertificateArray, x509CertificateArray2, x509Certificate, bl);
        if (bl) {
            System.out.println("Chain Summary: \n" + certificateChain.getSummary());
        }
        if (certificateChain.isChainedToTrust()) {
            if (certificateChain.getChainToTrust().length > 1) {
                return CertUtil.getThumbprint(certificateChain.getChainToTrust()[1]);
            }
            if (bl) {
                System.out.println("Chain length is: " + certificateChain.getChainToTrust().length);
            }
        } else if (bl) {
            System.out.println("Certificate is not trusted.");
        }
        return "";
    }

    public static String getThumbprint(java.security.cert.X509Certificate x509Certificate) throws NoSuchAlgorithmException, CertificateEncodingException {
        if (SHA1 == null) {
            SHA1 = MessageDigest.getInstance("SHA-1");
        }
        if (x509Certificate == null) {
            return "";
        }
        byte[] byArray = x509Certificate.getEncoded();
        SHA1.update(byArray);
        byte[] byArray2 = SHA1.digest();
        return CertUtil.hexify(byArray2);
    }

    public static String hexify(byte[] byArray) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(cArray[(byArray[i] & 0xF0) >> 4]);
            stringBuffer.append(cArray[byArray[i] & 0xF]);
        }
        return stringBuffer.toString().toUpperCase();
    }

    public static String formatThumbprintForDb(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); i += 2) {
            if (string2.length() > 0) {
                string2 = string2 + " ";
            }
            string2 = string2 + string.substring(i, i + 2);
        }
        return string2.toLowerCase();
    }

    public static String getCommonName(X509Certificate x509Certificate) {
        return CertUtil.getCommonName(x509Certificate.getSubjectDN().toString(), false);
    }

    public static String getCommonName(java.security.cert.X509Certificate x509Certificate) {
        return CertUtil.getCommonName(x509Certificate.getSubjectDN().toString(), false);
    }

    public static String getEmailAddress(X509Certificate x509Certificate) {
        return CertUtil.getCommonName(x509Certificate.getSubjectDN().toString(), true);
    }

    public static String getEmailAddress(java.security.cert.X509Certificate x509Certificate) {
        return CertUtil.getCommonName(x509Certificate.getSubjectDN().toString(), true);
    }

    public static String getCommonName(String string, boolean bl) {
        Object object;
        int n;
        log.debug((Object)("Will get common name from '" + string + "'."));
        Object object2 = null;
        String[] stringArray = string.split(",");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = stringArray.length - 1; i >= 0; --i) {
            n = i;
            while (stringArray[i].indexOf(34) >= 0 && stringArray[i].indexOf(34) == stringArray[i].lastIndexOf(34)) {
                object = stringArray[i - 1];
                Object object3 = "";
                if (((String)object).indexOf(34) >= 0) {
                    object3 = ((String)object).substring(0, ((String)object).indexOf(34) + 1);
                    object = ((String)object).substring(((String)object).indexOf(34) + 1);
                } else {
                    object3 = object;
                    object = "";
                }
                int n2 = n;
                stringArray[n2] = stringArray[n2] + (String)object3;
                stringArray[i - 1] = object;
                if (((String)object).length() != 0) continue;
                --i;
            }
            arrayList.add(stringArray[n]);
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray2[n] = stringArray2[n].replace("\"", "");
        }
        if (bl) {
            for (n = 0; object2 == null && n < stringArray2.length; ++n) {
                object = stringArray2[n].split("=");
                if (!"EMAILADDRESS".equals(object[0].trim())) continue;
                object2 = object[1];
            }
        }
        for (n = 0; object2 == null && n < stringArray2.length; ++n) {
            object = stringArray2[n].split("=");
            if (!"CN".equals(object[0].trim())) continue;
            object2 = ((String[])object).length > 1 ? object[1] : "";
        }
        for (n = 0; object2 == null && n < stringArray2.length; ++n) {
            object = stringArray2[n].split("=");
            if (!"OU".equals(object[0].trim())) continue;
            object2 = ((String[])object).length > 1 ? object[1] : "";
        }
        for (n = 0; object2 == null && n < stringArray2.length; ++n) {
            object = stringArray2[n].split("=");
            if (!"O".equals(object[0].trim())) continue;
            object2 = ((Object)object).length > 1 ? object[1] : "";
        }
        return object2;
    }

    public static final java.security.cert.X509Certificate findSupercedingCertificate(java.security.cert.X509Certificate[] x509CertificateArray, java.security.cert.X509Certificate x509Certificate) throws Exception {
        java.security.cert.X509Certificate x509Certificate2 = null;
        String string = CertUtil.getThumbprint(x509Certificate);
        for (int i = 0; x509CertificateArray != null && i < x509CertificateArray.length; ++i) {
            String string2;
            if (x509CertificateArray[i] == null || x509CertificateArray[i].getPublicKey() == null || x509Certificate == null || !x509CertificateArray[i].getPublicKey().equals(x509Certificate.getPublicKey()) || string.equals(string2 = CertUtil.getThumbprint(x509CertificateArray[i])) || !x509CertificateArray[i].getNotAfter().after(x509Certificate.getNotAfter()) || (x509Certificate2 = CertUtil.findSupercedingCertificate(x509CertificateArray, x509CertificateArray[i])) != null) continue;
            x509Certificate2 = x509CertificateArray[i];
        }
        return x509Certificate2;
    }

    public static final java.security.cert.X509Certificate getNewestCert(java.security.cert.X509Certificate x509Certificate, java.security.cert.X509Certificate x509Certificate2) {
        if (x509Certificate2 == null && x509Certificate == null) {
            return null;
        }
        if (x509Certificate2 == null) {
            return x509Certificate;
        }
        if (x509Certificate == null) {
            return x509Certificate2;
        }
        if (x509Certificate2.getNotAfter().after(x509Certificate.getNotAfter())) {
            return x509Certificate2;
        }
        return x509Certificate;
    }

    public static String delimitForDn(String string) {
        if (string != null) {
            string = string.replace("\\", "\\\\");
            string = string.replace(",", "\\,");
            string = string.replace("#", "\\#");
            string = string.replace("+", "\\+");
            string = string.replace("<", "\\<");
            string = string.replace(">", "\\>");
            string = string.replace(";", "\\;");
            string = string.replace("\"", "\\\"");
            string = string.replace("=", "\\=");
        }
        return string;
    }

    public static java.security.cert.X509Certificate getPublicKeyFromP12(byte[] byArray, String string) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            keyStore.load(byteArrayInputStream, (string != null ? string : "").toCharArray());
        }
        catch (IOException iOException) {
            if (iOException.getMessage() != null && iOException.getMessage().toLowerCase().contains("failed to decrypt safe contents")) {
                throw new IOException("Error while parsing P12 certificate. Most likely, the password is incorrect. Details: " + iOException.getMessage(), iOException);
            }
            throw iOException;
        }
        return CertUtil.getPublicKeyFromKeyStore(keyStore);
    }

    public static java.security.cert.X509Certificate getPublicKeyFromKeyStore(KeyStore keyStore) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        Enumeration<String> enumeration = keyStore.aliases();
        java.security.cert.X509Certificate x509Certificate = null;
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            x509Certificate = (java.security.cert.X509Certificate)keyStore.getCertificate(string);
        }
        return x509Certificate;
    }

    static {
        SHA1 = null;
    }
}

