/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.assess.util;

import com.cloudpath.common.util.UrlLoader;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ServerUtil {
    private static final Logger log = Logger.getLogger(ServerUtil.class);
    public static final String TIMESTAMP_PARTIAL_REGEX = "[0-9]{8}-[0-9]{6}";
    public static final String TIMESTAMP_FULL_REGEX = ".*TIMESTAMP:[0-9]{8}-[0-9]{6}.*";
    public static final SimpleDateFormat TIMESTAMP_WITHOUT_TIME = new SimpleDateFormat("yyyyMMdd");
    public static final SimpleDateFormat TIMESTAMP_WITH_TIME = new SimpleDateFormat("yyyyMMdd-kkmmss");
    private static String LAST_TIMESTAMP = null;

    public static long getLastTimestamp() {
        return ServerUtil.getTimestampAsDate(LAST_TIMESTAMP);
    }

    public static String getTimestampFromUrl(String string, String string2, boolean bl) {
        Object object;
        Object object2;
        if (bl && LAST_TIMESTAMP != null) {
            return LAST_TIMESTAMP;
        }
        if (string == null || string.length() == 0) {
            object2 = null;
            log.debug((Object)("Will attempt to load system properties from " + string2));
            try {
                object = new URL(string2);
                object2 = ServerUtil.getSystemConfig((URL)object);
            }
            catch (Exception exception) {
                log.warn((Object)("Error while loading system config from url '" + string2 + "'."), (Throwable)exception);
            }
            if (object2 != null && ((Properties)object2).size() > 0) {
                object = ((Properties)object2).getProperty("timestamp_file");
                string = string2 + (String)object;
                log.debug((Object)("Timestamp file is " + (String)object + ".  Full url is " + string));
            }
        }
        log.debug((Object)("Will load timestamp from url [" + string + "]."));
        object2 = UrlLoader.getTextFileFromUrl(string);
        object = "";
        if (((UrlLoader.UrlResponse)object2).isSuccessful()) {
            object = ServerUtil.extractTimestamp(((UrlLoader.UrlResponse)object2).getOutput());
        }
        LAST_TIMESTAMP = object;
        return object;
    }

    public static String extractTimestamp(String string) {
        if (string.matches(TIMESTAMP_FULL_REGEX)) {
            int n = string.indexOf("TIMESTAMP:") + 10;
            string = string.substring(n, string.length() <= n + 15 ? string.length() : n + 15);
        } else {
            log.debug((Object)("Did not recognize timestamp in: [" + string + "]"));
            string = "";
        }
        return string;
    }

    public static long getTimestampAsDate(String string) {
        try {
            if (string == null || "".equals(string)) {
                return 0L;
            }
            if (string.contains("-")) {
                return TIMESTAMP_WITH_TIME.parse(string).getTime();
            }
            return TIMESTAMP_WITHOUT_TIME.parse(string).getTime();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return 0L;
        }
    }

    public static boolean isSystemClockAcceptable(String string, int n) {
        long l = ServerUtil.getTimestampAsDate(string);
        long l2 = new Date().getTime();
        double d = l - l2;
        d = Math.abs(d);
        return (d /= 3600000.0) <= (double)n;
    }

    public static int isSystemClockAcceptableByUrl(String string, String string2) {
        String string3 = ServerUtil.getTimestampFromUrl(string, string2, true);
        if (string3.length() > 0) {
            if (ServerUtil.isSystemClockAcceptable(string3, 168)) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public static Properties getSystemConfig(URL uRL) throws Exception {
        URL uRL2 = new URL(uRL, "system_config.xml");
        log.debug((Object)("URL is " + uRL2));
        URLConnection uRLConnection = uRL2.openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        Properties properties = new Properties();
        properties.load(inputStream);
        inputStream.close();
        return properties;
    }
}

