/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.assess.pojo;

import com.cloudpath.assess.pojo.SettingInstall;
import com.cloudpath.assess.pojo.Settings;
import com.cloudpath.assess.pojo.util.SettingRuntime;
import com.cloudpath.assess.pojo.util.SettingValue;
import com.cloudpath.common.compare.Datatype;
import com.cloudpath.common.compare.Operator;
import com.cloudpath.common.util.XmlUtil;

public class Setting {
    public static final String ELEMENT_SETTING = "setting";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_OPERATOR = "operator";
    public static final String ATTRIBUTE_ADDTL_VALUE_OPERATOR = "av_operator";
    public static final String ATTRIBUTE_ADDTL_VALUE_DATATYPE = "av_datatype";
    public static final String ATTRIBUTE_IS_REQUIRED = "is_required";
    public static final String ATTRIBUTE_CAN_AUTO_FIX = "can_auto_fix";
    public static final String ATTRIBUTE_AUTO_FIX_REQUIRES_ELEVATION = "auto_fix_requires_elevation";
    public static final String ATTRIBUTE_ENFORCE_ADDITIONAL_VALUE = "enforce_additional_value";
    public static final String ELEMENT_CORRECT_TEXT = "correct_text";
    public static final String ELEMENT_INCORRECT_TEXT = "incorrect_text";
    public static final String ELEMENT_AS_REPAIRED_TEXT = "as_repaired_text";
    public static final String ELEMENT_WHEN_REPAIRED_TEXT = "when_repaired_text";
    public static final String ELEMENT_REQUIRED_VALUE = "required_value";
    public static final String ELEMENT_ADDITIONAL_VALUE = "additional_value";
    public static final String ELEMENT_UNENFORCED_VALUE = "unenforced_value";
    public static final String ELEMENT_HELP_LINK = "help_link";
    public static final String ELEMENT_ORIGINALS = "originals";
    public static final String ELEMENT_ORIGINAL_REQUIRED_VALUE = "original_required_value";
    public static final String ELEMENT_ORIGINAL_ADDITIONAL_VALUE = "original_additional_value";
    public static final String ELEMENT_ORIGINAL_UNENFORCED_VALUE = "original_unenforced_value";
    public static final Settings.SettingId DEFAULT_SETTING_ID = Settings.SettingId.NONE;
    public static final boolean DEFAULT_IS_REQUIRED = true;
    public static final boolean DEFAULT_DISPLAY = true;
    public static final boolean DEFAULT_ENFORCE_ADDITIONAL_VALUE = false;
    public static final boolean DEFAULT_CAN_AUTO_FIX = true;
    public static final boolean DEFAULT_AUTO_FIX_REQUIRES_ELEVATION = false;
    public static final Operator DEFAULT_OPERATOR = Operator.EQUAL;
    public static final Operator DEFAULT_ADDTL_VALUE_OPERATOR = Operator.EQUAL;
    public static final Datatype DEFAULT_ADDTL_VALUE_DATATYPE = Datatype.STRING;
    private long cls_SettingIdAsLong = -1L;
    private Settings.SettingId cls_SettingId = DEFAULT_SETTING_ID;
    private boolean cls_IsRequired = true;
    private Operator cls_Operator = DEFAULT_OPERATOR;
    private Operator cls_AvOperator = DEFAULT_ADDTL_VALUE_OPERATOR;
    private Datatype cls_AvDatatype = DEFAULT_ADDTL_VALUE_DATATYPE;
    private boolean cls_Display = true;
    private boolean cls_EnforceAdditionalValue = false;
    private boolean cls_CanAutoFix = true;
    private boolean cls_AutoFixRequiresElevation = false;
    private String cls_LabelWhenIncorrect = "";
    private String cls_LabelWhenRepaired = "";
    private String cls_HelpLink = "";
    private final SettingRuntime cls_SettingRuntime = new SettingRuntime(this);
    private SettingValue cls_RequiredValue;
    private final SettingInstall cls_Install;

    public Setting() {
        this.cls_RequiredValue = new SettingValue();
        this.cls_Install = new SettingInstall();
    }

    public Setting(Settings.SettingId settingId, String string, String string2) {
        this();
        this.setSettingId(settingId);
        this.getRequiredValue().setValue(string);
        this.getRequiredValue().setAdditionalValue(string2);
    }

    public Setting(Setting setting) {
        this.cls_SettingId = setting.getSettingId();
        this.cls_IsRequired = setting.getIsRequired();
        this.cls_Display = setting.getDisplay();
        this.cls_EnforceAdditionalValue = setting.getEnforceAdditionalValue();
        this.cls_CanAutoFix = setting.getCanAutoFix();
        this.cls_AutoFixRequiresElevation = setting.getAutoFixRequiresElevation();
        this.cls_LabelWhenIncorrect = setting.getLabelWhenIncorrect();
        this.cls_LabelWhenRepaired = setting.getLabelWhenRepaired();
        this.cls_HelpLink = setting.getHelpLink();
        this.cls_RequiredValue = new SettingValue(setting.getRequiredValue());
        this.cls_Operator = setting.getOperator();
        this.cls_AvOperator = setting.getAvOperator();
        this.cls_AvDatatype = setting.getAvDatatype();
        this.cls_Install = new SettingInstall(setting.getInstall());
    }

    public SettingInstall getInstall() {
        return this.cls_Install;
    }

    public SettingRuntime getRuntime() {
        return this.cls_SettingRuntime;
    }

    public long getId() {
        return this.getSettingId().getId();
    }

    public Settings.SettingId getSettingId() {
        return this.cls_SettingId;
    }

    public long getSettingIdAsLong() {
        return this.cls_SettingIdAsLong >= 0L ? this.cls_SettingIdAsLong : this.getSettingId().getId();
    }

    public void setSettingId(Settings.SettingId settingId) {
        this.cls_SettingId = settingId == null ? DEFAULT_SETTING_ID : settingId;
    }

    public void setSettingId(long l) {
        this.cls_SettingIdAsLong = l;
    }

    public Operator getOperator() {
        return this.cls_Operator;
    }

    public void setOperator(Operator operator) {
        this.cls_Operator = operator;
    }

    public Operator getAvOperator() {
        return this.cls_AvOperator;
    }

    public void setAvOperator(Operator operator) {
        this.cls_AvOperator = operator;
    }

    public Datatype getAvDatatype() {
        return this.cls_AvDatatype;
    }

    public void setAvDatatype(Datatype datatype) {
        this.cls_AvDatatype = datatype;
    }

    public String getLabelWhenIncorrect() {
        return this.cls_LabelWhenIncorrect;
    }

    public void setLabelWhenIncorrect(String string) {
        this.cls_LabelWhenIncorrect = string == null ? "" : string;
    }

    public String getLabelWhenRepaired() {
        return this.cls_LabelWhenRepaired;
    }

    public void setLabelWhenRepaired(String string) {
        this.cls_LabelWhenRepaired = string == null ? "" : string;
    }

    public boolean getIsRequired() {
        return this.cls_IsRequired;
    }

    public void setIsRequired(boolean bl) {
        this.cls_IsRequired = bl;
    }

    public SettingValue getRequiredValue() {
        return this.cls_RequiredValue;
    }

    public void setRequiredValue(SettingValue settingValue) {
        this.cls_RequiredValue = settingValue;
    }

    public boolean getDisplay() {
        return this.cls_Display;
    }

    public void setDisplay(boolean bl) {
        this.cls_Display = bl;
    }

    public boolean getEnforceAdditionalValue() {
        return this.cls_EnforceAdditionalValue;
    }

    public void setEnforceAdditionalValue(boolean bl) {
        this.cls_EnforceAdditionalValue = bl;
    }

    public boolean getCanAutoFix() {
        return this.cls_CanAutoFix;
    }

    public void setCanAutoFix(boolean bl) {
        this.cls_CanAutoFix = bl;
    }

    public boolean getAutoFixRequiresElevation() {
        return this.cls_AutoFixRequiresElevation;
    }

    public void setAutoFixRequiresElevation(boolean bl) {
        this.cls_AutoFixRequiresElevation = bl;
    }

    public String getHelpLink() {
        String string = this.cls_HelpLink;
        if (this.getSettingId() != Settings.SettingId.WIRELESS_NETWORK_PROFILE || string.length() == 0 || string.indexOf("${DEFAULT_HELP}") >= 0) {
            // empty if block
        }
        return string;
    }

    public void setHelpLink(String string) {
        this.cls_HelpLink = string == null ? "" : string;
    }

    public static String translate(Settings.SettingId settingId, String string) {
        if (settingId != Settings.SettingId.EAP_TYPE && settingId != Settings.SettingId.PEAP_INNER_TUNNEL && (settingId == Settings.SettingId.PEAP_TRUSTED_CA_LIST || settingId == Settings.SettingId.PEAP_TLS_TRUSTED_CA_LIST)) {
            return string.toLowerCase();
        }
        return string;
    }

    public static String untranslate(Settings.SettingId settingId, String string) {
        return string;
    }

    public String getXml(boolean bl, boolean bl2) {
        String string = "<setting" + XmlUtil.createAttribute(ATTRIBUTE_ID, this.getSettingIdAsLong()) + XmlUtil.createAttribute(ATTRIBUTE_IS_REQUIRED, this.getIsRequired(), true) + XmlUtil.createAttribute(ATTRIBUTE_CAN_AUTO_FIX, this.getCanAutoFix(), true) + XmlUtil.createAttribute(ATTRIBUTE_AUTO_FIX_REQUIRES_ELEVATION, this.getAutoFixRequiresElevation(), false) + XmlUtil.createAttribute(ATTRIBUTE_ENFORCE_ADDITIONAL_VALUE, this.getEnforceAdditionalValue(), false) + XmlUtil.createAttribute("is_install", this.getInstall().getIsInstall(), false) + XmlUtil.createAttribute(ATTRIBUTE_OPERATOR, this.getOperator().getName(), DEFAULT_OPERATOR.getName()) + XmlUtil.createAttribute(ATTRIBUTE_ADDTL_VALUE_OPERATOR, this.getAvOperator().getName(), DEFAULT_ADDTL_VALUE_OPERATOR.getName()) + XmlUtil.createAttribute(ATTRIBUTE_ADDTL_VALUE_DATATYPE, this.getAvDatatype().getId(), DEFAULT_ADDTL_VALUE_DATATYPE.getId()) + (this.getInstall().getIsInstall() ? XmlUtil.createAttribute("require_reboot", this.getInstall().getRequireReboot(), false) : "") + ">" + '\n' + XmlUtil.createElement(ELEMENT_INCORRECT_TEXT, this.replaceVariables(bl2, this.getLabelWhenIncorrect())) + XmlUtil.createElement(ELEMENT_WHEN_REPAIRED_TEXT, this.replaceVariables(bl2, this.getLabelWhenRepaired())) + XmlUtil.createElement(ELEMENT_REQUIRED_VALUE, Setting.untranslate(this.getSettingId(), this.getRequiredValue().getValue())) + XmlUtil.createElement(ELEMENT_ADDITIONAL_VALUE, this.getRequiredValue().getAdditionalValue()) + XmlUtil.createElement(ELEMENT_UNENFORCED_VALUE, this.getRequiredValue().getUnenforcedValue());
        if (bl) {
            string = string + XmlUtil.createElementOpen(ELEMENT_ORIGINALS) + XmlUtil.createElement(ELEMENT_ORIGINAL_REQUIRED_VALUE, Setting.untranslate(this.getSettingId(), this.getRuntime().getOriginalValue().getValue())) + XmlUtil.createElement(ELEMENT_ORIGINAL_ADDITIONAL_VALUE, this.getRuntime().getOriginalValue().getAdditionalValue()) + XmlUtil.createElement(ELEMENT_ORIGINAL_UNENFORCED_VALUE, this.getRuntime().getOriginalValue().getUnenforcedValue()) + XmlUtil.createElementClose(ELEMENT_ORIGINALS);
        }
        string = string + this.getInstall().getXml();
        string = string + XmlUtil.createElement(ELEMENT_HELP_LINK, this.replaceVariables(bl2, this.cls_HelpLink)) + XmlUtil.createElementClose(ELEMENT_SETTING);
        return string;
    }

    public String toString() {
        return "[Setting id=" + (Object)((Object)this.getSettingId()) + " name=\"" + this.getLabelWhenIncorrect() + "\"]";
    }

    public String getValue() {
        return this.getRequiredValue().getValue();
    }

    public void setValue(String string) {
        this.getRequiredValue().setValue(string);
    }

    public String getAdditionalValue() {
        return this.getRequiredValue().getAdditionalValue();
    }

    public void setAdditionalValue(String string) {
        this.getRequiredValue().setAdditionalValue(string);
    }

    public String getUnenforcedValue() {
        return this.getRequiredValue().getUnenforcedValue();
    }

    public void setUnenforcedValue(String string) {
        this.getRequiredValue().setUnenforcedValue(string);
    }

    private String replaceVariables(boolean bl, String string) {
        if (bl && this.getAdditionalValue() != null && this.getAdditionalValue().length() > 0) {
            string = string.replaceAll("\\Q${ADDITIONAL_VALUE}\\E", this.getAdditionalValue());
        }
        return string;
    }
}

