/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.assess.os.mac.tiger;

import com.cloudpath.assess.buffer.AbstractBuffer;
import com.cloudpath.assess.buffer.Buffer;
import com.cloudpath.assess.pojo.Setting;
import com.cloudpath.assess.pojo.Settings;
import com.cloudpath.assess.pojo.util.SettingValue;
import com.cloudpath.common.os.mac.tiger.network.internetconnect.MacSupplicantProfile;
import com.cloudpath.common.os.mac.tiger.network.networkconnect.NetworkConnectBuffer;
import com.cloudpath.common.os.mac.tiger.network.networkconnect.NetworkConnectPlist;
import com.cloudpath.common.pojo.NetworkInterface;
import com.cloudpath.common.util.Credential;
import com.cloudpath.common.util.InvalidValueException;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.common.util.Util;
import com.cloudpath.common.util.XmlUtil;
import com.cloudpath.workflow.common.WorkflowConstants;
import org.apache.log4j.Logger;

public class TigerSupplicantBuffer
extends AbstractBuffer
implements Buffer {
    private static final Logger log = Logger.getLogger(TigerSupplicantBuffer.class);
    private static final String NIC_SELECTED_VARIABLE = "${SELECTED}";
    private static final Settings.SettingId[] INTERESTED_SETTINGS = new Settings.SettingId[]{Settings.SettingId.MAC_DOT1X_PROFILE_NAME, Settings.SettingId.MAC_SSID, Settings.SettingId.MAC_DOT1X_OUTER_IDENTITY, Settings.SettingId.MAC_DOT1X_EAP_TYPES, Settings.SettingId.MAC_DOT1X_TTLS_INNER_AUTHENTICATION, Settings.SettingId.MAC_DOT1X_EAP_FAST_PAC_FLAG, Settings.SettingId.MAC_SSID_NETWORK_PORT};
    private final NetworkConnectBuffer cls_NetworkConnect;
    private String cls_NetworkInterfaceGuid;
    private String cls_ProfileName;
    private MacSupplicantProfile cls_Supplicant = null;
    private boolean cls_ProfileToBeDeleted = false;
    private boolean cls_IsDot1x = false;

    public TigerSupplicantBuffer(NetworkConnectBuffer networkConnectBuffer) {
        super(INTERESTED_SETTINGS);
        this.cls_NetworkConnect = networkConnectBuffer;
    }

    public boolean setSystemValue(Setting setting, SettingValue settingValue) throws InvalidValueException {
        if (!this.cls_IsDot1x) {
            return true;
        }
        Settings.SettingId settingId = setting.getSettingId();
        log.info((Object)(this.getClass().getSimpleName() + " will set value for " + (Object)((Object)settingId) + " to " + settingValue.getValue() + "/" + settingValue.getAdditionalValue()));
        if (settingId == Settings.SettingId.MAC_DOT1X_PROFILE_NAME) {
            if (!"1".equals(settingValue.getValue())) {
                this.cls_ProfileToBeDeleted = true;
                this.cls_Supplicant = new MacSupplicantProfile();
            }
            this.cls_Supplicant.setProfileName(settingValue.getAdditionalValue());
        } else if (settingId == Settings.SettingId.MAC_SSID) {
            this.cls_Supplicant.setSsid(settingValue.getAdditionalValue());
        } else if (settingId == Settings.SettingId.MAC_DOT1X_EAP_TYPES) {
            this.cls_Supplicant.setEapTypes(settingValue.getAdditionalValue());
        } else if (settingId == Settings.SettingId.MAC_DOT1X_TTLS_INNER_AUTHENTICATION) {
            NetworkConnectPlist.TtlsInnerAuthentication ttlsInnerAuthentication = NetworkConnectPlist.TtlsInnerAuthentication.getByDbName(settingValue.getValue());
            if (ttlsInnerAuthentication == null) {
                log.debug((Object)"TTLS Inner Auth parsed to null.  Will default PAP.");
                ttlsInnerAuthentication = NetworkConnectPlist.TtlsInnerAuthentication.PAP;
            }
            log.debug((Object)("Will set TTLS inner auth to " + (Object)((Object)ttlsInnerAuthentication)));
            this.cls_Supplicant.setTtlsInnerAuthentication(ttlsInnerAuthentication);
        } else if (settingId == Settings.SettingId.MAC_DOT1X_OUTER_IDENTITY) {
            this.cls_Supplicant.setOuterIdentity(settingValue.getAdditionalValue());
        } else if (settingId == Settings.SettingId.MAC_DOT1X_EAP_FAST_PAC_FLAG) {
            this.cls_Supplicant.setEapFastPacFlag(NetworkConnectPlist.EapFastPacFlag.getInstance(XmlUtil.getStringAsInt(settingValue.getValue(), -1)));
        } else if (settingId == Settings.SettingId.MAC_SSID_NETWORK_PORT) {
            String string = settingValue.getAdditionalValue();
            string = Util.replaceVariable(string, "SELECTED", this.cls_NetworkInterfaceGuid);
            this.cls_Supplicant.setNetworkInterface(string);
        }
        return true;
    }

    public SettingValue getSystemValue(Setting setting, boolean bl) {
        if (!this.cls_IsDot1x) {
            return null;
        }
        SettingValue settingValue = new SettingValue();
        Settings.SettingId settingId = setting.getSettingId();
        log.info((Object)("Will read value for " + (Object)((Object)settingId) + "."));
        if (settingId == Settings.SettingId.MAC_DOT1X_PROFILE_NAME) {
            String string;
            String string2;
            log.debug((Object)("Will get value for profile name ('" + this.cls_Supplicant.getProfileName() + "')..."));
            if (this.cls_Supplicant.getProfileName().length() == 0) {
                log.debug((Object)" - Profile is unconfigured.");
                string2 = "0";
                string = setting.getAdditionalValue();
            } else if (!this.cls_ProfileToBeDeleted) {
                log.debug((Object)" - Profile is configured.");
                string2 = "1";
                string = this.cls_Supplicant.getProfileName();
            } else {
                log.debug((Object)" - Profile is to be deleted. Will treat as unconfigured.");
                string2 = "0";
                string = setting.getAdditionalValue();
            }
            settingValue.setValue(string2);
            settingValue.setAdditionalValue(string);
        } else if (settingId == Settings.SettingId.MAC_SSID) {
            settingValue.setValue("1");
            settingValue.setAdditionalValue(this.cls_Supplicant.getSsid());
        } else if (settingId == Settings.SettingId.MAC_DOT1X_EAP_TYPES) {
            settingValue.setValue("1");
            settingValue.setAdditionalValue(this.cls_Supplicant.getEapTypesString());
        } else if (settingId == Settings.SettingId.MAC_DOT1X_TTLS_INNER_AUTHENTICATION) {
            settingValue.setValue(this.cls_Supplicant.getTtlsInnerAuthentication().dbName);
        } else if (settingId == Settings.SettingId.MAC_DOT1X_OUTER_IDENTITY) {
            settingValue.setValue("1");
            settingValue.setAdditionalValue(this.cls_Supplicant.getOuterIdentity());
        } else if (settingId == Settings.SettingId.MAC_DOT1X_EAP_FAST_PAC_FLAG) {
            settingValue.setValue(this.cls_Supplicant.getEapFastPacFlag().dbName);
        } else if (settingId == Settings.SettingId.MAC_SSID_NETWORK_PORT) {
            String string = this.cls_Supplicant.getNetworkInterface();
            if (NIC_SELECTED_VARIABLE.equals(setting.getAdditionalValue()) && this.cls_NetworkInterfaceGuid.equals(string)) {
                string = NIC_SELECTED_VARIABLE;
            }
            settingValue.setValue("1");
            settingValue.setAdditionalValue(string);
        }
        log.info((Object)("Read value for " + (Object)((Object)settingId) + " as '" + settingValue.getValue() + "' and '" + settingValue.getAdditionalValue() + "'."));
        return settingValue;
    }

    public void refresh(SelectionHandler selectionHandler, Setting[] settingArray) {
        int n;
        log.info((Object)"Will refresh.");
        this.cls_NetworkInterfaceGuid = ((NetworkInterface)selectionHandler.getObject(WorkflowConstants.DataType.SELECTED_INTERFACE)).getLogicalGuid();
        String string = null;
        for (n = 0; string == null && n < settingArray.length; ++n) {
            if (!Settings.SettingId.MAC_DOT1X_PROFILE_NAME.equals((Object)settingArray[n].getSettingId())) continue;
            string = settingArray[n].getAdditionalValue();
            log.info((Object)("Desired profile name determined to be '" + string + "'."));
        }
        if (string == null) {
            string = "";
        }
        this.cls_ProfileName = string;
        log.info((Object)("Desired profile name is '" + this.cls_ProfileName + "'."));
        n = 1;
        for (int i = 0; i < settingArray.length; ++i) {
            if (!Settings.SettingId.MAC_SSID_PSK.equals((Object)settingArray[i].getSettingId())) continue;
            log.info((Object)"The profile is psk-based.");
            n = 0;
        }
        this.cls_IsDot1x = n;
        if (n != 0) {
            log.debug((Object)"Will refresh network connect information...");
            this.cls_NetworkConnect.refresh();
            log.debug((Object)("Will ask network connect for profile '" + string + "'."));
            this.cls_Supplicant = this.cls_NetworkConnect.getProfile(string);
            log.debug((Object)("After refresh, supplicant is " + this.cls_Supplicant));
            this.cls_ProfileToBeDeleted = false;
            if (this.cls_Supplicant == null) {
                this.cls_Supplicant = new MacSupplicantProfile();
                log.info((Object)"Supplicant profile is null.  Will create a new one.");
            } else {
                log.info((Object)("Supplicant profile was found.  Name is '" + this.cls_Supplicant.getProfileName() + "'."));
            }
        }
    }

    public void commit(SelectionHandler selectionHandler) throws Exception {
        if (!this.cls_IsDot1x) {
            return;
        }
        log.info((Object)(this.getClass().getSimpleName() + " will commit " + this.cls_Supplicant.getProfileName()));
        if (this.cls_ProfileToBeDeleted) {
            log.debug((Object)"  - Deleting profile.");
            this.cls_NetworkConnect.deleteProfile(this.cls_Supplicant.getProfileName());
        } else {
            Credential credential;
            if (this.cls_Supplicant.getNetworkInterface().length() == 0) {
                this.cls_Supplicant.setNetworkInterface(this.cls_NetworkInterfaceGuid);
            }
            if (this.cls_Supplicant.getProfileName().length() == 0) {
                this.cls_Supplicant.setProfileName(this.cls_ProfileName);
            }
            if ((credential = (Credential)selectionHandler.getObject(WorkflowConstants.DataType.SELECTED_CREDENTIAL)) != null) {
                if (this.cls_Supplicant.getUserName().length() == 0 && credential.getUserName() != null && credential.getUserName().length() > 0) {
                    log.debug((Object)("Injecting user name " + credential.getUserName() + "."));
                    this.cls_Supplicant.setUserName(credential.getUserName());
                }
                if (this.cls_Supplicant.getPassword().length() == 0 && credential.getPassword() != null && credential.getPassword().length() > 0) {
                    log.error((Object)"Injecting password.");
                    this.cls_Supplicant.setPassword(credential.getPassword());
                }
            }
            log.debug((Object)"  - Adding/editing profile.");
            this.cls_NetworkConnect.add(this.cls_Supplicant);
        }
        log.debug((Object)"  - Committing changes to network connect.");
        this.cls_NetworkConnect.commit();
    }

    public String toString() {
        return Util.createToString(this.getClass());
    }
}

