/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.assess.os.mac.lion;

import com.cloudpath.assess.buffer.AbstractBuffer;
import com.cloudpath.assess.buffer.Buffer;
import com.cloudpath.assess.pojo.NetworkItem;
import com.cloudpath.assess.pojo.Setting;
import com.cloudpath.assess.pojo.Settings;
import com.cloudpath.assess.pojo.util.SettingValue;
import com.cloudpath.common.cert.IssuedCertificate;
import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.os.common.WirelessProvider;
import com.cloudpath.common.os.mac.leopard.cmd.Maccmd;
import com.cloudpath.common.os.mac.leopard.network.airport.LeopardAirportNetwork;
import com.cloudpath.common.os.mac.lion.LionMobileConfigReader;
import com.cloudpath.common.os.mac.lion.MobileConfigProfile;
import com.cloudpath.common.os.mac.snowleopard.network.networksetup.SnowLeopardNetworkSetupReader;
import com.cloudpath.common.parse.InvalidXmlException;
import com.cloudpath.common.pojo.NetworkInterface;
import com.cloudpath.common.util.Credential;
import com.cloudpath.common.util.FileHandler;
import com.cloudpath.common.util.InvalidValueException;
import com.cloudpath.common.util.OsConstants;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.common.util.Util;
import com.cloudpath.workflow.common.WorkflowConstants;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LionMobileConfigBuffer
extends AbstractBuffer
implements Buffer {
    private static final Logger log = Logger.getLogger(LionMobileConfigBuffer.class);
    public static final String KEYCHAIN_ID_WIRELESS = "com.apple.network.eap.user.item.wlan.ssid.";
    private static final Settings.SettingId[] INTERESTED_SETTINGS = new Settings.SettingId[]{Settings.SettingId.MOBILECONFIG_ID};
    public static final int SSID_CONFLICT_SET_TO_MANUAL = 0;
    public static final int SSID_CONFLICT_DELETE = 1;
    public static final int SSID_CONFLICT_DO_NOTHING = 2;
    private final Maccmd cls_Maccmd;
    private final LionMobileConfigReader cls_MobileConfigReader;
    private final SelectionHandler cls_SelectionHandler;
    private boolean cls_HasWrittenMobileConfig = false;
    private final WirelessProvider cls_WirelessProvider;
    private final SnowLeopardNetworkSetupReader cls_NetworkSetupReader;
    private final boolean cls_IsGuestMode;

    public LionMobileConfigBuffer(FileHandler fileHandler, CommandHandler commandHandler, Maccmd maccmd, LionMobileConfigReader lionMobileConfigReader, SelectionHandler selectionHandler, WirelessProvider wirelessProvider, SnowLeopardNetworkSetupReader snowLeopardNetworkSetupReader, boolean bl) {
        super(INTERESTED_SETTINGS);
        this.cls_Maccmd = maccmd;
        this.cls_MobileConfigReader = lionMobileConfigReader;
        this.cls_SelectionHandler = selectionHandler;
        this.cls_WirelessProvider = wirelessProvider;
        this.cls_NetworkSetupReader = snowLeopardNetworkSetupReader;
        this.cls_IsGuestMode = bl;
    }

    public boolean setSystemValue(Setting setting, SettingValue settingValue) throws InvalidValueException {
        Settings.SettingId settingId = setting.getSettingId();
        log.info((Object)(this.getClass().getSimpleName() + " will set value for " + (Object)((Object)settingId) + " to " + settingValue.getValue() + "/" + settingValue.getAdditionalValue()));
        if (Settings.SettingId.MOBILECONFIG_ID.equals((Object)settingId)) {
            String string = settingValue.getUnenforcedValue();
            long l = settingValue.getValueAsLong();
            MobileConfigProfile mobileConfigProfile = MobileConfigProfile.loadMobileConfigProfile(string);
            if (mobileConfigProfile != null) {
                Object object;
                String string2;
                Object object2;
                byte[] byArray;
                IssuedCertificate issuedCertificate;
                Credential credential = (Credential)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_CREDENTIAL);
                String string3 = "";
                String string4 = "";
                if (credential != null) {
                    string3 = credential.getUserName();
                    string4 = credential.getPassword();
                }
                if (string4 == null || string4.length() == 0) {
                    log.info((Object)"Will retrieve p12 info from runtime tls setting.");
                    string4 = (String)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.RUNTIME_TLS_PASSWORD);
                }
                if ((issuedCertificate = (IssuedCertificate)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.RUNTIME_ISSUED_CERTIFICATE)) != null) {
                    log.info((Object)"-> Will create config with certificate.");
                    byArray = issuedCertificate.getCertificateBytes();
                    log.info((Object)("-> MobileConfig: " + byArray));
                    object2 = "${P12PASSWORD}";
                    string2 = "<!-- P12_PASSWORD_PLACEHOLDER -->";
                    object = issuedCertificate.getCertificateData();
                    if (object != null && (object.contains((CharSequence)object2) || object.contains(string2))) {
                        if (object.contains((CharSequence)object2)) {
                            log.info((Object)"Mobileconfig contains variable for password.  Will inject.");
                            object = object.replace((CharSequence)object2, "<![CDATA[" + string4 + "]]>");
                        } else {
                            log.info((Object)"Mobileconfig does not contain variable for password.  Will not inject.");
                        }
                        if (object.contains(string2)) {
                            log.info((Object)"Mobileconfig contains marker for password.  Will inject.");
                            object = object.replace(string2, "<key>Password</key>\n<string><![CDATA[" + string4 + "]]></string>");
                        } else {
                            log.info((Object)"Mobileconfig does not contain marker for password.  Will not inject.");
                        }
                        log.info((Object)"Will replace mobileConfigData with modified string.");
                        byArray = object.getBytes();
                    }
                    log.info((Object)("Final XML: \n" + byArray));
                    MobileConfigProfile mobileConfigProfile2 = null;
                    try {
                        mobileConfigProfile2 = new MobileConfigProfile(new String(byArray));
                    }
                    catch (InvalidXmlException invalidXmlException) {
                        log.error((Object)invalidXmlException);
                    }
                    log.info((Object)("Final MobileConfig:\n" + mobileConfigProfile2));
                    this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.RUNTIME_REPLACEMENT_MOBILECONFIG, mobileConfigProfile2);
                } else {
                    log.info((Object)"Will create config with credentials.");
                    object2 = mobileConfigProfile.getXmlWithCredentialsForAdd(string3, string4);
                    byArray = ((String)object2).getBytes();
                }
                if (l == 2L) {
                    log.info((Object)"Will add system profile...");
                    this.cls_Maccmd.addSystemProfile(byArray);
                } else if (this.cls_IsGuestMode) {
                    log.info((Object)"Will add user profile in guest mode...");
                    this.cls_Maccmd.addUserProfile(byArray);
                } else {
                    log.info((Object)("Will user profile:\n" + byArray));
                    try {
                        object2 = mobileConfigProfile.getPayloadPayloadIdentifier();
                        log.info((Object)("Payload identifier of user profile is '" + (String)object2 + "'."));
                        if (this.cls_MobileConfigReader.isUserProfileInstalledByPayloadIdentifier((String)object2)) {
                            log.info((Object)("Will remove existing user profile with payload identifier '" + (String)object2 + "'."));
                            this.cls_MobileConfigReader.removeUserProfileByPayloadIdentifier((String)object2);
                        }
                        log.info((Object)("Will add user profile with payload identifier '" + (String)object2 + "'."));
                    }
                    catch (Throwable throwable) {
                        log.log((Priority)Level.INFO, (Object)"An error occurred while trying to check if existing profile exists.");
                    }
                    this.cls_MobileConfigReader.addProfile(byArray);
                    log.info((Object)"Will prioritize SSID...");
                    object2 = (NetworkInterface)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_INTERFACE);
                    if (object2 != null && ((NetworkInterface)object2).getLogicalGuid().length() > 0) {
                        string2 = mobileConfigProfile.getFirstSsid();
                        log.info((Object)("SSID to prioritize is: '" + string2 + "'."));
                        object = this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.DESIRED_SSID_IS_PSK) == null || (Boolean)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.DESIRED_SSID_IS_PSK) == false ? LeopardAirportNetwork.SecurityType.WPA2_ENTERPRISE : LeopardAirportNetwork.SecurityType.WPA2_PERSONAL;
                        if (string2 != null && string2.length() > 0) {
                            if (this.cls_NetworkSetupReader.isSsidPreferred(((NetworkInterface)object2).getLogicalGuid(), string2)) {
                                log.info((Object)("SSID '" + string2 + "' is already prioritized.  Will reprioritize..."));
                                this.cls_Maccmd.removePreferredWirelessNetwork(((NetworkInterface)object2).getLogicalGuid(), string2);
                                if (this.cls_NetworkSetupReader.isSsidPreferred(((NetworkInterface)object2).getLogicalGuid(), string2)) {
                                    log.info((Object)("SSID '" + string2 + "' is still prioritized.  Will reprioritize again..."));
                                    this.cls_Maccmd.removePreferredWirelessNetwork(((NetworkInterface)object2).getLogicalGuid(), string2);
                                }
                            }
                            log.info((Object)("Prioritizing SSID '" + string2 + "' to first slot."));
                            this.cls_Maccmd.addPreferredWirelessNetwork(((NetworkInterface)object2).getLogicalGuid(), string2, 0, ((LeopardAirportNetwork.SecurityType)((Object)object)).SnowLeopardOsName, null);
                            if (OsConstants.isMacYosemiteOrGreater()) {
                                this.cls_Maccmd.addPreferredWirelessNetworkWithAPI(((NetworkInterface)object2).getLogicalGuid(), string2);
                            }
                        }
                    } else {
                        log.info((Object)"-- No selected NIC available.");
                    }
                    log.info((Object)"Done prioritizing SSID.");
                }
            }
            this.cls_HasWrittenMobileConfig = true;
        }
        return true;
    }

    public SettingValue getSystemValue(Setting setting, boolean bl) {
        SettingValue settingValue = new SettingValue();
        Settings.SettingId settingId = setting.getSettingId();
        log.info((Object)("Will read value for " + (Object)((Object)settingId) + "."));
        if (Settings.SettingId.MOBILECONFIG_ID.equals((Object)settingId)) {
            boolean bl2;
            log.info((Object)"-------- WILL READ IF PROFILE IS INSTALLED -------");
            String string = setting.getUnenforcedValue();
            MobileConfigProfile mobileConfigProfile = (MobileConfigProfile)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.RUNTIME_REPLACEMENT_MOBILECONFIG);
            if (mobileConfigProfile == null) {
                log.info((Object)("File name is " + string));
                mobileConfigProfile = MobileConfigProfile.loadMobileConfigProfile(string);
                if (mobileConfigProfile == null) {
                    log.error((Object)"Mobileconfig file wasn't found!");
                    return null;
                }
            }
            String[] stringArray = mobileConfigProfile.getDot1XPayloadUUIDs(true, true);
            long l = setting.getRequiredValue().getValueAsLong();
            if (!this.cls_HasWrittenMobileConfig) {
                log.info((Object)"We have not attempted to write the profile.");
                bl2 = false;
            } else {
                log.info((Object)"We have previously attempted to write the profile.");
                bl2 = l == 2L ? this.cls_MobileConfigReader.hasUuidsInstalled(stringArray, false, true) : this.cls_MobileConfigReader.hasUuidsInstalled(stringArray, true, false);
                if (this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.DESIRED_SSID_IS_PSK) != null && !((Boolean)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.DESIRED_SSID_IS_PSK)).booleanValue()) {
                    Credential credential = (Credential)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_CREDENTIAL);
                    String string2 = "";
                    String string3 = "";
                    if (credential != null) {
                        string2 = credential.getUserName();
                        string3 = credential.getPassword();
                    }
                    Maccmd.Keychain keychain = Maccmd.Keychain.login;
                    if (l == 2L) {
                        keychain = Maccmd.Keychain.system;
                    }
                    String string4 = (String)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.DESIRED_SSID_NAME);
                    if (!this.cls_Maccmd.doesGenericPasswordMatch(keychain, string2, KEYCHAIN_ID_WIRELESS + string4, string3)) {
                        bl2 = false;
                        this.cls_Maccmd.deleteGenericPassword(keychain, string2, KEYCHAIN_ID_WIRELESS + string4);
                    }
                }
            }
            settingValue.setValue(bl2 ? "" + l : "0");
            settingValue.setAdditionalValue(setting.getRequiredValue().getAdditionalValue());
            settingValue.setUnenforcedValue(string);
            log.info((Object)"-------- DONE READING IF PROFILE IS INSTALLED -------");
        }
        log.info((Object)("Read value for " + (Object)((Object)settingId) + " as '" + settingValue.getValue() + "' and '" + settingValue.getAdditionalValue() + "'."));
        return settingValue;
    }

    public void refresh(SelectionHandler selectionHandler, Setting[] settingArray) {
        log.info((Object)"Will refresh Lion buffer...");
        NetworkInterface networkInterface = this.getSelectedInterface(this.cls_SelectionHandler);
        if (networkInterface != null && networkInterface.getInterfaceType() == 2) {
            log.info((Object)"NIC is wireless.  Will apply conflicting SSIDs.");
            this.doApplyConflictingSsids(selectionHandler);
        } else {
            log.info((Object)"NIC is not wireless.  Will not apply conflicing SSIDs.");
        }
    }

    public void commit(SelectionHandler selectionHandler) throws Exception {
    }

    public String toString() {
        return Util.createToString(this.getClass());
    }

    private void doApplyConflictingSsids(SelectionHandler selectionHandler) {
        log.info((Object)"* Will apply conflicting ssids...");
        NetworkItem networkItem = (NetworkItem)selectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK_ITEM);
        log.debug((Object)("Will check conflicting ssids.  Network item is: " + networkItem));
        if (networkItem != null) {
            log.debug((Object)("  Conflicting SSID Behavior is " + networkItem.getConflictBehavior() + ", SSID is '" + networkItem.getConflictSsids() + "'."));
        }
        if (networkItem != null && networkItem.getConflictBehavior() != 2) {
            log.debug((Object)"  Behavior is not do-nothing.");
            String string = this.getSelectedInterface(selectionHandler).getLogicalGuid();
            log.debug((Object)("  Interface is '" + string + "'."));
            String string2 = networkItem.getConflictSsids();
            log.debug((Object)("  Conflicting SSIDs are '" + string2 + "'."));
            if (string2 != null) {
                String[] stringArray;
                String[] stringArray2;
                block10: {
                    if (string2.length() == 0 || "*".equals(string2)) {
                        log.debug((Object)"  Conflicting SSIDs is wildcard.  Will use current SSID.");
                        stringArray2 = new String[]{};
                        if (this.cls_WirelessProvider != null) {
                            try {
                                stringArray = this.cls_WirelessProvider.getCurrentAssociation(this.getSelectedInterface(selectionHandler).getLogicalGuid());
                                if (stringArray != null && stringArray.getSsid() != null && stringArray.getSsid().length() > 0) {
                                    stringArray2 = new String[]{stringArray.getSsid()};
                                    log.debug((Object)("  ConflictingSsids will affect current SSID '" + stringArray.getSsid() + "'"));
                                    break block10;
                                }
                                log.debug((Object)"  No current SSID found for conflicting behavior.");
                            }
                            catch (Exception exception) {
                                log.debug((Object)"  Failed to query current ssid while setting conflicting ssids.  Will continue.", (Throwable)exception);
                            }
                        }
                    } else {
                        stringArray2 = string2.split(";");
                    }
                }
                stringArray = this.cls_NetworkSetupReader.getPreferredWirelessNetworks(string);
                log.info((Object)("  Existing preferred SSIDs are: " + Util.join(stringArray)));
                for (int i = 0; i < stringArray2.length; ++i) {
                    String string3 = stringArray2[i];
                    log.debug((Object)("  Will check ssid " + i + ": " + string3));
                    if (!LionMobileConfigBuffer.doesSsidExistInPreferred(string3, stringArray)) continue;
                    log.debug((Object)("  SSID '" + string3 + "' exists in preferred list.  Will remove."));
                    this.cls_NetworkSetupReader.deletePreferredWirelessNetwork(string, string3);
                }
            }
        }
        log.info((Object)"* Done applying conflicting ssids.");
    }

    public static final boolean doesSsidExistInPreferred(String string, String[] stringArray) {
        log.debug((Object)("Will check if ssid '" + string + "' exists in list '" + Util.join(stringArray) + "'."));
        if (string != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                log.debug((Object)(" - Ssid '" + string + "' exists in preferred list."));
                return true;
            }
        }
        log.debug((Object)(" - Ssid '" + string + "' does not exist in preferred list."));
        return false;
    }

    private NetworkInterface getSelectedInterface(SelectionHandler selectionHandler) {
        return (NetworkInterface)selectionHandler.getObject(WorkflowConstants.DataType.SELECTED_INTERFACE);
    }
}

