/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.assess.os.mac.leopard;

import com.cloudpath.assess.buffer.AbstractBuffer;
import com.cloudpath.assess.buffer.Buffer;
import com.cloudpath.assess.pojo.NetworkItem;
import com.cloudpath.assess.pojo.Setting;
import com.cloudpath.assess.pojo.Settings;
import com.cloudpath.assess.pojo.util.SettingValue;
import com.cloudpath.common.os.common.WirelessAssociation;
import com.cloudpath.common.os.common.WirelessProvider;
import com.cloudpath.common.os.mac.common.network.airport.SsidManager;
import com.cloudpath.common.os.mac.leopard.network.airport.LeopardAirportNetwork;
import com.cloudpath.common.os.mac.leopard.network.airport.LeopardSsid;
import com.cloudpath.common.pojo.NetworkInterface;
import com.cloudpath.common.util.BanishedWords;
import com.cloudpath.common.util.InvalidValueException;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.common.util.Util;
import com.cloudpath.workflow.common.WorkflowConstants;
import org.apache.log4j.Logger;

public class LeopardWirelessBuffer
extends AbstractBuffer
implements Buffer {
    private static final Logger log = Logger.getLogger(LeopardWirelessBuffer.class);
    private static final Settings.SettingId[] INTERESTED_SETTINGS = new Settings.SettingId[]{Settings.SettingId.MAC_LEOPARD_SSID_PROFILE_NAME, Settings.SettingId.MAC_SSID, Settings.SettingId.MAC_LEOPARD_SSID_SECURITY_TYPE, Settings.SettingId.MAC_LEOPARD_SSID_PREFERRED_INDEX, Settings.SettingId.MAC_SSID_PSK};
    public static final int SSID_CONFLICT_SET_TO_MANUAL = 0;
    public static final int SSID_CONFLICT_DELETE = 1;
    public static final int SSID_CONFLICT_DO_NOTHING = 2;
    private final SsidManager cls_SsidManager;
    private final WirelessProvider cls_WirelessProvider;
    private String cls_InterfaceName;
    private String cls_MacAddress;
    private String cls_SsidName;
    private String cls_Psk;
    private LeopardSsid cls_Ssid = null;
    private boolean cls_SsidToBeDeleted = false;
    private int cls_SsidCommittedCount = 0;

    public LeopardWirelessBuffer(SsidManager ssidManager, WirelessProvider wirelessProvider) {
        super(INTERESTED_SETTINGS);
        this.cls_SsidManager = ssidManager;
        this.cls_WirelessProvider = wirelessProvider;
    }

    public boolean setSystemValue(Setting setting, SettingValue settingValue) throws InvalidValueException {
        Settings.SettingId settingId = setting.getSettingId();
        log.info((Object)(this.getClass().getSimpleName() + " will set value for " + (Object)((Object)settingId) + " to " + settingValue.getValue() + "/" + settingValue.getAdditionalValue()));
        if (settingId == Settings.SettingId.MAC_SSID) {
            if (!"1".equals(settingValue.getValue())) {
                this.cls_SsidToBeDeleted = true;
                this.cls_Ssid = new LeopardSsid();
            }
            this.cls_Ssid.setSsid(settingValue.getAdditionalValue());
        } else if (settingId == Settings.SettingId.MAC_LEOPARD_SSID_PROFILE_NAME) {
            if ("1".equals(settingValue.getValue())) {
                this.cls_Ssid.setDot1xProfile(settingValue.getAdditionalValue());
                this.cls_Ssid.setDot1xUniqueProfileId("");
            } else {
                this.cls_Ssid.setDot1xProfile("");
                this.cls_Ssid.setDot1xUniqueProfileId("");
            }
        } else if (settingId == Settings.SettingId.MAC_LEOPARD_SSID_SECURITY_TYPE) {
            this.cls_Ssid.setSecurityType(LeopardAirportNetwork.SecurityType.parseSecurityType(settingValue.getValue()));
        } else if (settingId == Settings.SettingId.MAC_LEOPARD_SSID_PREFERRED_INDEX) {
            this.cls_Ssid.setIndex((int)settingValue.getValueAsLong() - 1);
        } else if (settingId == Settings.SettingId.MAC_SSID_PSK) {
            this.cls_Ssid.setPsk(settingValue.getAdditionalValue());
        }
        return true;
    }

    public SettingValue getSystemValue(Setting setting, boolean bl) {
        SettingValue settingValue = new SettingValue();
        Settings.SettingId settingId = setting.getSettingId();
        log.info((Object)("Will read value for " + (Object)((Object)settingId) + "."));
        if (settingId == Settings.SettingId.MAC_SSID) {
            String string;
            String string2;
            log.debug((Object)("Will get value for ssid  ('" + this.cls_Ssid.getSsid() + "')..."));
            if (this.cls_Ssid.getSsid().length() == 0) {
                log.debug((Object)" - Ssid is unconfigured.");
                string2 = "0";
                string = setting.getAdditionalValue();
            } else if (!this.cls_SsidToBeDeleted) {
                log.debug((Object)" - Ssid is configured.");
                string2 = "1";
                string = this.cls_Ssid.getSsid();
            } else {
                log.debug((Object)" - Ssid is to be deleted. Will treat as unconfigured.");
                string2 = "0";
                string = setting.getAdditionalValue();
            }
            settingValue.setValue(string2);
            settingValue.setAdditionalValue(string);
        } else if (settingId == Settings.SettingId.MAC_LEOPARD_SSID_PROFILE_NAME) {
            String string = this.cls_Ssid.getDot1xProfile();
            if (string == null | string.length() == 0) {
                settingValue.setValue("0");
            } else {
                settingValue.setValue("1");
                settingValue.setAdditionalValue(this.cls_Ssid.getDot1xProfile());
            }
        } else if (settingId == Settings.SettingId.MAC_LEOPARD_SSID_SECURITY_TYPE) {
            settingValue.setValue(this.cls_Ssid.getSecurityType().name());
        } else if (settingId == Settings.SettingId.MAC_LEOPARD_SSID_PREFERRED_INDEX) {
            settingValue.setValue("" + (this.cls_Ssid.getIndex() + 1));
        } else if (settingId == Settings.SettingId.MAC_SSID_PSK) {
            if (this.cls_SsidCommittedCount > 0) {
                settingValue.setValue("1");
                settingValue.setAdditionalValue(setting.getAdditionalValue());
            } else {
                if (!this.cls_SsidManager.isKeychainPskCorrect(this.cls_SsidName, this.cls_Psk)) {
                    log.debug((Object)"PSK did not match the keychain.");
                    settingValue.setValue("0");
                } else {
                    log.debug((Object)"PSK matched the keychain.");
                    settingValue.setValue("1");
                }
                settingValue.setAdditionalValue(setting.getAdditionalValue());
            }
        }
        log.info((Object)("Read value for " + (Object)((Object)settingId) + " as '" + settingValue.getValue() + "' and '" + settingValue.getAdditionalValue() + "'."));
        return settingValue;
    }

    public void refresh(SelectionHandler selectionHandler, Setting[] settingArray) {
        String string;
        log.info((Object)"Will refresh wireless buffer.");
        this.cls_InterfaceName = this.getSelectedInterface(selectionHandler).getLogicalGuid();
        this.cls_MacAddress = this.getSelectedInterface(selectionHandler).getMacAddress();
        this.cls_SsidName = null;
        LeopardAirportNetwork.SecurityType securityType = null;
        this.cls_Psk = "";
        log.debug((Object)"Will look for interesting settings...");
        for (int i = 0; i < settingArray.length; ++i) {
            if (Settings.SettingId.MAC_SSID.equals((Object)settingArray[i].getSettingId())) {
                this.cls_SsidName = settingArray[i].getAdditionalValue();
                log.debug((Object)(" - The ssid is " + this.cls_SsidName));
                continue;
            }
            if (Settings.SettingId.MAC_LEOPARD_SSID_SECURITY_TYPE.equals((Object)settingArray[i].getSettingId())) {
                log.debug((Object)(" - The security type is " + settingArray[i].getValue()));
                securityType = LeopardAirportNetwork.SecurityType.parseSecurityType(settingArray[i].getValue());
                continue;
            }
            if (!Settings.SettingId.MAC_SSID_PSK.equals((Object)settingArray[i].getSettingId())) continue;
            log.info((Object)" - The ssid is psk-based.");
            this.cls_Psk = settingArray[i].getAdditionalValue();
        }
        log.debug((Object)"Done finding interesting settings.");
        selectionHandler.setObject(WorkflowConstants.DataType.DESIRED_SECURITY_TYPE, (Object)securityType);
        if (securityType == LeopardAirportNetwork.SecurityType.OPEN || securityType == LeopardAirportNetwork.SecurityType.WEP || securityType == LeopardAirportNetwork.SecurityType.WPA_PERSONAL || securityType == LeopardAirportNetwork.SecurityType.WPA2_PERSONAL) {
            log.info((Object)("SSID " + this.cls_SsidName + " is PSK-based."));
            log.info((Object)"Will banish the pre-shared key from the log.");
            BanishedWords.add(this.cls_Psk, "[PRE-SHARED KEY]");
            selectionHandler.setObject(WorkflowConstants.DataType.DESIRED_SSID_IS_PSK, Boolean.TRUE);
            selectionHandler.setObject(WorkflowConstants.DataType.DESIRED_PSK, this.cls_Psk);
        } else {
            selectionHandler.setObject(WorkflowConstants.DataType.DESIRED_SSID_IS_PSK, Boolean.FALSE);
            selectionHandler.setObject(WorkflowConstants.DataType.DESIRED_PSK, null);
        }
        if (this.cls_SsidName == null) {
            this.cls_SsidName = "";
        }
        log.info((Object)("Desired ssid name is '" + this.cls_SsidName + "'."));
        log.debug((Object)"Will refresh ssid information...");
        this.cls_SsidManager.refresh(this.cls_InterfaceName, this.cls_MacAddress);
        NetworkItem networkItem = (NetworkItem)selectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK_ITEM);
        log.debug((Object)("Will check conflicting ssids.  Network item is: " + networkItem));
        if (networkItem != null) {
            log.debug((Object)("  Conflicting SSID Behavior is " + networkItem.getConflictBehavior() + ", SSID is '" + networkItem.getConflictSsids() + "'."));
        }
        if (networkItem != null && networkItem.getConflictBehavior() != 2 && (string = networkItem.getConflictSsids()) != null) {
            String[] stringArray;
            block21: {
                if (string.length() == 0 || "*".equals(string)) {
                    log.debug((Object)"Conflicting SSIDs is wildcard.  Will use current SSID.");
                    stringArray = new String[]{};
                    if (this.cls_WirelessProvider != null) {
                        try {
                            WirelessAssociation wirelessAssociation = this.cls_WirelessProvider.getCurrentAssociation(this.getSelectedInterface(selectionHandler).getLogicalGuid());
                            if (wirelessAssociation != null && wirelessAssociation.getSsid() != null && wirelessAssociation.getSsid().length() > 0) {
                                stringArray = new String[]{wirelessAssociation.getSsid()};
                                log.debug((Object)("ConflictingSsids will affect current SSID '" + wirelessAssociation.getSsid() + "'"));
                                break block21;
                            }
                            log.debug((Object)"No current SSID found for conflicting behavior.");
                        }
                        catch (Exception exception) {
                            log.debug((Object)"Failed to query current ssid while setting conflicting ssids.  Will continue.", (Throwable)exception);
                        }
                    }
                } else {
                    stringArray = string.split(";");
                }
            }
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                LeopardSsid leopardSsid = this.cls_SsidManager.getSsid(stringArray[i]);
                if (leopardSsid == null) continue;
                log.info((Object)("ConflictingSsid '" + stringArray[i] + "' exists.  Will delete it."));
                if (this.cls_SsidName != null && this.cls_SsidName.equals(stringArray[i])) {
                    log.warn((Object)"  - Our target SSID is configured as a conflicting SSID.  Will ignore it.");
                    continue;
                }
                this.cls_SsidManager.removeSsid(stringArray[i]);
                bl = true;
            }
            if (bl) {
                log.debug((Object)"Will commit changes related to conflictingSsids and then refresh ssid information...");
                try {
                    this.cls_SsidManager.commit(this.cls_InterfaceName, this.cls_MacAddress);
                }
                catch (Exception exception) {
                    log.error((Object)"An exception occurred while committing the conflictingSsid changes.", (Throwable)exception);
                }
                this.cls_SsidManager.refresh(this.cls_InterfaceName, this.cls_MacAddress);
            }
        }
        log.debug((Object)("Will ask ssid manager for ssid '" + this.cls_SsidName + "'."));
        this.cls_Ssid = this.cls_SsidManager.getSsid(this.cls_SsidName);
        log.debug((Object)("After refresh, ssid is " + this.cls_Ssid));
        this.cls_SsidToBeDeleted = false;
        if (this.cls_Ssid == null) {
            this.cls_Ssid = new LeopardSsid();
            log.info((Object)"Ssid instance is null.  Will create a new one.");
        } else {
            log.info((Object)("Ssid instance was found.  Ssid is '" + this.cls_Ssid.getSsid() + "'."));
        }
    }

    public void commit(SelectionHandler selectionHandler) throws Exception {
        log.debug((Object)"Committing wireless buffer.");
        log.info((Object)(this.getClass().getSimpleName() + " will commit " + this.cls_Ssid.getSsid()));
        if (this.cls_SsidToBeDeleted) {
            log.debug((Object)"  - Deleting ssid.");
            this.cls_SsidManager.removeSsid(this.cls_Ssid.getSsid());
        } else {
            if (this.cls_Ssid.getSsid().length() == 0) {
                this.cls_Ssid.setSsid(this.cls_SsidName);
            }
            log.debug((Object)"  - Adding/editing ssid.");
            this.cls_SsidManager.setSsid(this.cls_Ssid);
        }
        ++this.cls_SsidCommittedCount;
        log.debug((Object)"  - Committing changes to ssid manager.");
        this.cls_SsidManager.commit(this.cls_InterfaceName, this.cls_MacAddress);
    }

    public String toString() {
        return Util.createToString(this.getClass());
    }

    private NetworkInterface getSelectedInterface(SelectionHandler selectionHandler) {
        return (NetworkInterface)selectionHandler.getObject(WorkflowConstants.DataType.SELECTED_INTERFACE);
    }
}

