/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.assess.os.mac.leopard;

import com.cloudpath.assess.buffer.AbstractBuffer;
import com.cloudpath.assess.buffer.Buffer;
import com.cloudpath.assess.os.mac.leopard.LeopardSupplicantBuffer;
import com.cloudpath.assess.pojo.Setting;
import com.cloudpath.assess.pojo.Settings;
import com.cloudpath.assess.pojo.util.SettingValue;
import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.os.mac.leopard.cmd.Maccmd;
import com.cloudpath.common.os.mac.leopard.security.LeopardSecurity;
import com.cloudpath.common.os.mac.leopard.security.LeopardTrustSetting;
import com.cloudpath.common.util.FileHandler;
import com.cloudpath.common.util.FileUtil;
import com.cloudpath.common.util.InvalidValueException;
import com.cloudpath.common.util.OsConstants;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.common.util.Util;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class LeopardUtilityBuffer
extends AbstractBuffer
implements Buffer {
    private static final Logger log = Logger.getLogger(LeopardSupplicantBuffer.class);
    private static final Settings.SettingId[] INTERESTED_SETTINGS = new Settings.SettingId[]{Settings.SettingId.ROOT_CA_CERTIFICATE_MACHINE, Settings.SettingId.CERTIFICATE_EAP_USER, Settings.SettingId.CERTIFICATE_EAP_SYSTEM, Settings.SettingId.CERTIFICATE_CODESIGN, Settings.SettingId.CERTIFICATE_CLIENT, Settings.SettingId.MAC_FIREWALL};
    private final FileHandler cls_FileHandler;
    private final LeopardSecurity cls_SecurityManager;
    private final Maccmd cls_Maccmd;

    public LeopardUtilityBuffer(FileHandler fileHandler, CommandHandler commandHandler, LeopardSecurity leopardSecurity, Maccmd maccmd) {
        super(INTERESTED_SETTINGS);
        this.cls_FileHandler = fileHandler;
        this.cls_SecurityManager = leopardSecurity;
        this.cls_Maccmd = maccmd;
    }

    public boolean setSystemValue(Setting setting, SettingValue settingValue) throws InvalidValueException {
        Settings.SettingId settingId = setting.getSettingId();
        log.info((Object)(this.getClass().getSimpleName() + " will set value for " + (Object)((Object)settingId) + " to " + settingValue.getValue() + "/" + settingValue.getAdditionalValue()));
        if (Settings.SettingId.ROOT_CA_CERTIFICATE_MACHINE.equals((Object)settingId)) {
            String string = settingValue.getAdditionalValue();
            String string2 = settingValue.getUnenforcedValue();
            boolean bl = "1".equals(settingValue.getValue());
            this.doSetCertificateTrust(string, string2, bl, LeopardTrustSetting.SettingType.EAP, Maccmd.KeychainType.SYSTEM_ROOT);
            boolean bl2 = this.cls_SecurityManager.isCaTrustedForDot1x(string);
            if (!bl2) {
                log.warn((Object)("\n\n\n**** CERT '" + string + "' DID NOT ADD AS ROOT CA.  WILL TRY AS INTERMEDIARY CA OR SERVER CERT. ******\n\n"));
                this.doSetCertificateTrust(string, string2, bl, LeopardTrustSetting.SettingType.EAP, Maccmd.KeychainType.LOGIN);
            }
        } else if (Settings.SettingId.CERTIFICATE_EAP_USER.equals((Object)settingId)) {
            String string = settingValue.getAdditionalValue();
            String string3 = settingValue.getUnenforcedValue();
            boolean bl = "1".equals(settingValue.getValue());
            this.doSetCertificateTrust(string, string3, bl, LeopardTrustSetting.SettingType.EAP, Maccmd.KeychainType.LOGIN);
        } else if (Settings.SettingId.CERTIFICATE_EAP_SYSTEM.equals((Object)settingId)) {
            String string = settingValue.getAdditionalValue();
            String string4 = settingValue.getUnenforcedValue();
            boolean bl = "1".equals(settingValue.getValue());
            this.doSetCertificateTrust(string, string4, bl, LeopardTrustSetting.SettingType.EAP, Maccmd.KeychainType.SYSTEM);
        } else if (Settings.SettingId.CERTIFICATE_CODESIGN.equals((Object)settingId)) {
            try {
                String string = FileUtil.read("PublicCert.cer");
                String string5 = Util.getThumbprintFromCert(string);
                boolean bl = "1".equals(settingValue.getValue());
                this.doSetCertificateTrust(string5, string, bl, LeopardTrustSetting.SettingType.X509, Maccmd.KeychainType.SYSTEM);
            }
            catch (Exception exception) {
                log.error((Object)"Error occurred while loading PublicCert.cer.", (Throwable)exception);
            }
        } else if (Settings.SettingId.MAC_FIREWALL.equals((Object)settingId)) {
            long l = settingValue.getValueAsLong();
            if (OsConstants.isMacLeopardOrBefore()) {
                Maccmd.FirewallState firewallState = l == 0L ? Maccmd.FirewallState.OFF : Maccmd.FirewallState.ON_WITH_STEALTH_MODE;
                boolean bl = l == 1L ? this.cls_Maccmd.getFirewallStealthMode() : true;
                this.cls_Maccmd.setFirewallState(firewallState, bl);
            } else {
                Maccmd.FirewallState firewallState = Maccmd.FirewallState.getByOsValue((int)l, Maccmd.FirewallState.ON_WITH_STEALTH_MODE);
                this.cls_Maccmd.setFirewallState(firewallState, true);
            }
        }
        return true;
    }

    public SettingValue getSystemValue(Setting setting, boolean bl) {
        SettingValue settingValue = new SettingValue();
        Settings.SettingId settingId = setting.getSettingId();
        log.info((Object)("Will read value for " + (Object)((Object)settingId) + "."));
        if (Settings.SettingId.ROOT_CA_CERTIFICATE_MACHINE.equals((Object)settingId)) {
            String string = setting.getAdditionalValue();
            boolean bl2 = this.cls_SecurityManager.isCaTrustedForDot1x(string);
            if (bl2 && (bl2 = this.cls_SecurityManager.isCaTrustedForBasic(string))) {
                bl2 = this.cls_SecurityManager.isCaTrustedForSsl(string);
            }
            if (!bl2 && (bl2 = this.cls_SecurityManager.isCertificateTrustedForDot1x(Maccmd.KeychainType.LOGIN, string))) {
                log.warn((Object)("\n\n\n**** CERT '" + string + "' WAS NOT FOUND TRUSTED AS ROOT CA BUT DID FIND IT AS AN INTERMEDIARY CA OR SERVER CERT.  ******\n\n"));
            }
            settingValue.setValue(bl2 ? "1" : "0");
            settingValue.setAdditionalValue(string);
            settingValue.setUnenforcedValue(setting.getUnenforcedValue());
        } else if (Settings.SettingId.CERTIFICATE_EAP_USER.equals((Object)settingId)) {
            String string = setting.getAdditionalValue();
            boolean bl3 = this.cls_SecurityManager.isCertificateTrustedForDot1x(Maccmd.KeychainType.LOGIN, string);
            if (bl3 && (bl3 = this.cls_SecurityManager.isCertificateTrustedForBasic(Maccmd.KeychainType.LOGIN, string))) {
                bl3 = this.cls_SecurityManager.isCertificateTrustedForSsl(Maccmd.KeychainType.LOGIN, string);
            }
            settingValue.setValue(bl3 ? "1" : "0");
            settingValue.setAdditionalValue(string);
            settingValue.setUnenforcedValue(setting.getUnenforcedValue());
        } else if (Settings.SettingId.CERTIFICATE_EAP_SYSTEM.equals((Object)settingId)) {
            String string = setting.getAdditionalValue();
            boolean bl4 = this.cls_SecurityManager.isCertificateTrustedForDot1x(Maccmd.KeychainType.SYSTEM, string);
            if (bl4 && (bl4 = this.cls_SecurityManager.isCertificateTrustedForBasic(Maccmd.KeychainType.SYSTEM, string))) {
                bl4 = this.cls_SecurityManager.isCertificateTrustedForSsl(Maccmd.KeychainType.SYSTEM, string);
            }
            settingValue.setValue(bl4 ? "1" : "0");
            settingValue.setAdditionalValue(string);
            settingValue.setUnenforcedValue(setting.getUnenforcedValue());
        } else if (Settings.SettingId.CERTIFICATE_CODESIGN.equals((Object)settingId)) {
            try {
                String string = FileUtil.read("PublicCert.cer");
                String string2 = Util.getThumbprintFromCert(string);
                boolean bl5 = this.cls_SecurityManager.isCertificateTrustedForX509(Maccmd.KeychainType.SYSTEM, string2);
                settingValue.setValue(bl5 ? "1" : "0");
            }
            catch (Exception exception) {
                log.error((Object)"Error occurred while loading PublicCert.cer.", (Throwable)exception);
            }
        } else if (Settings.SettingId.CERTIFICATE_CLIENT.equals((Object)settingId)) {
            settingValue.setValue("1");
        } else if (Settings.SettingId.MAC_FIREWALL.equals((Object)settingId)) {
            Maccmd.FirewallState firewallState = this.cls_Maccmd.getFirewallState();
            boolean bl6 = this.cls_Maccmd.getFirewallStealthMode();
            if (Maccmd.FirewallState.OFF.equals((Object)firewallState)) {
                settingValue.setValue("0");
            } else {
                settingValue.setValue(bl6 ? "2" : "1");
            }
        }
        log.info((Object)("Read value for " + (Object)((Object)settingId) + " as '" + settingValue.getValue() + "' and '" + settingValue.getAdditionalValue() + "'."));
        return settingValue;
    }

    public void refresh(SelectionHandler selectionHandler, Setting[] settingArray) {
    }

    public void commit(SelectionHandler selectionHandler) throws Exception {
    }

    public String toString() {
        return Util.createToString(this.getClass());
    }

    private void doSetCertificateTrust(String string, String string2, boolean bl, LeopardTrustSetting.SettingType settingType, Maccmd.KeychainType keychainType) {
        File file = null;
        try {
            file = File.createTempFile("XPC_", ".cer");
            this.cls_FileHandler.writeFile(file, string2);
            if (bl) {
                log.info((Object)("Will set CA certificate " + string + " to trusted."));
                this.cls_SecurityManager.setCertificateToTrusted(keychainType, settingType, file);
            } else {
                log.info((Object)("Will set CA certificate " + string + " to untrusted."));
                this.cls_SecurityManager.setCertificateToUntrusted(keychainType, file);
            }
            file.delete();
            file.deleteOnExit();
        }
        catch (IOException iOException) {
            log.error((Object)("Failed to write cert to temp file " + (file != null ? file.getAbsolutePath() : "[NoFile]")));
        }
    }
}

