/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.assess.os.mac.leopard;

import com.cloudpath.assess.buffer.AbstractBuffer;
import com.cloudpath.assess.buffer.Buffer;
import com.cloudpath.assess.pojo.Profile;
import com.cloudpath.assess.pojo.Setting;
import com.cloudpath.assess.pojo.Settings;
import com.cloudpath.assess.pojo.util.SettingValue;
import com.cloudpath.common.cert.CertUtil;
import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.os.mac.common.network.eap.EapProfileManager;
import com.cloudpath.common.os.mac.leopard.cmd.Maccmd;
import com.cloudpath.common.os.mac.leopard.network.airport.LeopardAirportNetwork;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEapProfile;
import com.cloudpath.common.os.mac.snowleopard.network.eap.SnowLeopardEapProfileManager;
import com.cloudpath.common.os.mac.tiger.network.networkconnect.NetworkConnectPlist;
import com.cloudpath.common.pojo.NetworkInterface;
import com.cloudpath.common.util.Credential;
import com.cloudpath.common.util.FileHandler;
import com.cloudpath.common.util.InvalidValueException;
import com.cloudpath.common.util.OsConstants;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.common.util.Util;
import com.cloudpath.common.util.XmlUtil;
import com.cloudpath.workflow.common.WorkflowConstants;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class LeopardSupplicantBuffer
extends AbstractBuffer
implements Buffer {
    private static final Logger log = Logger.getLogger(LeopardSupplicantBuffer.class);
    private static final Settings.SettingId[] INTERESTED_SETTINGS = new Settings.SettingId[]{Settings.SettingId.MAC_DOT1X_PROFILE_NAME, Settings.SettingId.MAC_DOT1X_OUTER_IDENTITY, Settings.SettingId.MAC_DOT1X_EAP_TYPES, Settings.SettingId.MAC_DOT1X_TTLS_INNER_AUTHENTICATION, Settings.SettingId.MAC_DOT1X_EAP_FAST_PAC_FLAG, Settings.SettingId.MAC_LEOPARD_DOT1X_CACHE_CREDENTIALS, Settings.SettingId.MAC_LEOPARD_DOT1X_AUTO_CONNECT, Settings.SettingId.MAC_TRUSTED_SERVER_NAMES, Settings.SettingId.MAC_ONE_TIME_PASSWORD, Settings.SettingId.MAC_TRUSTED_CA_LIST, Settings.SettingId.MAC_DOT1X_BAD_PROFILE};
    private final EapProfileManager cls_EapProfileManager;
    private String cls_ProfileName;
    private Credential cls_Credentials = new Credential();
    private LeopardEapProfile cls_EapProfile = null;
    private boolean cls_ProfileToBeDeleted = false;
    private boolean cls_WriteProfile = true;

    public LeopardSupplicantBuffer(FileHandler fileHandler, CommandHandler commandHandler, EapProfileManager eapProfileManager) {
        super(INTERESTED_SETTINGS);
        this.cls_EapProfileManager = eapProfileManager;
    }

    public boolean setSystemValue(Setting setting, SettingValue settingValue) throws InvalidValueException {
        block11: {
            Settings.SettingId settingId;
            block19: {
                block18: {
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    block13: {
                                        block12: {
                                            block10: {
                                                settingId = setting.getSettingId();
                                                log.info((Object)(this.getClass().getSimpleName() + " will set value for " + (Object)((Object)settingId) + " to " + settingValue.getValue() + "/" + settingValue.getAdditionalValue()));
                                                if (settingId != Settings.SettingId.MAC_DOT1X_PROFILE_NAME) break block10;
                                                if ("1".equals(settingValue.getValue())) {
                                                    this.cls_WriteProfile = true;
                                                } else {
                                                    this.cls_ProfileToBeDeleted = true;
                                                    this.cls_EapProfile = new LeopardEapProfile();
                                                }
                                                this.cls_EapProfile.setUserDefinedName(settingValue.getAdditionalValue());
                                                break block11;
                                            }
                                            if (settingId != Settings.SettingId.MAC_DOT1X_EAP_TYPES) break block12;
                                            this.cls_EapProfile.getEapConfig().setEapTypes(settingValue.getAdditionalValue());
                                            break block11;
                                        }
                                        if (settingId != Settings.SettingId.MAC_LEOPARD_DOT1X_AUTO_CONNECT) break block13;
                                        this.cls_EapProfile.setConnectByDefault("1".equals(settingValue.getValue()));
                                        break block11;
                                    }
                                    if (settingId != Settings.SettingId.MAC_DOT1X_TTLS_INNER_AUTHENTICATION) break block14;
                                    NetworkConnectPlist.TtlsInnerAuthentication ttlsInnerAuthentication = NetworkConnectPlist.TtlsInnerAuthentication.getByDbName(settingValue.getValue());
                                    if (ttlsInnerAuthentication == null) {
                                        log.debug((Object)"TTLS Inner Auth parsed to null.  Will default to NONE.");
                                        ttlsInnerAuthentication = NetworkConnectPlist.TtlsInnerAuthentication.NONE;
                                    }
                                    log.debug((Object)("Will set TTLS inner auth to " + (Object)((Object)ttlsInnerAuthentication)));
                                    this.cls_EapProfile.getEapConfig().setTtlsInnerAuthentication(ttlsInnerAuthentication);
                                    break block11;
                                }
                                if (settingId != Settings.SettingId.MAC_DOT1X_OUTER_IDENTITY) break block15;
                                this.cls_EapProfile.getEapConfig().setOuterIdentity(settingValue.getAdditionalValue());
                                break block11;
                            }
                            if (settingId != Settings.SettingId.MAC_DOT1X_EAP_FAST_PAC_FLAG) break block16;
                            this.cls_EapProfile.getEapConfig().setEapFastPacFlag(NetworkConnectPlist.EapFastPacFlag.getInstance(XmlUtil.getStringAsInt(settingValue.getValue(), -1)));
                            break block11;
                        }
                        if (settingId != Settings.SettingId.MAC_LEOPARD_DOT1X_CACHE_CREDENTIALS) break block17;
                        this.cls_EapProfile.setDesiredPassword(this.cls_Credentials.getPassword());
                        this.cls_EapProfile.getEapConfig().setUserName(this.cls_Credentials.getUserName());
                        break block11;
                    }
                    if (settingId != Settings.SettingId.MAC_TRUSTED_SERVER_NAMES) break block18;
                    if (OsConstants.isMacLeopardOrBefore()) break block11;
                    this.cls_EapProfile.getEapConfig().setTlsTrustedServerNamesList(settingValue.getAdditionalValue());
                    break block11;
                }
                if (settingId != Settings.SettingId.MAC_TRUSTED_CA_LIST) break block19;
                if (OsConstants.isMacLeopardOrBefore()) break block11;
                String string = settingValue.getUnenforcedValue();
                String[] stringArray = string.split(";");
                if (stringArray != null && stringArray.length == 1 && (stringArray[0] == null || stringArray[0].length() == 0)) {
                    log.debug((Object)"Cert data is blank.  Will remove any that exist.");
                    stringArray = new String[]{};
                }
                this.cls_EapProfile.getEapConfig().removeAllTlsTrustedCertificates();
                for (int i = 0; i < stringArray.length; ++i) {
                    this.cls_EapProfile.getEapConfig().addTlsTrustedCertificate(stringArray[i]);
                }
                break block11;
            }
            if (settingId == Settings.SettingId.MAC_ONE_TIME_PASSWORD) {
                this.cls_EapProfile.getEapConfig().setOneTimeUserPassword(XmlUtil.getStringAsBoolean(settingValue.getValue(), false));
            } else if (settingId == Settings.SettingId.MAC_DOT1X_BAD_PROFILE && OsConstants.isMacSnowLeopard() && this.cls_EapProfileManager instanceof SnowLeopardEapProfileManager) {
                int n;
                String string = setting.getAdditionalValue();
                SnowLeopardEapProfileManager snowLeopardEapProfileManager = (SnowLeopardEapProfileManager)this.cls_EapProfileManager;
                ArrayList<String> arrayList = new ArrayList<String>();
                for (n = 0; n < snowLeopardEapProfileManager.getProfileCount(); ++n) {
                    LeopardEapProfile leopardEapProfile = snowLeopardEapProfileManager.getProfile(n);
                    log.debug((Object)("PROFILE " + n + " -> " + leopardEapProfile.getUserDefinedName()));
                    String string2 = leopardEapProfile.getUserDefinedName();
                    if (string2 == null || !string2.equals(string) && !string2.matches(string)) continue;
                    arrayList.add(string2);
                }
                for (n = 0; n < arrayList.size(); ++n) {
                    log.debug((Object)("**** DELETING: " + arrayList.get(n)));
                    snowLeopardEapProfileManager.deleteProfile((String)arrayList.get(n));
                }
            }
        }
        return true;
    }

    public SettingValue getSystemValue(Setting setting, boolean bl) {
        SettingValue settingValue = new SettingValue();
        Settings.SettingId settingId = setting.getSettingId();
        log.info((Object)("Will read value for " + (Object)((Object)settingId) + "."));
        if (settingId == Settings.SettingId.MAC_DOT1X_PROFILE_NAME) {
            String string;
            String string2;
            log.debug((Object)("Will get value for profile name ('" + this.cls_EapProfile.getUserDefinedName() + "')..."));
            if (this.cls_EapProfile.getUserDefinedName().length() == 0) {
                log.debug((Object)" - Profile is unconfigured.");
                string2 = "0";
                string = setting.getAdditionalValue();
            } else if (!this.cls_ProfileToBeDeleted) {
                log.debug((Object)" - Profile is configured.");
                string2 = "1";
                string = this.cls_EapProfile.getUserDefinedName();
            } else {
                log.debug((Object)" - Profile is to be deleted. Will treat as unconfigured.");
                string2 = "0";
                string = setting.getAdditionalValue();
            }
            settingValue.setValue(string2);
            settingValue.setAdditionalValue(string);
        } else if (settingId == Settings.SettingId.MAC_DOT1X_EAP_TYPES) {
            settingValue.setValue("1");
            settingValue.setAdditionalValue(this.cls_EapProfile.getEapConfig().getEapTypesString());
        } else if (settingId == Settings.SettingId.MAC_LEOPARD_DOT1X_AUTO_CONNECT) {
            settingValue.setValue("" + XmlUtil.getBooleanAsInt(this.cls_EapProfile.getConnectByDefault()));
        } else if (settingId == Settings.SettingId.MAC_DOT1X_TTLS_INNER_AUTHENTICATION) {
            settingValue.setValue(this.cls_EapProfile.getEapConfig().getTtlsInnerAuthentication().dbName);
        } else if (settingId == Settings.SettingId.MAC_DOT1X_OUTER_IDENTITY) {
            settingValue.setValue("1");
            settingValue.setAdditionalValue(this.cls_EapProfile.getEapConfig().getOuterIdentity());
        } else if (settingId == Settings.SettingId.MAC_DOT1X_EAP_FAST_PAC_FLAG) {
            settingValue.setValue(this.cls_EapProfile.getEapConfig().getEapFastPacFlag().dbName);
        } else if (settingId == Settings.SettingId.MAC_ONE_TIME_PASSWORD) {
            if (OsConstants.isMacLeopardOrBefore()) {
                settingValue.setValue(setting.getRequiredValue().getValue());
            } else {
                settingValue.setValue("" + XmlUtil.getBooleanAsInt(this.cls_EapProfile.getEapConfig().getOneTimeUserPassword()));
            }
        } else if (settingId == Settings.SettingId.MAC_LEOPARD_DOT1X_CACHE_CREDENTIALS) {
            String string = this.cls_EapProfile.getEapConfig().getUserName();
            if (!this.cls_Credentials.getUserName().equals(string)) {
                log.debug((Object)("User name " + string + " does not match " + this.cls_Credentials.getUserName()));
                settingValue.setValue("0");
            } else {
                String string3 = this.cls_EapProfile.getEapConfig().getUserPasswordKeychainItemId();
                log.debug((Object)("PasswordId is " + string3));
                if (string3 == null || string3.length() == 0 || !this.cls_EapProfileManager.isKeychainPasswordCorrect(this.isSystemProfile() ? Maccmd.Keychain.system : Maccmd.Keychain.login, this.isSystemProfile() ? "" : string, string3, this.cls_Credentials.getPassword())) {
                    log.debug((Object)"Password did not match the keychain.");
                    if (bl) {
                        settingValue.setValue(setting.getRequiredValue().getValue());
                    } else {
                        settingValue.setValue("0");
                    }
                } else {
                    log.debug((Object)"Password matched the keychain.");
                    settingValue.setValue("1");
                }
            }
        } else if (settingId == Settings.SettingId.MAC_TRUSTED_SERVER_NAMES) {
            if (OsConstants.isMacLeopardOrBefore()) {
                settingValue.setValue(setting.getRequiredValue().getValue());
                settingValue.setAdditionalValue(setting.getRequiredValue().getAdditionalValue());
            } else {
                String string = this.cls_EapProfile.getEapConfig().getTlsTrustedServerNamesList();
                settingValue.setValue("1");
                settingValue.setAdditionalValue(string);
            }
        } else if (settingId == Settings.SettingId.MAC_TRUSTED_CA_LIST) {
            if (OsConstants.isMacLeopardOrBefore()) {
                settingValue.setValue(setting.getRequiredValue().getValue());
                settingValue.setAdditionalValue(setting.getRequiredValue().getAdditionalValue());
            } else {
                int n = this.cls_EapProfile.getEapConfig().getTlsTrustedCertificateCount();
                String string = "";
                for (int i = 0; i < n; ++i) {
                    String string4 = this.cls_EapProfile.getEapConfig().getTlsTrustedCertificate(i);
                    try {
                        string4 = "-----BEGIN CERTIFICATE-----\n" + string4 + "\n" + "-----END CERTIFICATE-----";
                        X509Certificate x509Certificate = CertUtil.getCertificateFromString(string4);
                        String string5 = CertUtil.getThumbprint(x509Certificate);
                        string5 = CertUtil.formatThumbprintForDb(string5);
                        if (string.length() > 0) {
                            string = string + ";";
                        }
                        string = string + string5;
                        continue;
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        log.error((Object)("Unable to parse certificate (1): " + string4), (Throwable)noSuchAlgorithmException);
                        continue;
                    }
                    catch (CertificateEncodingException certificateEncodingException) {
                        log.error((Object)("Unable to parse certificate (2): " + string4), (Throwable)certificateEncodingException);
                        continue;
                    }
                    catch (CertificateException certificateException) {
                        log.error((Object)("Unable to parse certificate (3): " + string4), (Throwable)certificateException);
                    }
                }
                settingValue.setValue("1");
                settingValue.setAdditionalValue(string);
            }
        } else if (settingId == Settings.SettingId.MAC_DOT1X_BAD_PROFILE) {
            if (OsConstants.isMacSnowLeopard() && this.cls_EapProfileManager instanceof SnowLeopardEapProfileManager) {
                String string = setting.getAdditionalValue();
                SnowLeopardEapProfileManager snowLeopardEapProfileManager = (SnowLeopardEapProfileManager)this.cls_EapProfileManager;
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < snowLeopardEapProfileManager.getProfileCount(); ++i) {
                    LeopardEapProfile leopardEapProfile = snowLeopardEapProfileManager.getProfile(i);
                    log.debug((Object)("MATCH STRING: '" + string + "'"));
                    log.debug((Object)("PROFILE " + i + " -> '" + leopardEapProfile.getUserDefinedName() + "'"));
                    String string6 = leopardEapProfile.getUserDefinedName();
                    if (string6 != null && (string6.equals(string) || string6.matches(string))) {
                        log.debug((Object)" -> MATCHED...");
                        arrayList.add(string6);
                        continue;
                    }
                    log.debug((Object)" -> NO MATCH");
                }
                settingValue.setValue(arrayList.size() == 0 ? "1" : "0");
                settingValue.setAdditionalValue(setting.getAdditionalValue());
            } else {
                settingValue.setValue("1");
                settingValue.setAdditionalValue(setting.getAdditionalValue());
            }
        }
        log.info((Object)("Read value for " + (Object)((Object)settingId) + " as '" + settingValue.getValue() + "' and '" + settingValue.getAdditionalValue() + "'."));
        return settingValue;
    }

    public void refresh(SelectionHandler selectionHandler, Setting[] settingArray) {
        log.info((Object)"Will refresh eap profiles.");
        String string = null;
        NetworkInterface networkInterface = (NetworkInterface)selectionHandler.getObject(WorkflowConstants.DataType.SELECTED_INTERFACE);
        if (networkInterface != null) {
            for (int i = 0; i < settingArray.length; ++i) {
                if (!Settings.SettingId.MAC_DOT1X_PROFILE_NAME.equals((Object)settingArray[i].getSettingId())) continue;
                string = settingArray[i].getAdditionalValue();
                log.info((Object)("Desired profile name determined to be '" + string + "'."));
            }
            if (string == null) {
                string = "";
            }
            this.cls_ProfileName = string;
            log.info((Object)("Desired profile name is '" + this.cls_ProfileName + "'."));
            log.debug((Object)"Will refresh eap profile information...");
            this.cls_EapProfileManager.refresh(networkInterface.getLogicalGuid());
            log.debug((Object)("Will ask eapProfileManager for profile '" + string + "'."));
            this.cls_EapProfile = this.cls_EapProfileManager.getProfileByName(string);
            if (this.cls_EapProfile != null) {
                log.debug((Object)" - A profile was found by name.");
                if (OsConstants.isMacSnowLeopardOrLater()) {
                    log.debug((Object)" - We are on Snow Leopard or later.");
                    if (!this.isWired(selectionHandler)) {
                        log.debug((Object)" - We are on wireless.");
                        String string2 = (String)selectionHandler.getObject(WorkflowConstants.DataType.DESIRED_SSID_NAME);
                        LeopardAirportNetwork.SecurityType securityType = (LeopardAirportNetwork.SecurityType)((Object)selectionHandler.getObject(WorkflowConstants.DataType.DESIRED_SECURITY_TYPE));
                        log.debug((Object)(" - The desired ssid is '" + string2 + "' and security type is '" + (Object)((Object)securityType) + "'."));
                        log.debug((Object)("  - The profile points to '" + this.cls_EapProfile.getWirelessNetwork() + "' and '" + this.cls_EapProfile.getWirelessSecurity() + "'."));
                        if (string2 != null && !string2.equals(this.cls_EapProfile.getWirelessNetwork())) {
                            log.debug((Object)" - The profile points to a different SSID.  Will not use it.");
                            this.cls_EapProfile = null;
                        } else if (securityType != null && !securityType.equals((Object)LeopardAirportNetwork.SecurityType.getByOsName(this.cls_EapProfile.getWirelessSecurity(), null))) {
                            log.debug((Object)" - The profile points to a different security type.  Will not use it.");
                            this.cls_EapProfile = null;
                        }
                    }
                }
            } else {
                log.debug((Object)" - A profile was not found by name.");
            }
            if (this.cls_EapProfile != null && this.cls_EapProfile.getInactive()) {
                log.info((Object)("An EAP Profile exists as '" + string + "' but it is marked inactive."));
                this.cls_EapProfile = null;
            }
            log.info((Object)"Will cleanup conflicting profiles (during refresh)...");
            this.cls_EapProfileManager.resolveConflicts(this.cls_EapProfile, networkInterface.getMacAddress(), true, networkInterface.getLogicalGuid());
            log.info((Object)"Done cleaning up conflicting profiles (during refresh).");
            log.debug((Object)("After refresh, supplicant is " + this.cls_EapProfile));
            this.cls_ProfileToBeDeleted = false;
            if (this.cls_EapProfile == null) {
                this.cls_WriteProfile = false;
                this.cls_EapProfile = new LeopardEapProfile();
                log.info((Object)"Eap profile is null.  Will create a new one.");
            } else {
                log.info((Object)("Eap profile was found.  Name is '" + this.cls_EapProfile.getUserDefinedName() + "'."));
                this.cls_WriteProfile = true;
            }
            this.cls_Credentials = (Credential)selectionHandler.getObject(WorkflowConstants.DataType.SELECTED_CREDENTIAL);
            if (this.cls_Credentials == null) {
                this.cls_Credentials = new Credential();
            }
        }
    }

    public void commit(SelectionHandler selectionHandler) throws Exception {
        Object object;
        Object object2;
        log.info((Object)(this.getClass().getSimpleName() + " will commit " + this.cls_EapProfile.getUserDefinedName()));
        NetworkInterface networkInterface = (NetworkInterface)selectionHandler.getObject(WorkflowConstants.DataType.SELECTED_INTERFACE);
        if (this.cls_ProfileToBeDeleted) {
            log.debug((Object)("  - Deleting profile " + this.cls_EapProfile.getUserDefinedName()));
            this.cls_EapProfileManager.deleteProfile(this.cls_EapProfile.getUserDefinedName());
        } else if (this.cls_WriteProfile) {
            log.debug((Object)("  - Writing profile '" + this.cls_EapProfile.getUserDefinedName() + "'."));
            if (this.cls_EapProfile.getUserDefinedName().length() == 0) {
                log.debug((Object)("  - Profile name is blank.  Will use '" + this.cls_ProfileName + "'."));
                this.cls_EapProfile.setUserDefinedName(this.cls_ProfileName);
            }
            if (this.cls_EapProfile.getEapConfig().isTls() && (object2 = (String)selectionHandler.getObject(WorkflowConstants.DataType.RUNTIME_IDENTITY_HANDLE)) != null && ((String)object2).length() > 0) {
                log.info((Object)("Will include identity handle '" + (String)object2 + " in TLS eap profile."));
                this.cls_EapProfile.getEapConfig().setIdentityHandleData((String)object2);
                this.cls_EapProfile.getEapConfig().setIdentityHandleType("");
            }
            if ((object2 = (Credential)selectionHandler.getObject(WorkflowConstants.DataType.SELECTED_CREDENTIAL)) != null) {
                if (this.cls_EapProfile.getEapConfig().isTls()) {
                    log.info((Object)"CREDENTIALS:  For TLS, we will use blank credentials in the profile.");
                    this.cls_EapProfile.getEapConfig().setUserName("");
                    this.cls_EapProfile.setDesiredPassword("");
                } else {
                    log.info((Object)("CREDENTIALS:  For non-TLS, we will use the real credentials in the profile (User=" + ((Credential)object2).getUserName() + ")."));
                    this.cls_EapProfile.getEapConfig().setUserName(((Credential)object2).getUserName());
                    this.cls_EapProfile.setDesiredPassword(((Credential)object2).getPassword());
                }
            } else {
                log.warn((Object)"Credentials are null.");
            }
            log.debug((Object)"  - Adding/editing profile.");
            log.debug((Object)this.cls_EapProfile.getSummary());
            String string = (String)selectionHandler.getObject(WorkflowConstants.DataType.DESIRED_SSID_NAME);
            if (string != null) {
                this.cls_EapProfile.setWirelessNetwork(string);
            }
            if ((object = (LeopardAirportNetwork.SecurityType)((Object)selectionHandler.getObject(WorkflowConstants.DataType.DESIRED_SECURITY_TYPE))) != null) {
                this.cls_EapProfile.setWirelessSecurity(((LeopardAirportNetwork.SecurityType)((Object)object)).OsName);
            }
            this.cls_EapProfileManager.addProfile(this.cls_EapProfile, networkInterface.getMacAddress());
        }
        log.debug((Object)"  - Committing changes to network connect.");
        object2 = (Profile)selectionHandler.getObject(WorkflowConstants.DataType.SELECTED_PROFILE);
        boolean bl = true;
        if (object2 != null && (object = ((Profile)object2).getSettingById(Settings.SettingId.MAC_LEOPARD_DOT1X_CACHE_CREDENTIALS)) != null && object.getRuntime().getWasSkipped()) {
            bl = false;
        }
        this.cls_EapProfileManager.commit(networkInterface.getLogicalGuid(), bl);
    }

    public String toString() {
        return Util.createToString(this.getClass());
    }

    private boolean isSystemProfile() {
        return "[SYSTEM]".equals(this.cls_ProfileName);
    }

    private boolean isWired(SelectionHandler selectionHandler) {
        return this.getInterface(selectionHandler).getInterfaceType() != 2;
    }

    private NetworkInterface getInterface(SelectionHandler selectionHandler) {
        return (NetworkInterface)selectionHandler.getObject(WorkflowConstants.DataType.SELECTED_INTERFACE);
    }
}

