/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.assess.os.mac.common;

import com.cloudpath.assess.buffer.AbstractBuffer;
import com.cloudpath.assess.buffer.Buffer;
import com.cloudpath.assess.pojo.Network;
import com.cloudpath.assess.pojo.Setting;
import com.cloudpath.assess.pojo.Settings;
import com.cloudpath.assess.pojo.util.SettingValue;
import com.cloudpath.assess.util.ServerUtil;
import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.command.CommandHandlerImpl;
import com.cloudpath.common.os.mac.common.FireFoxProxy;
import com.cloudpath.common.os.mac.common.MacUtil;
import com.cloudpath.common.os.mac.common.network.networksetup.HttpProxyBehavior;
import com.cloudpath.common.os.mac.common.network.networksetup.Ipv6Behavior;
import com.cloudpath.common.os.mac.common.network.networksetup.NetworkSetupReader;
import com.cloudpath.common.os.mac.common.network.scutil.ScUtilInterface;
import com.cloudpath.common.os.mac.common.provider.MacDefaultsProvider;
import com.cloudpath.common.os.mac.common.provider.MacSoftwareUpdateProvider;
import com.cloudpath.common.os.mac.leopard.cmd.Maccmd;
import com.cloudpath.common.os.mac.snowleopard.network.networksetup.SnowLeopardNetworkSetupReader;
import com.cloudpath.common.pojo.NetworkInterface;
import com.cloudpath.common.util.FileUtil;
import com.cloudpath.common.util.InvalidValueException;
import com.cloudpath.common.util.JnlpUtil;
import com.cloudpath.common.util.OsConstants;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.common.util.XmlUtil;
import com.cloudpath.workflow.common.WorkflowConstants;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;

public class MacSystemBuffer
extends AbstractBuffer
implements Buffer {
    private static final Logger log = Logger.getLogger(MacSystemBuffer.class);
    private static final Settings.SettingId[] INTERESTED_SETTINGS = new Settings.SettingId[]{Settings.SettingId.TIGER_UPDATE, Settings.SettingId.LEOPARD_UPDATE, Settings.SettingId.LION_UPDATE, Settings.SettingId.MOUNTAIN_LION_UPDATE, Settings.SettingId.SNOW_LEOPARD_UPDATE, Settings.SettingId.IPV6_CONFIGURATION, Settings.SettingId.SYSTEM_CLOCK_BY_URL, Settings.SettingId.PHAROS_PACKAGE_INSTALLED, Settings.SettingId.HTTP_PROXY_SETTING, Settings.SettingId.MAC_CHECK_FOR_UPDATES, Settings.SettingId.MAC_LOCATION_NAME};
    private final CommandHandler cls_CommandHandler;
    private final Maccmd cls_Maccmd;
    private final NetworkSetupReader cls_NetworkSetupReader;
    private NetworkInterface cls_SelectedNic = null;
    private Network cls_Network = null;

    public MacSystemBuffer(CommandHandler commandHandler, NetworkSetupReader networkSetupReader, Maccmd maccmd) {
        super(INTERESTED_SETTINGS);
        this.cls_CommandHandler = commandHandler;
        this.cls_NetworkSetupReader = networkSetupReader;
        this.cls_Maccmd = maccmd;
    }

    public boolean setSystemValue(Setting setting, SettingValue settingValue) throws InvalidValueException {
        boolean bl;
        block26: {
            Settings.SettingId settingId = setting.getSettingId();
            log.info((Object)(this.getClass().getSimpleName() + " will set value for " + (Object)((Object)settingId) + " to " + settingValue.getValue() + "/" + settingValue.getAdditionalValue()));
            bl = true;
            if (Settings.SettingId.LEOPARD_UPDATE.equals((Object)settingId)) {
                MacUtil.openSoftwareUpdateGui(this.cls_CommandHandler);
                bl = false;
            } else if (Settings.SettingId.SNOW_LEOPARD_UPDATE.equals((Object)settingId)) {
                MacUtil.openSoftwareUpdateGui(this.cls_CommandHandler);
                bl = false;
            } else if (Settings.SettingId.LION_UPDATE.equals((Object)settingId)) {
                MacUtil.openSoftwareUpdateGui(this.cls_CommandHandler);
                bl = false;
            } else if (Settings.SettingId.MOUNTAIN_LION_UPDATE.equals((Object)settingId)) {
                MacUtil.openSoftwareUpdateGui(this.cls_CommandHandler);
                bl = false;
            } else if (Settings.SettingId.TIGER_UPDATE.equals((Object)settingId)) {
                MacUtil.openSoftwareUpdateGui(this.cls_CommandHandler);
                bl = false;
            } else if (Settings.SettingId.IPV6_CONFIGURATION.equals((Object)settingId)) {
                if (this.cls_SelectedNic != null) {
                    Ipv6Behavior.Ipv6Type ipv6Type = Ipv6Behavior.Ipv6Type.getByDbValue(settingValue.getValue());
                    Ipv6Behavior ipv6Behavior = new Ipv6Behavior(ipv6Type);
                    String[] stringArray = settingValue.getAdditionalValue().split(";");
                    ipv6Behavior.setIpv6Address(stringArray.length > 0 ? stringArray[0] : "");
                    ipv6Behavior.setIpv6Router(stringArray.length > 1 ? stringArray[1] : "");
                    ipv6Behavior.setIpv6PrefixLength(stringArray.length > 2 ? stringArray[2] : "");
                    try {
                        if (OsConstants.isMacLionOrLater()) {
                            this.cls_NetworkSetupReader.setIpv6Behavior(this.cls_SelectedNic.getServiceName(), ipv6Behavior);
                            break block26;
                        }
                        this.cls_NetworkSetupReader.setIpv6Behavior(this.cls_SelectedNic.getName(), ipv6Behavior);
                    }
                    catch (IOException iOException) {
                        log.error((Object)("An error occurred while setting ipv6 behavior to " + ipv6Behavior + "."), (Throwable)iOException);
                    }
                }
            } else if (!Settings.SettingId.SYSTEM_CLOCK_BY_URL.equals((Object)settingId) && !Settings.SettingId.PHAROS_PACKAGE_INSTALLED.equals((Object)settingId)) {
                if (Settings.SettingId.MAC_CHECK_FOR_UPDATES.equals((Object)settingId)) {
                    FileUtil fileUtil = new FileUtil();
                    MacDefaultsProvider macDefaultsProvider = new MacDefaultsProvider(this.cls_CommandHandler);
                    MacSoftwareUpdateProvider macSoftwareUpdateProvider = new MacSoftwareUpdateProvider(this.cls_CommandHandler, fileUtil, macDefaultsProvider);
                    int n = XmlUtil.getStringAsInt(settingValue.getValue(), 7);
                    macSoftwareUpdateProvider.setSoftwareUpdates(true, n * 24 * 60 * 60);
                } else if (Settings.SettingId.HTTP_PROXY_SETTING.equals((Object)settingId)) {
                    this.changeProxyBehavior(settingValue);
                    bl = true;
                } else if (Settings.SettingId.MAC_LOCATION_NAME.equals((Object)settingId) && this.cls_NetworkSetupReader instanceof SnowLeopardNetworkSetupReader) {
                    SnowLeopardNetworkSetupReader snowLeopardNetworkSetupReader = (SnowLeopardNetworkSetupReader)this.cls_NetworkSetupReader;
                    String string = snowLeopardNetworkSetupReader.getCurrentLocation();
                    String string2 = setting.getAdditionalValue();
                    log.info((Object)("Administrator has specified the location name '" + string2 + "'."));
                    if (string2.equals(string)) {
                        log.info((Object)" - Administrator specified location is the current location.");
                    } else if (snowLeopardNetworkSetupReader.hasLocation(string2)) {
                        log.info((Object)" - Administrator specified location already exists.  Will switch to it.");
                        snowLeopardNetworkSetupReader.switchLocation(string2);
                    } else {
                        log.info((Object)" - Administrator specified location does not exist.  Will create and switch to it.");
                        snowLeopardNetworkSetupReader.addLocation(string2);
                        snowLeopardNetworkSetupReader.switchLocation(string2);
                    }
                }
            }
        }
        return bl;
    }

    public SettingValue getSystemValue(Setting setting, boolean bl) {
        SettingValue settingValue = new SettingValue();
        Settings.SettingId settingId = setting.getSettingId();
        log.info((Object)("Will read value for " + (Object)((Object)settingId) + "."));
        if (settingId == Settings.SettingId.LEOPARD_UPDATE) {
            if (OsConstants.isMacLeopard()) {
                settingValue.setValue(MacUtil.getSystemSoftwarePatchLevel() + "");
            } else {
                settingValue.setValue(setting.getRequiredValue().getValue());
            }
        } else if (settingId == Settings.SettingId.SNOW_LEOPARD_UPDATE) {
            if (OsConstants.isMacSnowLeopard()) {
                settingValue.setValue(MacUtil.getSystemSoftwarePatchLevel() + "");
            } else {
                settingValue.setValue(setting.getRequiredValue().getValue());
            }
        } else if (settingId == Settings.SettingId.LION_UPDATE) {
            if (OsConstants.isMacLion()) {
                settingValue.setValue(MacUtil.getSystemSoftwarePatchLevel() + "");
            } else {
                settingValue.setValue(setting.getRequiredValue().getValue());
            }
        } else if (settingId == Settings.SettingId.MOUNTAIN_LION_UPDATE) {
            if (OsConstants.isMacMountainLion()) {
                settingValue.setValue(MacUtil.getSystemSoftwarePatchLevel() + "");
            } else {
                settingValue.setValue(setting.getRequiredValue().getValue());
            }
        } else if (settingId == Settings.SettingId.TIGER_UPDATE) {
            if (OsConstants.isMacTiger()) {
                settingValue.setValue(MacUtil.getSystemSoftwarePatchLevel() + "");
            } else {
                settingValue.setValue(setting.getRequiredValue().getValue());
            }
        } else if (Settings.SettingId.IPV6_CONFIGURATION.equals((Object)settingId)) {
            if (this.cls_SelectedNic != null) {
                Ipv6Behavior ipv6Behavior = null;
                ipv6Behavior = OsConstants.isMacLionOrLater() ? this.cls_NetworkSetupReader.getIpv6Behavior(this.cls_SelectedNic.getServiceName()) : this.cls_NetworkSetupReader.getIpv6Behavior(this.cls_SelectedNic.getName());
                settingValue.setValue(ipv6Behavior.getIpv6Type().DbValue);
                settingValue.setAdditionalValue(ipv6Behavior.getIpv6Address() + ";" + ipv6Behavior.getIpv6Router() + ";" + ipv6Behavior.getIpv6PrefixLength());
            }
        } else if (Settings.SettingId.SYSTEM_CLOCK_BY_URL.equals((Object)settingId)) {
            int n = ServerUtil.isSystemClockAcceptableByUrl(setting.getRequiredValue().getUnenforcedValue(), JnlpUtil.getCodeBase() != null ? JnlpUtil.getCodeBase().toString() : this.cls_Network.getBaseUrl());
            if (!setting.getIsRequired() && n < 0) {
                log.info((Object)"SystemClockByUrl is optional and we were not able to query the URL, so we will skip it.");
                n = 1;
            }
            settingValue.setValue("" + n);
            settingValue.setUnenforcedValue("" + ServerUtil.getLastTimestamp());
        } else if (Settings.SettingId.MAC_CHECK_FOR_UPDATES.equals((Object)settingId)) {
            CommandHandlerImpl commandHandlerImpl = new CommandHandlerImpl();
            FileUtil fileUtil = new FileUtil();
            MacDefaultsProvider macDefaultsProvider = new MacDefaultsProvider(commandHandlerImpl);
            MacSoftwareUpdateProvider macSoftwareUpdateProvider = new MacSoftwareUpdateProvider(commandHandlerImpl, fileUtil, macDefaultsProvider);
            if (OsConstants.isMacMountainLionOrLater()) {
                if (macSoftwareUpdateProvider.isSoftwareUpdatesEnabled()) {
                    if (setting.getRequiredValue().equals("-1")) {
                        settingValue.setValue("1");
                    } else {
                        settingValue.setValue(setting.getRequiredValue().getValue());
                    }
                } else {
                    settingValue.setValue("-1");
                }
            } else {
                settingValue.setValue(macSoftwareUpdateProvider.getSoftwareUpdateInterval() / 60L / 60L / 24L + "");
            }
        } else if (Settings.SettingId.PHAROS_PACKAGE_INSTALLED.equals((Object)settingId)) {
            String string = setting.getRequiredValue().getAdditionalValue();
            boolean bl2 = MacUtil.isPharosPackageInstalled(string);
            settingValue.setValue(bl2 ? "1" : "0");
            settingValue.setAdditionalValue(string);
        } else if (Settings.SettingId.HTTP_PROXY_SETTING.equals((Object)settingId)) {
            if (this.proxyBehaviorCorrect(setting)) {
                settingValue.setValue(setting.getValue());
                settingValue.setAdditionalValue(setting.getAdditionalValue());
            } else {
                settingValue.setValue("1000");
                settingValue.setAdditionalValue("shouldnotmatch");
            }
        } else if (Settings.SettingId.MAC_LOCATION_NAME.equals((Object)settingId)) {
            if (this.cls_NetworkSetupReader instanceof SnowLeopardNetworkSetupReader) {
                settingValue.setValue("1");
                settingValue.setAdditionalValue(((SnowLeopardNetworkSetupReader)this.cls_NetworkSetupReader).getCurrentLocation());
            } else {
                settingValue = setting.getRequiredValue();
            }
        }
        log.info((Object)("Read value for " + (Object)((Object)settingId) + " as '" + settingValue.getValue() + "' and '" + settingValue.getAdditionalValue() + "'."));
        return settingValue;
    }

    public void refresh(SelectionHandler selectionHandler, Setting[] settingArray) {
        log.debug((Object)"Mac System Buffer is refreshing...");
        this.cls_SelectedNic = (NetworkInterface)selectionHandler.getObject(WorkflowConstants.DataType.SELECTED_INTERFACE);
        this.cls_Network = (Network)selectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK);
    }

    public void commit(SelectionHandler selectionHandler) throws Exception {
    }

    private void changeProxyBehavior(SettingValue settingValue) {
        log.info((Object)("Will change proxy to " + settingValue.getValue() + " - '" + settingValue.getAdditionalValue() + "'"));
        ScUtilInterface scUtilInterface = new ScUtilInterface();
        scUtilInterface.enumGuidList();
        HttpProxyBehavior httpProxyBehavior = new HttpProxyBehavior(HttpProxyBehavior.HttpProxyType.getByDbValue(settingValue.getValue()));
        FireFoxProxy fireFoxProxy = new FireFoxProxy();
        if (!fireFoxProxy.areFirefoxProxySettingsSystem()) {
            fireFoxProxy.changeFirefoxProxySettingsToSystem();
        }
        if (httpProxyBehavior.isManual()) {
            log.info((Object)("Setting extra manual config settings using " + settingValue.getAdditionalValue()));
            URL uRL = null;
            try {
                uRL = new URL(settingValue.getAdditionalValue());
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                try {
                    uRL = new URL("http://" + settingValue.getAdditionalValue());
                }
                catch (MalformedURLException malformedURLException2) {
                    malformedURLException2.printStackTrace();
                    log.error((Object)"Unable to convert string to URL.");
                    return;
                }
            }
            if (uRL.getPort() == -1) {
                log.info((Object)"During change, proxy URL port is -1.  Will use 0.");
                httpProxyBehavior.setHttpProxyPort("0");
            } else {
                log.info((Object)("During change, proxy URL port is " + uRL.getPort()));
                httpProxyBehavior.setHttpProxyPort(String.valueOf(uRL.getPort()));
            }
            String string = uRL.getProtocol() + "://" + uRL.getHost() + uRL.getFile();
            log.info((Object)("During change, stripped proxy URL : " + string));
            httpProxyBehavior.setHttpProxyServer(string);
        } else if (httpProxyBehavior.isAutoByUrl()) {
            log.info((Object)"Setting extra auto_by_url settings..");
            httpProxyBehavior.setHttpProxyAutoconfUrl(settingValue.getAdditionalValue());
        } else if (httpProxyBehavior.isAutoOrByUrl()) {
            log.info((Object)"Setting extra auto_or_by_url settings..");
            httpProxyBehavior.setHttpProxyAutoconfUrl(settingValue.getAdditionalValue());
        }
        if (OsConstants.isBeforeMacMountainLionUpdate2()) {
            log.info((Object)"Is pre-10.8.2, will use old method of setting proxy.");
            scUtilInterface.setProxyOnAllGuids(httpProxyBehavior);
        } else {
            log.info((Object)"Is 10.8.2 or greater, will use new method of setting proxy.");
            log.info((Object)("New Behavior Will Be: " + httpProxyBehavior));
            log.info((Object)("On NIC: " + this.cls_SelectedNic));
            this.cls_Maccmd.setProxy(this.cls_SelectedNic, httpProxyBehavior);
        }
    }

    private boolean proxyBehaviorCorrect(Setting setting) {
        Object object;
        log.info((Object)("Will check if proxy is correct based on " + setting.getValue() + " - '" + setting.getAdditionalValue() + "'"));
        ScUtilInterface scUtilInterface = new ScUtilInterface();
        HttpProxyBehavior httpProxyBehavior = new HttpProxyBehavior(HttpProxyBehavior.HttpProxyType.getByDbValue(setting.getValue()));
        boolean bl = false;
        scUtilInterface.enumGuidList();
        FireFoxProxy fireFoxProxy = new FireFoxProxy();
        if (httpProxyBehavior.isAutoByUrl() || httpProxyBehavior.isAutoOrByUrl()) {
            httpProxyBehavior.setHttpProxyAutoconfUrl(setting.getAdditionalValue());
        } else if (httpProxyBehavior.isManual()) {
            object = null;
            log.info((Object)("Proxy URL value is: " + setting.getAdditionalValue()));
            try {
                object = new URL(setting.getAdditionalValue());
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                log.error((Object)"Unable to parse as a normal URL.  Trying alternate parsing.");
                try {
                    object = new URL("http://" + setting.getAdditionalValue());
                }
                catch (MalformedURLException malformedURLException2) {
                    malformedURLException2.printStackTrace();
                    log.error((Object)("The URL was malformed.  URL : " + setting.getAdditionalValue()));
                    return false;
                }
            }
            if (((URL)object).getPort() == -1) {
                log.info((Object)"During get, proxy URL port is -1, will use 0.");
                httpProxyBehavior.setHttpProxyPort("0");
            } else {
                log.info((Object)("During get, proxy URL port is " + ((URL)object).getPort() + "."));
                httpProxyBehavior.setHttpProxyPort(String.valueOf(((URL)object).getPort()));
            }
            String string = ((URL)object).getProtocol() + "://" + ((URL)object).getHost() + ((URL)object).getFile();
            log.info((Object)("Stripped proxy URL : " + string));
            httpProxyBehavior.setHttpProxyServer(string);
        }
        bl = !fireFoxProxy.isFirefoxInstalled() ? true : fireFoxProxy.isFirefoxInstalled() && fireFoxProxy.areFirefoxProxySettingsSystem();
        object = this.cls_SelectedNic;
        if (OsConstants.isBeforeMacMountainLionUpdate2()) {
            object = null;
        }
        return scUtilInterface.allProxySettingsMatch(httpProxyBehavior, (NetworkInterface)object) && bl;
    }
}

