/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.assess.os.common;

import com.cloudpath.assess.buffer.AbstractBuffer;
import com.cloudpath.assess.buffer.Buffer;
import com.cloudpath.assess.pojo.Setting;
import com.cloudpath.assess.pojo.Settings;
import com.cloudpath.assess.pojo.util.SettingValue;
import com.cloudpath.common.os.common.ApplicationProvider;
import com.cloudpath.common.util.InvalidValueException;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.common.util.Util;
import com.cloudpath.common.util.XmlUtil;
import org.apache.log4j.Logger;

public class ApplicationBuffer
extends AbstractBuffer
implements Buffer {
    private static final Logger log = Logger.getLogger(ApplicationBuffer.class);
    private static final Settings.SettingId[] INTERESTED_SETTINGS = new Settings.SettingId[]{Settings.SettingId.PROCESS_STATE, Settings.SettingId.SERVICE_STATE, Settings.SettingId.APPLICATION_INSTALLED};
    private final ApplicationProvider cls_ApplicationProvider;

    public ApplicationBuffer(ApplicationProvider applicationProvider) {
        super(applicationProvider != null ? INTERESTED_SETTINGS : DISABLED);
        this.cls_ApplicationProvider = applicationProvider;
    }

    public boolean setSystemValue(Setting setting, SettingValue settingValue) throws InvalidValueException {
        Settings.SettingId settingId = setting.getSettingId();
        log.info((Object)(this.getClass().getSimpleName() + " will set value for " + (Object)((Object)settingId) + " to " + settingValue.getValue() + "/" + settingValue.getAdditionalValue()));
        if (settingId != Settings.SettingId.APPLICATION_INSTALLED) {
            if (settingId == Settings.SettingId.PROCESS_STATE) {
                int n = XmlUtil.getStringAsInt(settingValue.getValue(), 1);
                String string = settingValue.getAdditionalValue();
                if (n == 1) {
                    this.cls_ApplicationProvider.launchApplication(string);
                } else {
                    this.cls_ApplicationProvider.killApplication(string);
                }
            } else if (settingId == Settings.SettingId.SERVICE_STATE) {
                int n = XmlUtil.getStringAsInt(settingValue.getValue(), 1);
                String string = settingValue.getAdditionalValue();
                this.cls_ApplicationProvider.setServiceState(string, n);
            } else {
                throw new RuntimeException("Unsupported setting " + (Object)((Object)settingId));
            }
        }
        return true;
    }

    public SettingValue getSystemValue(Setting setting, boolean bl) {
        SettingValue settingValue = new SettingValue();
        Settings.SettingId settingId = setting.getSettingId();
        boolean bl2 = false;
        log.debug((Object)("Will read value for " + (Object)((Object)settingId) + "."));
        if (settingId == Settings.SettingId.APPLICATION_INSTALLED) {
            String string = "";
            if (setting.getInstall().getIsInstall()) {
                string = setting.getInstall().getUninstallRegistryTitle();
            }
            if (string == null || string.length() == 0) {
                string = setting.getRequiredValue().getAdditionalValue();
            }
            if (!(bl2 = this.cls_ApplicationProvider.isApplicationInstalled(string))) {
                int n = 0;
                try {
                    n = this.cls_ApplicationProvider.getProcessCount(string);
                }
                catch (Exception exception) {
                    log.error((Object)("Error occurred while determinging process count for '" + string + "'."), (Throwable)exception);
                }
                if (n > 0) {
                    bl2 = true;
                }
            }
            settingValue.setValue(bl2 ? "1" : "0");
            settingValue.setAdditionalValue(setting.getRequiredValue().getAdditionalValue());
        } else if (settingId == Settings.SettingId.PROCESS_STATE) {
            String string = setting.getRequiredValue().getAdditionalValue();
            int n = 0;
            try {
                n = this.cls_ApplicationProvider.getProcessCount(string);
            }
            catch (Exception exception) {
                log.error((Object)("Error occurred while determining process count for '" + string + "'."), (Throwable)exception);
            }
            settingValue.setValue(n > 0 ? "1" : "0");
            settingValue.setAdditionalValue(string);
        } else if (settingId == Settings.SettingId.SERVICE_STATE) {
            String string = setting.getRequiredValue().getAdditionalValue();
            int n = this.cls_ApplicationProvider.getServiceState(string);
            settingValue.setValue(n + "");
            settingValue.setAdditionalValue(string);
        } else {
            throw new RuntimeException("Unsupported setting " + (Object)((Object)settingId));
        }
        log.info((Object)("Read value for " + (Object)((Object)settingId) + " as '" + settingValue.getValue() + "' and '" + settingValue.getAdditionalValue() + "'."));
        return settingValue;
    }

    public void refresh(SelectionHandler selectionHandler, Setting[] settingArray) {
        this.cls_ApplicationProvider.refresh();
    }

    public void commit(SelectionHandler selectionHandler) throws Exception {
    }

    public String toString() {
        return Util.createToString(this.getClass());
    }
}

