/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.workflow.block;

import com.cloudpath.app.xpc.util.PersistenceHelper;
import com.cloudpath.app.xpc.util.XpcConstants;
import com.cloudpath.app.xpc.workflow.SnapshotUtil;
import com.cloudpath.app.xpc.workflow.block.request.AssociateToSsidRequest;
import com.cloudpath.app.xpc.workflow.block.request.EnableAirportRequest;
import com.cloudpath.app.xpc.workflow.block.request.LeopardConnectRequest;
import com.cloudpath.app.xpc.workflow.block.request.LogoutRequest;
import com.cloudpath.assess.pojo.NetworkItem;
import com.cloudpath.assess.pojo.Profile;
import com.cloudpath.common.app.gui.GuiTab;
import com.cloudpath.common.dispatch.AsyncHandler;
import com.cloudpath.common.dispatch.CustomSelection;
import com.cloudpath.common.dispatch.DispatchRequest;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.dispatch.DoneRequest;
import com.cloudpath.common.dispatch.RetrySelection;
import com.cloudpath.common.dispatch.SkipSelection;
import com.cloudpath.common.dispatch.StartOverRequest;
import com.cloudpath.common.dispatch.StartingPoint;
import com.cloudpath.common.dispatch.WaitRequest;
import com.cloudpath.common.os.common.WirelessAssociation;
import com.cloudpath.common.os.mac.common.network.airport.AirportListener;
import com.cloudpath.common.os.mac.common.network.airport.AirportMonitor;
import com.cloudpath.common.os.mac.common.network.airport.AirportReader;
import com.cloudpath.common.os.mac.common.network.airport.AuthenticationListener;
import com.cloudpath.common.os.mac.common.network.airport.SsidListener;
import com.cloudpath.common.os.mac.common.network.eap.EapProfileManager;
import com.cloudpath.common.os.mac.leopard.eapol.MacEapCmd;
import com.cloudpath.common.os.mac.leopard.network.LeopardWirelessDot1xMonitor;
import com.cloudpath.common.os.mac.leopard.network.airport.LeopardAirportNetwork;
import com.cloudpath.common.os.mac.leopard.network.airport.LeopardSsidMonitor;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardAuthenticationMonitor;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEapProfile;
import com.cloudpath.common.pojo.NetworkInterface;
import com.cloudpath.common.util.Credential;
import com.cloudpath.common.util.OsConstants;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.common.util.Util;
import com.cloudpath.workflow.common.WorkflowConstants;
import com.cloudpath.workflow.common.block.BlockUtil;
import com.cloudpath.workflow.common.block.WorkflowBlock;
import org.apache.log4j.Logger;

public class LeopardReconnectBlock
implements WorkflowBlock,
SsidListener,
AirportListener,
AuthenticationListener {
    private static final Logger log = Logger.getLogger(LeopardReconnectBlock.class);
    private static final String STATUS_TITLE = "Connecting to the Secure Network";
    private final EapProfileManager cls_EapManager;
    private final MacEapCmd cls_Eapcmd;
    private final SelectionHandler cls_SelectionHandler;
    private final PersistenceHelper cls_Persistence;
    private final AirportReader cls_WirelessProvider;
    private final AsyncHandler cls_AsyncHandler;
    private LeopardSsidMonitor cls_SsidMonitor;
    private LeopardWirelessDot1xMonitor cls_WirelessDot1xMonitor;
    private LeopardAuthenticationMonitor cls_WiredAuthenticationMonitor;
    private AirportMonitor cls_AirportMonitor;
    private boolean cls_FirstConnect = true;
    private boolean cls_De451WorkAroundApplied = false;
    private boolean cls_DE447WorkAroundApplied = false;
    private int cls_LastAssociationPercent = 0;

    public LeopardReconnectBlock(SelectionHandler selectionHandler, AirportReader airportReader, AsyncHandler asyncHandler, PersistenceHelper persistenceHelper, MacEapCmd macEapCmd, EapProfileManager eapProfileManager) {
        this.cls_SelectionHandler = selectionHandler;
        this.cls_WirelessProvider = airportReader;
        this.cls_AsyncHandler = asyncHandler;
        this.cls_Persistence = persistenceHelper;
        this.cls_Eapcmd = macEapCmd;
        this.cls_EapManager = eapProfileManager;
    }

    public WorkflowConstants.DataType[] getPrerequisites() {
        return new WorkflowConstants.DataType[]{WorkflowConstants.DataType.SELECTED_INTERFACE, WorkflowConstants.DataType.DESIRED_SUPPLICANT_PROFILE_NAME, WorkflowConstants.DataType.DESIRED_SSID_NAME};
    }

    public WorkflowConstants.DataType[] getGuaranteedOutput() {
        return new WorkflowConstants.DataType[0];
    }

    public GuiTab getWorkflowTab() {
        return this.isTabEnabled() ? XpcConstants.AUTHENTICATE : null;
    }

    public boolean reset() {
        if (this.isTabEnabled()) {
            this.cls_FirstConnect = true;
            this.cls_De451WorkAroundApplied = false;
            this.stopMonitors(true);
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.ORIGINAL_SSID, null);
        }
        return true;
    }

    public DispatchRequest doProcess(boolean bl) {
        return this.doProcess(bl, true);
    }

    public synchronized DispatchRequest doProcess(boolean bl, boolean bl2) {
        Object object;
        if (!this.isTabEnabled()) {
            return new DoneRequest("LeopardReconnectBlockA");
        }
        log.debug((Object)(bl2 ? "\nStarting reconnect process...\n" : "Executing doProcess again..."));
        try {
            this.cls_WirelessProvider.closeSystemPreferences();
        }
        catch (Exception exception) {
            // empty catch block
        }
        final NetworkInterface networkInterface = this.getInterface();
        if (networkInterface == null) {
            log.warn((Object)"WARNING:  Received a requst to process but the NIC is null.");
            return new DoneRequest("LeopardReconnectBlockB");
        }
        if (bl) {
            log.debug((Object)"Is revert.");
            BlockUtil.sendAsync(this.cls_AsyncHandler, new LeopardConnectRequest("Revert", "Reverting Modifications", "The previous changes are being removed...", "/loading.gif", 0, !this.isPsk()));
            if (!this.isWired()) {
                WirelessAssociation wirelessAssociation = null;
                try {
                    wirelessAssociation = this.cls_WirelessProvider.getCurrentAssociation(networkInterface.getLogicalGuid());
                    if (wirelessAssociation.isAssociatedTo(this.getSsid())) {
                        log.info((Object)"We are attahed to the desired ssid.  Will disconnect from ssid since we are reverting.");
                        this.cls_WirelessProvider.disconnect(networkInterface.getLogicalGuid());
                    } else {
                        this.cls_WirelessProvider.abandon();
                    }
                }
                catch (Exception exception) {
                    log.error((Object)"An error occurred while disconnecting.", (Throwable)exception);
                }
                final String string = (String)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.ORIGINAL_SSID);
                if (string != null && string.length() > 0) {
                    log.debug((Object)("Original ssid: " + string + " Current Ssid: " + wirelessAssociation.getSsid()));
                    if (wirelessAssociation == null || !wirelessAssociation.isAssociatedTo(string)) {
                        log.info((Object)("Will attempt to associate to the original ssid " + string));
                        Util.runThread("RevertConnect", new Runnable(){

                            public void run() {
                                try {
                                    LeopardReconnectBlock.this.cls_WirelessProvider.disconnect(networkInterface.getLogicalGuid());
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                LeopardReconnectBlock.this.cls_WirelessProvider.connectToOpenSsid(networkInterface.getLogicalGuid(), string);
                            }
                        });
                    }
                }
            }
            log.warn((Object)(this.getClass().getSimpleName() + " is in revert mode, returning done."));
            return new DoneRequest("LeopardReconnectBlockC");
        }
        if (this.isLoginProfile()) {
            return new LogoutRequest("Your Computer Is Now Configured.", "Your computer has been configured to automatically log into the network.  To do so, you must logout and then log back into the computer.<br><br>When prompted by a popup, click <b>Log Out</b> or select <b>Log Out...</b> from the Apple menu.");
        }
        log.debug((Object)"Not a revert.");
        if (bl2) {
            object = this.isWired() ? "Preparing to authenticate to the network..." : "Please wait while we associate to the wireless network '" + this.getSsid() + "'...";
            BlockUtil.sendAsync(this.cls_AsyncHandler, new LeopardConnectRequest("Preparing", STATUS_TITLE, (String)object, "/loading.gif", 0, !this.isPsk()));
        } else {
            log.debug((Object)"Will not update status because we are on a subsequent call.");
        }
        log.debug((Object)"Will stop any monitors that are running.");
        this.stopMonitors(true);
        if (this.isWired()) {
            log.debug((Object)"Starting the wired authentication monitor.");
            object = this.cls_EapManager.getProfileByName(this.getProfileName());
            this.cls_Eapcmd.stop8021x(networkInterface.getLogicalGuid());
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.cls_Eapcmd.start8021x(networkInterface.getLogicalGuid(), this.getUserPassword(), ((LeopardEapProfile)object).getEapConfig());
            this.cls_WiredAuthenticationMonitor = new LeopardAuthenticationMonitor("A", networkInterface.getLogicalGuid(), 1000, 50, 45000L, this, object != null ? ((LeopardEapProfile)object).getEapConfig() : null, this.getUserPassword(), this.cls_Eapcmd, this.getShowPreCredentials(), 0);
        } else {
            block41: {
                try {
                    log.debug((Object)("Loading the current association for '" + networkInterface.getLogicalGuid() + "'."));
                    object = this.cls_WirelessProvider.getCurrentAssociation(networkInterface.getLogicalGuid());
                    if (!object.isEnabled()) {
                        log.debug((Object)"Airport is turned off.  Ask the user to turn it on.  Will also start the monitor.");
                        boolean bl3 = this.cls_WirelessProvider.setPowerState(networkInterface.getLogicalGuid(), true);
                        if (bl3) {
                            for (int i = 0; !object.isEnabled() && i < 5; ++i) {
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                object = this.cls_WirelessProvider.getCurrentAssociation(networkInterface.getLogicalGuid());
                            }
                            Thread.sleep(2000L);
                        }
                        if (bl3 && !object.isEnabled()) {
                            this.cls_AirportMonitor = new AirportMonitor(this.cls_WirelessProvider, networkInterface.getLogicalGuid(), true, this, 200, 10, 600000L);
                            return new EnableAirportRequest();
                        }
                    }
                    log.debug((Object)("Current ssid: " + object.getSsid()));
                    if (object.isAssociatedTo(this.getSsid())) {
                        if (this.cls_FirstConnect) {
                            log.info((Object)"User was already associated to the ssid.  Will force a disconnect.");
                            this.cls_WirelessProvider.disconnect(networkInterface.getLogicalGuid());
                            Thread.sleep(200L);
                            break block41;
                        }
                        log.warn((Object)("Association to " + object.getSsid() + " succeeded."));
                        try {
                            log.debug((Object)"Will check for DE-447 issue.");
                            log.debug((Object)("OS sees WPA2: " + object.isWpa2()));
                            log.debug((Object)("OS is Configured For WPA: " + this.isConfiguredForWpaEnterprise()));
                            if (object.isWpa2() && this.isConfiguredForWpaEnterprise()) {
                                log.info((Object)"DE-447 issue seems to be happening.");
                                if (this.cls_DE447WorkAroundApplied) {
                                    log.error((Object)"There is still a discrepency (DE-447), but we already applied the work around.  Will continue normally.");
                                } else {
                                    log.warn((Object)"There is a discrepency between the SSID's configuration and the security type the OS thinks it is connecting to.  This is a known issue in certian Leopard situations (DE-447).  We will attempt to work arround this issue.");
                                    this.cls_DE447WorkAroundApplied = true;
                                    LeopardEapProfile leopardEapProfile = this.cls_EapManager.getProfileByName(this.getProfileName());
                                    this.cls_WirelessProvider.connectToDot1xSsid(this.getSsid(), leopardEapProfile, networkInterface.getLogicalGuid(), false);
                                    log.warn((Object)"Issued connect command again to work around Mac Leopard issue DE-447");
                                }
                            } else {
                                log.debug((Object)"Mac Leopard DE-447 is not occuring.");
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            log.error((Object)"ERROR OCCURRED while checking for Mac issue related to WPA2 vs WPA.", (Throwable)exception);
                        }
                        this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.VERIFIED_RECONNECT_COMPLETED, Boolean.TRUE);
                        try {
                            log.debug((Object)"Will notify wireless provider that association has completed.");
                            this.cls_WirelessProvider.associationComplete();
                        }
                        catch (Exception exception) {
                            log.error((Object)"Ignorable error occurred while notifying wireless provider that association completed.", (Throwable)exception);
                        }
                        log.debug((Object)"LeopardReconnectBlock will return DoneRequest.");
                        return new DoneRequest("LeopardReconnectBlockD");
                    }
                    if (this.cls_FirstConnect && object.isAssociated()) {
                        log.debug((Object)("Will set original association to '" + object.getSsid() + "' and disconnect."));
                        this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.ORIGINAL_SSID, object.getSsid());
                        SnapshotUtil.captureSnapshot(this.cls_Persistence, this.cls_SelectionHandler, "before migration.");
                    }
                }
                catch (Exception exception) {
                    log.error((Object)"An error occurred while checking current association.");
                }
            }
            this.cls_FirstConnect = false;
            boolean bl4 = this.isPsk();
            String string = (String)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.DESIRED_PSK);
            if (bl4) {
                this.cls_WirelessProvider.connectToPskSsid(networkInterface.getLogicalGuid(), this.getSsid(), string);
                this.cls_SsidMonitor = new LeopardSsidMonitor(this.cls_WirelessProvider, networkInterface.getLogicalGuid(), this.getSsid(), this, 200, 50, 20000L);
            } else {
                LeopardEapProfile leopardEapProfile = this.cls_EapManager.getProfileByName(this.getProfileName());
                this.cls_WirelessProvider.connectToDot1xSsid(this.getSsid(), leopardEapProfile, networkInterface.getLogicalGuid());
                this.cls_Eapcmd.stop8021x(networkInterface.getLogicalGuid());
                this.cls_Eapcmd.start8021x(networkInterface.getLogicalGuid(), this.getUserPassword(), leopardEapProfile.getEapConfig());
                this.cls_WirelessDot1xMonitor = new LeopardWirelessDot1xMonitor(this.cls_WirelessProvider, networkInterface.getLogicalGuid(), this.getSsid(), this, this, leopardEapProfile != null ? leopardEapProfile.getEapConfig() : null, this.getUserPassword(), this.cls_Eapcmd, this.getShowPreCredentials(), 0);
            }
            log.debug((Object)"Informing GUI that we are waiting for association.");
        }
        if (this.isWired()) {
            return new LeopardConnectRequest("WiredWait", STATUS_TITLE, "", "/loading.gif", 1, true);
        }
        return new LeopardConnectRequest("WirelessWait", STATUS_TITLE, "Please wait while we associate to the wireless network '" + this.getSsid() + "'...", "/loading.gif", 1, !this.isPsk());
    }

    public DispatchRequest addSelection(DispatchResponse dispatchResponse, boolean bl) {
        if (bl) {
            return this.doProcess(bl);
        }
        log.info((Object)("Selection is: " + dispatchResponse));
        if (dispatchResponse instanceof SkipSelection) {
            log.info((Object)"User has selected to skip ssid association.");
            this.stopMonitors(true);
            return new DoneRequest("LeopardReconnectBlockE");
        }
        if (dispatchResponse instanceof RetrySelection) {
            log.info((Object)"User has selected to retry association.");
            try {
                NetworkInterface networkInterface = this.getInterface();
                this.cls_WirelessProvider.disconnect(networkInterface != null ? networkInterface.getLogicalGuid() : "");
            }
            catch (Exception exception) {
                log.info((Object)"Error while retrying association.", (Throwable)exception);
            }
            return this.doProcess(bl);
        }
        if (dispatchResponse instanceof CustomSelection) {
            CustomSelection customSelection = (CustomSelection)dispatchResponse;
            if (customSelection.getId() == 1200) {
                return this.doProcess(bl);
            }
            if (customSelection.getId() == 1201) {
                String string;
                log.debug((Object)"User selected to change credentials");
                BlockUtil.sendAsync(this.cls_AsyncHandler, new WaitRequest("Returning to Credentials", "", "/loading.gif"));
                this.stopMonitors(true);
                if (!this.isWired() && (string = (String)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.ORIGINAL_SSID)) != null) {
                    log.debug((Object)("Will thread off the reattachment to the original ssid " + string));
                    Util.runThread("ReattachToOpen", new Runnable(){

                        public void run() {
                            NetworkInterface networkInterface = LeopardReconnectBlock.this.getInterface();
                            LeopardReconnectBlock.this.cls_WirelessProvider.connectToOpenSsid(networkInterface != null ? networkInterface.getLogicalGuid() : "", string);
                        }
                    });
                }
                return new StartOverRequest("LeoaprdReconnectBlock", StartingPoint.CONFIGURE, false);
            }
            log.error((Object)("Unknown selection: " + dispatchResponse + " -> " + customSelection.getId()));
            return this.doProcess(bl);
        }
        log.error((Object)("Unknown selection: " + dispatchResponse));
        return this.doProcess(bl);
    }

    private boolean isLoginProfile() {
        String string = (String)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.DESIRED_SUPPLICANT_PROFILE_NAME);
        log.debug((Object)("Checking if profile name '" + string + "' is a login profile."));
        return LeopardEapProfile.isLoginProfile(string);
    }

    private boolean isWired() {
        return this.getInterface().getInterfaceType() != 2;
    }

    private NetworkInterface getInterface() {
        return (NetworkInterface)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_INTERFACE);
    }

    private NetworkItem getNetworkItem() {
        return (NetworkItem)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK_ITEM);
    }

    private Profile getProfile() {
        return (Profile)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_PROFILE);
    }

    private String getProfileName() {
        return (String)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.DESIRED_SUPPLICANT_PROFILE_NAME);
    }

    private String getSsid() {
        return (String)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.DESIRED_SSID_NAME);
    }

    private String getUserPassword() {
        Credential credential = (Credential)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_CREDENTIAL);
        return credential != null ? credential.getPassword() : "";
    }

    public void associated(String string) {
        boolean bl = this.isPsk();
        String string2 = "Association successful.";
        string2 = string2 + (bl ? "" : " Please wait for authentication to complete.");
        BlockUtil.sendAsync(this.cls_AsyncHandler, new LeopardConnectRequest("Associated", STATUS_TITLE, string2, "/loading.gif", -1, !this.isPsk()));
        if (bl) {
            this.stopMonitors(true);
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.VERIFIED_RECONNECT_COMPLETED, Boolean.TRUE);
            this.cls_AsyncHandler.processAsync(new DoneRequest("LeopardReconnectBlockF"));
        }
    }

    public void associationTimedout() {
        log.info((Object)"Association timed out.");
        BlockUtil.sendAsync(this.cls_AsyncHandler, new LeopardConnectRequest("AssociationTimeout", "Association Timed Out", "We failed to associate to the wireless network '" + this.getSsid() + "' within the allotted time period.  This means the wireless network is not within range.  Please ensure you are physically within range of this wireless network.  <br><br>To try again, click the 'Retry' link below.", "/error.gif", 1, !this.isPsk()));
    }

    public void associationPending(int n) {
        if (this.cls_LastAssociationPercent < 40 && n >= 40) {
            NetworkInterface networkInterface = this.getInterface();
            boolean bl = this.isPsk();
            if (bl) {
                String string = (String)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.DESIRED_PSK);
                this.cls_WirelessProvider.connectToPskSsid(networkInterface != null ? networkInterface.getLogicalGuid() : "", this.getSsid(), string);
            } else {
                log.info((Object)"Will bounce airport power state to try to help the association along.");
                this.cls_WirelessProvider.setPowerState(networkInterface != null ? networkInterface.getLogicalGuid() : "", false);
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.cls_WirelessProvider.setPowerState(networkInterface != null ? networkInterface.getLogicalGuid() : "", true);
            }
        }
        this.cls_LastAssociationPercent = n;
    }

    public void airportStateChanged(boolean bl) {
        log.debug((Object)("Notified that airport state changed to " + bl));
        DispatchRequest dispatchRequest = this.doProcess(false);
        if (!(dispatchRequest instanceof EnableAirportRequest)) {
            log.debug((Object)("Due to airport state change, will send request: " + dispatchRequest));
            this.cls_AsyncHandler.processAsync(dispatchRequest);
        }
    }

    private boolean isPsk() {
        Boolean bl = (Boolean)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.DESIRED_SSID_IS_PSK);
        boolean bl2 = bl != null && Boolean.TRUE.equals(bl);
        return bl2;
    }

    private boolean isConfiguredForWpaEnterprise() {
        LeopardAirportNetwork.SecurityType securityType = (LeopardAirportNetwork.SecurityType)((Object)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.DESIRED_SECURITY_TYPE));
        return LeopardAirportNetwork.SecurityType.WPA_ENTERPRISE.equals((Object)securityType);
    }

    private boolean isConfiguredForNonWep8021X() {
        LeopardAirportNetwork.SecurityType securityType = (LeopardAirportNetwork.SecurityType)((Object)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.DESIRED_SECURITY_TYPE));
        return securityType != null && securityType.Is8021X && !securityType.IsWep;
    }

    private void stopMonitors(boolean bl) {
        log.debug((Object)"Will stop monitors...");
        if (this.cls_SsidMonitor != null) {
            this.cls_SsidMonitor.stop(bl);
        }
        if (this.cls_WirelessDot1xMonitor != null) {
            this.cls_WirelessDot1xMonitor.stop(bl);
        }
        if (this.cls_WiredAuthenticationMonitor != null) {
            this.cls_WiredAuthenticationMonitor.stop(bl);
        }
        if (this.cls_AirportMonitor != null) {
            this.cls_AirportMonitor.stop(bl);
        }
        log.debug((Object)"All monitors stopped.");
    }

    public void authenticationSuccessful() {
        BlockUtil.sendAsync(this.cls_AsyncHandler, new WaitRequest("Authentication Successful", "Your authentication to the network succeeded.", "/loading.gif"));
        this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.VERIFIED_RECONNECT_COMPLETED, Boolean.TRUE);
        if (this.isWired()) {
            this.cls_AsyncHandler.processAsync(new DoneRequest("LeopardReconnectBlockG"));
        } else {
            Object object;
            log.info((Object)"AuthenticationSucceeded: Received notification that we are authenticated to the ssid.");
            if (!this.cls_De451WorkAroundApplied && this.isConfiguredForNonWep8021X() && OsConstants.isMacLeopard()) {
                log.debug((Object)"AuthenticationSucceeded: Since we are on a 802.1X SSID, we will issue a secondary connect request.");
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.cls_De451WorkAroundApplied = true;
                object = this.getInterface();
                LeopardEapProfile leopardEapProfile = this.cls_EapManager.getProfileByName(this.getProfileName());
                this.cls_WirelessProvider.connectToDot1xSsid(this.getSsid(), leopardEapProfile, ((NetworkInterface)object).getLogicalGuid(), false);
                log.debug((Object)"AuthenticationSucceeded: Secondary connect request sent.");
            }
            if (!((object = this.doProcess(false, false)) instanceof AssociateToSsidRequest)) {
                log.debug((Object)("AuthenticationSucceeded: Will request that request '" + object + "' is processed asynchronously."));
                this.cls_AsyncHandler.processAsync((DispatchRequest)object);
            }
        }
    }

    public void authenticationTimedout(int n) {
        LeopardConnectRequest leopardConnectRequest = new LeopardConnectRequest("AuthenticationTimeout", "Authentication Timed Out", "The authentication attempt failed to occur within the allotted time period.  Please verify that your user name '" + ((Credential)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_CREDENTIAL)).getUserName() + "' and your password are correct.<br><br>To try again, click the 'Retry' link below.<br><br>To change your user name or password, click the 'Change Credentials' link below.", "/error.gif", 1, !this.isPsk());
        log.info((Object)("Authentication timed out.  Will originate connect request " + leopardConnectRequest.getInstanceId()));
        BlockUtil.sendAsync(this.cls_AsyncHandler, leopardConnectRequest);
    }

    private boolean getMigrationBehavior() {
        switch (this.getNetworkItem().getMigrationBehavior()) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return this.cls_WirelessProvider.ssidIsInScanList(this.getInterface().getName(), this.getSsid());
            }
        }
        return true;
    }

    public boolean isTabEnabled() {
        if (this.getNetworkItem() != null && this.getProfile() != null) {
            return this.getMigrationBehavior();
        }
        return false;
    }

    private boolean getShowPreCredentials() {
        Profile profile = this.getProfile();
        NetworkItem networkItem = this.getNetworkItem();
        if (profile == null || profile.getShowPreCredentials() == -1) {
            if (networkItem != null) {
                return networkItem.getShowPreCredentials();
            }
            return false;
        }
        return profile.getShowPreCredentials() == 1;
    }
}

