/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.workflow.block;

import com.cloudpath.app.xpc.util.XpcConstants;
import com.cloudpath.app.xpc.workflow.block.error.NoProfileError;
import com.cloudpath.app.xpc.workflow.block.error.NoSupportedInterfaceError;
import com.cloudpath.app.xpc.workflow.block.request.InterfaceRequest;
import com.cloudpath.app.xpc.workflow.block.selection.InterfaceSelection;
import com.cloudpath.assess.pojo.Condition;
import com.cloudpath.assess.pojo.Network;
import com.cloudpath.assess.pojo.NetworkItem;
import com.cloudpath.assess.pojo.Profile;
import com.cloudpath.assess.pojo.Setting;
import com.cloudpath.assess.pojo.Settings;
import com.cloudpath.common.app.gui.GuiTab;
import com.cloudpath.common.dispatch.DispatchRequest;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.dispatch.DoneRequest;
import com.cloudpath.common.dispatch.RetrySelection;
import com.cloudpath.common.dispatch.StartOverRequest;
import com.cloudpath.common.dispatch.StartingPoint;
import com.cloudpath.common.os.common.NicProvider;
import com.cloudpath.common.os.mac.leopard.network.airport.LeopardAirportNetwork;
import com.cloudpath.common.os.mac.lion.MobileConfigProfile;
import com.cloudpath.common.pojo.IpSet;
import com.cloudpath.common.pojo.NetworkInterface;
import com.cloudpath.common.pojo.NetworkInterfaces;
import com.cloudpath.common.util.Arguments;
import com.cloudpath.common.util.BanishedWords;
import com.cloudpath.common.util.OsConstants;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.workflow.common.WorkflowConstants;
import com.cloudpath.workflow.common.block.WorkflowBlock;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class FindProfileBlock
implements WorkflowBlock {
    private static final Logger log = Logger.getLogger(FindProfileBlock.class);
    private final SelectionHandler cls_SelectionHandler;
    private final NicProvider cls_NicProvider;

    public FindProfileBlock(SelectionHandler selectionHandler, NicProvider nicProvider) {
        this.cls_SelectionHandler = selectionHandler;
        this.cls_NicProvider = nicProvider;
    }

    public WorkflowConstants.DataType[] getPrerequisites() {
        return new WorkflowConstants.DataType[]{WorkflowConstants.DataType.CURRENT_OS, WorkflowConstants.DataType.CURRENT_OS_VERSION, WorkflowConstants.DataType.SELECTED_NETWORK_ITEM};
    }

    public WorkflowConstants.DataType[] getGuaranteedOutput() {
        return new WorkflowConstants.DataType[]{WorkflowConstants.DataType.SELECTED_INTERFACE, WorkflowConstants.DataType.SELECTED_PROFILE};
    }

    public GuiTab getWorkflowTab() {
        return XpcConstants.WELCOME;
    }

    public boolean reset() {
        this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_INTERFACE, null);
        this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_PROFILE, null);
        return true;
    }

    public DispatchRequest doProcess(boolean bl) {
        int n;
        NetworkInterface networkInterface;
        int n2;
        Object object;
        Object object2;
        Profile[] profileArray;
        log.debug((Object)"FindProfileBlock do process...");
        if (bl) {
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_PROFILE, null);
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_INTERFACE, null);
            return DoneRequest.INSTANCE;
        }
        if (this.getProfile() == null) {
            log.debug((Object)"Profile is null.  Will find potential profiles.");
            profileArray = this.findPotentialProfiles();
            log.debug((Object)("Potential profile count: " + profileArray.length));
            if (profileArray.length == 1) {
                log.info((Object)"Found profile because only one was potential.");
                object2 = this.setProfile(profileArray[0]);
                if (object2 != null) {
                    return object2;
                }
            } else if (profileArray.length == 0) {
                log.warn((Object)"No profiles found in set of potential profiles.");
                return new NoProfileError();
            }
        } else {
            log.debug((Object)"Profile already set.  Will limit potential to set profile.");
            profileArray = new Profile[]{this.getProfile()};
        }
        if (this.getNetworkInterface() == null) {
            try {
                log.debug((Object)"Will get all interfaces to determine if we need to prompt the user.");
                object2 = this.cls_NicProvider.getAllInterfaces(false);
            }
            catch (Exception exception) {
                log.error((Object)"Error while trying to get information about all interfaces.", (Throwable)exception);
                object2 = new NetworkInterfaces();
            }
        } else {
            log.debug((Object)"The network interface has already been selected.  Will limit possible nics to selection.");
            object2 = new NetworkInterfaces();
            ((NetworkInterfaces)object2).addInterface(this.getNetworkInterface());
        }
        log.debug((Object)(((NetworkInterfaces)object2).getInterfaceCount() + " nics loaded."));
        int[] nArray = FindProfileBlock.getSupportedInterfaceTypes(profileArray);
        NetworkInterfaces networkInterfaces = ((NetworkInterfaces)object2).getQualifyingInterfaces(nArray);
        log.debug((Object)(networkInterfaces.getInterfaceCount() + " nics supported."));
        switch (networkInterfaces.getInterfaceCount()) {
            case 0: {
                log.info((Object)"No interfaces on the system are supported.");
                return new NoSupportedInterfaceError("None of the network interfaces on this system are supported for configuration on this network.");
            }
            case 1: {
                log.info((Object)"Only one interface qualifies.");
                return this.setNetworkInterface(networkInterfaces.getInterface(0));
            }
        }
        String string = this.getArguments().getInterfaceGuid();
        if (string != null && string.length() > 0 && (object = networkInterfaces.getInterfaceByLogicalGuid(string)) != null) {
            log.info((Object)"Nic found by specified guid.");
            return this.setNetworkInterface((NetworkInterface)object);
        }
        object = this.getArguments().getIpAddress();
        if (object != null && ((String)object).length() > 0 && (n2 = networkInterfaces.getIndexByIpAddress((String)object)) >= 0) {
            log.info((Object)"Nic found by specified ip address.");
            return this.setNetworkInterface(networkInterfaces.getInterface(n2));
        }
        IpSet ipSet = this.getNetwork().getSubnets();
        if (ipSet == null) {
            log.debug((Object)"Network does not have a subnet mask defined.");
        } else {
            log.debug((Object)("Will compare NICs to the network's defined subnet mask '" + ipSet.getList() + "'."));
            networkInterface = null;
            for (n = 0; n < networkInterfaces.getInterfaceCount(); ++n) {
                if (!ipSet.includesIpAddress(networkInterfaces.getInterface(n).getIpAddress())) continue;
                if (networkInterface == null) {
                    log.debug((Object)("Interface " + networkInterfaces.getInterface(n) + " matches ip mask."));
                    networkInterface = networkInterfaces.getInterface(n);
                    continue;
                }
                log.debug((Object)("Interface " + networkInterfaces.getInterface(n) + " is the second match for ip mask.  Cannot select nic by ip mask."));
                networkInterface = null;
                n = networkInterfaces.getInterfaceCount();
            }
            if (networkInterface != null) {
                return this.setNetworkInterface(networkInterface);
            }
            log.debug((Object)"Either no match or multiple matches were found for defined subnet mask.");
        }
        log.debug((Object)"Will look for only one support NIC with an IP address.");
        networkInterface = null;
        for (n = 0; n < networkInterfaces.getInterfaceCount(); ++n) {
            if (!IpSet.isValidIpAddress(networkInterfaces.getInterface(n).getIpAddress())) continue;
            if (networkInterface == null) {
                networkInterface = networkInterfaces.getInterface(n);
                log.debug((Object)("- Nic '" + networkInterface + "' has a valid IP address."));
                continue;
            }
            log.debug((Object)("- Nic '" + networkInterfaces.getInterface(n) + "' also has a valid IP address."));
            networkInterface = null;
            n = networkInterfaces.getInterfaceCount();
        }
        if (networkInterface != null) {
            return this.setNetworkInterface(networkInterface);
        }
        log.debug((Object)"Will look for built-in interfaces in the supported group.");
        for (n = 0; n < networkInterfaces.getInterfaceCount(); ++n) {
            if (networkInterfaces.getInterface(n).getInterfaceType() == 1 && "en0".equals(networkInterfaces.getInterface(n).getLogicalGuid())) {
                log.debug((Object)"- en0 found.");
                if (networkInterface == null) {
                    networkInterface = networkInterfaces.getInterface(n);
                    continue;
                }
                networkInterface = null;
                n = networkInterfaces.getInterfaceCount();
                continue;
            }
            if (networkInterfaces.getInterface(n).getInterfaceType() != 2 || !"en1".equals(networkInterfaces.getInterface(n).getLogicalGuid())) continue;
            log.debug((Object)"- en1 found.");
            if (networkInterface == null) {
                networkInterface = networkInterfaces.getInterface(n);
                continue;
            }
            networkInterface = null;
            n = networkInterfaces.getInterfaceCount();
        }
        if (networkInterface != null) {
            return this.setNetworkInterface(networkInterface);
        }
        log.info((Object)"We need to prompt the user to select an interface.");
        NetworkInterface networkInterface2 = this.getPreferredNic(networkInterfaces, 2);
        NetworkInterface networkInterface3 = this.getPreferredNic(networkInterfaces, 1);
        log.debug((Object)("Preferred wireless is " + networkInterface2));
        log.debug((Object)("Preferred wired is " + networkInterface3));
        return new InterfaceRequest(networkInterface2, networkInterface3, networkInterfaces);
    }

    private DispatchRequest setProfile(Profile profile) {
        log.info((Object)("Setting profile to " + profile));
        this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_PROFILE, profile);
        this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.DESIRED_SSID_NAME, FindProfileBlock.findSsidInProfile(profile));
        this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.DESIRED_SUPPLICANT_PROFILE_NAME, FindProfileBlock.findProfileNameInProfile(profile));
        this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.DESIRED_SECURITY_TYPE, (Object)FindProfileBlock.findWlanSecurityTypeInProfile(profile));
        if (OsConstants.isMacLionOrLater()) {
            log.info((Object)"Will find PSK on Lion+...");
            for (int i = 0; i < profile.getSectionCount(); ++i) {
                for (int j = 0; j < profile.getSection(i).getSettingCount(); ++j) {
                    Setting setting = profile.getSection(i).getSetting(j);
                    long l = setting.getSettingId().getId();
                    if (Settings.SettingId.MOBILECONFIG_ID.getId() != l) continue;
                    log.info((Object)" - Found profile setting...");
                    String string = setting.getRequiredValue().getUnenforcedValue();
                    log.info((Object)(" - Profile file name is '" + string + "'."));
                    MobileConfigProfile mobileConfigProfile = MobileConfigProfile.loadMobileConfigProfile(string);
                    if (mobileConfigProfile == null) {
                        log.error((Object)("\n\nUnable to locate profile by file name: " + string));
                        continue;
                    }
                    String string2 = mobileConfigProfile.getEncryptionType();
                    String string3 = mobileConfigProfile.getPsk();
                    if (string3 == null && (string2 == null || !string2.equals("None"))) continue;
                    BanishedWords.add(string3, "[PRE-SHARED KEY]");
                    this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.DESIRED_SSID_IS_PSK, Boolean.TRUE);
                    this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.DESIRED_PSK, string3);
                }
            }
        }
        if (this.getNetworkInterface() != null) {
            log.info((Object)"Interface already set.  Done with block.");
            log.info((Object)("Selections at FindProfile after NIC found: \n" + this.cls_SelectionHandler.print()));
            return DoneRequest.INSTANCE;
        }
        log.debug((Object)"Set Profile is returning null.");
        log.info((Object)("Selections at FindProfile: \n" + this.cls_SelectionHandler.print()));
        return null;
    }

    private DispatchRequest setNetworkInterface(NetworkInterface networkInterface) {
        log.info((Object)("Will set interface: " + networkInterface));
        this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_INTERFACE, networkInterface);
        if (this.getProfile() != null) {
            log.info((Object)"Profile already set.  Done with block.");
            return DoneRequest.INSTANCE;
        }
        Profile[] profileArray = this.findPotentialProfiles();
        log.debug((Object)("Found " + profileArray.length + " potential profiles."));
        switch (profileArray.length) {
            case 0: {
                log.info((Object)"No potential profile exist.");
                return new NoProfileError();
            }
            case 1: {
                log.info((Object)"Only one potential profile now exists.");
                return this.setProfile(profileArray[0]);
            }
        }
        log.warn((Object)"Multiple profiles still qualify.  Will use first.");
        return this.setProfile(profileArray[0]);
    }

    public DispatchRequest addSelection(DispatchResponse dispatchResponse, boolean bl) {
        if (!bl) {
            log.debug((Object)("Received selection '" + dispatchResponse + "'"));
            if (dispatchResponse instanceof InterfaceSelection) {
                NetworkInterface networkInterface = ((InterfaceSelection)dispatchResponse).getNetworkInterface();
                if (networkInterface != null) {
                    this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_INTERFACE, networkInterface);
                }
            } else if (dispatchResponse instanceof RetrySelection) {
                log.debug((Object)"Will send start over request...");
                return new StartOverRequest("FindProfileBlock.Retry", StartingPoint.CONFIGURE, false);
            }
        }
        return this.doProcess(bl);
    }

    private Network getNetwork() {
        return (Network)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK);
    }

    private NetworkItem getNetworkItem() {
        return (NetworkItem)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK_ITEM);
    }

    private NetworkInterface getNetworkInterface() {
        return (NetworkInterface)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_INTERFACE);
    }

    private Profile getProfile() {
        return (Profile)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_PROFILE);
    }

    private Profile[] findPotentialProfiles() {
        Object object;
        Object object2;
        log.debug((Object)"Will find potential profiles...");
        ArrayList<Condition> arrayList = new ArrayList<Condition>();
        Object object3 = this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.CURRENT_OS);
        if (object3 != null) {
            log.debug((Object)(" - Adding condition for os " + object3));
            arrayList.add(new Condition(Condition.ConditionKey.OS, Condition.ConditionOperator.EQ, object3.toString()));
        }
        if ((object2 = this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.CURRENT_OS_VERSION)) != null) {
            log.debug((Object)(" - Adding condition for version " + object2));
            arrayList.add(new Condition(Condition.ConditionKey.VERSION, Condition.ConditionOperator.EQ, object2.toString()));
        }
        if ((object = this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_INTERFACE)) != null) {
            log.debug((Object)" - Adding condition for nic type.");
            arrayList.add(new Condition(Condition.ConditionKey.TYPE, Condition.ConditionOperator.EQ, ((NetworkInterface)object).getInterfaceType() + ""));
        }
        log.debug((Object)("Getting potential profiles for " + arrayList.size() + " conditions."));
        Condition[] conditionArray = new Condition[arrayList.size()];
        arrayList.toArray(conditionArray);
        NetworkItem networkItem = this.getNetworkItem();
        log.debug((Object)("Will find potential profiles from network's " + networkItem.getProfileCount() + " profiles."));
        return networkItem.getPotentialProfiles(conditionArray);
    }

    private NetworkInterface getPreferredNic(NetworkInterfaces networkInterfaces, int n) {
        log.debug((Object)("Will get preferred nic of type " + n));
        NetworkInterfaces networkInterfaces2 = networkInterfaces.getQualifyingInterfaces(new int[]{n});
        log.debug((Object)(" - Nics of specified type: " + networkInterfaces2.getInterfaceCount()));
        switch (networkInterfaces2.getInterfaceCount()) {
            case 0: {
                return null;
            }
            case 1: {
                return networkInterfaces2.getInterface(0);
            }
        }
        log.debug((Object)"Multiple nics exist.  Will look for an ip address.");
        for (int i = 0; i < networkInterfaces2.getInterfaceCount(); ++i) {
            String string = networkInterfaces2.getInterface(i).getIpAddress();
            if (string == null || string.length() <= 0) continue;
            log.debug((Object)"Found nic with ip address.  Will use it as preferred.");
            return networkInterfaces2.getInterface(i);
        }
        NetworkInterface networkInterface = null;
        if (n == 1) {
            networkInterface = networkInterfaces2.getInterfaceByLogicalGuid("en0");
        } else if (n == 2) {
            networkInterface = networkInterfaces2.getInterfaceByLogicalGuid("en1");
        }
        if (networkInterface != null && networkInterface.getInterfaceType() == n) {
            return networkInterface;
        }
        log.debug((Object)"Did not find a preferred nic.");
        return networkInterfaces2.getInterface(0);
    }

    public static int[] getSupportedInterfaceTypes(Profile[] profileArray) {
        int n;
        int[] nArray;
        log.debug((Object)"WIll get supported interface types for profiles...");
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < profileArray.length; ++i) {
            nArray = profileArray[i].calculateSupportedInterfaceTypes();
            for (n = 0; n < nArray.length; ++n) {
                hashSet.add(nArray[n]);
            }
        }
        Object[] objectArray = hashSet.toArray();
        nArray = new int[objectArray.length];
        for (n = 0; n < objectArray.length; ++n) {
            log.debug((Object)(" - Supported type: " + objectArray[n]));
            nArray[n] = (Integer)objectArray[n];
        }
        log.debug((Object)(" - " + nArray.length + " types of interfaces supported."));
        return nArray;
    }

    private static String findSsidInProfile(Profile profile) {
        long l;
        Setting setting;
        int n;
        int n2;
        for (n2 = 0; n2 < profile.getSectionCount(); ++n2) {
            for (n = 0; n < profile.getSection(n2).getSettingCount(); ++n) {
                setting = profile.getSection(n2).getSetting(n);
                l = setting.getSettingId().getId();
                if (Settings.SettingId.MAC_SSID.getId() != l) continue;
                return setting.getRequiredValue().getAdditionalValue();
            }
        }
        if (OsConstants.isMacLionOrLater()) {
            log.info((Object)"Will find SSID on Lion+...");
            for (n2 = 0; n2 < profile.getSectionCount(); ++n2) {
                for (n = 0; n < profile.getSection(n2).getSettingCount(); ++n) {
                    setting = profile.getSection(n2).getSetting(n);
                    l = setting.getSettingId().getId();
                    if (Settings.SettingId.MOBILECONFIG_ID.getId() != l) continue;
                    log.info((Object)" - Found profile setting...");
                    String string = setting.getRequiredValue().getUnenforcedValue();
                    log.info((Object)(" - Profile file name is '" + string + "'."));
                    MobileConfigProfile mobileConfigProfile = MobileConfigProfile.loadMobileConfigProfile(string);
                    if (mobileConfigProfile == null) {
                        log.error((Object)("\n\nUnable to locate profile by file name: " + string));
                        continue;
                    }
                    String string2 = mobileConfigProfile.getFirstSsid();
                    if (string2 == null) continue;
                    log.info((Object)(" - Desired SSID is " + string2));
                    return string2;
                }
            }
        }
        return null;
    }

    private static LeopardAirportNetwork.SecurityType findWlanSecurityTypeInProfile(Profile profile) {
        for (int i = 0; i < profile.getSectionCount(); ++i) {
            for (int j = 0; j < profile.getSection(i).getSettingCount(); ++j) {
                Setting setting = profile.getSection(i).getSetting(j);
                long l = setting.getSettingId().getId();
                if (Settings.SettingId.MAC_LEOPARD_SSID_SECURITY_TYPE.getId() != l) continue;
                return LeopardAirportNetwork.SecurityType.parseSecurityType(setting.getValue());
            }
        }
        return null;
    }

    private static String findProfileNameInProfile(Profile profile) {
        long l;
        Setting setting;
        int n;
        int n2;
        for (n2 = 0; n2 < profile.getSectionCount(); ++n2) {
            for (n = 0; n < profile.getSection(n2).getSettingCount(); ++n) {
                setting = profile.getSection(n2).getSetting(n);
                l = setting.getSettingId().getId();
                if (Settings.SettingId.MAC_DOT1X_PROFILE_NAME.getId() != l) continue;
                return setting.getRequiredValue().getAdditionalValue();
            }
        }
        if (OsConstants.isMacLionOrLater()) {
            log.info((Object)"Will find profile type on Lion+...");
            for (n2 = 0; n2 < profile.getSectionCount(); ++n2) {
                for (n = 0; n < profile.getSection(n2).getSettingCount(); ++n) {
                    setting = profile.getSection(n2).getSetting(n);
                    l = setting.getSettingId().getId();
                    if (Settings.SettingId.MOBILECONFIG_ID.getId() != l || setting.getRequiredValue().getValueAsLong() != 2L) continue;
                    log.info((Object)"Profile is for a system profile.");
                    return "[SYSTEM]";
                }
            }
        }
        return FindProfileBlock.findSsidInProfile(profile);
    }

    private Arguments getArguments() {
        return (Arguments)(this.cls_SelectionHandler != null ? this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.ARGUMENTS) : null);
    }
}

