/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.workflow.block;

import com.cloudpath.app.xpc.util.XpcConstants;
import com.cloudpath.app.xpc.workflow.block.request.NetworkItemRequest;
import com.cloudpath.app.xpc.workflow.block.selection.NetworkItemSelection;
import com.cloudpath.assess.pojo.Network;
import com.cloudpath.assess.pojo.NetworkItem;
import com.cloudpath.common.app.gui.GuiTab;
import com.cloudpath.common.dispatch.DispatchRequest;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.dispatch.DoneRequest;
import com.cloudpath.common.util.Arguments;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.workflow.common.WorkflowConstants;
import com.cloudpath.workflow.common.block.WorkflowBlock;
import org.apache.log4j.Logger;

public class FindNetworkItemBlock
implements WorkflowBlock {
    private static final Logger log = Logger.getLogger(FindNetworkItemBlock.class);
    private final SelectionHandler cls_SelectionHandler;
    private String cls_PreviousSelection;
    private boolean cls_IsInitialized = false;

    public FindNetworkItemBlock(SelectionHandler selectionHandler) {
        this.cls_SelectionHandler = selectionHandler;
    }

    public WorkflowConstants.DataType[] getPrerequisites() {
        return new WorkflowConstants.DataType[]{WorkflowConstants.DataType.SELECTED_NETWORK};
    }

    public WorkflowConstants.DataType[] getGuaranteedOutput() {
        return new WorkflowConstants.DataType[]{WorkflowConstants.DataType.SELECTED_NETWORK_ITEM};
    }

    public GuiTab getWorkflowTab() {
        return XpcConstants.WELCOME;
    }

    public boolean reset() {
        log.info((Object)"Reseting.");
        if (this.getNetworkItem() != null) {
            this.cls_PreviousSelection = this.getNetworkItem().getName();
        }
        this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_NETWORK_ITEM, null);
        this.cls_IsInitialized = false;
        return true;
    }

    public DispatchRequest doProcess(boolean bl) {
        if (bl) {
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_NETWORK_ITEM, null);
            return new DoneRequest("FindNetworkItemBlockRevert");
        }
        if (!this.cls_IsInitialized && !this.isSecondaryPass()) {
            NetworkItem networkItem = this.howManySubnetsExist();
            if (networkItem != null) {
                this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_NETWORK_ITEM, networkItem);
            }
            this.cls_IsInitialized = true;
        }
        if (this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK_ITEM) != null) {
            log.debug((Object)"Done.");
            return DoneRequest.INSTANCE;
        }
        log.debug((Object)"Will request NetworkItemSelection.");
        return new NetworkItemRequest(this.getNetwork(), this.cls_PreviousSelection);
    }

    public DispatchRequest addSelection(DispatchResponse dispatchResponse, boolean bl) {
        if (!bl) {
            log.debug((Object)("Received selection '" + dispatchResponse + "'"));
            if (dispatchResponse instanceof NetworkItemSelection) {
                NetworkItemSelection networkItemSelection = (NetworkItemSelection)dispatchResponse;
                log.debug((Object)("NetworkItem name selected is '" + networkItemSelection.getName() + "'."));
                NetworkItem networkItem = this.getNetwork().getNetworkItemByName(networkItemSelection.getName());
                if (networkItem != null) {
                    this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_NETWORK_ITEM, networkItem);
                }
            }
        }
        return this.doProcess(bl);
    }

    private Network getNetwork() {
        return (Network)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK);
    }

    private NetworkItem getNetworkItem() {
        return (NetworkItem)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK_ITEM);
    }

    private NetworkItem howManySubnetsExist() {
        Network network = this.getNetwork();
        log.debug((Object)("Step howManySubnetsExist - Count: " + network.getNetworkItemCount()));
        switch (network.getNetworkItemCount(true)) {
            case 0: {
                log.debug((Object)"We need to prompt.");
                return null;
            }
            case 1: {
                return network.getNetworkItem(0);
            }
        }
        return this.wasSubnetSpecified();
    }

    private NetworkItem wasSubnetSpecified() {
        log.debug((Object)"Setp wasSubnetSpecified");
        if (this.getArguments().hasNetworkItemName()) {
            log.debug((Object)"Arguments specify a NetworkItem name.");
            return this.doesSubnetNameMatch();
        }
        log.debug((Object)"Arguments do not specify a NetworkItem name.  Will need to prompt.");
        return null;
    }

    private NetworkItem doesSubnetNameMatch() {
        Network network = this.getNetwork();
        NetworkItem networkItem = network.getNetworkItemByName(this.getArguments().getNetworkItemName());
        if (networkItem != null) {
            log.debug((Object)"NetworkItem found by name.");
            return networkItem;
        }
        log.debug((Object)"NetworkItem not found by name.  Will need to prompt.");
        return null;
    }

    private Arguments getArguments() {
        return (Arguments)(this.cls_SelectionHandler != null ? this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.ARGUMENTS) : null);
    }

    private boolean isSecondaryPass() {
        return this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.IS_SECONDARY_PASS) != null && (Boolean)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.IS_SECONDARY_PASS) != false;
    }
}

