/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.workflow.block;

import com.cloudpath.app.xpc.util.XpcConstants;
import com.cloudpath.app.xpc.util.XpcUtil;
import com.cloudpath.app.xpc.workflow.block.request.CredentialRequest;
import com.cloudpath.app.xpc.workflow.block.selection.CredentialSelection;
import com.cloudpath.assess.pojo.Network;
import com.cloudpath.assess.pojo.NetworkItem;
import com.cloudpath.assess.pojo.Profile;
import com.cloudpath.assess.pojo.Setting;
import com.cloudpath.assess.pojo.Settings;
import com.cloudpath.assess.util.PojoUtil;
import com.cloudpath.common.app.gui.GuiTab;
import com.cloudpath.common.cert.IssuedCertificate;
import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.dispatch.DispatchRequest;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.dispatch.DoneRequest;
import com.cloudpath.common.dispatch.ErrorRequest;
import com.cloudpath.common.os.common.OsProvider;
import com.cloudpath.common.os.mac.leopard.cert.CertificateLoader;
import com.cloudpath.common.util.Credential;
import com.cloudpath.common.util.HttpResult;
import com.cloudpath.common.util.Resources;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.common.util.UrlLoader2;
import com.cloudpath.common.util.Util;
import com.cloudpath.report.client.ReportHandler;
import com.cloudpath.workflow.common.WorkflowConstants;
import com.cloudpath.workflow.common.block.WorkflowBlock;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class CredentialBlock
implements WorkflowBlock {
    private static final Logger log = Logger.getLogger(CredentialBlock.class);
    private final SelectionHandler cls_SelectionHandler;
    private final CommandHandler cls_CommandHandler;

    public CredentialBlock(SelectionHandler selectionHandler, OsProvider osProvider) {
        this.cls_SelectionHandler = selectionHandler;
        this.cls_CommandHandler = osProvider.getCommandHandler();
    }

    public WorkflowConstants.DataType[] getPrerequisites() {
        return new WorkflowConstants.DataType[]{WorkflowConstants.DataType.SELECTED_PROFILE};
    }

    public WorkflowConstants.DataType[] getGuaranteedOutput() {
        return new WorkflowConstants.DataType[0];
    }

    public GuiTab getWorkflowTab() {
        return this.getProfile() != null ? XpcConstants.WELCOME : null;
    }

    public boolean reset() {
        return this.getShowPreCredentials();
    }

    public synchronized DispatchRequest doProcess(boolean bl) {
        String string;
        Object object;
        String string2;
        Object object2;
        Object object3;
        if (bl) {
            log.debug((Object)"Done due to revert.");
            return new DoneRequest("CredentialBlockRevert");
        }
        NetworkItem networkItem = this.getNetworkItem();
        if (this.getShowPreCredentials()) {
            if (this.canReusePreviousCredentials()) {
                log.info((Object)"On a secondary pass and the credentials have already been captured.");
                return new DoneRequest("CredentialBlockB");
            }
            log.info((Object)"Will pre-prompt user for credentials.");
            return new CredentialRequest((Credential)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_CREDENTIAL), this.getNetwork(), networkItem, this.getProfile());
        }
        log.info((Object)"Will not pre-prompt user for credentials.");
        if (this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_CREDENTIAL) == null) {
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_CREDENTIAL, new Credential());
        }
        String string3 = this.getNetworkItem().getRegistrationUrl();
        String string4 = this.getNetworkItem().getRegistrationCookie();
        if (string3 != null && string3.length() > 0) {
            log.debug((Object)"Will flush previous http authentication.");
            UrlLoader2.flushWwwCache();
            string3 = XpcUtil.replaceVariables(string3, this.cls_SelectionHandler, true);
            object3 = (Credential)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_CREDENTIAL);
            log.debug((Object)("Will call registration URL: '" + string3 + "'"));
            object2 = UrlLoader2.fetchUrlViaPost(string3, ((Credential)object3).getUserName(), ((Credential)object3).getPassword(), 8000, string4);
            log.debug((Object)"Will kill http authentication.");
            UrlLoader2.flushWwwCache();
            log.debug((Object)"Will check registration results...");
            string2 = ((HttpResult)object2).getContent();
            if (string2 == null) {
                string2 = "";
            }
            object = ((HttpResult)object2).getDerivedStatusText();
            if (((HttpResult)object2).getStatusCode() == 401L && (string = PojoUtil.getResourceString(Resources.ResourceString.ERROR_REGISTRATION_URL_401, this.getNetwork(), this.getNetworkItem(), this.getProfile())) != null && string.length() > 0) {
                object = string;
            }
            if (this.getNetworkItem().getRegistrationBehavior() == 1) {
                if (((HttpResult)object2).getStatusCode() != 200L) {
                    if (((HttpResult)object2).getStatusCode() == -2L) {
                        object = "Unable to register due to lack of network connectivity.";
                    }
                    log.error((Object)("Registration failed.  Will show message: " + (String)object));
                    return new ErrorRequest("Registration Failed", (String)object, false, true);
                }
                log.info((Object)"Registration succeeded.");
            } else {
                if (((HttpResult)object2).getStatusCode() == 401L) {
                    log.error((Object)("Registration failed.  Will show message: " + (String)object));
                    return new ErrorRequest("Registration Failed", (String)object, false, true);
                }
                log.info((Object)("Registration did not fail authentication. (" + ((HttpResult)object2).getStatusCode() + ")"));
            }
        }
        if ((object2 = ((Profile)(object3 = this.getProfile())).getSettingById(Settings.SettingId.CERTIFICATE_CLIENT)) != null) {
            ((Setting)object2).getRuntime().getOriginalValue().setValue("0");
            string2 = ((Setting)object2).getUnenforcedValue();
            log.debug((Object)("TLS Certificate URL (CredentialBlock): " + string2));
            object = (Credential)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_CREDENTIAL);
            string = System.getProperty("user.name");
            String string5 = "";
            if (object != null) {
                string = ((Credential)object).getUserName();
                string5 = ((Credential)object).getPassword();
            }
            HashMap<String, String> hashMap = XpcUtil.createVariableMap(this.cls_SelectionHandler, (Credential)object);
            log.info((Object)"Will load certificate in credential block.");
            try {
                this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.RUNTIME_CERTIFICATE_RESPONSE, null);
                this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.RUNTIME_ISSUED_CERTIFICATE, null);
                IssuedCertificate issuedCertificate = CertificateLoader.generateClientCertificate(this.cls_CommandHandler, string2, string, string5, hashMap);
                if (issuedCertificate != null && issuedCertificate.getCertificateData() != null && issuedCertificate.getCertificateData().contains("ERROR:")) {
                    log.error((Object)("Failed to retrieve certificate.  Error text received: " + issuedCertificate.getCertificateData()));
                    return new ErrorRequest("Error Occurred", issuedCertificate.getCertificateData(), false, false);
                }
                this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.RUNTIME_ISSUED_CERTIFICATE, issuedCertificate);
                this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.RUNTIME_TLS_PASSWORD, string5);
            }
            catch (CertificateLoader.CertificateGenerationException certificateGenerationException) {
                log.error((Object)"Failed to retrieve certificate.", (Throwable)certificateGenerationException);
                String string6 = "<html>" + certificateGenerationException.getBasicMessage() + "</html>";
                return new CredentialRequest((Credential)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_CREDENTIAL), this.getNetwork(), networkItem, this.getProfile(), string6);
            }
        }
        log.debug((Object)(Util.getShortName(this.getClass()) + " is done."));
        return new DoneRequest("CredentialBlockC");
    }

    public DispatchRequest addSelection(DispatchResponse dispatchResponse, boolean bl) {
        if (bl) {
            return this.doProcess(bl);
        }
        log.info((Object)("Selection is: " + dispatchResponse));
        if (dispatchResponse instanceof CredentialSelection) {
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_CREDENTIAL, ((CredentialSelection)dispatchResponse).getCredential());
            try {
                if (this.getNetworkItem().isRemoteUploadEnabledForStateInfo()) {
                    ReportHandler reportHandler = (ReportHandler)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.RUNTIME_REPORT_HANDLER);
                    reportHandler.updateSession_CredsRecieved();
                }
            }
            catch (Exception exception) {
                log.error((Object)"Error occurred while doing reporting.", (Throwable)exception);
            }
            return new DoneRequest("CredentialBlockD");
        }
        log.error((Object)("Unknown selection: " + dispatchResponse));
        return this.doProcess(bl);
    }

    private boolean getShowPreCredentials() {
        Profile profile = this.getProfile();
        NetworkItem networkItem = this.getNetworkItem();
        if (profile == null || profile.getShowPreCredentials() == -1) {
            if (networkItem != null) {
                return networkItem.getShowPreCredentials();
            }
            return false;
        }
        return profile.getShowPreCredentials() == 1;
    }

    private NetworkItem getNetworkItem() {
        return (NetworkItem)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK_ITEM);
    }

    private Network getNetwork() {
        return (Network)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK);
    }

    private Profile getProfile() {
        return (Profile)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_PROFILE);
    }

    private boolean canReusePreviousCredentials() {
        try {
            return this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.IS_SECONDARY_PASS) != null && (Boolean)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.IS_SECONDARY_PASS) != false && this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_CREDENTIAL) != null && !((Credential)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_CREDENTIAL)).getUserName().equals(this.getNetworkItem().getDefaultUserName());
        }
        catch (Exception exception) {
            log.warn((Object)"Unable to determine if we can reuse credentials.", (Throwable)exception);
            return false;
        }
    }
}

