/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.workflow.block;

import com.cloudpath.app.xpc.util.PersistenceHelper;
import com.cloudpath.app.xpc.util.XpcConstants;
import com.cloudpath.app.xpc.util.XpcUtil;
import com.cloudpath.app.xpc.workflow.SnapshotUtil;
import com.cloudpath.app.xpc.workflow.block.request.InstallNoticeRequest;
import com.cloudpath.app.xpc.workflow.block.request.KeychainRequest;
import com.cloudpath.app.xpc.workflow.block.request.NotifyBeforeFixRequest;
import com.cloudpath.app.xpc.workflow.block.request.RepairSectionRequest;
import com.cloudpath.app.xpc.workflow.block.selection.InstallNoticeSelection;
import com.cloudpath.app.xpc.workflow.block.selection.RepairSectionSelection;
import com.cloudpath.assess.SectionController;
import com.cloudpath.assess.buffer.BufferManager;
import com.cloudpath.assess.pojo.Network;
import com.cloudpath.assess.pojo.NetworkItem;
import com.cloudpath.assess.pojo.Profile;
import com.cloudpath.assess.pojo.Setting;
import com.cloudpath.assess.pojo.Settings;
import com.cloudpath.assess.util.Modifications;
import com.cloudpath.common.app.gui.GuiTab;
import com.cloudpath.common.dispatch.AsyncHandler;
import com.cloudpath.common.dispatch.DispatchRequest;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.dispatch.DoneRequest;
import com.cloudpath.common.dispatch.WaitRequest;
import com.cloudpath.common.os.common.OsProvider;
import com.cloudpath.common.os.mac.common.util.KeychainException;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.common.util.SpecializedException;
import com.cloudpath.report.client.ReportHandler;
import com.cloudpath.workflow.common.WorkflowConstants;
import com.cloudpath.workflow.common.block.BlockUtil;
import com.cloudpath.workflow.common.block.WorkflowBlock;
import org.apache.log4j.Logger;

public class ConfigureBlock
implements WorkflowBlock {
    private static final Logger log = Logger.getLogger((String)ConfigureBlock.class.getName());
    private final SelectionHandler cls_SelectionHandler;
    private final PersistenceHelper cls_Persistence;
    private SectionController cls_SectionController;
    private final BufferManager cls_BufferManager;
    private final AsyncHandler cls_AsyncHandler;
    private final OsProvider cls_OsProvider;

    public ConfigureBlock(SelectionHandler selectionHandler, BufferManager bufferManager, AsyncHandler asyncHandler, OsProvider osProvider, PersistenceHelper persistenceHelper) {
        this.cls_SelectionHandler = selectionHandler;
        this.cls_BufferManager = bufferManager;
        this.cls_AsyncHandler = asyncHandler;
        this.cls_OsProvider = osProvider;
        this.cls_Persistence = persistenceHelper;
    }

    public WorkflowConstants.DataType[] getPrerequisites() {
        return new WorkflowConstants.DataType[]{WorkflowConstants.DataType.SELECTED_CONTENT, WorkflowConstants.DataType.SELECTED_NETWORK, WorkflowConstants.DataType.SELECTED_NETWORK_ITEM, WorkflowConstants.DataType.SELECTED_PROFILE, WorkflowConstants.DataType.SELECTED_INTERFACE};
    }

    public WorkflowConstants.DataType[] getGuaranteedOutput() {
        return new WorkflowConstants.DataType[]{WorkflowConstants.DataType.MODIFICATIONS};
    }

    public GuiTab getWorkflowTab() {
        return this.getProfile() != null ? XpcConstants.CONFIGURE : null;
    }

    public boolean reset() {
        log.info((Object)(this.getClass().getSimpleName() + " reset."));
        this.cls_SectionController = null;
        return true;
    }

    public DispatchRequest doProcess(boolean bl) {
        log.info((Object)"Starting ConfigureBLock.doProcess...");
        log.info((Object)("Selections at configuration: " + this.cls_SelectionHandler.print()));
        BlockUtil.sendAsync(this.cls_AsyncHandler, new WaitRequest("Inspecting configuration...", "", "/loading.gif"));
        if (bl) {
            log.debug((Object)("\n\n\nAt " + this.getClass().getSimpleName() + ": " + '\n' + this.cls_SelectionHandler.print() + "\n\n"));
        }
        log.info((Object)(this.getClass().getSimpleName() + " do process - " + bl));
        if (this.getProfile() != null) {
            log.debug((Object)"Will check for pre-transition script...");
            String string = this.getProfile().getPreTransitionScript();
            if (string != null && string.length() > 0) {
                log.debug((Object)"Will execute pre-transition script.");
                try {
                    string = XpcUtil.replaceVariables(string, this.cls_SelectionHandler);
                    this.cls_OsProvider.runScript(string, this.getProfile().getPreRunas() == 1);
                    log.debug((Object)"Pre-transition script executed.");
                }
                catch (Exception exception) {
                    log.warn((Object)"Unable to execute pre-transition script.", (Throwable)exception);
                }
            }
        }
        return this.doProcess(false, null, bl);
    }

    public DispatchRequest addSelection(DispatchResponse dispatchResponse, boolean bl) {
        BlockUtil.sendAsync(this.cls_AsyncHandler, new WaitRequest("Inspecting configuration...", "", "/loading.gif"));
        log.info((Object)(this.getClass().getSimpleName() + " add selection: " + dispatchResponse));
        if (dispatchResponse instanceof RepairSectionSelection) {
            RepairSectionSelection.Action action = ((RepairSectionSelection)dispatchResponse).getAction();
            if (RepairSectionSelection.Action.REPAIR == action) {
                log.debug((Object)"Action is repair...");
                return this.doProcess(true, ((RepairSectionSelection)dispatchResponse).getSettings(), bl);
            }
            if (RepairSectionSelection.Action.REVERT != action && RepairSectionSelection.Action.EXIT != action) {
                return this.doProcess(false, null, bl);
            }
        } else if (dispatchResponse instanceof InstallNoticeSelection) {
            log.info((Object)"Install notice complete.");
        }
        return this.doProcess(false, null, bl);
    }

    private DispatchRequest doProcess(boolean bl, Setting[] settingArray, boolean bl2) {
        if (this.cls_SectionController == null || this.cls_SectionController.isForRevert() != bl2) {
            log.debug((Object)"Will initialize section controller.");
            this.cls_SectionController = new SectionController(this.cls_SelectionHandler, this.cls_BufferManager, this.getProfile(), bl2);
            this.cls_SectionController.init();
        } else {
            log.debug((Object)"Will not initialize section controller.");
        }
        if (!bl2) {
            SnapshotUtil.captureSnapshot(this.cls_Persistence, this.cls_SelectionHandler, "before configuration.");
        }
        Setting[] settingArray2 = null;
        try {
            log.debug((Object)("Will process settings within SectionController.  AutoFix = " + bl));
            settingArray2 = this.cls_SectionController.process(bl, settingArray);
        }
        catch (KeychainException keychainException) {
            log.info((Object)"A keychain exception was raised.");
            Setting setting = this.getProfile().getSettingById(Settings.SettingId.MAC_LEOPARD_DOT1X_CACHE_CREDENTIALS);
            return new KeychainRequest(keychainException, setting);
        }
        catch (SpecializedException specializedException) {
            log.error((Object)"An untrapped specializedException was raised.", (Throwable)specializedException);
        }
        if (settingArray2 == null) {
            Modifications modifications = this.cls_SectionController.getModifications();
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.MODIFICATIONS, modifications);
            try {
                if (this.getNetworkItem().isRemoteUploadEnabledForStateInfo()) {
                    ReportHandler reportHandler = (ReportHandler)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.RUNTIME_REPORT_HANDLER);
                    reportHandler.updateSession_ConfigComplete();
                }
            }
            catch (Exception exception) {
                log.error((Object)"Error occurred while doing reporting.", (Throwable)exception);
            }
            return new DoneRequest("ConfigureBlockA");
        }
        for (int i = 0; i < settingArray2.length; ++i) {
            if (!settingArray2[i].getInstall().getIsInstall() || settingArray2[i].getRuntime().getWasSkipped()) continue;
            log.debug((Object)"Found install-based setting.  Will display install notice...");
            long l = settingArray2[i].getRequiredValue().getValueAsLong();
            for (int j = 0; j < settingArray2.length; ++j) {
                settingArray2[j].getRuntime().resetNotificationCount();
            }
            return new InstallNoticeRequest(settingArray2[i], this.getNetwork(), this.getNetworkItem(), l == 0L);
        }
        RepairSectionRequest repairSectionRequest = new RepairSectionRequest(settingArray2);
        if (repairSectionRequest.isFirstNotification()) {
            log.info((Object)"Item needs repaired and this is the first notification.");
            if (this.getNetworkItem().getFixAutomatically()) {
                if (settingArray2 != null) {
                    for (int i = 0; i < settingArray2.length; ++i) {
                        if (!settingArray2[i].getCanAutoFix() || settingArray2[i].getRuntime().getWasNotified() || settingArray2[i].getHelpLink() == null || !settingArray2[i].getHelpLink().startsWith("NOTIFY:")) continue;
                        return new NotifyBeforeFixRequest(settingArray2[i]);
                    }
                }
                log.info((Object)"Network item is set to fix automatically.  Will request settings to be fixed.");
                RepairSectionSelection repairSectionSelection = new RepairSectionSelection(RepairSectionSelection.Action.REPAIR);
                return this.addSelection(repairSectionSelection, bl2);
            }
            log.info((Object)"Item needs repaired but it is not fix-automatically.");
        } else {
            log.info((Object)"Item needs repaired but is not first notification.");
        }
        log.debug((Object)("Will return " + repairSectionRequest));
        return repairSectionRequest;
    }

    private Network getNetwork() {
        return (Network)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK);
    }

    private NetworkItem getNetworkItem() {
        return (NetworkItem)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK_ITEM);
    }

    private Profile getProfile() {
        return (Profile)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_PROFILE);
    }
}

