/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.workflow.block;

import com.cloudpath.app.xpc.util.PersistenceHelper;
import com.cloudpath.app.xpc.util.XpcConstants;
import com.cloudpath.app.xpc.workflow.block.request.RevertCompleteRequest;
import com.cloudpath.assess.pojo.Snapshot;
import com.cloudpath.common.app.gui.GuiTab;
import com.cloudpath.common.dispatch.DispatchRequest;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.dispatch.DoneRequest;
import com.cloudpath.common.dispatch.StartingPoint;
import com.cloudpath.common.dispatch.TerminateRequest;
import com.cloudpath.common.os.common.OsProvider;
import com.cloudpath.common.pojo.Content;
import com.cloudpath.common.pojo.NetworkInterface;
import com.cloudpath.common.util.Arguments;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.workflow.common.WorkflowConstants;
import com.cloudpath.workflow.common.block.WorkflowBlock;
import com.cloudpath.workflow.common.block.request.ContinueConfigurationConfirmationRequest;
import com.cloudpath.workflow.common.block.request.ContinueRevertConfirmationRequest;
import com.cloudpath.workflow.common.block.request.RevertConfirmationRequest;
import com.cloudpath.workflow.common.block.request.StartRevertRequest;
import com.cloudpath.workflow.common.block.selection.ContinueConfigurationConfirmationSelection;
import com.cloudpath.workflow.common.block.selection.ContinueRevertConfirmationSelection;
import com.cloudpath.workflow.common.block.selection.RevertConfirmationSelection;
import org.apache.log4j.Logger;

public class BootstrapBlock
implements WorkflowBlock {
    private static final Logger log = Logger.getLogger(BootstrapBlock.class);
    private final SelectionHandler cls_SelectionHandler;
    private final PersistenceHelper cls_Persistence;
    private final OsProvider cls_OsProvider;
    private WorkflowConstants.Confirmation cls_RevertConfirmation = WorkflowConstants.Confirmation.NONE;
    private WorkflowConstants.Confirmation cls_ContinueConfirmation = WorkflowConstants.Confirmation.NONE;

    public BootstrapBlock(SelectionHandler selectionHandler, OsProvider osProvider, PersistenceHelper persistenceHelper) {
        this.cls_SelectionHandler = selectionHandler;
        this.cls_OsProvider = osProvider;
        this.cls_Persistence = persistenceHelper;
    }

    public WorkflowConstants.DataType[] getPrerequisites() {
        return new WorkflowConstants.DataType[0];
    }

    public WorkflowConstants.DataType[] getGuaranteedOutput() {
        return new WorkflowConstants.DataType[]{WorkflowConstants.DataType.CURRENT_OS, WorkflowConstants.DataType.CURRENT_OS_VERSION};
    }

    public GuiTab getWorkflowTab() {
        return XpcConstants.WELCOME;
    }

    public boolean reset() {
        this.cls_RevertConfirmation = WorkflowConstants.Confirmation.NONE;
        this.cls_ContinueConfirmation = WorkflowConstants.Confirmation.NONE;
        return true;
    }

    public DispatchRequest doProcess(boolean bl) {
        if (bl) {
            Snapshot snapshot = (Snapshot)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_SNAPSHOT);
            return new RevertCompleteRequest(snapshot);
        }
        if (this.cls_OsProvider != null && this.cls_OsProvider.getOsInfo() != null) {
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.CURRENT_OS, this.cls_OsProvider.getOsInfo().getOsName());
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.CURRENT_OS_VERSION, this.cls_OsProvider.getOsInfo().getOsVersion());
        } else {
            log.warn((Object)"Either the osProvider or the osInfo is null.");
        }
        StartingPoint startingPoint = this.getStartingPoint();
        if (startingPoint == StartingPoint.REVERT_PROMPT) {
            Content content = this.cls_Persistence.getLastSnapshot();
            return new RevertConfirmationRequest(((Snapshot)content.getContent()).getNetwork().getName());
        }
        if (startingPoint == StartingPoint.CONTINUE_CONFIGURE_PROMPT) {
            return new ContinueConfigurationConfirmationRequest(this.getArguments().getNetworkName());
        }
        if (startingPoint == StartingPoint.CONTINUE_REVERT_PROMPT) {
            Content content = this.cls_Persistence.getLastSnapshot();
            return new ContinueRevertConfirmationRequest(((Snapshot)content.getContent()).getNetwork().getName());
        }
        if (StartingPoint.CANCEL.equals((Object)startingPoint)) {
            log.warn((Object)"User selected to cancel.  Will request application to close.");
            return new TerminateRequest();
        }
        if (StartingPoint.CONFIGURE.equals((Object)startingPoint)) {
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_BEHAVIOR, (Object)WorkflowConstants.WorkflowBehavior.CONFIGURE);
            return new DoneRequest("BootstrapBlockA");
        }
        if (StartingPoint.REVERT.equals((Object)startingPoint)) {
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_BEHAVIOR, (Object)WorkflowConstants.WorkflowBehavior.REVERT);
            return new StartRevertRequest();
        }
        throw new RuntimeException("Unknown starting point " + (Object)((Object)startingPoint));
    }

    public DispatchRequest addSelection(DispatchResponse dispatchResponse, boolean bl) {
        if (bl) {
            return new DoneRequest("BootstrapBlockRevert");
        }
        if (dispatchResponse instanceof ContinueConfigurationConfirmationSelection) {
            this.cls_ContinueConfirmation = ((ContinueConfigurationConfirmationSelection)dispatchResponse).getConfirmation();
        } else if (dispatchResponse instanceof ContinueRevertConfirmationSelection) {
            this.cls_ContinueConfirmation = ((ContinueRevertConfirmationSelection)dispatchResponse).getConfirmation();
        } else if (dispatchResponse instanceof RevertConfirmationSelection) {
            this.cls_RevertConfirmation = ((RevertConfirmationSelection)dispatchResponse).getConfirmation();
        }
        return this.doProcess(bl);
    }

    private StartingPoint getStartingPoint() {
        StartingPoint startingPoint = (StartingPoint)((Object)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.STARTING_POINT));
        log.warn((Object)("Starting point from cache is " + (Object)((Object)startingPoint)));
        if (startingPoint != null) {
            if (StartingPoint.REVERT.equals((Object)startingPoint)) {
                Content content = this.cls_Persistence.getLastSnapshot();
                Snapshot snapshot = (Snapshot)content.getContent();
                NetworkInterface networkInterface = null;
                try {
                    networkInterface = this.cls_OsProvider.getNicProvider().getInterface(snapshot.getInterfaceGuid());
                    this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_CONTENT, content);
                    this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_NETWORK, snapshot.getNetwork());
                    this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_NETWORK_ITEM, snapshot.getNetwork().getNetworkItem(0));
                    this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_PROFILE, snapshot.getProfile());
                    this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_INTERFACE, networkInterface);
                    this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_BEHAVIOR, (Object)WorkflowConstants.WorkflowBehavior.REVERT);
                    this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_SNAPSHOT, snapshot);
                    this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.ORIGINAL_SSID, snapshot.getOriginalSsid());
                }
                catch (Exception exception) {
                    log.error((Object)("Unable to load interface '" + snapshot.getInterfaceGuid() + "' for snapshot."), (Throwable)exception);
                    startingPoint = null;
                }
            } else if (!StartingPoint.CONFIGURE.equals((Object)startingPoint)) {
                startingPoint = null;
            }
        }
        if (startingPoint == null) {
            startingPoint = this.wasUninstallSpecified();
        }
        return startingPoint;
    }

    private StartingPoint wasUninstallSpecified() {
        log.debug((Object)" - Was Uninstall Specified?");
        return this.wasContinueSpecified();
    }

    private StartingPoint wasContinueSpecified() {
        log.debug((Object)(" - Was Continue Specified? " + this.getArguments().isContinue()));
        if (this.getArguments().isContinue()) {
            return this.wasContinueConfirmed();
        }
        return this.wasRevertSpecified();
    }

    private StartingPoint wasRevertSpecified() {
        log.debug((Object)(" - Was Revert Specified: " + this.getArguments().isRevert()));
        if (this.getArguments().isRevert() && this.cls_Persistence.getLastSnapshot() != null) {
            return this.wasRevertConfirmed();
        }
        return StartingPoint.CONFIGURE;
    }

    private StartingPoint wasContinueConfirmed() {
        log.debug((Object)(" - Was Continue Confirmed? " + (Object)((Object)this.cls_ContinueConfirmation)));
        if (this.cls_ContinueConfirmation == WorkflowConstants.Confirmation.NONE) {
            if (this.getArguments().isContinueInstall()) {
                return StartingPoint.CONTINUE_CONFIGURE_PROMPT;
            }
            return StartingPoint.CONTINUE_REVERT_PROMPT;
        }
        if (this.cls_ContinueConfirmation == WorkflowConstants.Confirmation.CANCEL) {
            return StartingPoint.CANCEL;
        }
        if (this.getArguments().isContinueInstall()) {
            return StartingPoint.CONFIGURE;
        }
        return StartingPoint.REVERT;
    }

    private StartingPoint wasRevertConfirmed() {
        log.debug((Object)(" - Was Revert Confirmed? " + (Object)((Object)this.cls_RevertConfirmation)));
        if (this.cls_RevertConfirmation == WorkflowConstants.Confirmation.NONE) {
            return StartingPoint.REVERT_PROMPT;
        }
        if (this.cls_RevertConfirmation == WorkflowConstants.Confirmation.CANCEL) {
            return StartingPoint.CANCEL;
        }
        return StartingPoint.REVERT;
    }

    private Arguments getArguments() {
        return (Arguments)(this.cls_SelectionHandler != null ? this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.ARGUMENTS) : null);
    }
}

