/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.workflow;

import com.cloudpath.assess.pojo.Network;
import com.cloudpath.assess.pojo.NetworkItem;
import com.cloudpath.assess.pojo.Profile;
import com.cloudpath.assess.pojo.Snapshot;
import com.cloudpath.common.pojo.NetworkInterface;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.workflow.common.WorkflowConstants;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class SnapshotHandler {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy h:mm:ss a", Locale.US);
    private final SelectionHandler cls_SelectionHandler;

    public SnapshotHandler(SelectionHandler selectionHandler) {
        this.cls_SelectionHandler = selectionHandler;
    }

    public Snapshot getSnapshot() {
        Network network = (Network)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK);
        NetworkItem networkItem = (NetworkItem)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK_ITEM);
        Profile profile = (Profile)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_PROFILE);
        String string = (String)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.CURRENT_OS_VERSION);
        NetworkInterface networkInterface = (NetworkInterface)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_INTERFACE);
        Snapshot snapshot = new Snapshot();
        snapshot.setTimestamp(DATE_FORMAT.format(new Date()));
        snapshot.setName(network != null ? "Prior to " + network.getName() : "Snapshot");
        String string2 = (String)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.CURRENT_OS);
        if (string2 != null) {
            snapshot.setOs(string2);
        }
        if (string != null) {
            snapshot.setOsVersion(string);
        }
        if (networkInterface != null) {
            snapshot.setInterfaceName(networkInterface.getName());
            snapshot.setInterfaceGuid(networkInterface.getLogicalGuid());
        }
        snapshot.setOriginalSsid((String)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.ORIGINAL_SSID));
        snapshot.setNetwork(network, networkItem, profile);
        return snapshot;
    }
}

