/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.util;

import com.cloudpath.app.xpc.util.PersistenceHelper;
import com.cloudpath.assess.pojo.Network;
import com.cloudpath.assess.pojo.Snapshot;
import com.cloudpath.common.parse.InvalidXmlException;
import com.cloudpath.common.parse.ParseManager;
import com.cloudpath.common.persistence.InvalidPersistenceException;
import com.cloudpath.common.persistence.ObjectPersistence;
import com.cloudpath.common.pojo.Content;
import org.apache.log4j.Logger;

public class PersistenceHelperImpl
implements PersistenceHelper {
    private static final Logger log = Logger.getLogger(PersistenceHelperImpl.class);
    private final ObjectPersistence cls_ObjectPersistence;
    private final ParseManager cls_ParseManager;

    public PersistenceHelperImpl(ObjectPersistence objectPersistence, ParseManager parseManager) {
        this.cls_ObjectPersistence = objectPersistence;
        this.cls_ParseManager = parseManager;
    }

    public Content getLastSnapshot() {
        try {
            String string = this.cls_ObjectPersistence.read(PersistenceType.SNAPSHOT.name(), "LastSnapshot");
            if (string != null && string.length() > 0) {
                Object object = this.cls_ParseManager.parse(string);
                if (object != null && object instanceof Content) {
                    if (((Content)object).getContent() != null && ((Content)object).getContent() instanceof Snapshot) {
                        return (Content)object;
                    }
                    log.warn((Object)"Discarding last snapshot because content is null or not a snapshot.");
                } else {
                    log.warn((Object)"Discarding last snapshot because it is null or not Content.");
                }
            }
        }
        catch (InvalidXmlException invalidXmlException) {
            log.error((Object)"Error while loading last snapshot.", (Throwable)invalidXmlException);
        }
        catch (InvalidPersistenceException invalidPersistenceException) {
            log.error((Object)"Error occurred while loading last snapshot.", (Throwable)invalidPersistenceException);
        }
        return null;
    }

    public String[] getNetworkConfigNames() {
        try {
            return this.cls_ObjectPersistence.getAll(PersistenceType.CONFIGURATION.name());
        }
        catch (InvalidPersistenceException invalidPersistenceException) {
            log.error((Object)"Error while getting network config names.", (Throwable)invalidPersistenceException);
            return new String[0];
        }
    }

    public Content getNetworkConfig(String string) {
        try {
            String string2 = this.cls_ObjectPersistence.read(PersistenceType.CONFIGURATION.name(), string);
            Object object = this.cls_ParseManager.parse(string2);
            if (object != null && object instanceof Content && ((Content)object).getContent() != null && ((Content)object).getContent() instanceof Network) {
                return (Content)object;
            }
        }
        catch (InvalidXmlException invalidXmlException) {
            log.error((Object)("Error while loading network config '" + string + "'."), (Throwable)invalidXmlException);
        }
        catch (InvalidPersistenceException invalidPersistenceException) {
            log.error((Object)("Error while loading network config '" + string + "'."), (Throwable)invalidPersistenceException);
        }
        return null;
    }

    public boolean saveNetworkConfig(Content content) {
        String string;
        if (content != null && content.getContent() != null && content.getContent() instanceof Network && (string = ((Network)content.getContent()).getName()) != null && string.length() > 0) {
            try {
                this.cls_ObjectPersistence.save(PersistenceType.CONFIGURATION.name(), string, content.getXml());
                return true;
            }
            catch (InvalidPersistenceException invalidPersistenceException) {
                log.error((Object)("Error while saving network config '" + string + "'."), (Throwable)invalidPersistenceException);
            }
        }
        return false;
    }

    public boolean deleteNetworkConfig(String string) {
        try {
            this.cls_ObjectPersistence.delete(PersistenceType.CONFIGURATION.name(), string);
            return true;
        }
        catch (InvalidPersistenceException invalidPersistenceException) {
            log.error((Object)("Error while deleting network config '" + string + "'."), (Throwable)invalidPersistenceException);
            return false;
        }
    }

    public boolean saveSnapshot(Snapshot snapshot) {
        Content content = new Content(snapshot);
        content.setIsValid(true);
        try {
            this.cls_ObjectPersistence.save(PersistenceType.SNAPSHOT.name(), "LastSnapshot", content.getXml());
            return true;
        }
        catch (Exception exception) {
            log.error((Object)"Error saving last snapshot.", (Throwable)exception);
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PersistenceType {
        SNAPSHOT,
        CONFIGURATION;

    }
}

