/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.launch;

import com.cloudpath.app.xpc.gui.XpcMenuProvider;
import com.cloudpath.app.xpc.util.PersistenceHelper;
import com.cloudpath.app.xpc.util.PersistenceHelperImpl;
import com.cloudpath.app.xpc.util.XpcUtil;
import com.cloudpath.assess.buffer.Buffer;
import com.cloudpath.assess.buffer.BufferManager;
import com.cloudpath.assess.buffer.BufferManagerImpl;
import com.cloudpath.assess.pojo.ConfigConstants;
import com.cloudpath.assess.pojo.Network;
import com.cloudpath.common.app.Application;
import com.cloudpath.common.app.gui.ExternalInterface;
import com.cloudpath.common.app.gui.GuiTabChangeListener;
import com.cloudpath.common.dispatch.AsyncHandler;
import com.cloudpath.common.dispatch.DispatchRequest;
import com.cloudpath.common.dispatch.ResponseHandler;
import com.cloudpath.common.os.common.OsProvider;
import com.cloudpath.common.os.mac.common.provider.MacSystemProvider;
import com.cloudpath.common.parse.ParseManager;
import com.cloudpath.common.persistence.InvalidPersistenceException;
import com.cloudpath.common.persistence.ObjectPersistenceImpl;
import com.cloudpath.common.util.AbstractDataType;
import com.cloudpath.common.util.Arguments;
import com.cloudpath.common.util.Credential;
import com.cloudpath.common.util.GuiShutdownListener;
import com.cloudpath.common.util.LogUtil;
import com.cloudpath.common.util.Resources;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.common.util.SelectionHandlerImpl;
import com.cloudpath.common.util.SelectionListener;
import com.cloudpath.gui.FormProvider;
import com.cloudpath.gui.GuiController;
import com.cloudpath.gui.component.XpcForm;
import com.cloudpath.gui.util.FormListener;
import com.cloudpath.workflow.Workflow;
import com.cloudpath.workflow.common.WorkflowConstants;
import com.cloudpath.workflow.common.util.WorkflowBuilder;
import java.io.File;

public abstract class XpressConnect
implements Application,
FormProvider,
WorkflowBuilder {
    private final SelectionHandler cls_SelectionHandler = new SelectionHandlerImpl(new WorkflowConstants.DataType[0], new WorkflowConstants.DataType[0]);
    private final PersistenceHelper cls_PersistenceHelper;
    private OsProvider cls_OsProvider;
    private BufferManagerImpl cls_BufferManager;
    private XpcMenuProvider cls_MenuProvider;
    private final GuiShutdownListener cls_GuiShutdownListener;
    private GuiController cls_GuiController;

    public XpressConnect(String[] stringArray, File file, GuiShutdownListener guiShutdownListener, String string) throws InvalidPersistenceException {
        String string2 = Resources.ResourceString.BUILD_LABEL.getValue();
        System.setProperty("http.agent", "XpressConnect/" + string2 + " (" + string + ")");
        this.cls_GuiShutdownListener = guiShutdownListener;
        if (file == null) {
            LogUtil.logToTempDirectory();
        } else {
            LogUtil.logToDirectory(file);
        }
        ParseManager parseManager = new ParseManager(ConfigConstants.CONFIG_ELEMENTS);
        this.cls_PersistenceHelper = new PersistenceHelperImpl(ObjectPersistenceImpl.getInstance(), parseManager);
        this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.ARGUMENTS, new Arguments(stringArray));
        this.cls_OsProvider = this.createOsProvider();
        this.cls_BufferManager = new BufferManagerImpl(this.createBuffers());
        if (this.getOsProvider() != null) {
            XpcUtil.setSystemProvider(new MacSystemProvider(this.getOsProvider().getCommandHandler()));
        }
    }

    protected OsProvider getOsProvider() {
        return this.cls_OsProvider;
    }

    protected PersistenceHelper getPersistenceHelper() {
        return this.cls_PersistenceHelper;
    }

    protected SelectionHandler getSelectionHandler() {
        return this.cls_SelectionHandler;
    }

    protected BufferManager getBufferManager() {
        return this.cls_BufferManager;
    }

    protected abstract OsProvider createOsProvider();

    protected abstract Buffer[] createBuffers();

    public void shutdown() {
        if (this.cls_GuiController != null) {
            this.cls_GuiController.shutdown();
        }
    }

    public final ResponseHandler getResponseHandler(GuiTabChangeListener guiTabChangeListener, AsyncHandler asyncHandler) {
        return new Workflow(this.getSelectionHandler(), guiTabChangeListener, asyncHandler, this);
    }

    public final ExternalInterface getGui(AsyncHandler asyncHandler) {
        this.cls_MenuProvider = new XpcMenuProvider(asyncHandler, this.cls_OsProvider, this.cls_SelectionHandler);
        this.cls_GuiController = new GuiController(this.cls_GuiShutdownListener, this, this.cls_MenuProvider, asyncHandler, true, this.getOsProvider());
        SelectionMonitor selectionMonitor = new SelectionMonitor(this.cls_GuiController);
        this.cls_SelectionHandler.addListener(selectionMonitor);
        return this.cls_GuiController;
    }

    public void setParams(String string, String string2) {
        if (string != null && string.length() > 0 || string2 != null && string2.length() > 0) {
            Credential credential = new Credential();
            credential.setUserName(string != null ? string : "");
            credential.setPassword(string2 != null ? string2 : "");
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_CREDENTIAL, credential);
        }
    }

    public abstract XpcForm getForm(FormListener var1, DispatchRequest var2);

    private class SelectionMonitor
    implements SelectionListener {
        private final GuiController cls_GuiController;

        public SelectionMonitor(GuiController guiController) {
            this.cls_GuiController = guiController;
        }

        public void selectionUpdated(AbstractDataType abstractDataType, Object object, Object object2) {
            if (WorkflowConstants.DataType.SELECTED_NETWORK.equals(abstractDataType) && object != null) {
                Network network = (Network)object;
                this.cls_GuiController.getFrame().getMainPanel().setTitle(network.getWelcomeTitle());
                this.cls_GuiController.getFrame().getMainPanel().setLicenseLabel(network.getLicensee(), ((Network)object).isLicensed(), ((Network)object).getContractState(), ((Network)object).getExpirationDate());
                XpressConnect.this.cls_MenuProvider.setOptionsMenu(!network.getGuiFlag_HideOptions());
            }
        }
    }
}

