/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.launch;

import com.cloudpath.app.xpc.gui.form.ConnectedForm;
import com.cloudpath.app.xpc.gui.form.CredentialPromptForm;
import com.cloudpath.app.xpc.gui.form.FixDateForm;
import com.cloudpath.app.xpc.gui.form.InstallNoticeForm;
import com.cloudpath.app.xpc.gui.form.InterfaceSelectionForm;
import com.cloudpath.app.xpc.gui.form.LeopardAuthenticateForm;
import com.cloudpath.app.xpc.gui.form.LocationPromptForm;
import com.cloudpath.app.xpc.gui.form.LogoutForm;
import com.cloudpath.app.xpc.gui.form.MacEnableAirportForm;
import com.cloudpath.app.xpc.gui.form.MacKeychainForm;
import com.cloudpath.app.xpc.gui.form.MacSystemCredentialForm;
import com.cloudpath.app.xpc.gui.form.ManualRepairForm;
import com.cloudpath.app.xpc.gui.form.NetworkItemSelectionForm;
import com.cloudpath.app.xpc.gui.form.NetworkSelectionForm;
import com.cloudpath.app.xpc.gui.form.NotifyBeforeFixForm;
import com.cloudpath.app.xpc.gui.form.RevertCompleteForm;
import com.cloudpath.app.xpc.gui.form.TigerAuthenticateForm;
import com.cloudpath.app.xpc.launch.XpressConnect;
import com.cloudpath.app.xpc.workflow.block.BootstrapBlock;
import com.cloudpath.app.xpc.workflow.block.ConfigureBlock;
import com.cloudpath.app.xpc.workflow.block.ConnectedBlock;
import com.cloudpath.app.xpc.workflow.block.CredentialBlock;
import com.cloudpath.app.xpc.workflow.block.ElevationBlock;
import com.cloudpath.app.xpc.workflow.block.FindNetworkBlock;
import com.cloudpath.app.xpc.workflow.block.FindNetworkItemBlock;
import com.cloudpath.app.xpc.workflow.block.FindProfileBlock;
import com.cloudpath.app.xpc.workflow.block.LocationBlock;
import com.cloudpath.app.xpc.workflow.block.PrepareProfileBlock;
import com.cloudpath.app.xpc.workflow.block.SnowLeopardReconnectBlock;
import com.cloudpath.app.xpc.workflow.block.TlsBlock;
import com.cloudpath.app.xpc.workflow.block.ValidateBlock;
import com.cloudpath.app.xpc.workflow.block.request.AssociateToSsidRequest;
import com.cloudpath.app.xpc.workflow.block.request.CredentialRequest;
import com.cloudpath.app.xpc.workflow.block.request.EnableAirportRequest;
import com.cloudpath.app.xpc.workflow.block.request.InstallNoticeRequest;
import com.cloudpath.app.xpc.workflow.block.request.InterfaceRequest;
import com.cloudpath.app.xpc.workflow.block.request.KeychainRequest;
import com.cloudpath.app.xpc.workflow.block.request.LeopardConnectRequest;
import com.cloudpath.app.xpc.workflow.block.request.LocationRequest;
import com.cloudpath.app.xpc.workflow.block.request.LogoutRequest;
import com.cloudpath.app.xpc.workflow.block.request.NetworkItemRequest;
import com.cloudpath.app.xpc.workflow.block.request.NetworkRequest;
import com.cloudpath.app.xpc.workflow.block.request.NotifyBeforeFixRequest;
import com.cloudpath.app.xpc.workflow.block.request.NotifyConnectedRequest;
import com.cloudpath.app.xpc.workflow.block.request.RepairSectionRequest;
import com.cloudpath.app.xpc.workflow.block.request.RevertCompleteRequest;
import com.cloudpath.app.xpc.workflow.block.request.SystemCredentialRequest;
import com.cloudpath.assess.buffer.Buffer;
import com.cloudpath.assess.os.common.ApplicationBuffer;
import com.cloudpath.assess.os.common.FileBuffer;
import com.cloudpath.assess.os.mac.common.MacSystemBuffer;
import com.cloudpath.assess.os.mac.leopard.LeopardSupplicantBuffer;
import com.cloudpath.assess.os.mac.leopard.LeopardUtilityBuffer;
import com.cloudpath.assess.os.mac.leopard.LeopardWirelessBuffer;
import com.cloudpath.assess.pojo.Setting;
import com.cloudpath.assess.pojo.Settings;
import com.cloudpath.assess.util.SettingUtil;
import com.cloudpath.common.command.CommandHandlerImpl;
import com.cloudpath.common.dispatch.DispatchRequest;
import com.cloudpath.common.os.common.OsProvider;
import com.cloudpath.common.os.mac.common.MacOsProvider;
import com.cloudpath.common.os.mac.common.MacUtil;
import com.cloudpath.common.os.mac.leopard.cmd.Maccmd;
import com.cloudpath.common.os.mac.leopard.eapol.MacEapCmd;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEapBindingPlist;
import com.cloudpath.common.os.mac.leopard.security.LeopardSecurity;
import com.cloudpath.common.os.mac.snowleopard.SnowLeopardOsProvider;
import com.cloudpath.common.os.mac.snowleopard.network.SnowLeopardSsidManager;
import com.cloudpath.common.os.mac.snowleopard.network.airport.SnowLeopardAirportReader;
import com.cloudpath.common.os.mac.snowleopard.network.eap.SnowLeopardEapProfileManager;
import com.cloudpath.common.os.mac.snowleopard.network.networksetup.SnowLeopardNetworkSetupReader;
import com.cloudpath.common.persistence.InvalidPersistenceException;
import com.cloudpath.common.util.FileUtil;
import com.cloudpath.common.util.GuiShutdownListener;
import com.cloudpath.gui.component.XpcForm;
import com.cloudpath.gui.template.XpcPromptForm;
import com.cloudpath.gui.util.FormListener;
import com.cloudpath.workflow.common.util.WorkflowChain;
import java.io.File;
import org.apache.log4j.Logger;

public class SnowLeopardXpressConnect
extends XpressConnect {
    private static final Logger log = Logger.getLogger(SnowLeopardXpressConnect.class);
    private Maccmd cls_Maccmd;
    private MacEapCmd cls_MacEapCmd;
    private LeopardEapBindingPlist cls_EapBindingPlist;
    private SnowLeopardEapProfileManager cls_EapProfileManager;
    private SnowLeopardSsidManager cls_SsidManager;

    public SnowLeopardXpressConnect(String[] stringArray, GuiShutdownListener guiShutdownListener) throws InvalidPersistenceException {
        super(stringArray, new File("/tmp"), guiShutdownListener, "Macintosh; Intel Mac OS X 10_6");
    }

    public XpcForm getForm(FormListener formListener, DispatchRequest dispatchRequest) {
        XpcPromptForm xpcPromptForm = null;
        if (dispatchRequest instanceof NetworkRequest) {
            xpcPromptForm = new NetworkSelectionForm(formListener, (NetworkRequest)dispatchRequest, this.getPersistenceHelper());
        } else if (dispatchRequest instanceof LeopardConnectRequest) {
            xpcPromptForm = new LeopardAuthenticateForm(formListener, (LeopardConnectRequest)dispatchRequest);
        } else if (dispatchRequest instanceof NetworkItemRequest) {
            xpcPromptForm = new NetworkItemSelectionForm(formListener, (NetworkItemRequest)dispatchRequest);
        } else if (dispatchRequest instanceof InterfaceRequest) {
            xpcPromptForm = new InterfaceSelectionForm(formListener, (InterfaceRequest)dispatchRequest, this.getOsProvider().getNicProvider());
        } else if (dispatchRequest instanceof NotifyConnectedRequest) {
            xpcPromptForm = new ConnectedForm(formListener, (NotifyConnectedRequest)dispatchRequest);
        } else if (dispatchRequest instanceof KeychainRequest) {
            xpcPromptForm = new MacKeychainForm(formListener, (KeychainRequest)dispatchRequest, this.getOsProvider().getApplicationProvider(), this.getSelectionHandler());
        } else if (dispatchRequest instanceof RepairSectionRequest) {
            Setting[] settingArray = ((RepairSectionRequest)dispatchRequest).getIncorrectSettings();
            Setting setting = SettingUtil.getSettingBySettingId(settingArray, Settings.SettingId.SYSTEM_CLOCK_BY_URL);
            xpcPromptForm = setting != null ? new FixDateForm(formListener, setting, this.getOsProvider().getCommandHandler()) : new ManualRepairForm(formListener, (RepairSectionRequest)dispatchRequest, this.getOsProvider());
        } else if (dispatchRequest instanceof InstallNoticeRequest) {
            xpcPromptForm = new InstallNoticeForm(formListener, (InstallNoticeRequest)dispatchRequest, this.getOsProvider(), this.getOsProvider().getApplicationProvider(), this.getSelectionHandler());
        } else if (dispatchRequest instanceof SystemCredentialRequest) {
            xpcPromptForm = new MacSystemCredentialForm(formListener, (SystemCredentialRequest)dispatchRequest, this.cls_Maccmd, this.getSelectionHandler());
        } else if (dispatchRequest instanceof CredentialRequest) {
            xpcPromptForm = new CredentialPromptForm(formListener, (CredentialRequest)dispatchRequest, this.getOsProvider(), this.getSelectionHandler(), this.cls_Maccmd);
        } else if (dispatchRequest instanceof EnableAirportRequest) {
            xpcPromptForm = new MacEnableAirportForm(formListener, (EnableAirportRequest)dispatchRequest);
        } else if (dispatchRequest instanceof AssociateToSsidRequest) {
            xpcPromptForm = new TigerAuthenticateForm(formListener, (AssociateToSsidRequest)dispatchRequest, this.getOsProvider());
        } else if (dispatchRequest instanceof LogoutRequest) {
            xpcPromptForm = new LogoutForm(formListener, (LogoutRequest)dispatchRequest, this.cls_Maccmd);
        } else if (dispatchRequest instanceof RevertCompleteRequest) {
            xpcPromptForm = new RevertCompleteForm(formListener, (RevertCompleteRequest)dispatchRequest);
        } else if (dispatchRequest instanceof LocationRequest) {
            xpcPromptForm = new LocationPromptForm(formListener, (LocationRequest)dispatchRequest, this.getNetworkSetup());
        } else if (dispatchRequest instanceof NotifyBeforeFixRequest) {
            xpcPromptForm = new NotifyBeforeFixForm(formListener, (NotifyBeforeFixRequest)dispatchRequest, this.getSelectionHandler());
        } else {
            log.error((Object)("No handler for request: " + dispatchRequest), (Throwable)new Exception("No handler for request: " + dispatchRequest));
        }
        return xpcPromptForm;
    }

    protected Buffer[] createBuffers() {
        LeopardSecurity leopardSecurity = new LeopardSecurity(this.getOsProvider().getFileHandler(), this.getOsProvider().getCommandHandler(), this.cls_Maccmd);
        return new Buffer[]{new LeopardUtilityBuffer(this.getOsProvider().getFileHandler(), this.getOsProvider().getCommandHandler(), leopardSecurity, this.cls_Maccmd), new LeopardSupplicantBuffer(this.getOsProvider().getFileHandler(), this.getOsProvider().getCommandHandler(), this.cls_EapProfileManager), new LeopardWirelessBuffer(this.cls_SsidManager, this.getOsProvider().getWirelessProvider()), new MacSystemBuffer(this.getOsProvider().getCommandHandler(), ((MacOsProvider)this.getOsProvider()).getNetworkSetupReader(), this.cls_Maccmd), new FileBuffer(this.getOsProvider().getFileHandler()), new ApplicationBuffer(this.getOsProvider().getApplicationProvider())};
    }

    public void populateWorkflow(WorkflowChain workflowChain) {
        log.info((Object)"Creating workflow for configuration.");
        workflowChain.addBlock(new BootstrapBlock(this.getSelectionHandler(), this.getOsProvider(), this.getPersistenceHelper()));
        workflowChain.addBlock(new FindNetworkBlock(this.getSelectionHandler(), this.getOsProvider(), this.getPersistenceHelper()));
        workflowChain.addBlock(new FindNetworkItemBlock(this.getSelectionHandler()));
        workflowChain.addBlock(new FindProfileBlock(this.getSelectionHandler(), this.getOsProvider().getNicProvider()));
        workflowChain.addBlock(new LocationBlock(this.getSelectionHandler(), this.getOsProvider()));
        workflowChain.addBlock(new PrepareProfileBlock(this.getSelectionHandler(), this.getOsProvider()));
        workflowChain.addBlock(new CredentialBlock(this.getSelectionHandler(), this.getOsProvider()));
        workflowChain.addBlock(new ElevationBlock(this.getSelectionHandler(), false));
        workflowChain.addBlock(new ConfigureBlock(this.getSelectionHandler(), this.getBufferManager(), workflowChain, this.getOsProvider(), this.getPersistenceHelper()));
        workflowChain.addBlock(new TlsBlock(this.getSelectionHandler(), this.getOsProvider(), this.cls_Maccmd, this.getOsProvider().getCommandHandler(), workflowChain));
        workflowChain.addBlock(new SnowLeopardReconnectBlock(this.getSelectionHandler(), (SnowLeopardAirportReader)this.getOsProvider().getWirelessProvider(), workflowChain, this.getPersistenceHelper(), this.cls_MacEapCmd, this.cls_EapProfileManager));
        workflowChain.addBlock(new ValidateBlock(this.getSelectionHandler(), this.getOsProvider(), workflowChain));
        workflowChain.addBlock(new ElevationBlock(this.getSelectionHandler(), true));
        workflowChain.addBlock(new ConnectedBlock(this.getSelectionHandler(), workflowChain, this.getOsProvider()));
    }

    protected OsProvider createOsProvider() {
        CommandHandlerImpl commandHandlerImpl = new CommandHandlerImpl();
        FileUtil fileUtil = new FileUtil();
        SnowLeopardOsProvider snowLeopardOsProvider = new SnowLeopardOsProvider(fileUtil, commandHandlerImpl);
        this.cls_Maccmd = snowLeopardOsProvider.getMaccmd();
        this.cls_MacEapCmd = new MacEapCmd(fileUtil, commandHandlerImpl, this.cls_Maccmd);
        String string = "";
        try {
            string = MacUtil.getSystemId(commandHandlerImpl);
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to read system ID.", exception);
        }
        SnowLeopardNetworkSetupReader snowLeopardNetworkSetupReader = new SnowLeopardNetworkSetupReader(commandHandlerImpl, this.cls_Maccmd);
        this.cls_EapBindingPlist = new LeopardEapBindingPlist(fileUtil, commandHandlerImpl, string);
        this.cls_EapProfileManager = new SnowLeopardEapProfileManager(fileUtil, commandHandlerImpl, this.cls_Maccmd, this.cls_EapBindingPlist, snowLeopardNetworkSetupReader);
        this.cls_SsidManager = new SnowLeopardSsidManager(fileUtil, commandHandlerImpl, this.cls_Maccmd, this.cls_EapBindingPlist, snowLeopardNetworkSetupReader, this.cls_EapProfileManager);
        return snowLeopardOsProvider;
    }

    public SnowLeopardNetworkSetupReader getNetworkSetup() {
        return (SnowLeopardNetworkSetupReader)((MacOsProvider)this.getOsProvider()).getNetworkSetupReader();
    }
}

