/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.gui.form;

import com.cloudpath.app.xpc.util.XpcUtil;
import com.cloudpath.app.xpc.workflow.block.request.SystemCredentialRequest;
import com.cloudpath.app.xpc.workflow.block.selection.CredentialSelection;
import com.cloudpath.assess.pojo.Network;
import com.cloudpath.assess.pojo.NetworkItem;
import com.cloudpath.assess.pojo.Profile;
import com.cloudpath.assess.util.PojoUtil;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.os.mac.leopard.cmd.Maccmd;
import com.cloudpath.common.util.Resources;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.common.util.Util;
import com.cloudpath.gui.component.XpcLinkListener;
import com.cloudpath.gui.component.XpcPanel;
import com.cloudpath.gui.component.XpcPartialLinkLabel;
import com.cloudpath.gui.template.XpcPromptForm;
import com.cloudpath.gui.util.FormListener;
import com.cloudpath.gui.util.GuiConstants;
import com.cloudpath.workflow.common.WorkflowConstants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.MatteBorder;
import org.apache.log4j.Logger;

public class MacSystemCredentialForm
extends XpcPromptForm
implements XpcLinkListener,
ActionListener {
    public static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MacSystemCredentialForm.class);
    private static final int LINK_RETRY = 1;
    private static final String ADMIN_TITLE = "Administrator Privileges Required:";
    private static final String STANDARD_TITLE = "Authentication to Computer Required:";
    private final XpcPartialLinkLabel cls_RetryLink;
    private final Maccmd cls_Maccmd;
    private VerifyChecker cls_VerifyChecker;
    private final JPanel cls_ErrorPanel;
    private final SystemCredentialRequest cls_Request;
    private final JLabel cls_ImageLabel;

    public MacSystemCredentialForm(FormListener formListener, SystemCredentialRequest systemCredentialRequest, Maccmd maccmd, SelectionHandler selectionHandler) {
        super(formListener, systemCredentialRequest.getRunAsAdmin() ? ADMIN_TITLE : STANDARD_TITLE, "< Back", "");
        String string;
        String string2;
        this.cls_Maccmd = maccmd;
        this.cls_Request = systemCredentialRequest;
        if (systemCredentialRequest.getRunAsAdmin()) {
            string2 = PojoUtil.getResourceString(Resources.ResourceString.ADMIN_CREDENTIAL_TEXT, (Network)selectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK), (NetworkItem)selectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK_ITEM), (Profile)selectionHandler.getObject(WorkflowConstants.DataType.SELECTED_PROFILE));
            string = "Computer Admin Account & Password";
        } else {
            string2 = "To allow " + Resources.ResourceString.PRODUCT_NAME.getValue() + " to configure your computer, please enter the username and password which you use to access your computer.  Your username should already be populated.  If you do not have a password configured, it may be left blank.";
            string = "Computer Username & Password";
        }
        XpcPanel xpcPanel = new XpcPanel(true);
        xpcPanel.setOpaque(false);
        xpcPanel.setLayout(new BorderLayout(0, 0));
        this.add((Component)xpcPanel, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel("<html>" + string2 + "</html>");
        jLabel.setAlignmentX(0.0f);
        jLabel.setHorizontalAlignment(2);
        jLabel.setOpaque(false);
        jLabel.setBorder(new MatteBorder(5, 5, 5, 5, (Color)null));
        jLabel.setFont(GuiConstants.FONT_ARIAL_11_PLAIN);
        jPanel.add((Component)jLabel, "North");
        this.cls_ErrorPanel = new JPanel();
        this.cls_ErrorPanel.setLayout(new BorderLayout());
        this.cls_ErrorPanel.setBorder(new MatteBorder(0, 0, 0, 0, Color.green));
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        JButton jButton = new JButton(GuiConstants.getImage("/mac_lock.gif"));
        jButton.setBorder(null);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.addActionListener(this);
        jPanel2.add(jButton);
        this.cls_RetryLink = new XpcPartialLinkLabel();
        this.cls_RetryLink.setForeground(GuiConstants.COLOR_ERROR);
        this.cls_RetryLink.addText("Authentication was unsuccessful.  ");
        this.cls_RetryLink.addLink("Click here to retry.", 1, this);
        jPanel2.add(this.cls_RetryLink);
        this.cls_ErrorPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(new MatteBorder(0, 30, 10, 0, (Color)null));
        JLabel jLabel2 = new JLabel("<html>If you are using Google's Chrome browser, please relaunch " + Resources.ResourceString.PRODUCT_NAME.getValue() + " with Safari.</html>");
        jLabel2.setFont(GuiConstants.FONT_ARIAL_11_PLAIN);
        jLabel2.setForeground(GuiConstants.COLOR_ERROR);
        jPanel3.add((Component)jLabel2, "Center");
        this.cls_ErrorPanel.add((Component)jPanel3, "South");
        this.cls_ErrorPanel.setVisible(false);
        xpcPanel.add((Component)this.cls_ErrorPanel, "North");
        XpcPanel xpcPanel2 = new XpcPanel();
        ((BorderLayout)xpcPanel2.getLayout()).setHgap(20);
        this.cls_ImageLabel = new JLabel(this.getScaledImage(90));
        xpcPanel2.add((Component)this.cls_ImageLabel, "Center");
        jPanel.add((Component)xpcPanel2, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setOpaque(false);
        jPanel4.setBorder(new MatteBorder(5, 0, 0, 0, (Color)null));
        jPanel4.setLayout(new BorderLayout());
        JLabel jLabel3 = new JLabel("<html>Enter Your <font color='red'><b>" + string + "</b></font>,</html>");
        jLabel3.setHorizontalAlignment(0);
        jPanel4.add((Component)jLabel3, "Center");
        JLabel jLabel4 = new JLabel("Not Your Network Password");
        jLabel4.setHorizontalAlignment(0);
        jPanel4.add((Component)jLabel4, "South");
        jPanel.add((Component)jPanel4, "South");
        xpcPanel.add((Component)jPanel, "Center");
        Util.runThread("InitialVerifierLaunch", new Runnable(){

            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                MacSystemCredentialForm.this.cls_VerifyChecker = new VerifyChecker(MacSystemCredentialForm.this.cls_Request.getRunAsStandardUser(), MacSystemCredentialForm.this.cls_Request.getAdminUserName(), MacSystemCredentialForm.this.cls_Request.getAdminPassword());
            }
        });
    }

    public void setElevationResult(boolean bl) {
        if (bl) {
            this.cls_ErrorPanel.setVisible(false);
            this.cls_ImageLabel.setIcon(this.getScaledImage(90));
            this.selectionMade(new CredentialSelection(null));
        } else {
            log.info((Object)"User failed to provide an administrative password.");
            this.cls_ErrorPanel.setVisible(true);
            this.cls_ImageLabel.setIcon(this.getScaledImage(60));
        }
    }

    public DispatchResponse getSelection() {
        return null;
    }

    public void linkClicked(int n) {
        if (n == 1) {
            if (this.cls_VerifyChecker != null) {
                this.cls_VerifyChecker.stop();
            }
            this.cls_ErrorPanel.setVisible(false);
            this.cls_ImageLabel.setIcon(this.getScaledImage(90));
            this.cls_VerifyChecker = new VerifyChecker(this.cls_Request.getRunAsStandardUser(), this.cls_Request.getAdminUserName(), this.cls_Request.getAdminPassword());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.linkClicked(1);
    }

    public void skipClicked() {
        log.warn((Object)"*** User has selected to skip authorization screen. ***");
        this.setElevationResult(true);
    }

    private ImageIcon getScaledImage(int n) {
        return new ImageIcon(GuiConstants.getImage("/mac_password.gif").getImage().getScaledInstance(250 * n / 100, 143 * n / 100, 0));
    }

    private class VerifyChecker
    implements Runnable {
        private final Thread cls_Thread = Util.runThread("VerifyChecker", this);
        private final boolean cls_AllowStandardUser;
        private final String cls_AdminUserName;
        private final String cls_AdminPassword;
        private boolean cls_ContinueRunning = true;

        public VerifyChecker(boolean bl, String string, String string2) {
            this.cls_AllowStandardUser = bl;
            this.cls_AdminUserName = string;
            this.cls_AdminPassword = string2;
        }

        public void stop() {
            this.cls_ContinueRunning = false;
            this.cls_Thread.interrupt();
        }

        public void run() {
            boolean bl;
            if (XpcUtil.isGuestMode()) {
                log.debug((Object)"Will not install maccmd.  Assumed to be installed in guest mode.");
                boolean bl2 = true;
                MacSystemCredentialForm.this.setElevationResult(true);
                return;
            }
            if (this.cls_AllowStandardUser) {
                log.debug((Object)"Will install maccmd for use by standard users.");
                bl = MacSystemCredentialForm.this.cls_Maccmd.installForStandardUser(this.cls_AdminUserName, this.cls_AdminPassword);
            } else {
                log.debug((Object)"Will install maccmd for use by admin users.");
                bl = MacSystemCredentialForm.this.cls_Maccmd.installForAdminUser();
            }
            if (bl) {
                boolean bl3 = this.cls_AllowStandardUser ? MacSystemCredentialForm.this.cls_Maccmd.verify(this.cls_AdminUserName, this.cls_AdminPassword) : MacSystemCredentialForm.this.cls_Maccmd.verify(null, null, true);
                if (bl3) {
                    if (this.cls_ContinueRunning) {
                        MacSystemCredentialForm.this.setElevationResult(true);
                    }
                } else if (this.cls_ContinueRunning) {
                    MacSystemCredentialForm.this.setElevationResult(false);
                }
            } else if (this.cls_ContinueRunning) {
                MacSystemCredentialForm.this.setElevationResult(false);
            }
        }
    }
}

