/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.gui.form;

import com.cloudpath.app.xpc.workflow.block.request.LeopardConnectRequest;
import com.cloudpath.app.xpc.workflow.block.selection.RepairSectionSelection;
import com.cloudpath.common.dispatch.CustomSelection;
import com.cloudpath.common.dispatch.DispatchRequest;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.dispatch.RetrySelection;
import com.cloudpath.common.dispatch.SkipSelection;
import com.cloudpath.gui.component.StatusPanel;
import com.cloudpath.gui.component.XpcLink;
import com.cloudpath.gui.component.XpcLinkListener;
import com.cloudpath.gui.component.XpcPanel;
import com.cloudpath.gui.form.UpdatableForm;
import com.cloudpath.gui.template.XpcPromptForm;
import com.cloudpath.gui.util.FormListener;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class LeopardAuthenticateForm
extends XpcPromptForm
implements XpcLinkListener,
UpdatableForm {
    public static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(LeopardAuthenticateForm.class);
    private static int LINK_SKIP = 1;
    private static int LINK_RETRY = 2;
    private static int LINK_CHANGE_CREDENTIALS = 3;
    private final StatusPanel cls_StatusPanel;
    private final JPanel cls_BottomLeftPanel;

    public LeopardAuthenticateForm(FormListener formListener, LeopardConnectRequest leopardConnectRequest) {
        super(formListener, (JPanel)null, null, null);
        this.setLoading(true);
        this.cls_StatusPanel = new StatusPanel(leopardConnectRequest.getTitle(), leopardConnectRequest.getMessage(), leopardConnectRequest.getIcon());
        this.add((Component)this.cls_StatusPanel, "Center");
        XpcPanel xpcPanel = new XpcPanel();
        this.cls_BottomLeftPanel = new JPanel(new FlowLayout(0, 10, 10));
        this.cls_BottomLeftPanel.setOpaque(false);
        if (leopardConnectRequest.getAllowChangeCredentials()) {
            this.cls_BottomLeftPanel.add((Component)new XpcLink("Change Credentials", LINK_CHANGE_CREDENTIALS, this, true), "West");
        }
        this.cls_BottomLeftPanel.add((Component)new XpcLink("Retry", LINK_RETRY, this, true), "East");
        xpcPanel.add((Component)this.cls_BottomLeftPanel, "West");
        this.cls_BottomLeftPanel.setVisible(leopardConnectRequest.getProvideOptions() != 0);
        this.add((Component)xpcPanel, "South");
    }

    public DispatchResponse getSelection() {
        return new RepairSectionSelection(RepairSectionSelection.Action.REPAIR);
    }

    public void linkClicked(int n) {
        if (n == LINK_SKIP) {
            log.debug((Object)"User clicked skip.");
            this.selectionMade(new SkipSelection("- Authentication was skipped."));
        } else if (n == LINK_RETRY) {
            log.debug((Object)"User clicked retry.");
            this.selectionMade(new RetrySelection());
        } else if (n == LINK_CHANGE_CREDENTIALS) {
            log.debug((Object)"User clicked link to change credentials.");
            this.selectionMade(new CustomSelection(1201));
        }
    }

    public boolean update(DispatchRequest dispatchRequest) {
        if (dispatchRequest instanceof LeopardConnectRequest) {
            LeopardConnectRequest leopardConnectRequest = (LeopardConnectRequest)dispatchRequest;
            this.cls_StatusPanel.setTitle(leopardConnectRequest.getTitle());
            this.cls_StatusPanel.setMessage(leopardConnectRequest.getMessage());
            this.cls_StatusPanel.setIcon(leopardConnectRequest.getIcon());
            if (leopardConnectRequest.getProvideOptions() >= 0) {
                this.cls_BottomLeftPanel.setVisible(leopardConnectRequest.getProvideOptions() != 0);
            }
            return true;
        }
        return false;
    }
}

