/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.gui.form;

import com.cloudpath.app.xpc.workflow.block.request.InterfaceRequest;
import com.cloudpath.app.xpc.workflow.block.selection.InterfaceSelection;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.os.common.NicProvider;
import com.cloudpath.common.pojo.NetworkInterface;
import com.cloudpath.common.pojo.NetworkInterfaces;
import com.cloudpath.gui.component.XpcButtonListItem;
import com.cloudpath.gui.component.XpcLinkListener;
import com.cloudpath.gui.component.XpcListPanel;
import com.cloudpath.gui.component.XpcPartialLinkLabel;
import com.cloudpath.gui.template.XpcPromptForm;
import com.cloudpath.gui.util.FormListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class InterfaceSelectionForm
extends XpcPromptForm
implements XpcLinkListener {
    public static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(InterfaceSelectionForm.class);
    private static final int LINK_SHOW_ALL = 2;
    private final NicProvider cls_NicProvider;
    private final ArrayList<NetworkInterface> cls_DisplayedNics = new ArrayList();
    private final JPanel cls_Panel;
    private final NetworkInterface cls_PreferredWireless;
    private final NetworkInterface cls_PreferredWired;
    private final XpcButtonListItem cls_Wireless;
    private final XpcButtonListItem cls_Wired;
    private final XpcListPanel cls_List;
    private final XpcPartialLinkLabel cls_LinkLabel = new XpcPartialLinkLabel();
    private boolean cls_AllShown = false;

    public InterfaceSelectionForm(FormListener formListener, InterfaceRequest interfaceRequest, NicProvider nicProvider) {
        super(formListener, "How would you like to connect to the network?", "< Back", "Continue >");
        this.cls_NicProvider = nicProvider;
        this.cls_PreferredWireless = interfaceRequest.getPreferredWireless();
        this.cls_PreferredWired = interfaceRequest.getPreferredWired();
        this.cls_Panel = new JPanel();
        this.cls_Panel.setOpaque(false);
        this.cls_Panel.setLayout(new BoxLayout(this.cls_Panel, 1));
        this.add((Component)this.cls_Panel, "Center");
        this.cls_List = new XpcListPanel(this.cls_Panel);
        this.cls_Panel.add(this.cls_List);
        int n = 0;
        this.cls_Wireless = this.cls_PreferredWireless != null ? new XpcButtonListItem(48, interfaceRequest.getAllSupportedInterfaces().getInterfaceCount() > 3, "Wireless using '" + this.cls_PreferredWireless.getName() + "'.", "", n++, this, 0) : null;
        this.cls_Wired = this.cls_PreferredWired != null ? new XpcButtonListItem(48, interfaceRequest.getAllSupportedInterfaces().getInterfaceCount() > 3, "Wired using '" + this.cls_PreferredWired.getName() + "'.", "", n++, this, 0) : null;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        this.cls_Panel.add(jPanel);
        jPanel = new JPanel(new FlowLayout(0));
        jPanel.setOpaque(false);
        jPanel.add(this.cls_LinkLabel);
        this.cls_Panel.add(jPanel);
        this.populateNics(false, null);
        this.cls_List.setSelected(0);
        log.debug((Object)(this.getClass().getSimpleName() + " initialized."));
    }

    public DispatchResponse getSelection() {
        int n = this.cls_List.getSelected();
        if (n >= 0) {
            return new InterfaceSelection(this.cls_DisplayedNics.get(n));
        }
        return null;
    }

    private void populateNics(boolean bl, NetworkInterfaces networkInterfaces) {
        int n = this.cls_List.getSelected();
        this.cls_List.clear();
        this.cls_DisplayedNics.clear();
        if (this.cls_Wireless != null) {
            this.cls_List.addListItem(this.cls_Wireless);
            this.cls_DisplayedNics.add(this.cls_PreferredWireless);
        }
        if (this.cls_Wired != null) {
            this.cls_List.addListItem(this.cls_Wired);
            this.cls_DisplayedNics.add(this.cls_PreferredWired);
        }
        this.cls_AllShown = bl;
        if (bl) {
            this.cls_LinkLabel.clear();
            this.cls_LinkLabel.addText("Show only ");
            this.cls_LinkLabel.addLink("preferred NICs.", 2, this);
            for (int i = 0; i < networkInterfaces.getInterfaceCount(); ++i) {
                NetworkInterface networkInterface = networkInterfaces.getInterface(i);
                boolean bl2 = true;
                if (this.cls_PreferredWireless != null && networkInterface.getName().equals(this.cls_PreferredWireless.getName())) {
                    bl2 = false;
                } else if (this.cls_PreferredWired != null && networkInterface.getName().equals(this.cls_PreferredWired.getName())) {
                    bl2 = false;
                }
                if (!bl2) continue;
                int n2 = this.cls_List.getItemCount();
                String string = "Use ";
                String string2 = " (Not recommended)";
                if (networkInterface.getInterfaceType() == 1) {
                    string = "Wired using ";
                    string2 = "";
                } else if (networkInterface.getInterfaceType() == 2) {
                    string = "Wireless using ";
                    string2 = "";
                }
                string = string + " ";
                XpcButtonListItem xpcButtonListItem = new XpcButtonListItem(48, networkInterfaces.getInterfaceCount() > 3, string + "'" + networkInterface.getName() + "'." + string2, "", n2, this, 0);
                this.cls_List.addListItem(xpcButtonListItem);
                this.cls_DisplayedNics.add(networkInterface);
            }
        } else {
            this.cls_LinkLabel.clear();
            this.cls_LinkLabel.addText("NIC missing?  ");
            this.cls_LinkLabel.addLink("Click here to show all NICs.", 2, this);
        }
        this.cls_List.setSelected(n);
        this.validate();
    }

    public void linkClicked(int n) {
        if (n == 2) {
            if (!this.cls_AllShown) {
                try {
                    NetworkInterfaces networkInterfaces = this.cls_NicProvider.getAllInterfaces(true);
                    this.populateNics(true, networkInterfaces);
                }
                catch (Exception exception) {
                    log.error((Object)"Error while showing all nics.", (Throwable)exception);
                }
            } else {
                this.populateNics(false, null);
            }
        }
    }
}

