/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.gui.form;

import com.cloudpath.app.xpc.util.XpcUtil;
import com.cloudpath.app.xpc.workflow.block.request.InstallNoticeRequest;
import com.cloudpath.app.xpc.workflow.block.selection.InstallNoticeSelection;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.dispatch.SkipSelection;
import com.cloudpath.common.os.common.ApplicationProvider;
import com.cloudpath.common.os.common.BrowserProvider;
import com.cloudpath.common.util.FileUtil;
import com.cloudpath.common.util.JnlpUtil;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.common.util.UrlLoader;
import com.cloudpath.common.util.Util;
import com.cloudpath.gui.component.XpcLink;
import com.cloudpath.gui.component.XpcLinkListener;
import com.cloudpath.gui.component.XpcPanel;
import com.cloudpath.gui.component.XpcSpacer;
import com.cloudpath.gui.template.XpcPromptForm;
import com.cloudpath.gui.util.FormListener;
import com.cloudpath.gui.util.GuiConstants;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.net.NoRouteToHostException;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.border.MatteBorder;
import org.apache.log4j.Logger;

public class InstallNoticeForm
extends XpcPromptForm
implements XpcLinkListener,
UrlLoader.DownloadListener {
    public static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(InstallNoticeForm.class);
    private static int LINK_DOWNLOAD_MANUALLY = 1;
    private static final String INSTALL_TITLE = "Additional Software Is Required";
    private static final String UNINSTALL_TITLE = "Software Was Installed";
    private final BrowserProvider cls_BrowserProvider;
    private final ApplicationProvider cls_ApplicationProvider;
    private final InstallNoticeRequest cls_Request;
    private final JLabel cls_ErrorMessage;
    private final JLabel cls_DescriptionLabel;
    private final String cls_PromptText;
    private boolean cls_ContinueDisplayed = false;

    public InstallNoticeForm(FormListener formListener, InstallNoticeRequest installNoticeRequest, BrowserProvider browserProvider, ApplicationProvider applicationProvider, SelectionHandler selectionHandler) {
        super(formListener, installNoticeRequest.isUninstall() ? UNINSTALL_TITLE : INSTALL_TITLE, installNoticeRequest.getSetting().getIsRequired() || installNoticeRequest.isUninstall() ? "" : "Skip", InstallNoticeForm.getNextCaption(installNoticeRequest));
        this.cls_BrowserProvider = browserProvider;
        this.cls_ApplicationProvider = applicationProvider;
        this.cls_Request = installNoticeRequest;
        String string = installNoticeRequest.isUninstall() ? installNoticeRequest.getSetting().getInstall().getUninstallText() : installNoticeRequest.getSetting().getInstall().getInstallText();
        string = XpcUtil.replaceVariables(string, selectionHandler);
        this.cls_PromptText = Util.getSplitLines(string);
        XpcPanel xpcPanel = new XpcPanel();
        this.add((Component)xpcPanel, "Center");
        XpcPanel xpcPanel2 = new XpcPanel(true);
        xpcPanel.add((Component)xpcPanel2, "Center");
        this.cls_DescriptionLabel = new JLabel("<html>" + this.cls_PromptText + "</html>");
        this.cls_DescriptionLabel.setAlignmentX(0.0f);
        this.cls_DescriptionLabel.setHorizontalAlignment(2);
        this.cls_DescriptionLabel.setOpaque(false);
        this.cls_DescriptionLabel.setBorder(new MatteBorder(15, 30, 15, 30, (Color)null));
        this.cls_DescriptionLabel.setFont(GuiConstants.FONT_ARIAL_11_PLAIN);
        xpcPanel2.add(this.cls_DescriptionLabel);
        this.cls_ErrorMessage = new JLabel("");
        this.cls_ErrorMessage.setForeground(GuiConstants.COLOR_ERROR);
        this.cls_ErrorMessage.setFont(GuiConstants.FONT_ARIAL_11_BOLD);
        this.cls_ErrorMessage.setBorder(new MatteBorder(7, 30, 7, 30, (Color)null));
        GuiConstants.makeBold(this.cls_ErrorMessage);
        xpcPanel2.add(this.cls_ErrorMessage);
        xpcPanel2.add(new XpcSpacer(2, 10));
        if (!installNoticeRequest.isUninstall()) {
            String string2 = "Download Manually";
            String string3 = installNoticeRequest.getSetting().getHelpLink();
            if (string2 != null && string3 != null && string2.length() > 0 && string3.length() > 0) {
                if (string3.startsWith("[") && string3.indexOf("]") > 0) {
                    string2 = string3.substring(1, string3.indexOf("]"));
                    string3 = string3.substring(string3.indexOf("]") + 1);
                }
                log.debug((Object)("Link caption is '" + string2 + "'."));
                log.debug((Object)("Link URL is '" + string3 + "'."));
                XpcLink xpcLink = new XpcLink(string2, LINK_DOWNLOAD_MANUALLY, this, true);
                xpcPanel.add((Component)xpcLink, "South");
            }
        }
    }

    public DispatchResponse getSelection() {
        if (this.cls_Request.isUninstall()) {
            return this.doUninstall();
        }
        return this.doInstall();
    }

    private DispatchResponse doUninstall() {
        this.cls_Request.getSetting().getRuntime().setWasSkipped(true);
        this.cls_Request.getSetting().getRuntime().skipReverting();
        this.cls_Request.getSetting().getRuntime().incrementIncorrectNotificationCount();
        return new InstallNoticeSelection(this.cls_Request.getSetting());
    }

    protected String getFullUrl() {
        return this.getFileParts()[0];
    }

    protected String getBaseUrl() {
        return this.getFileParts()[1];
    }

    protected String getFileName() {
        return this.getFileParts()[2];
    }

    private String[] getFileParts() {
        String string = JnlpUtil.getCodeBase() != null ? JnlpUtil.getCodeBase().toString() : this.cls_Request.getNetwork().getBaseUrl();
        String string2 = this.cls_Request.getSetting().getInstall().getInstallCabName();
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        string = string + "installs/";
        if (string2.startsWith("http")) {
            int n;
            int n2 = string2.lastIndexOf(47);
            if (n2 < (n = string2.lastIndexOf(92))) {
                n2 = n;
            }
            if (n2 > 0) {
                string = string2.substring(0, n2);
                string2 = string2.substring(n2 + 1);
                if (!string.endsWith("/")) {
                    string = string + "/";
                }
            }
        }
        String string3 = string + string2;
        return new String[]{string3, string, string2};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private DispatchResponse doInstall() {
        block28: {
            InstallNoticeForm.log.info((Object)"Right button clicked.  Will do install...");
            if (this.cls_ContinueDisplayed && this.cls_Request.getSetting().getInstall().getUninstallRegistryTitle().length() == 0) {
                InstallNoticeForm.log.info((Object)"User has clicked 'continue'.  AppName is blank, so we will continue on.");
                return new InstallNoticeSelection(this.cls_Request.getSetting());
            }
            InstallNoticeForm.log.info((Object)"Will blank out error & status labels before continueing with install.");
            this.setStatusLabel(null);
            this.showError(null);
            var1_1 = this.getFullUrl();
            var2_2 = this.getFileName();
            InstallNoticeForm.log.info((Object)("Full URL is '" + var1_1 + "'."));
            InstallNoticeForm.log.info((Object)("File name is '" + var2_2 + "'."));
            var3_3 = this.cls_Request.getSetting().getInstall().getUninstallRegistryTitle();
            if (!var3_3.endsWith(".app")) {
                var3_3 = var3_3 + ".app";
            }
            var4_4 = this.cls_Request.getSetting().getInstall().getInstallArguments();
            InstallNoticeForm.log.info((Object)("Install options are '" + var4_4 + "'."));
            var5_5 = new File(FileUtil.getUserTmpDir(), var2_2);
            InstallNoticeForm.log.info((Object)("The application '" + var3_3 + "' is required."));
            InstallNoticeForm.log.info((Object)("Will use temp file '" + var5_5.getAbsolutePath() + "'."));
            this.cls_ApplicationProvider.refresh();
            if (this.cls_ApplicationProvider.isApplicationInstalled(this.cls_Request.getSetting().getInstall().getUninstallRegistryTitle())) {
                InstallNoticeForm.log.info((Object)("User manually installed the application '" + var3_3 + "'."));
                return new InstallNoticeSelection(this.cls_Request.getSetting());
            }
            InstallNoticeForm.log.info((Object)"Application needs to be installed.");
            InstallNoticeForm.log.info((Object)("Full URL is '" + var1_1 + "'."));
            var6_6 = var1_1 == null || var1_1.length() == 0 || var1_1.startsWith("http://127.0.0.1") != false;
            InstallNoticeForm.log.info((Object)("Is standalone CD mode: " + var6_6));
            InstallNoticeForm.log.info((Object)("Will look for resource '" + var2_2 + "' in classpath (" + System.getProperty("java.class.path") + ")."));
            var7_7 = this.getClass().getResourceAsStream("/" + var2_2);
            var8_8 = false;
            if (var7_7 == null) {
                InstallNoticeForm.log.info((Object)(" - Could not find resource '" + var2_2 + "' in classpath."));
            } else {
                InstallNoticeForm.log.info((Object)(" - Found resource '" + var2_2 + "' in classpath."));
                var9_9 = null;
                try {
                    var9_9 = new FileOutputStream(var5_5);
                    var10_14 = new byte[1024];
                    while ((var11_16 = var7_7.read(var10_14)) > 0) {
                        var9_9.write(var10_14, 0, var11_16);
                    }
                    var8_8 = true;
                    var13_17 = null;
                    ** if (var9_9 == null) goto lbl-1000
                }
                catch (Throwable var12_21) {
                    var13_18 = null;
                    if (var9_9 != null) {
                        try {
                            var9_9.close();
                        }
                        catch (Exception var14_20) {
                            // empty catch block
                        }
                    }
                    throw var12_21;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var9_9.close();
                    }
                    catch (Exception var14_19) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block28;
                    catch (Exception var10_15) {
                        InstallNoticeForm.log.error((Object)("An error occurred while copying file " + var2_2 + "."), (Throwable)var10_15);
                        var13_17 = null;
                        if (var9_9 != null) {
                            try {
                                var9_9.close();
                            }
                            catch (Exception var14_19) {}
                        }
                    }
                }
            }
        }
        try {
            if (var8_8) {
                InstallNoticeForm.log.info((Object)("Will use version from classpath, which is now at " + var5_5.getAbsolutePath() + "."));
                InstallNoticeForm.log.info((Object)"Will not download application because installer is in classpath.");
            } else if (var6_6) {
                InstallNoticeForm.log.debug((Object)("Will use cached version from CD at " + var5_5.getAbsolutePath() + "."));
                InstallNoticeForm.log.info((Object)"Will not download application due to being a standalone CD.");
            } else {
                InstallNoticeForm.log.debug((Object)("Will download application from " + var1_1 + "."));
                for (var9_10 = 0; var5_5.exists() && var9_10 < 10; ++var9_10) {
                    if (var5_5.delete()) continue;
                    var5_5 = new File(FileUtil.getUserTmpDir(), var9_10 + "_" + var2_2);
                }
                InstallNoticeForm.log.info((Object)("Will download application to '" + var5_5.getAbsolutePath() + "'."));
                var1_1 = var1_1.replace(" ", "%20");
                UrlLoader.getBytesFromUrl(new URL(var1_1), var5_5, (UrlLoader.DownloadListener)this);
            }
            InstallNoticeForm.log.info((Object)("Will install application '" + var5_5.getAbsolutePath() + "' as '" + var3_3 + "' with options '" + var4_4 + "'."));
            this.setStatusLabel("Unzipping and launching installer...");
            var9_11 = this.cls_ApplicationProvider.installApplication(var5_5, var3_3, var4_4);
            if (var9_11 == ApplicationProvider.InstallResult.SUCCESS_INSTALLER_RUNNING) {
                this.setStatusLabel("Installer has been started.  Click <b>Continue</b> when installer has completed..");
                this.getRightButton().setText("Continue >");
                this.getRightButton().setEnabled(true);
                this.showError(null);
                this.cls_ContinueDisplayed = true;
                return null;
            }
            if (var9_11 == ApplicationProvider.InstallResult.FAILED_TO_LOAD_FILE) {
                this.showError("The installer did not launch correctly.");
                this.getLeftButton().setText("Skip");
                this.getLeftButton().setVisible(true);
                this.cls_ContinueDisplayed = false;
                return null;
            }
            if (var9_11 == ApplicationProvider.InstallResult.FAILED_TO_UNZIP_FILE) {
                this.showError("The installer did not unzip correctly.");
                this.getLeftButton().setText("Skip");
                this.getLeftButton().setVisible(true);
                this.cls_ContinueDisplayed = false;
                return null;
            }
            return new InstallNoticeSelection(this.cls_Request.getSetting());
        }
        catch (NoRouteToHostException var9_12) {
            InstallNoticeForm.log.error((Object)"Error downloading and installing file.", (Throwable)var9_12);
            this.showError("An error occurred while attempting to connect to the server.  Please make sure you are connected to the network.");
        }
        catch (Exception var9_13) {
            InstallNoticeForm.log.error((Object)"Error downloading and installing file.", (Throwable)var9_13);
            var9_13.printStackTrace();
            this.showError("An error occurred loading installer.");
        }
        return null;
    }

    public void backClicked() {
        log.info((Object)"On install notice, user selected skip.");
        this.cls_Request.getSetting().getRuntime().setWasSkipped(true);
        this.selectionMade(new SkipSelection("Skipped by user request"));
    }

    public void linkClicked(int n) {
        if (n == LINK_DOWNLOAD_MANUALLY) {
            log.debug((Object)"User clicked to download manually.");
            String string = this.cls_Request.getSetting().getHelpLink();
            this.setStatusLabel(null);
            this.showError(null);
            if (string != null && string.startsWith("[") && string.indexOf("]") > 0) {
                string = string.substring(string.indexOf("]") + 1);
            }
            log.debug((Object)("HelpLink is '" + string + "'."));
            if (string.startsWith("http")) {
                log.debug((Object)("Will open link '" + string + "'."));
                try {
                    this.cls_BrowserProvider.openBrowser(string);
                }
                catch (Exception exception) {
                    log.warn((Object)("Unable to open browser for help link '" + string + "'."), (Throwable)exception);
                    JOptionPane.showMessageDialog(this, "<html>Additional information is available at: " + string + "<br><br></html>", "Help", 1);
                }
            } else {
                string = Util.getSplitLines(string);
                JOptionPane.showMessageDialog(this, "<html>" + string + "<br><br></html>", "Help", 1);
            }
        }
    }

    private void showError(String string) {
        if (string != null) {
            log.info((Object)("Showing error '" + string + "'."));
            this.setStatusLabel(null);
            this.cls_ErrorMessage.setText("<html>" + string + "</html>");
            this.cls_ErrorMessage.setVisible(true);
        } else {
            this.cls_ErrorMessage.setText("");
            this.cls_ErrorMessage.setVisible(false);
        }
    }

    private static final String getNextCaption(InstallNoticeRequest installNoticeRequest) {
        if (installNoticeRequest.isUninstall()) {
            return "Continue >";
        }
        if (installNoticeRequest.getSetting().getInstall().getInstallCabName() == null || installNoticeRequest.getSetting().getInstall().getInstallCabName().length() == 0) {
            return "";
        }
        return "Install >";
    }

    public void updateDownload(int n, int n2) {
        double d = (double)n / (n2 > 0 ? (double)n2 : 1.0);
        int n3 = (int)(d * 100.0);
        this.setStatusLabel("Installer is downloading.  " + n3 + "% complete...");
    }

    private void setStatusLabel(String string) {
        if (string == null || string.length() == 0) {
            this.cls_DescriptionLabel.setText("<html>" + this.cls_PromptText + "</html>");
        } else {
            this.cls_DescriptionLabel.setText("<html>" + this.cls_PromptText + "<br><br><b>**</b> " + string + "</html>");
        }
    }
}

