/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.gui.form;

import com.cloudpath.app.xpc.util.XpcUtil;
import com.cloudpath.app.xpc.workflow.block.request.CredentialRequest;
import com.cloudpath.app.xpc.workflow.block.selection.CredentialSelection;
import com.cloudpath.assess.pojo.Profile;
import com.cloudpath.assess.pojo.Setting;
import com.cloudpath.assess.pojo.Settings;
import com.cloudpath.assess.util.PojoUtil;
import com.cloudpath.common.cert.IssuedCertificate;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.os.common.BrowserProvider;
import com.cloudpath.common.os.mac.leopard.cert.CertificateLoader;
import com.cloudpath.common.os.mac.leopard.cmd.Maccmd;
import com.cloudpath.common.util.BanishedWords;
import com.cloudpath.common.util.Credential;
import com.cloudpath.common.util.HttpResult;
import com.cloudpath.common.util.Resources;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.common.util.UrlLoader2;
import com.cloudpath.common.util.Util;
import com.cloudpath.gui.component.XpcLink;
import com.cloudpath.gui.component.XpcLinkListener;
import com.cloudpath.gui.component.XpcPanel;
import com.cloudpath.gui.component.XpcSpacer;
import com.cloudpath.gui.template.XpcPromptForm;
import com.cloudpath.gui.util.FormListener;
import com.cloudpath.gui.util.GuiConstants;
import com.cloudpath.gui.util.XpcFocusTraversalPolicy;
import com.cloudpath.workflow.common.WorkflowConstants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URLEncoder;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.MatteBorder;
import org.apache.log4j.Logger;

public class CredentialPromptForm
extends XpcPromptForm
implements XpcLinkListener {
    public static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(CredentialPromptForm.class);
    private static int LINK_HELP = 1;
    private static String LAST_USERNAME = "";
    private final BrowserProvider cls_BrowserProvider;
    private final CredentialRequest cls_Request;
    private final JTextField cls_UserNameField;
    private final JPasswordField cls_PasswordField;
    private final JLabel cls_ErrorMessage;
    private final SelectionHandler cls_SelectionHandler;
    private final Maccmd cls_Maccmd;

    public CredentialPromptForm(FormListener formListener, final CredentialRequest credentialRequest, BrowserProvider browserProvider, SelectionHandler selectionHandler, Maccmd maccmd) {
        super(formListener, "Enter your credentials for this network:", "< Back", "Continue >");
        this.cls_Maccmd = maccmd;
        this.cls_BrowserProvider = browserProvider;
        this.cls_Request = credentialRequest;
        this.cls_SelectionHandler = selectionHandler;
        String string = credentialRequest.getNetworkItem().getPreCredentialText();
        if (string == null || string.length() == 0) {
            string = PojoUtil.getResourceString(Resources.ResourceString.PRE_CREDENTIAL_TEXT, credentialRequest.getNetwork(), credentialRequest.getNetworkItem(), credentialRequest.getProfile());
        }
        string = XpcUtil.replaceVariables(string, selectionHandler);
        string = Util.getSplitLines(string);
        String string2 = null;
        String string3 = null;
        Credential credential = credentialRequest.getCredential();
        if (credential != null) {
            string2 = credential.getUserName();
            string3 = credential.getPassword();
        }
        if (string2 == null || string2.length() == 0) {
            string2 = credentialRequest.getNetworkItem().getDefaultUserName();
        }
        if (string3 == null || string3.length() == 0) {
            string3 = credentialRequest.getNetworkItem().getDefaultPassword();
        }
        if (LAST_USERNAME.length() > 0) {
            string2 = LAST_USERNAME;
        }
        XpcPanel xpcPanel = new XpcPanel(true);
        this.add((Component)xpcPanel, "Center");
        JLabel jLabel = new JLabel("<html>" + string + "</html>");
        jLabel.setAlignmentX(0.0f);
        jLabel.setHorizontalAlignment(2);
        jLabel.setOpaque(false);
        jLabel.setBorder(new MatteBorder(15, 30, 15, 30, (Color)null));
        jLabel.setFont(GuiConstants.FONT_ARIAL_11_PLAIN);
        xpcPanel.add(jLabel);
        this.cls_ErrorMessage = new JLabel("");
        this.cls_ErrorMessage.setForeground(GuiConstants.COLOR_ERROR);
        this.cls_ErrorMessage.setFont(GuiConstants.FONT_ARIAL_11_BOLD);
        this.cls_ErrorMessage.setVisible(false);
        this.cls_ErrorMessage.setBorder(new MatteBorder(7, 30, 7, 30, (Color)null));
        GuiConstants.makeBold(this.cls_ErrorMessage);
        xpcPanel.add(this.cls_ErrorMessage);
        xpcPanel.add(new XpcSpacer(2, 10));
        Dimension dimension = new Dimension(100, 20);
        String string4 = credentialRequest.getNetworkItem().getUserNameDescription();
        if (string4 == null || string4.length() == 0) {
            string4 = "User Name";
        }
        if (!string4.endsWith(":")) {
            string4 = string4 + ":";
        }
        JLabel jLabel2 = new JLabel(string4);
        jLabel2.setFont(GuiConstants.FONT_ARIAL_11_BOLD);
        jLabel2.setHorizontalAlignment(4);
        jLabel2.setMinimumSize(dimension);
        jLabel2.setMaximumSize(dimension);
        jLabel2.setPreferredSize(dimension);
        this.cls_UserNameField = new JTextField(string2);
        this.cls_UserNameField.setColumns(32);
        this.cls_UserNameField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                CredentialPromptForm.this.showError("", null);
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.cls_UserNameField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                String string = CredentialPromptForm.getCheckedUserName(CredentialPromptForm.this.cls_UserNameField.getText(), credentialRequest.getNetworkItem().getDefaultUserName(), credentialRequest.getNetworkItem().getPreCredentialSuffix(), credentialRequest.getNetworkItem().getPreCredentialReplacementRegex(), credentialRequest.getNetworkItem().getPreCredentialCase());
                CredentialPromptForm.this.cls_UserNameField.setText(string);
            }
        });
        XpcPanel xpcPanel2 = new XpcPanel();
        ((BorderLayout)xpcPanel2.getLayout()).setHgap(20);
        xpcPanel2.setMaximumSize(new Dimension(2000, 20));
        xpcPanel2.setPreferredSize(new Dimension(2000, 20));
        xpcPanel2.add(new XpcSpacer(6, 2));
        xpcPanel2.add((Component)jLabel2, "West");
        xpcPanel2.add((Component)this.cls_UserNameField, "Center");
        xpcPanel2.add((Component)new XpcSpacer(20, 2), "East");
        xpcPanel2.setAlignmentX(0.0f);
        xpcPanel.add(xpcPanel2);
        xpcPanel.add(new XpcSpacer(2, 10));
        String string5 = credentialRequest.getNetworkItem().getPasswordDescription();
        if (string5 == null || string5.length() == 0) {
            string5 = "Password";
        }
        if (!string5.endsWith(":")) {
            string5 = string5 + ":";
        }
        JLabel jLabel3 = new JLabel(string5);
        jLabel3.setFont(GuiConstants.FONT_ARIAL_11_BOLD);
        jLabel3.setHorizontalAlignment(4);
        jLabel3.setMinimumSize(dimension);
        jLabel3.setMaximumSize(dimension);
        jLabel3.setPreferredSize(dimension);
        XpcPanel xpcPanel3 = new XpcPanel();
        ((BorderLayout)xpcPanel3.getLayout()).setHgap(20);
        this.cls_PasswordField = new JPasswordField(string3);
        this.cls_PasswordField.setColumns(32);
        xpcPanel3.setMaximumSize(new Dimension(2000, 20));
        xpcPanel3.setPreferredSize(new Dimension(2000, 20));
        xpcPanel3.add(new XpcSpacer(6, 2));
        xpcPanel3.add((Component)jLabel3, "West");
        xpcPanel3.add((Component)this.cls_PasswordField, "Center");
        xpcPanel3.add((Component)new XpcSpacer(20, 2), "East");
        xpcPanel3.setAlignmentX(0.0f);
        xpcPanel.add(xpcPanel3);
        this.cls_PasswordField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                CredentialPromptForm.this.showError("", null);
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        xpcPanel.add(new XpcPanel());
        String string6 = credentialRequest.getNetworkItem().getPreCredentialHelpLinkName();
        String string7 = credentialRequest.getNetworkItem().getPreCredentialHelpLinkUrl();
        if (string6 != null && string7 != null && string6.length() > 0 && string7.length() > 0) {
            string6 = XpcUtil.replaceVariables(string6, selectionHandler);
            XpcLink xpcLink = new XpcLink(string6, LINK_HELP, this, true);
            xpcPanel.add(xpcLink);
        }
        if (this.cls_Request.getErrorMessage() != null && this.cls_Request.getErrorMessage().length() > 0) {
            this.showError(this.cls_Request.getErrorMessage(), null);
        }
    }

    public DispatchResponse getSelection() {
        String string;
        String string2;
        String string3;
        Object object;
        Object object2;
        String string4 = this.cls_UserNameField.getText();
        String string5 = new String(this.cls_PasswordField.getPassword());
        String string6 = PojoUtil.getResourceString(Resources.ResourceString.ERROR_INVALID_USERNAME, this.cls_Request.getNetwork(), this.cls_Request.getNetworkItem(), this.cls_Request.getProfile());
        String string7 = CredentialPromptForm.getUserNameErrorMessage(string4, this.cls_Request.getUserNameRegex(), string6);
        String string8 = CredentialPromptForm.getPasswordErrorMessage(string5);
        if (string7 != null || string8 != null) {
            Credential credential = (Credential)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_CREDENTIAL);
            if (credential == null) {
                credential = new Credential();
                this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_CREDENTIAL, credential);
            }
            if (credential != null) {
                credential.setUserName(string4);
            }
            if (string7 != null) {
                this.showError(XpcUtil.replaceVariables(string7, this.cls_SelectionHandler), this.cls_UserNameField);
            } else if (string8 != null) {
                this.showError(XpcUtil.replaceVariables(string8, this.cls_SelectionHandler), this.cls_PasswordField);
            }
            return null;
        }
        BanishedWords.add(string5, "[USER_PASSWORD]");
        try {
            BanishedWords.add(URLEncoder.encode(string5, "UTF-8"), "[USER_PASSWORD]");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        LAST_USERNAME = string4;
        this.cls_ErrorMessage.setText("");
        this.cls_ErrorMessage.setVisible(false);
        Credential credential = new Credential();
        credential.setUserName(string4);
        credential.setPassword(string5);
        credential.setDomain("");
        String string9 = this.cls_Request.getNetworkItem().getRegistrationUrl();
        String string10 = this.cls_Request.getNetworkItem().getRegistrationCookie();
        if (string9 != null && string9.length() > 0) {
            log.debug((Object)"Will flush previous http authentication.");
            UrlLoader2.flushWwwCache();
            string9 = XpcUtil.replaceVariables(string9, this.cls_SelectionHandler, true, credential);
            log.debug((Object)("Will call registration URL: '" + string9 + "'"));
            object2 = UrlLoader2.fetchUrlViaPost(string9, string4, string5, 8000, string10);
            log.debug((Object)"Will kill http authentication.");
            UrlLoader2.flushWwwCache();
            log.debug((Object)"Will check registration results...");
            object = ((HttpResult)object2).getContent();
            if (object == null) {
                object = "";
            }
            string3 = ((HttpResult)object2).getDerivedStatusText();
            log.info((Object)("Status text from request: " + string3));
            if (((HttpResult)object2).getStatusCode() == 401L) {
                string2 = "";
                if (string3 != null && string3.length() > 0 && string3.startsWith("ERROR:")) {
                    string2 = string3.substring(6);
                    log.info((Object)("Override status text is: " + string2));
                }
                if (string2 != null && string2.length() > 0) {
                    string3 = string2;
                } else {
                    string = PojoUtil.getResourceString(Resources.ResourceString.ERROR_REGISTRATION_URL_401, this.cls_Request.getNetwork(), this.cls_Request.getNetworkItem(), this.cls_Request.getProfile());
                    if (string != null && string.length() > 0) {
                        log.info((Object)("Static status text is: " + string));
                        string3 = string;
                    } else {
                        log.info((Object)"Will use status text.");
                    }
                }
            }
            if (this.cls_Request.getNetworkItem().getRegistrationBehavior() == 1) {
                if (((HttpResult)object2).getStatusCode() != 200L) {
                    if (((HttpResult)object2).getStatusCode() == -2L) {
                        string3 = "Unable to register due to lack of network connectivity.";
                    }
                    log.error((Object)("Registration failed.  Will show message: " + string3));
                    this.showError(XpcUtil.replaceVariables(string3, this.cls_SelectionHandler), null);
                    return null;
                }
                log.info((Object)"Registration succeeded.");
            } else {
                if (((HttpResult)object2).getStatusCode() == 401L) {
                    log.error((Object)("Registration failed.  Will show message: " + string3));
                    this.showError(XpcUtil.replaceVariables(string3, this.cls_SelectionHandler), null);
                    return null;
                }
                log.info((Object)("Registration did not fail authentication. (" + ((HttpResult)object2).getStatusCode() + ")"));
            }
        }
        if ((object = ((Profile)(object2 = this.cls_Request.getProfile())).getSettingById(Settings.SettingId.CERTIFICATE_CLIENT)) != null) {
            ((Setting)object).getRuntime().getOriginalValue().setValue("0");
            string3 = ((Setting)object).getUnenforcedValue();
            log.debug((Object)("TLS Certificate URL: " + string3));
            string2 = System.getProperty("user.name");
            string = "";
            if (credential != null) {
                string2 = credential.getUserName();
                string = credential.getPassword();
            }
            HashMap<String, String> hashMap = XpcUtil.createVariableMap(this.cls_SelectionHandler, credential);
            try {
                this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.RUNTIME_CERTIFICATE_RESPONSE, null);
                this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.RUNTIME_ISSUED_CERTIFICATE, null);
                log.info((Object)"Will load certificate in credential form.");
                IssuedCertificate issuedCertificate = CertificateLoader.generateClientCertificate(this.cls_Maccmd.getCommandHandler(), string3, string2, string, hashMap);
                this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.RUNTIME_ISSUED_CERTIFICATE, issuedCertificate);
                this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.RUNTIME_TLS_PASSWORD, string);
            }
            catch (CertificateLoader.CertificateGenerationException certificateGenerationException) {
                log.error((Object)"Failed to retrieve certificate.", (Throwable)certificateGenerationException);
                String string11 = "<html>" + certificateGenerationException.getBasicMessage() + "</html>";
                this.showError(XpcUtil.replaceVariables(string11, this.cls_SelectionHandler, false, credential), null);
                return null;
            }
            credential.setUserName("");
            credential.setPassword("");
        }
        return new CredentialSelection(credential);
    }

    public void populateFocusTraversal(XpcFocusTraversalPolicy xpcFocusTraversalPolicy) {
        xpcFocusTraversalPolicy.addComponent(this.cls_UserNameField);
        xpcFocusTraversalPolicy.addComponent(this.cls_PasswordField);
        super.populateFocusTraversal(xpcFocusTraversalPolicy);
    }

    public void doFocus() {
        this.cls_UserNameField.requestFocus();
    }

    public void linkClicked(int n) {
        if (n == LINK_HELP) {
            log.debug((Object)"User clicked help.");
            String string = this.cls_Request.getNetworkItem().getPreCredentialHelpLinkUrl();
            string = XpcUtil.replaceVariables(string, this.cls_SelectionHandler);
            if (string.startsWith("http")) {
                try {
                    this.cls_BrowserProvider.openBrowser(string);
                }
                catch (Exception exception) {
                    log.warn((Object)("Unable to open browser for help link '" + string + "'."), (Throwable)exception);
                    JOptionPane.showMessageDialog(this, "<html>Additional information is available at: " + string + "<br><br></html>", "Help", 1);
                }
            } else {
                string = Util.getSplitLines(string);
                JOptionPane.showMessageDialog(this, "<html>" + string + "<br><br></html>", "Help", 1);
            }
        }
    }

    private void showError(String string, JTextField jTextField) {
        if (string != null && string.length() > 0) {
            log.info((Object)("Showing error '" + string + "'."));
            this.cls_ErrorMessage.setVisible(true);
            this.cls_ErrorMessage.setText(string);
            this.cls_ErrorMessage.setForeground(GuiConstants.COLOR_ERROR);
        } else {
            this.cls_ErrorMessage.setForeground(Color.white);
        }
        this.cls_UserNameField.setBackground(Color.white);
        this.cls_PasswordField.setBackground(Color.WHITE);
        if (jTextField != null) {
            jTextField.setBackground(GuiConstants.COLOR_ERROR_BACKGROUND);
            jTextField.requestFocus();
        }
    }

    protected static String getUserNameErrorMessage(String string, String string2, String string3) {
        log.debug((Object)"Will check if regex is valid.");
        log.debug((Object)("User name regex is '" + string2 + "'."));
        if (string.length() == 0) {
            return "The user name field must be populated.";
        }
        if (string2 != null && string2.length() > 0) {
            log.debug((Object)("User name regex is populated.  Will compare to '" + string + "'."));
            if (!string.matches(string2)) {
                log.info((Object)("User name regex '" + string2 + "' returned false when tested against '" + string + "'."));
                return string3;
            }
        }
        return null;
    }

    protected static String getPasswordErrorMessage(String string) {
        if (string.length() == 0) {
            return "The password field must be populated.";
        }
        return null;
    }

    private static String doRegexReplace(String string, String string2) {
        String string3;
        String string4;
        boolean bl;
        String string5 = string;
        log.info((Object)("Regex is : " + string));
        if (string5.startsWith("s/")) {
            string5 = string5.substring(2);
        }
        if (string5.startsWith("/")) {
            string5 = string5.substring(1);
        }
        log.debug((Object)("Work string is '" + string5 + "'."));
        if (string5.endsWith("/i")) {
            string5 = string5.substring(0, string5.length() - 2);
            log.debug((Object)("Modified:      '" + string5 + "'."));
            string5 = "(?i)" + string5;
            log.debug((Object)("Modified:      '" + string5 + "'."));
            bl = false;
        } else if (string5.endsWith("/gi")) {
            string5 = string5.substring(0, string5.length() - 3);
            string5 = "(?i)" + string5;
            bl = true;
        } else if (string5.endsWith("/ig")) {
            string5 = string5.substring(0, string5.length() - 3);
            string5 = "(?i)" + string5;
            bl = true;
        } else if (string5.endsWith("/g")) {
            string5 = string5.substring(0, string5.length() - 2);
            bl = true;
        } else {
            bl = false;
        }
        if (string5.endsWith("/") && !string5.endsWith("\\/")) {
            string5 = string5.substring(0, string5.length() - 1);
        }
        log.info((Object)("Stripped regex : " + string5 + "  (isGlobal=" + bl + ")"));
        String[] stringArray = string5.split("/");
        if (string5.endsWith("\\/")) {
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = "";
            stringArray = stringArray2;
        }
        int n = 0;
        String string6 = stringArray[n++];
        while (stringArray.length >= n && CredentialPromptForm.getEndingSlashCount(string6) % 2 == 1) {
            string6 = string6.substring(0, string6.length() - 1) + "/" + stringArray[n++];
        }
        String string7 = string4 = stringArray.length > n ? stringArray[n++] : "";
        while (stringArray.length > n && CredentialPromptForm.getEndingSlashCount(string4) % 2 == 1) {
            string4 = string4 + "/" + stringArray[n++];
        }
        if (string4.endsWith("\\") && CredentialPromptForm.getEndingSlashCount(string4) % 2 == 1) {
            string4 = string4 + "\\";
        }
        log.info((Object)("To Test: '" + string2 + "'"));
        log.info((Object)("Match '" + string6 + "', Replace '" + string4 + "', isGlobal: " + bl));
        log.info((Object)("To replace : '" + string4 + "'"));
        try {
            string3 = bl ? string2.replaceAll(string6, string4) : string2.replaceFirst(string6, string4);
        }
        catch (Exception exception) {
            string3 = string2;
        }
        log.info((Object)("Final String: '" + string3 + "'"));
        return string3;
    }

    private static int getEndingSlashCount(String string) {
        int n = 0;
        for (int i = string.length() - 1; string != null && i >= 0; --i) {
            if ("\\".equals(string.substring(i, i + 1))) {
                ++n;
                continue;
            }
            return n;
        }
        return n;
    }

    private static boolean suffixMatches(String string, String string2) {
        String[] stringArray = string2.split(";");
        string = string.toUpperCase();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            log.info((Object)("Checking suffix '" + stringArray[i].toUpperCase() + "' against username '" + string + "'."));
            if (!string.endsWith(stringArray[i].toUpperCase())) continue;
            bl = true;
            log.info((Object)("Found match '" + stringArray[i] + "'."));
            break;
        }
        return bl;
    }

    protected static String getCheckedUserName(String string, String string2, String string3, String string4, int n) {
        String[] stringArray = string3.split(";");
        if (string == null || string.length() == 0) {
            return string2;
        }
        if (!string.equals(string2)) {
            if (n == 1) {
                string = string.toUpperCase();
            } else if (n == 2) {
                string = string.toLowerCase();
            }
            if (string4.length() > 0) {
                string = CredentialPromptForm.doRegexReplace(string4, string);
            }
            if (stringArray.length > 0 && !CredentialPromptForm.suffixMatches(string, string3)) {
                string = string + stringArray[0];
            }
        }
        return string;
    }
}

