#!/bin/sh

LOG=/tmp/xpc_launcher.log
BASEDIR=`dirname "$0"`

echo Launcher starting... >> $LOG
echo Base directory is $BASEDIR >> $LOG
echo Current directory is `pwd` >> $LOG
echo Home directory is `cd ~; pwd` >> $LOG
echo Application name is XpressConnect >> $LOG

# NOTE:  Include the full tools directory in the classpath so that installers can be loaded from there.

EMBEDDED_JAVA_FILE=$BASEDIR/../PlugIns/jre/bin/java
INSTALLED_JAVA_FILE=/System/Library/Java/JavaVirtualMachines
OS_VERSION=`sw_vers | grep 'ProductVersion:' | grep -o '[0-9]*\.[0-9]*.*'`

echo Installed Java Location: $INSTALLED_JAVA_FILE >> $LOG
echo Embedded Java Location: $EMBEDDED_JAVA_FILE >> $LOG
echo OS version is: $OS_VERSION >> $LOG

if [[ "$OS_VERSION" = 10.4* ]]; then
  echo OS is 10.4 and should have Java is installed on system.  Will use system-installed java. >> $LOG
  java -cp "$BASEDIR/tools/:$BASEDIR/tools/XpressConnect.jar:$BASEDIR/tools/network_config.jar:$BASEDIR/tools/log4j.jar:$BASEDIR/tools/jnlp.jar:$BASEDIR/../../../config/network_config.jar:$BASEDIR/../../../config/" com.cloudpath.app.xpc.Launch
  HANDLED=true;
elif [[ "$OS_VERSION" = 10.5* ]]; then
  echo OS is 10.5 and should have Java is installed on system.  Will use system-installed java. >> $LOG
  java -cp "$BASEDIR/tools/:$BASEDIR/tools/XpressConnect.jar:$BASEDIR/tools/network_config.jar:$BASEDIR/tools/log4j.jar:$BASEDIR/tools/jnlp.jar:$BASEDIR/../../../config/network_config.jar:$BASEDIR/../../../config/" com.cloudpath.app.xpc.Launch
  HANDLED=true;
elif [[ "$OS_VERSION" = 10.6* ]]; then
  echo OS is 10.6 and should have Java is installed on system.  Will use system-installed java. >> $LOG
  java -cp "$BASEDIR/tools/:$BASEDIR/tools/XpressConnect.jar:$BASEDIR/tools/network_config.jar:$BASEDIR/tools/log4j.jar:$BASEDIR/tools/jnlp.jar:$BASEDIR/../../../config/network_config.jar:$BASEDIR/../../../config/" com.cloudpath.app.xpc.Launch
  HANDLED=true;
elif [ -d "$INSTALLED_JAVA_FILE" ]; then
  echo Java is installed on the system.  Will check if it is enabled.  >> $LOG
  echo LITERAL JAVA OUTPUT:  `java -version 2>&1` >> $LOG
  JAVA_OUTPUT=`java -version 2>&1 | grep ".*[0-9].[0-9].*"`
  echo DERIVED JAVA OUTPUT: $JAVA_OUTPUT >> $LOG
  if [ "$JAVA_OUTPUT"  ]; then
    echo Java is installed on the system and enabled. Will use the system-installed java. >> $LOG
    java -cp "$BASEDIR/tools/:$BASEDIR/tools/XpressConnect.jar:$BASEDIR/tools/network_config.jar:$BASEDIR/tools/log4j.jar:$BASEDIR/tools/jnlp.jar:$BASEDIR/../../../config/network_config.jar:$BASEDIR/../../../config/" com.cloudpath.app.xpc.Launch
    HANDLED=true;
  else
    echo Java is installed on the system but is disabled. >> $LOG
  fi
fi

if [ $HANDLED ]; then
  echo Application was launched via system-installed java. >> $LOG
elif [ -e "$EMBEDDED_JAVA_FILE" ]; then
  echo Java is either not installed or disabled.  Will use the embedded java JRE included in our package. >> $LOG
  "$EMBEDDED_JAVA_FILE" -cp "$BASEDIR/tools/:$BASEDIR/tools/XpressConnect.jar:$BASEDIR/tools/network_config.jar:$BASEDIR/tools/log4j.jar:$BASEDIR/tools/jnlp.jar:$BASEDIR/../../../config/network_config.jar:$BASEDIR/../../../config/" com.cloudpath.app.xpc.Launch
else 
  echo Java is not installed or disabled and the embedded Java could not be located. >> $LOG
  echo Will notify user of the need for Java. >> $LOG
  echo Network Administrator: An embedded JRE may be included in the Mac client to eliminate the need for Java to be installed.  Contact support for details.
  osascript -e "tell application \"Finder\"
    activate
    display dialog \"This application requires Java but Java is neither installed on this computer nor embedded in this application's deployment package.  

    Either install Java or request an application package that contains an embedded Java.\" with title \"XpressConnect\" buttons \"Quit\" with icon stop
    end tell"
fi


