/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.workflow.common.util;

import com.cloudpath.common.app.gui.GuiTab;
import com.cloudpath.common.app.gui.GuiTabChangeListener;
import com.cloudpath.common.dispatch.AsyncHandler;
import com.cloudpath.common.dispatch.DispatchRequest;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.dispatch.DoneRequest;
import com.cloudpath.common.dispatch.StepBackwardSelection;
import com.cloudpath.common.util.Util;
import com.cloudpath.workflow.common.WorkflowConstants;
import com.cloudpath.workflow.common.block.WorkflowBlock;
import com.cloudpath.workflow.common.block.request.StartRevertRequest;
import com.cloudpath.workflow.common.util.WorkflowChain;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class WorkflowChainImpl
implements WorkflowChain,
AsyncHandler {
    private static final Logger log = Logger.getLogger(WorkflowChainImpl.class);
    private final ArrayList<WorkflowBlock> cls_Blocks = new ArrayList();
    private final GuiTabChangeListener cls_TabListener;
    private final AsyncHandler cls_AsyncHandler;
    private int cls_CurrentIndex = -1;
    private boolean cls_IsRevert = false;

    public WorkflowChainImpl(GuiTabChangeListener guiTabChangeListener, AsyncHandler asyncHandler) {
        this.cls_TabListener = guiTabChangeListener;
        this.cls_AsyncHandler = asyncHandler;
    }

    public int getCurrentIndex() {
        return this.cls_CurrentIndex;
    }

    public int getBlockCount() {
        return this.cls_Blocks.size();
    }

    public void addBlock(WorkflowBlock workflowBlock) {
        this.cls_Blocks.add(workflowBlock);
        this.cls_CurrentIndex = this.cls_CurrentIndex < 0 ? 0 : this.cls_CurrentIndex;
    }

    public boolean isValid() {
        if (this.cls_Blocks.size() == 0) {
            return false;
        }
        ArrayList<WorkflowConstants.DataType> arrayList = new ArrayList<WorkflowConstants.DataType>();
        for (int i = 0; i < this.cls_Blocks.size(); ++i) {
            WorkflowConstants.DataType[] dataTypeArray = this.cls_Blocks.get(i).getPrerequisites();
            for (int j = 0; j < dataTypeArray.length; ++j) {
                if (arrayList.contains(dataTypeArray[j])) continue;
                log.error((Object)("Requirement '" + dataTypeArray[j] + "' not met for block " + this.cls_Blocks.get(i).getClass().getSimpleName() + "."));
                return false;
            }
            WorkflowConstants.DataType[] dataTypeArray2 = this.cls_Blocks.get(i).getGuaranteedOutput();
            for (int j = 0; j < dataTypeArray2.length; ++j) {
                arrayList.add(dataTypeArray2[j]);
            }
        }
        log.info((Object)"Block stack verification succeeded.");
        return true;
    }

    public DispatchRequest doProcess() {
        log.debug((Object)"WorkflowChainImpl.doProcess...");
        WorkflowBlock workflowBlock = this.getCurrentBlock();
        if (this.cls_TabListener != null) {
            this.cls_TabListener.tabsChanged(this.getWorkflowTabs(), workflowBlock.getWorkflowTab());
        }
        log.debug((Object)("Chain will process.  Current block is " + workflowBlock + "."));
        DispatchRequest dispatchRequest = this.getCurrentBlock().doProcess(this.cls_IsRevert);
        log.debug((Object)("Chain received: " + dispatchRequest + ".  Will process."));
        dispatchRequest = this.handleRequest(dispatchRequest);
        log.debug((Object)("Chain will return: " + dispatchRequest));
        return dispatchRequest;
    }

    public DispatchRequest addSelection(DispatchResponse dispatchResponse) {
        log.debug((Object)("Chain adding selection " + dispatchResponse));
        if (dispatchResponse instanceof StepBackwardSelection) {
            log.debug((Object)"Selection is to step backward.");
            this.getCurrentBlock().reset();
            this.gotoPreviousBlock();
            boolean bl = this.getCurrentBlock().reset();
            while (!bl) {
                log.debug((Object)("Current block " + this.getCurrentBlock() + " was not active.  Will step back another step."));
                this.gotoPreviousBlock();
                bl = this.getCurrentBlock().reset();
            }
            log.debug((Object)("While stepping backwards, will stop at " + this.getCurrentBlock()));
            DispatchRequest dispatchRequest = this.getCurrentBlock().doProcess(this.cls_IsRevert);
            if (dispatchRequest instanceof DoneRequest) {
                while (dispatchRequest instanceof DoneRequest) {
                    log.debug((Object)("The block " + this.getCurrentBlock() + " returned a DoneRequest.  Will move forward again."));
                    this.gotoNextBlock();
                    dispatchRequest = this.getCurrentBlock().doProcess(this.cls_IsRevert);
                }
            }
            log.debug((Object)("Step backwards function returning request " + dispatchRequest));
            return dispatchRequest;
        }
        log.info((Object)"WorkflowChainImpl.addSelection will call handleRequest...");
        DispatchRequest dispatchRequest = this.handleRequest(this.getCurrentBlock().addSelection(dispatchResponse, this.cls_IsRevert));
        log.info((Object)("WorkflowChainImpl.addSelection is returning response: " + dispatchRequest));
        return dispatchRequest;
    }

    public GuiTab[] getWorkflowTabs() {
        ArrayList<GuiTab> arrayList = new ArrayList<GuiTab>();
        for (int i = 0; i < this.cls_Blocks.size(); ++i) {
            GuiTab guiTab;
            if (arrayList.size() == 0) {
                guiTab = this.cls_Blocks.get(i).getWorkflowTab();
                if (guiTab == null) continue;
                arrayList.add(guiTab);
                continue;
            }
            if (arrayList.get(arrayList.size() - 1) == this.cls_Blocks.get(i).getWorkflowTab() || (guiTab = this.cls_Blocks.get(i).getWorkflowTab()) == null) continue;
            arrayList.add(guiTab);
        }
        GuiTab[] guiTabArray = new GuiTab[arrayList.size()];
        arrayList.toArray(guiTabArray);
        return guiTabArray;
    }

    private WorkflowBlock getCurrentBlock() {
        return this.cls_CurrentIndex >= 0 && this.cls_CurrentIndex < this.cls_Blocks.size() ? this.cls_Blocks.get(this.cls_CurrentIndex) : null;
    }

    public void restart() {
        this.cls_IsRevert = false;
        this.cls_CurrentIndex = 0;
        for (int i = 0; i < this.cls_Blocks.size(); ++i) {
            this.cls_Blocks.get(i).reset();
        }
    }

    private boolean hasNextBlock() {
        log.debug((Object)("Currently on block " + this.cls_CurrentIndex + " of " + (this.cls_Blocks.size() - 1)));
        if (this.cls_IsRevert) {
            return this.cls_CurrentIndex > 0;
        }
        return this.cls_CurrentIndex < this.cls_Blocks.size() - 1;
    }

    private void gotoNextBlock() {
        this.cls_CurrentIndex = this.cls_IsRevert ? (this.hasNextBlock() ? this.cls_CurrentIndex - 1 : this.cls_CurrentIndex) : (this.hasNextBlock() ? this.cls_CurrentIndex + 1 : this.cls_CurrentIndex);
        WorkflowBlock workflowBlock = this.getCurrentBlock();
        log.info((Object)("*** Moving to block " + Util.getClassName(workflowBlock) + " ***"));
        if (this.cls_TabListener != null) {
            log.info((Object)(" - Will notify tab listener.\n - Block is : " + Util.getClassName(workflowBlock) + "\n - Block's tab is: " + workflowBlock.getWorkflowTab()));
            this.cls_TabListener.tabsChanged(this.getWorkflowTabs(), workflowBlock.getWorkflowTab());
        }
    }

    private void gotoPreviousBlock() {
        this.cls_CurrentIndex = this.cls_IsRevert ? (this.cls_CurrentIndex > 0 ? this.cls_CurrentIndex + 1 : 0) : (this.cls_CurrentIndex > 0 ? this.cls_CurrentIndex - 1 : 0);
    }

    private DispatchRequest handleRequest(DispatchRequest dispatchRequest) {
        log.debug((Object)("Handling request: " + dispatchRequest));
        if (dispatchRequest instanceof StartRevertRequest) {
            this.cls_IsRevert = true;
            this.cls_CurrentIndex = this.cls_Blocks.size();
            dispatchRequest = new DoneRequest("WorkflowChainImpl");
        }
        if (dispatchRequest instanceof DoneRequest) {
            log.debug((Object)" - Is Done Request.");
            if (this.hasNextBlock()) {
                log.debug((Object)" - Has next block.");
                this.gotoNextBlock();
                log.debug((Object)("New block is " + this.getCurrentBlock() + ".  Will call doProcess..."));
                DispatchRequest dispatchRequest2 = this.getCurrentBlock().doProcess(this.cls_IsRevert);
                log.debug((Object)("Response from block is " + dispatchRequest2));
                DispatchRequest dispatchRequest3 = this.handleRequest(dispatchRequest2);
                log.debug((Object)("WorkflowChainImpl.HandleRequest will return response: " + dispatchRequest3));
                return dispatchRequest3;
            }
            log.debug((Object)" - Done with blocks.");
            return dispatchRequest;
        }
        log.debug((Object)" - Not a done request.");
        return dispatchRequest;
    }

    public void clear() {
        this.cls_Blocks.clear();
        this.cls_CurrentIndex = -1;
    }

    public void processAsync(DispatchRequest dispatchRequest) {
        log.debug((Object)("Received async request: " + dispatchRequest));
        DispatchRequest dispatchRequest2 = this.handleRequest(dispatchRequest);
        log.debug((Object)("WorkflowChainImpl.processAsync will request async processing of: " + dispatchRequest2));
        this.cls_AsyncHandler.processAsync(dispatchRequest2);
    }

    public void processAsync(DispatchResponse dispatchResponse) {
        log.debug((Object)("Received async selection: " + dispatchResponse));
        this.cls_AsyncHandler.processAsync(dispatchResponse);
    }
}

