/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.gui.util;

import com.cloudpath.gui.util.GuiConstants;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JPanel;
import javax.swing.border.MatteBorder;

public class GuiUtil {
    public static JPanel getLine() {
        JPanel jPanel = new JPanel();
        jPanel.setFocusable(false);
        jPanel.setBackground(GuiConstants.COLOR_LINE);
        jPanel.setBorder(new MatteBorder(0, 0, 0, 0, GuiConstants.COLOR_WORKAREA));
        jPanel.setMaximumSize(new Dimension(9999, 3));
        jPanel.setPreferredSize(new Dimension(-1, 3));
        return jPanel;
    }

    public static JPanel getAccentLine() {
        JPanel jPanel = new JPanel();
        jPanel.setFocusable(false);
        jPanel.setBackground(GuiConstants.COLOR_ACCENT_LINE);
        jPanel.setBorder(new MatteBorder(0, 0, 0, 0, GuiConstants.COLOR_WORKAREA));
        jPanel.setMaximumSize(new Dimension(9999, 2));
        jPanel.setPreferredSize(new Dimension(-1, 2));
        return jPanel;
    }

    public static JPanel getVerticalPadding(int n) {
        JPanel jPanel = new JPanel();
        jPanel.setFocusable(false);
        jPanel.setOpaque(false);
        jPanel.setBorder(new MatteBorder(0, 0, 0, 0, GuiConstants.COLOR_WORKAREA));
        jPanel.setMaximumSize(new Dimension(9999, n));
        jPanel.setPreferredSize(new Dimension(-1, n));
        return jPanel;
    }

    public static JPanel getHorizontalPadding(int n) {
        JPanel jPanel = new JPanel();
        jPanel.setFocusable(false);
        jPanel.setBackground(GuiConstants.COLOR_WORKAREA);
        jPanel.setBorder(new MatteBorder(0, 0, 0, 0, GuiConstants.COLOR_WORKAREA));
        jPanel.setMaximumSize(new Dimension(n, 9999));
        jPanel.setPreferredSize(new Dimension(n, -1));
        return jPanel;
    }

    public static Rectangle getScreenBounds(GraphicsConfiguration graphicsConfiguration, Toolkit toolkit) {
        Insets insets = toolkit.getScreenInsets(graphicsConfiguration);
        Rectangle rectangle = graphicsConfiguration.getBounds();
        int n = rectangle.x + insets.left;
        int n2 = rectangle.y + insets.top;
        int n3 = rectangle.width - (insets.left + insets.right);
        int n4 = rectangle.height - (insets.top + insets.bottom);
        return new Rectangle(n, n2, n3, n4);
    }
}

