/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.gui.template;

import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.dispatch.StepBackwardSelection;
import com.cloudpath.gui.component.XpcButtonPanel;
import com.cloudpath.gui.component.XpcCaptionPanel;
import com.cloudpath.gui.component.XpcForm;
import com.cloudpath.gui.util.FormListener;
import com.cloudpath.gui.util.GuiConstants;
import com.cloudpath.gui.util.XpcFocusTraversalPolicy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public abstract class XpcPromptForm
extends JPanel
implements XpcForm,
FormListener {
    private static final Logger log = Logger.getLogger(XpcPromptForm.class);
    private final XpcButtonPanel cls_Buttons;
    private final FormListener cls_FormListener;
    private final JPanel cls_OriginalHeaderPanel;
    private final XpcCaptionPanel cls_CaptionPanel;
    private boolean cls_ButtonsVisible = false;

    public XpcPromptForm(FormListener formListener, String string, String string2, String string3) {
        this(formListener, new XpcCaptionPanel(string), string2, string3);
    }

    public XpcPromptForm(FormListener formListener, JPanel jPanel, String string, String string2) {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.cls_OriginalHeaderPanel = jPanel;
        if (jPanel != null) {
            if (!(jPanel instanceof XpcCaptionPanel)) {
                jPanel = new XpcCaptionPanel(jPanel);
            }
            this.add((Component)jPanel, "North");
        }
        this.cls_CaptionPanel = (XpcCaptionPanel)jPanel;
        this.cls_FormListener = formListener;
        this.cls_Buttons = new XpcButtonPanel(this, string, string2);
        if (this.cls_Buttons.getRightButton() != null) {
            this.cls_Buttons.getRightButton().requestFocus();
        }
        if (string != null || string2 != null) {
            this.showButtons();
        } else {
            this.hideButtons();
        }
    }

    protected JButton getRightButton() {
        return this.cls_Buttons.getRightButton();
    }

    protected JButton getLeftButton() {
        return this.cls_Buttons.getLeftButton();
    }

    protected FormListener getFormListener() {
        return this.cls_FormListener;
    }

    protected JPanel getOriginalHeaderPanel() {
        return this.cls_OriginalHeaderPanel;
    }

    protected void setLoading(boolean bl) {
        if (this.cls_CaptionPanel != null) {
            this.cls_CaptionPanel.setLoading(bl);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 10 || n == 39) {
            if (!(keyEvent.getSource() instanceof JButton)) {
                this.nextClicked();
            }
        } else if (n == 27 || n == 37) {
            if (!(keyEvent.getSource() instanceof JButton)) {
                this.backClicked();
            }
        } else if (n == 38) {
            this.upClicked();
        } else if (n == 40) {
            this.downClicked();
        } else if (n == 92) {
            this.skipClicked();
        }
    }

    public boolean selectionMade(DispatchResponse dispatchResponse) {
        this.setCursor(GuiConstants.CURSOR_BUSY);
        if (dispatchResponse == null) {
            dispatchResponse = this.getSelection();
        }
        log.debug((Object)("Made selection: " + dispatchResponse));
        if (dispatchResponse != null) {
            if (this.cls_FormListener != null) {
                log.debug((Object)("Will notify form listener of selection: " + dispatchResponse));
                this.cls_FormListener.selectionMade(dispatchResponse);
                return true;
            }
        } else {
            log.warn((Object)"Ignoring selection because selection is null.");
        }
        this.setCursor(GuiConstants.CURSOR_DEFAULT);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextClicked() {
        boolean bl = this.getRightButton().isEnabled();
        boolean bl2 = this.getLeftButton().isEnabled();
        try {
            this.getRightButton().setEnabled(false);
            this.getLeftButton().setEnabled(false);
            this.setCursor(GuiConstants.CURSOR_BUSY);
            this.selectionMade(null);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.getRightButton().setEnabled(bl);
            this.getLeftButton().setEnabled(bl2);
            throw throwable;
        }
        this.getRightButton().setEnabled(bl);
        this.getLeftButton().setEnabled(bl2);
    }

    public void backClicked() {
        this.setCursor(GuiConstants.CURSOR_BUSY);
        this.selectionMade(new StepBackwardSelection());
    }

    public void upClicked() {
    }

    public void downClicked() {
    }

    public void skipClicked() {
    }

    public void populateFocusTraversal(XpcFocusTraversalPolicy xpcFocusTraversalPolicy) {
        this.cls_Buttons.populateFocusTraversal(xpcFocusTraversalPolicy);
    }

    public void doFocus() {
        if (this.cls_Buttons.getRightButton() != null) {
            this.cls_Buttons.getRightButton().requestFocus();
        }
    }

    public JButton getDefaultButton() {
        return this.cls_Buttons.getDefaultButton();
    }

    public abstract DispatchResponse getSelection();

    public void setButtonsVisible(boolean bl, boolean bl2) {
        if (!bl && !bl2) {
            this.hideButtons();
        } else {
            this.showButtons();
            if (this.getLeftButton() != null) {
                this.getLeftButton().setVisible(bl);
            }
            if (this.getRightButton() != null) {
                this.getRightButton().setVisible(bl2);
            }
        }
    }

    public void hideButtons() {
        if (this.cls_ButtonsVisible) {
            this.remove(this.cls_Buttons);
        }
        this.cls_ButtonsVisible = false;
    }

    public void showButtons() {
        if (!this.cls_ButtonsVisible) {
            this.add((Component)this.cls_Buttons, "South");
        }
        this.cls_ButtonsVisible = true;
    }

    protected XpcCaptionPanel getCaptionPanel() {
        return this.cls_CaptionPanel;
    }
}

