/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.gui.factor;

import com.cloudpath.common.util.FileUtil;
import com.cloudpath.common.util.Resources;
import com.cloudpath.gui.component.XpcButtonPanel;
import com.cloudpath.gui.component.XpcConsoleLogger;
import com.cloudpath.gui.component.XpcForm;
import com.cloudpath.gui.component.XpcSpacer;
import com.cloudpath.gui.factor.FrameUtil;
import com.cloudpath.gui.util.GuiConstants;
import com.cloudpath.gui.util.XpcFocusTraversalPolicy;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class LogFrame
extends JFrame
implements KeyListener,
WindowListener,
XpcForm {
    public static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(LogFrame.class);
    private final XpcButtonPanel cls_Buttons;
    private final JTextArea cls_Log;
    private final XpcConsoleLogger cls_LogUpdater;

    public LogFrame() {
        Dimension dimension = new Dimension(600, 600);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.getContentPane().setBackground(GuiConstants.COLOR_BACKGROUND);
        this.setTitle(Resources.ResourceString.PRODUCT_NAME.getValue());
        this.setResizable(true);
        this.setFocusable(true);
        this.addWindowListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new XpcSpacer(10, 1), "West");
        this.getContentPane().add((Component)new XpcSpacer(10, 1), "East");
        this.getContentPane().add((Component)new XpcSpacer(1, 20), "North");
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.getContentPane().add((Component)jPanel, "Center");
        jPanel.add(FrameUtil.createLabel("Logs", true, false));
        jPanel.add(new XpcSpacer(1, 10));
        this.cls_Log = new JTextArea("");
        this.cls_Log.setLineWrap(false);
        this.cls_Log.setWrapStyleWord(true);
        this.cls_Log.setOpaque(true);
        this.cls_Log.setFont(GuiConstants.FONT_ARIAL_10_PLAIN);
        this.cls_Log.setRows(80);
        this.cls_Log.setBackground(Color.WHITE);
        JScrollPane jScrollPane = new JScrollPane(this.cls_Log);
        jScrollPane.setOpaque(false);
        jPanel.add(jScrollPane);
        jPanel.add(new JPanel(new BorderLayout()));
        jPanel.add(new XpcSpacer(1, 20));
        this.cls_Buttons = new XpcButtonPanel(this, "Save", "OK");
        jPanel.add(this.cls_Buttons);
        this.getRootPane().setDefaultButton(this.getDefaultButton());
        this.pack();
        this.cls_LogUpdater = new XpcConsoleLogger(this.cls_Log, jScrollPane);
        this.cls_LogUpdater.setLayout((Layout)new PatternLayout("%d{MMddyy HH:mm:ss} %-5p: %m %x (%F:%L-%t)%n"));
        this.cls_LogUpdater.activateOptions();
        Logger.getRootLogger().addAppender((Appender)this.cls_LogUpdater);
    }

    public void setMessage(String string) {
        this.cls_Log.setText(string);
    }

    public void close() {
        this.setVisible(false);
    }

    public void backClicked() {
        log.info((Object)"User has selected to save logs to desktop.");
        String string = Resources.ResourceString.PRODUCT_NAME.getValue() + ".log";
        File file = new File(FileUtil.getUserHome() + File.separator + "Desktop", string);
        if (file.getParent() != null && file.getParentFile().exists()) {
            String string2 = "";
            try {
                File file2;
                File file3 = File.createTempFile("tmp", ".tmp");
                File file4 = file3.getParentFile();
                if (!file3.delete()) {
                    file3.deleteOnExit();
                }
                if ((file2 = new File(file4, string)).exists()) {
                    try {
                        string2 = FileUtil.read(file2);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string2 == null || string2.length() == 0) {
                string2 = this.cls_Log.getText();
            }
            try {
                FileUtil.write(file.getAbsolutePath(), string2);
                JOptionPane.showMessageDialog(this, "<html>The log has been saved to the desktop as " + string + ".</html>", "Logs", 1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(this, "<html>The log could not be saved to the desktop.<br>It is located at " + string + " in the temp directory.</html>", "Logs", 1);
            }
        }
    }

    public void nextClicked() {
        this.close();
    }

    public void populateFocusTraversal(XpcFocusTraversalPolicy xpcFocusTraversalPolicy) {
        this.cls_Buttons.populateFocusTraversal(xpcFocusTraversalPolicy);
    }

    public void doFocus() {
        this.cls_Buttons.getRightButton().requestFocus();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public JButton getDefaultButton() {
        return this.cls_Buttons.getDefaultButton();
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.close();
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

