/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.gui.component;

import com.cloudpath.common.util.OsConstants;
import com.cloudpath.gui.component.XpcComponentConstants;
import com.cloudpath.gui.component.XpcListItem;
import com.cloudpath.gui.util.FormListener;
import com.cloudpath.gui.util.GuiConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class XpcButtonListItem
extends JPanel
implements XpcListItem,
MouseListener {
    private static final Logger log = Logger.getLogger(XpcButtonListItem.class);
    public static final long serialVersionUID = 1L;
    private static final Dimension UNSELECTED_ITEM_MINIMUM_SIZE = new Dimension(99999, 16);
    private static final Insets SELECTED_INSETS_TOP = new Insets(4, 0, 0, 0);
    private static final Insets UNSELECTED_INSETS_TOP = new Insets(4, 0, 0, 0);
    private static final Insets SELECTED_INSETS_CENTER = new Insets(4, 0, 0, 0);
    private static final Insets UNSELECTED_INSETS_CENTER = new Insets(4, 0, 0, 0);
    private final FormListener cls_FormListener;
    private final int cls_Index;
    private final String cls_Caption;
    private final String cls_Description;
    private final JButton cls_Button;
    private boolean cls_Selected = true;
    private ActionListener cls_Listener = null;
    private boolean cls_SelectionMade = false;
    private final int cls_Height;
    private final Dimension ITEM_MINIMUM_SIZE;
    private final boolean cls_IsLongList;

    public XpcButtonListItem(int n, boolean bl, String string, String string2, int n2, FormListener formListener, int n3) {
        this.cls_IsLongList = bl;
        this.cls_Height = n;
        this.ITEM_MINIMUM_SIZE = new Dimension(99999, n);
        this.cls_Index = n2;
        this.cls_Caption = string;
        this.cls_Description = string2;
        this.cls_FormListener = formListener;
        this.setMinimumSize(this.ITEM_MINIMUM_SIZE);
        this.setMaximumSize(new Dimension(99999, n));
        this.setPreferredSize(this.ITEM_MINIMUM_SIZE);
        this.setOpaque(!OsConstants.isMac());
        this.setBackground(GuiConstants.COLOR_WORKAREA);
        this.setLayout(new BorderLayout());
        this.setFocusable(false);
        this.cls_Button = new JButton(string);
        this.cls_Button.setBorder(null);
        this.cls_Button.setHorizontalAlignment(2);
        if (n3 >= 0) {
            this.cls_Button.setVerticalAlignment(n3);
        } else if (n > 32) {
            this.cls_Button.setVerticalAlignment(1);
        } else {
            this.cls_Button.setVerticalAlignment(0);
        }
        this.cls_Button.setFont(GuiConstants.FONT_ARIAL_11_PLAIN);
        this.cls_Button.setAlignmentX(0.5f);
        this.cls_Button.setOpaque(!OsConstants.isMac());
        this.cls_Button.setBackground(GuiConstants.COLOR_ERROR);
        this.cls_Button.setDefaultCapable(false);
        this.cls_Button.setActionCommand("" + n2);
        this.cls_Button.setFocusable(false);
        this.cls_Button.addMouseListener(this);
        this.add((Component)this.cls_Button, "Center");
        this.setSelected(false);
    }

    public void addListener(ActionListener actionListener) {
        this.cls_Listener = actionListener;
    }

    public boolean isSelected() {
        return this.cls_Selected;
    }

    public void setSelected(boolean bl) {
        if (bl != this.cls_Selected) {
            this.cls_Button.setText(XpcButtonListItem.formatTitle(bl, this.cls_Caption, this.cls_Description, this.cls_IsLongList));
            if (bl) {
                this.cls_Button.setBackground(GuiConstants.COLOR_LIST_SELECTION);
                this.setBackground(GuiConstants.COLOR_LIST_SELECTION);
                this.cls_Button.setBorderPainted(true);
                if (this.cls_Button.getVerticalAlignment() == 1) {
                    this.cls_Button.setMargin(SELECTED_INSETS_TOP);
                } else {
                    this.cls_Button.setMargin(SELECTED_INSETS_CENTER);
                }
                if (this.cls_IsLongList) {
                    this.setMinimumSize(this.ITEM_MINIMUM_SIZE);
                    this.setMaximumSize(new Dimension(99999, this.cls_Height));
                    this.setPreferredSize(this.ITEM_MINIMUM_SIZE);
                }
            } else {
                this.cls_Button.setBackground(GuiConstants.COLOR_WORKAREA);
                this.setBackground(GuiConstants.COLOR_WORKAREA);
                if (this.cls_Button.getVerticalAlignment() == 1) {
                    this.cls_Button.setMargin(UNSELECTED_INSETS_TOP);
                } else {
                    this.cls_Button.setMargin(UNSELECTED_INSETS_CENTER);
                }
                if (XpcComponentConstants.isMac()) {
                    this.cls_Button.setBorderPainted(false);
                }
                if (this.cls_IsLongList) {
                    this.setMinimumSize(UNSELECTED_ITEM_MINIMUM_SIZE);
                    this.setMaximumSize(new Dimension(99999, 32));
                    this.setPreferredSize(UNSELECTED_ITEM_MINIMUM_SIZE);
                }
            }
            this.cls_Selected = bl;
        }
    }

    private void selectionMade() {
        if (this.cls_FormListener != null && !this.cls_SelectionMade && this.cls_FormListener.selectionMade(null)) {
            this.cls_SelectionMade = true;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        log.debug((Object)("Mouse click: " + mouseEvent));
        if (this.isSelected()) {
            this.selectionMade();
        } else {
            this.cls_Listener.actionPerformed(new ActionEvent(this.cls_Button, this.cls_Index, this.cls_Button.getActionCommand()));
            if (mouseEvent.getClickCount() > 1) {
                this.selectionMade();
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(GuiConstants.CURSOR_HAND);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.setCursor(GuiConstants.CURSOR_DEFAULT);
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private static String formatTitle(boolean bl, String string, String string2, boolean bl2) {
        String string3;
        String string4 = "<td>&nbsp;&nbsp;&nbsp;</td>";
        if (OsConstants.isMac()) {
            string4 = "";
        }
        if (bl) {
            string3 = "<html><table><tr>" + string4 + "<td><font color='black'><b>" + string + "</b></font>";
            if (string2 != null && string2.length() > 0) {
                string3 = string3 + "<br><table><tr>" + string4 + "<td><font color='black'>" + string2 + "</font></td></tr></table>";
            }
            string3 = string3 + "</td></tr></table></html>";
        } else {
            string3 = "<html><table><tr>" + string4 + "<td><font color='#404040'>" + string + "</font>";
            if (!bl2 && string2 != null && string2.length() > 0) {
                string3 = string3 + "<br><table><tr><td>&nbsp;&nbsp;&nbsp;</td><td><font color='#808080'>" + string2 + "</font></td></tr></table>";
            }
            string3 = string3 + "</td></tr></table></html>";
        }
        return string3;
    }
}

